/**
 * The Exploded Pie Chart displays a set of random data in a column series.
 */
Ext.define('KitchenSink.view.charts.pie.Exploded', {
    extend: 'Ext.Panel',
    xtype: 'exploded-pie',

    // <example>
    // Content between example tags is omitted from code preview.
    bodyStyle: 'background: transparent !important',
    layout: {
        type: 'vbox',
        pack: 'center'
    },

    themes: {
        classic: {
            percentChangeColumn: {
                width: 75
            }
        },
        neptune: {
            percentChangeColumn: {
                width: 100
            }
        }
    },
    // </example>

    initComponent: function() {
        var me = this;

        this.myDataStore = Ext.create('Ext.data.JsonStore', {
            fields: ['os', 'data1' ],
            data: [
                { os: 'Android', data1: 68.3 },
                { os: 'iOS', data1: 17.9 },
                { os: 'Windows Phone', data1: 10.2 },
                { os: 'BlackBerry', data1: 1.7 },
                { os: 'Others', data1: 1.9 }
            ]
        });

        //<example>
        me.dockedItems = [{
            xtype: 'toolbar',
            dock: 'top',
            items: [
                '->',
            {
                text: 'Preview',
                handler: function() {
                    me.down('polar').preview();
                }
            }]
        }];
        //</example>

        me.items = [{
            xtype: 'polar',
            width: '100%',
            height: 400,
            store: this.myDataStore,
            insetPadding: 40,
            legend: {
                docked: 'right'
            },
            sprites: [{
                type: 'text',
                text: 'Pie Charts - Exploded',
                fontSize: 22,
                width: 100,
                height: 30,
                x: 40, // the sprite x position
                y: 12  // the sprite y position
            }, {
                type: 'text',
                text: 'Data: IDC Predictions - 2017',
                x: 12,
                y: 380
            }, {
                type: 'text',
                text: 'Source: Internet',
                x: 12,
                y: 395
            }],
            series: [{
                type: 'pie',
                angleField: 'data1',
                label: {
                    field: 'os',
                    display: 'outside',
                    calloutLine: true
                },
                style: 'padding: 10px;',
                highlight: {
                    fillStyle: '#000',
                    lineWidth: 20,
                    strokeStyle: '#fff'
                },
                tooltip: {
                    trackMouse: true,
                    renderer: function(storeItem, item) {
                        this.setHtml(storeItem.get('os') + ': ' + storeItem.get('data1') + '%');
                    }
                }
            }]
        //<example>
        }, {
            style: 'padding-top: 10px;',
            xtype: 'gridpanel',
            columns : {
                defaults: {
                    sortable: false,
                    menuDisabled: true
                },
                items: [
                    { text: 'OS', dataIndex: 'os' },
                    { text: 'Market Share', dataIndex: 'data1', width: 150, renderer: function(v) { return v + '%'; } }
                ]
            },
            store: this.myDataStore,
            width: '100%'
        //</example>
        }];

        this.callParent();
    }
});
