/*
 * References :
 * http://stackoverflow.com/questions/14920869/how-to-display-image-on-center-extjs-4
 */
Ext.define('Optima5.LoginWindow',{
	extend  :'Ext.window.Window',
	
	loginSent: false,
	
	initComponent:function() {
		var me = this ;
		
		Ext.apply(me,{
			title: 'Optima Desktop / Login',
			width: 550,
			height: 200,
			layout: {
				type: 'hbox',
				align: 'stretch',
			},
			resizable: false,
			plain: true,
			closable: false,
			style:{
				'display': 'table-cell',
				'vertical-align': 'middle'
			},
			items:[{
				xtype:'container',
				width:155,
				cls:'op5-login-west',
				itemId:'iconCtn'
				/*
				style:{
					background:"url('images/AquaSafari_logo.png') no-repeat center center"
				},
				*/
				/*
				items:[{
					xtype:'image',
					src:'images/AquaSafari_logo.png',
					style: {
						'display': 'block',
						'margin': 'auto',
					}
				}]
				*/
			},{
				flex:1,
				xtype:'form',
				itemId: 'fpLogin',
				frame:true,
				bodyPadding: 10,
				defaultType: 'textfield',
				fieldDefaults: {
						labelAlign: 'left',
						anchor: '100%',
						margin: '10 0 15 0'
				},
				listeners: {
					afterRender: function(thisForm, options){
						this.keyNav = Ext.create('Ext.util.KeyNav', this.el, {
								enter: me.doLogin,
								scope: me
						});
					}
				},
				items: [{
					xtype:'displayfield',
					labelSeparator: ' :',
					fieldLabel: '<b>Please enter login information</b>',
					margin: '0 0 15 0',
					labelWidth: 200
				},{
					fieldLabel: 'User @ Domain',
					allowBlank: false,
					msgTarget:'side',
					name: 'user'
				},{
					fieldLabel: 'Password',
					inputType: 'password',
					name: 'password'
				}],
				buttons: [{
					itemId: 'btnEnter',
					text: "Login",
					handler: me.doLogin,
					scope:me
				}]
			},{
				flex:1,
				xtype:'form',
				itemId: 'fpAuth2',
				hidden: true,
				frame:true,
				bodyPadding: 10,
				defaultType: 'textfield',
				fieldDefaults: {
					labelWidth: 100,
						labelAlign: 'left',
						anchor: '100%',
						margin: '10 0 15 0'
				},
				listeners: {
					afterRender: function(thisForm, options){
						this.keyNav = Ext.create('Ext.util.KeyNav', this.el, {
								enter: me.doLogin,
								scope: me
						});
					}
				},
				items: [{
					xtype:'displayfield',
					value: '<b>Two-factor authentication</b>',
					margin: '0 0 5 0',
				},{
					xtype:'displayfield',
					name: 'auth2email',
					labelSeparator: ' :',
					fieldLabel: '<b>Email</b>',
					margin: '0 0 15 0',
				},{
					width: 180,
					anchor: '',
					fieldLabel: 'One-time code',
					//inputType: 'password',
					name: 'auth2code'
				}],
				buttons: [{
					itemId: 'btnEnter',
					text: "Login",
					handler: me.doLogin,
					scope:me
				}]
			}]
		});
		
		this.callParent() ;
		
		me.on('beforedestroy',me.onBeforeDestroy,me) ;
		me.on('afterrender',function() {
			this.probeUrl() ;
		},me) ;
		me.probeAutoLogin() ;
	},
	probeUrl: function() {
		var modulesLib = Optima5.Helper.getModulesLib(),
			modules = modulesLib.modulesGetAll(),
			hostname = window.location.hostname,
			loginIcon,
			loginEl = this.down('#iconCtn').getEl() ;
		
		Ext.Array.each( modules, function(moduleRecord) {
			if( moduleRecord.get('loginUrl') == hostname ) {
				loginIcon = moduleRecord.get('loginIcon') ;
				return false ;
			}
		}) ;
		if( !Ext.isEmpty(loginIcon) ) {
			// CSS replace
			loginEl.removeCls('op5-login-west') ;
			loginEl.dom.style.background = "url('images/icons/" + loginIcon + "') no-repeat center center" ;
		}
	},
	probeAutoLogin: function() {
		var isIPAddress = function(v) {
			return /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/.test(v);
		} ;
		if( !isIPAddress(window.location.hostname) ) {
			return ;
		}
		/*
		 * Optional /DEV
		 * + /DEV.autologin.json :
		 * {
		 *    "login_domain":"",
		 *    "login_user":"",
		 *    "login_password":""
		 * }
		 */
		var me = this ;
		Ext.Ajax.request({
			url: 'DEV',
			success: function() {
				Ext.Ajax.request({
					url: 'DEV.autologin.json',
					success: function(response) {
						var responseObj ;
						try {
							responseObj = Ext.decode(response.responseText);
						} catch(e) {
							return ;
						}
						var form = me.down('#fpLogin').getForm() ;
						form.findField('user').setValue(responseObj.login_user+'@'+responseObj.login_domain) ;
						form.findField('password').setValue(responseObj.login_password) ;
						me.doLogin() ;
					},
					scope:me
				});
			},
			scope:me
		});
	},
	doLogin: function() {
		var me = this ;
		if( me.loginSent ) {
			return ;
		}
		
		me.loginSent=true;
		Ext.getBody().mask('Logging in...') ;
		me.down('#fpLogin').query('#btnEnter')[0].setDisabled(true) ;
		
		var form = me.down('#fpLogin').getForm() ;
		var userStr = form.findField('user').getValue() ;
		var passStr = form.findField('password').getValue() ;
		
		var tarr = (userStr!='') ? userStr.split('@') : []
			, loginDomain, loginUser
			, loginPass = passStr ;
		switch( tarr.length ) {
			case 2 :
				loginUser = tarr[0];
				loginDomain = tarr[1];
				break ;
			case 1 :
				loginUser = 'root' ;
				loginDomain = tarr[0];
				break ;
			default :
				Ext.MessageBox.alert('Login failed', 'Invalid user parameter (user@domain)');
				me.recycle() ;
				return ;
		}
		
		var ajaxParams = {
			_action: 'login',
			login_domain: loginDomain,
			login_user  : loginUser,
			login_password: loginPass,
		};
		
		var formPanel = me.down('#fpAuth2') ;
		var loginAuth2code = null;
		if( formPanel.isVisible() ) {
			loginAuth2code = formPanel.getForm().findField('auth2code').getValue() ;
			Ext.apply(ajaxParams,{
				login_auth2code: loginAuth2code,
			});
		}
		
		Ext.Ajax.request({
			url: 'server/login.php',
			params: ajaxParams,
			success: function(response) {
				if( !Ext.isEmpty(Ext.decode(response.responseText).redirect) ) {
					 window.location.href = Ext.decode(response.responseText).redirect;
					 return ;
				}
				if( Ext.decode(response.responseText).done == false ) {
					Ext.getBody().unmask() ;
					
					if( Ext.decode(response.responseText).errors )
						var mstr = Ext.decode(response.responseText).errors.join('\n') ;
					else
						var mstr = 'Cannot open session. Contact admin.' ;
					/*
					Ext.Msg.alert('Initialization error', mstr,function(){
						window.location.reload() ;
					}) ;
					*/
					me.fireEvent('loginfailed',me, mstr) ;
					return ;
				}
				
				if( Ext.decode(response.responseText).need_auth2 ) {
					me.loginSent=false;
					this.down('#fpLogin').setVisible(false);
					this.down('#fpAuth2').setVisible(true);
					this.down('#fpAuth2').getForm().findField('auth2email').setValue(Ext.decode(response.responseText).auth2_emailAdr);
					this.down('#fpAuth2').getForm().findField('auth2code').reset();
					return;
				}
				
				var objLoginData = Ext.decode(response.responseText).login_data ;
				//console.dir( Ext.decode(response.responseText).login_data ) ;
				me.fireEvent('loginsuccess',me, objLoginData['session_id']) ;
				return ;
			},
			scope : me
		});
	},
	recycle: function() {
		var me = this ;
		var form = me.down('#fpLogin').getForm() ;
		form.findField('password').setValue() ;
		me.down('#fpLogin').query('#btnEnter')[0].setDisabled(false) ;
		me.loginSent = false ;
		
		this.down('#fpLogin').setVisible(true);
		this.down('#fpAuth2').setVisible(false);
		
		Ext.getBody().unmask() ;
	},
	
	onBeforeDestroy: function() {
		var me = this,
			docBody = Ext.getBody() ;
		if( docBody.isMasked() ) {
			docBody.unmask() ;
		}
	}
	
});
