Ext.define('Optima5.Modules.CrmBase.DataWindow' ,{
	extend: 'Ext.window.Window',
	requires: [
		'Optima5.Modules.CrmBase.DataWindowToolbar',
		'Optima5.Modules.CrmBase.BiblePanel',
		'Optima5.Modules.CrmBase.FilePanel',
		'Optima5.Modules.CrmBase.TablePanel',
		'Optima5.Modules.CrmBase.DefineStorePanel',
		'Optima5.Modules.CrmBase.DataImportPanel',
		
		'Optima5.Modules.CrmBase.DataWindowTriggerForm'
	],
	
	optimaModule: null,
	
	dataType:'', /* 'bible','file' */
	bibleId:null,
	fileId:null,
	parentFileId:null,
	
	
	statics: {
		sOpenDefineWindow : function(optimaModule, defineDataType, defineIsNew, defineDataId) {
			var params = new Object() ;
			Ext.apply(params,{
				optimaModule: optimaModule
			}) ;
			if( defineIsNew == true ){
				Ext.apply( params, {
					defineDataType: defineDataType ,
					defineIsNew: true
				}) ;
			}
			else
			{
				switch( defineDataType )
				{
					case 'bible' :
						Ext.apply( params, {
							defineIsNew: false,
							defineDataType: defineDataType ,
							defineBibleId : defineDataId
						}) ;
					break ;
					
					case 'file' :
						Ext.apply( params, {
							defineIsNew: false,
							defineDataType: defineDataType ,
							defineFileId : defineDataId
						}) ;
					break ;
					
					case 'table' :
						Ext.apply( params, {
							defineIsNew: false,
							defineDataType: defineDataType ,
							defineTableId : defineDataId
						}) ;
					break ;
					
					default:
						Ext.Msg.alert('Status', 'Shouldnt happen !!!');
						return ;
					break ;
				}
			}
			
			var definestorepanel = Ext.create('Optima5.Modules.CrmBase.DefineStorePanel',params) ;
			definestorepanel.on('beforedestroy',function(panel){
				if( panel.up('window') ) {
					var parentwin = panel.up('window') ;
					panel.on('destroy',function() {
						parentwin.close() ;
					}) ;
				}
			});
			
			optimaModule.createWindow({
				title:'Store definition',
				width:720,
				height:600,
				iconCls: 'op5-crmbase-definewindow-icon',
				animCollapse:false,
				border: false,
				items: [ definestorepanel ]
			}) ;
		}
	},
	
	initComponent: function() {
		var me = this ;
		if( (me.optimaModule) instanceof Optima5.Module ) {} else {
			Optima5.Helper.logError('CrmBase:DataWindow','No module reference ?') ;
		}
		
		var cfgValid = false ;
		switch( me.dataType ) {
			case 'bible' :
				if( me.bibleId && me.bibleId != '' ) {
					Ext.apply(me,{
						items:[Ext.create('Optima5.Modules.CrmBase.BiblePanel',{
							itemId:'biblePanel',
							border: false,
							optimaModule: me.optimaModule,
							listeners: {
								load: {
									fn: me.onReload,
									scope: me
								}
							}
						})]
					}) ;
					cfgValid = true ;
				}
				break ;
				
			case 'file' :
				if( me.fileId && me.fileId != '' ) {
					Ext.apply(me,{
						items:[Ext.create('Optima5.Modules.CrmBase.FilePanel',{
							itemId:'filePanel',
							border: false,
							optimaModule: me.optimaModule,
							listeners: {
								load: {
									fn: me.onReload,
									scope: me
								},
								viewchange: {
									fn: me.onFileViewChanged,
									scope: me
								}
							}
						})]
					}) ;
					cfgValid = true ;
				}
				break ;
				
			case 'table' :
				if( me.tableId && me.tableId != '' ) {
					Ext.apply(me,{
						items:[Ext.create('Optima5.Modules.CrmBase.TablePanel',{
							itemId:'tablePanel',
							border: false,
							optimaModule: me.optimaModule,
							listeners: {
								load: {
									fn: me.onReload,
									scope: me
								}
							}
						})]
					}) ;
					cfgValid = true ;
				}
				break ;
				
			default : break ;
		}
		if( !cfgValid ) {
			Optima5.Helper.logError('CrmBase:DataWindow','Invalid config') ;
		}
		
		Ext.apply(me,{
			border: false,
			tbar: Ext.create('Optima5.Modules.CrmBase.DataWindowToolbar',{
				itemId:'tbar',
				optimaModule: me.optimaModule,
				dataType: me.dataType,
				listeners:{
					toolbaritemclick: me.onToolbarItemClick,
					scope:me
				}
			})
		}) ;
		
		
		me.on('show', function() {
			// configure panel + load data
			me.configureComponents() ;
		},me,{single:true}) ;
		
		me.callParent() ;
		
		me.mon(me.optimaModule,'op5broadcast',me.onCrmeventBroadcast,me) ;
	},
	onReload: function() {
		var me = this ;
		me.getToolbar().enableTruncateStore( !me.getPanel().isEmpty() ) ;
		me.getToolbar().enableDropStore( me.getPanel().isEmpty() ) ;
	},
	onFileViewChanged: function(viewId) {
		var me = this ;
		switch( viewId ) {
			case 'editgrid' :
				me.getToolbar().enableNew( true ) ;
				break ;
			
			default :
				me.getToolbar().enableNew( false ) ;
				break ;
		}
	},
	
	onCrmeventBroadcast: function( crmEvent, eventParams ) {
		var me = this ;
		if( this._ignoreCrmEvent ) {
			return ;
		}
		switch( crmEvent ) {
			case 'datachange' :
			case 'definechange' :
			case 'togglepublishdata' :
				switch( eventParams.dataType ) {
					case 'bible' :
						if( me.dataType=='bible' && eventParams.bibleId == me.bibleId ) {
						} else {
							return ;
						}
						break ;
					case 'file' :
						if( me.dataType=='file' && ( eventParams.fileId == me.fileId || eventParams.fileId == me.parentFileId ) ) {
						} else {
							return ;
						}
						break ;
					case 'table' :
						if( me.dataType=='table' && eventParams.tableId == me.tableId ) {
						} else {
							return ;
						}
						break ;
					default :
						return ;
				}
				break ;
			
			default :
				return ;
		}
		
		switch( crmEvent ) {
			case 'togglepublishdata' :
				return me.configureComponents(true) ;
			case 'definechange' :
				return me.configureComponents() ;
			case 'datachange' :
				return me.getPanel().reload() ;
		}
	},
	getToolbar: function() {
		var me = this ;
		return me.child('#tbar');
	},
	getPanel: function() {
		var me = this ;
		switch( me.dataType ) {
			case 'bible' :
				return me.child('#biblePanel') ;
			case 'file' :
				return me.child('#filePanel') ;
			case 'table' :
				return me.child('#tablePanel') ;
			default :
				return null ;
		}
	},
	
	configureComponents: function( toolbarOnly ) {
		var me = this ,
			params = {} ;
		
		switch( me.dataType ) {
			case 'bible' :
				params = {
					_action : 'data_getBibleCfg',
					bible_code : me.bibleId
				};
				break ;
				
			case 'file' :
				params = {
					_action : 'data_getFileGrid_config',
					file_code : me.fileId
				};
				break ;
				
			case 'table' :
				params = {
					_action : 'data_getTableGrid_config',
					table_code : me.tableId
				};
				break ;
		}
			
		me.optimaModule.getConfiguredAjaxConnection().request({
			params: params,
			success: function(response) {
				me.onConfigLoad( Ext.decode(response.responseText).data, toolbarOnly ) ;
			},
			scope: me
		});
		
		if( me.dataType == 'table' ) {
			me.optimaModule.getConfiguredAjaxConnection().request({
				params: {
					_action: 'data_importTrigger_getCfg',
					data_type: me.dataType,
					table_code: me.tableId
				},
				success: function(response) {
					me.onConfigTriggerLoad( Ext.decode(response.responseText).data ) ;
				},
				scope: me
			});
		} else {
			me.onConfigTriggerLoad( null ) ;
		}
	},
	onConfigLoad: function( ajaxData, toolbarOnly ) {
		var me = this ;
		
		me.bibleId = me.fileId = me.parentFileId = null ;
		
		switch( me.dataType ) {
			case 'bible' :
				me.bibleId = ajaxData.define_bible.bible_code ;
				
				me.setTitle( me.optimaModule.getWindowTitle( ajaxData.define_bible.text ) ) ;
				me.child('#tbar').reconfigure( ajaxData.define_bible, ajaxData.auth_status ) ;
				if( !toolbarOnly ) {
					me.child('#biblePanel').reconfigure( me.bibleId, ajaxData ) ;
				}
				break ;
			case 'file' :
				me.fileId = ajaxData.define_file.file_code ;
				if( ajaxData.define_file.file_parent_code != '' ) {
					me.parentFileId = ajaxData.define_file.file_parent_code ;
				}
				
				me.setTitle( me.optimaModule.getWindowTitle( ajaxData.define_file.text ) ) ;
				me.child('#tbar').reconfigure( ajaxData.define_file, ajaxData.auth_status ) ;
				if( !toolbarOnly ) {
					me.child('#filePanel').reconfigure( me.fileId, ajaxData ) ;
				}
				break ;
			case 'table' :
				me.tableId = ajaxData.define_table.table_code ;
				
				me.setTitle( me.optimaModule.getWindowTitle( ajaxData.define_table.text ) ) ;
				me.child('#tbar').reconfigure( ajaxData.define_table, ajaxData.auth_status ) ;
				if( !toolbarOnly ) {
					me.child('#tablePanel').reconfigure( me.tableId, ajaxData ) ;
				}
				break ;
		}
	},
	onConfigTriggerLoad: function( ajaxData ) {
		var me = this ;
		me.child('#tbar').reconfigureDataimportTrigger( ajaxData ) ;
	},
	onToolbarItemClick: function( menuId, menuItemId, checked ) {
		var me = this ;
		//console.log(menuId+':'+menuItemId+' '+checked) ;
		switch( menuId ) {
			case 'new' :
				return me.getPanel().onClickNew() ;
				break ;
				
			case 'file' :
				switch( menuItemId ) {
					case 'importdata' :
						return me.openDataImportPanel() ;
					case 'export-bible-csv' :
						return me.getPanel().exportBible('CSV') ;
					case 'export-bible-xlsx' :
						return me.getPanel().exportBible('XLSX') ;
					case 'export-file-csv' :
						return me.getPanel().exportFile('CSV') ;
					case 'export-file-xlsx' :
						return me.getPanel().exportFile('XLSX') ;
					case 'export-table-csv' :
						return me.getPanel().exportTable('CSV') ;
					case 'export-table-xlsx' :
						return me.getPanel().exportTable('XLSX') ;
					case 'export-gallery' :
						return me.getPanel().exportGallery() ;
					default : break ;
				}
				break ;
				
			case 'view' :
				switch( menuItemId ) {
					case 'grid' :
					case 'editgrid' :
					case 'calendar' :
					case 'gallery' :
					//case 'gmap' :
						var viewmode = menuItemId ;
						return me.getPanel().switchToPanel(viewmode) ;
					default:
						break ;
				}
				break ;
				
			case 'options' :
				switch( menuItemId ) {
					case 'toggle-lockadmin' :
						return me.storeToggleLockadmin( checked ) ;
					case 'toggle-android' :
						return me.storeTogglePublish( checked ) ;
					case 'definestore' :
						return me.openDefineWindow( false ) ;
					case 'truncatestore' :
						return me.handleTruncateStore() ;
					case 'dropstore' :
						return me.handleDeleteStore() ;
					case 'dataimport-trigger' :
						return me.openTriggerForm() ;
					default : break ;
				}
				break ;
				
			case 'refresh' :
				if( me.getPanel() ) {
					me.getPanel().reload() ;
				}
				break ;
		}
	},
	
	openDefineWindow : function() {
		var me = this ;
		
		switch( me.dataType )
		{
			case 'bible' :
				Optima5.Modules.CrmBase.DataWindow.sOpenDefineWindow(me.optimaModule,'bible',false,me.bibleId) ;
			break ;
			
			case 'file' :
				Optima5.Modules.CrmBase.DataWindow.sOpenDefineWindow(me.optimaModule,'file',false,me.fileId) ;
			break ;
			
			case 'table' :
				Optima5.Modules.CrmBase.DataWindow.sOpenDefineWindow(me.optimaModule,'table',false,me.tableId) ;
			break ;
			
			default:
				Ext.Msg.alert('Status', 'Shouldnt happen !!!');
				return ;
			break ;
		}
	},
	handleTruncateStore: function() {
		var me = this,
			msg ;
		
		msg = "Truncate(delete all) " ;
		switch( this.dataType ) {
			case 'bible' :
				msg+= ' bible ' + this.bibleId ;
				break ;
			case 'file' :
				msg+= ' file ' + this.fileId ;
				break ;
			case 'table' :
				msg+= ' table ' + this.tableId ;
				break ;
			default :
				return ;
		}
		msg+= ' and all associated data ?\nType \'YES\' to confirm.' ;
		
		Ext.Msg.show({
			title:'Truncate store',
			msg: msg ,
			icon: Ext.Msg.WARNING,
			buttons: Ext.Msg.YESNO,
			prompt: true,
			fn:function(buttonId,text){
				switch( buttonId ) {
					case 'yes':
						if( text.toUpperCase() == 'YES' ) {
							me.doTruncateStore() ;
						} else {
							Ext.Msg.alert('Abort','Not confirmed') ;
						}
						break ;
				}
			},
			scope:me
		}) ;
	},
	handleDeleteStore: function() {
		var me = this,
			msg ;
		
		msg = "Drop " ;
		switch( this.dataType ) {
			case 'bible' :
				msg+= ' bible ' + this.bibleId ;
				break ;
			case 'file' :
				msg+= ' file ' + this.fileId ;
				break ;
			case 'table' :
				msg+= ' table ' + this.tableId ;
				break ;
			default :
				return ;
		}
		msg+= ' and all associated data ?' ;
		
		Ext.Msg.show({
			title:'Drop store',
			msg: msg ,
			icon: Ext.Msg.WARNING,
			buttons: Ext.Msg.YESNO,
			fn:function(buttonId){
				switch( buttonId ) {
					case 'yes':
						me.doDeleteStore() ;
						break ;
				}
			},
			scope:me
		}) ;
	},
	doTruncateStore: function() {
		var me = this ;
		
		var ajaxParams = {
			_action : 'define_truncate'
		};
		switch( this.dataType )
		{
			case 'bible' :
				Ext.apply( ajaxParams, {
					data_type: 'bible',
					bible_code : this.bibleId
				}) ;
			break ;
			
			case 'file' :
				Ext.apply( ajaxParams, {
					data_type: 'file',
					file_code : this.fileId
				}) ;
			break ;
			
			case 'table' :
				Ext.apply( ajaxParams, {
					data_type: 'table',
					table_code : this.tableId
				}) ;
			break ;
			
			default:
				Ext.Msg.alert('Status', 'Shouldnt happen !!!');
				return ;
			break ;
		}
		
		me.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams,
			success: function(response) {
				if( Ext.decode(response.responseText).success == false ) {
					Ext.Msg.alert('Failed', 'Failed');
				}
				else {
					me.optimaModule.postCrmEvent('definechange',{
						dataType:me.dataType,
						bibleId:me.bibleId,
						fileId:me.fileId,
						tableId:me.tableId
					}) ;
				}
			},
			scope: me
		});
	},
	doDeleteStore: function() {
		var me = this ;
		
		var ajaxParams = {
			_action : 'define_drop'
		};
		switch( this.dataType )
		{
			case 'bible' :
				Ext.apply( ajaxParams, {
					data_type: 'bible',
					bible_code : this.bibleId
				}) ;
			break ;
			
			case 'file' :
				Ext.apply( ajaxParams, {
					data_type: 'file',
					file_code : this.fileId
				}) ;
			break ;
			
			case 'table' :
				Ext.apply( ajaxParams, {
					data_type: 'table',
					table_code : this.tableId
				}) ;
			break ;
			
			default:
				Ext.Msg.alert('Status', 'Shouldnt happen !!!');
				return ;
			break ;
		}
		
		me.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams,
			success: function(response) {
				if( Ext.decode(response.responseText).success == false ) {
					Ext.Msg.alert('Failed', 'Failed');
				}
				else {
					me._ignoreCrmEvent = true ;
					me.optimaModule.postCrmEvent('definechange',{
						dataType:me.dataType,
						bibleId:me.bibleId,
						fileId:me.fileId,
						tableId:me.tableId
					}) ;
					me.destroy() ;
				}
			},
			scope: me
		});
	},
	storeTogglePublish: function( isPublished ) {
		var me = this ;
		
		var ajaxParams = {
			_action : 'define_togglePublish',
			isPublished: isPublished
		};
		switch( this.dataType )
		{
			case 'bible' :
				Ext.apply( ajaxParams, {
					data_type: 'bible',
					bible_code : this.bibleId
				}) ;
			break ;
			
			case 'file' :
				Ext.apply( ajaxParams, {
					data_type: 'file',
					file_code : this.fileId
				}) ;
			break ;
			
			default:
				Ext.Msg.alert('Status', 'Shouldnt happen !!!');
				return ;
			break ;
		}
		
		me.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams,
			success: function(response) {
				// Rebuild helper on event "toolbarloaded"
				me.optimaModule.postCrmEvent('togglepublishdata',{
					dataType:me.dataType,
					bibleId:me.bibleId,
					fileId:me.fileId
				}) ;
			},
			scope: me
		});
	},
	storeToggleLockadmin: function( isLockadmin ) {
		var me = this ;
		
		var ajaxParams = {
			_action : 'define_toggleLockadmin',
			isLockadmin: isLockadmin
		};
		switch( this.dataType )
		{
			case 'table' :
				Ext.apply( ajaxParams, {
					data_type: 'table',
					table_code : this.tableId
				}) ;
			break ;
			
			default:
				Ext.Msg.alert('Status', 'Shouldnt happen !!!');
				return ;
			break ;
		}
		
		me.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams,
			success: function(response) {
				me.optimaModule.postCrmEvent('definechange',{
					dataType: me.dataType,
					tableId: me.tableId
				}) ;
			},
			scope: me
		});
	},
	
	
	openDataImportPanel: function() {
		var me = this ;
		
		var setSizeFromParent = function( parentPanel, targetPanel ) {
			targetPanel.setSize({
				width: parentPanel.getSize().width - 20,
				height: parentPanel.getSize().height - 60
			}) ;
		};
		
		var dataImportPanel = Ext.create('Optima5.Modules.CrmBase.DataImportPanel',{
			parentDataWindow: me,
			width:800, // dummy initial size, for border layout to work
			height:600, // ...
			floating: true,
			renderTo: me.getEl(),
			tools: [{
				type: 'close',
				handler: function(e, t, p) {
					p.ownerCt.destroy();
				}
			}]
		});
		
		dataImportPanel.mon(me,'resize', function() {
			setSizeFromParent( me, dataImportPanel ) ;
		},me) ;
		
		// Size + position
		setSizeFromParent(me,dataImportPanel) ;
		dataImportPanel.on('destroy',function() {
			me.getEl().unmask() ;
			// me.fireEvent('qbookztemplatechange') ;
		},me,{single:true}) ;
		me.getEl().mask() ;
		
		dataImportPanel.show();
		dataImportPanel.getEl().alignTo(me.getEl(), 't-t?',[0,50]);
	},
	
	
	openTriggerForm: function() {
		var me = this ;
		
		this.getEl().mask() ;
		// Open panel
		var createPanel = Ext.create('Optima5.Modules.CrmBase.DataWindowTriggerForm',{
			optimaModule: this.optimaModule,
				dataType: me.dataType,
				tableId:me.tableId,
			width:400, // dummy initial size, for border layout to work
			height:null, // ...
			floating: true,
			draggable: true,
			resizable: true,
			renderTo: this.getEl(),
			tools: [{
				type: 'close',
				handler: function(e, t, p) {
					p.ownerCt.destroy();
				},
				scope: this
			}]
		});
		createPanel.on('saved', function(p) {
			this.doTreeLoad() ;
		},this,{single:true}) ;
		createPanel.on('destroy',function(p) {
			this.getEl().unmask() ;
			this.floatingPanel = null ;
		},this,{single:true}) ;
		
		createPanel.show();
		createPanel.getEl().alignTo(this.getEl(), 'c-c?');
	},
	
});
