Ext.define('Optima5.Modules.CrmBase.DataWindowToolbar' ,{
	extend: 'Ext.toolbar.Toolbar',
	
	clsForLockadmin: 'op5-crmbase-lockadmin',
	clsForPublished: 'op5-crmbase-published',
	clsForTrigger: 'op5-crmbase-trigger',
	
	initComponent: function() {
		var me = this ;
		Ext.apply( this , {
			items : [{
				hidden: true,
				itemId: 'new',
				text: 'New',
				iconCls: 'op5-crmbase-datatoolbar-new',
				handler:me.onItemClick,
				scope:me
			},{
				itemId: 'file',
				text: 'File',
				iconCls: 'op5-crmbase-datatoolbar-file',
				viewConfig: {forceFit: true},
				menu: {
					defaults: {
						handler:me.onItemClick,
						scope:me
					},
					items: [{
						itemId: 'importdata',
						text: 'Import data',
						iconCls: 'op5-crmbase-datatoolbar-file-importdata'
					},{
						xtype: 'menuseparator'
					},{
						itemId: 'export-bible-csv',
						text: 'CSV export',
						iconCls: 'op5-crmbase-datatoolbar-file-export-excel'
					},{
						itemId: 'export-bible-xlsx',
						text: 'XLSX export',
						iconCls: 'op5-crmbase-datatoolbar-file-export-excel'
					},{
						itemId: 'export-file-csv',
						text: 'CSV export',
						iconCls: 'op5-crmbase-datatoolbar-file-export-excel'
					},{
						itemId: 'export-file-xlsx',
						text: 'XLSX export',
						iconCls: 'op5-crmbase-datatoolbar-file-export-excel'
					},{
						itemId: 'export-table-csv',
						text: 'CSV export',
						iconCls: 'op5-crmbase-datatoolbar-file-export-excel'
					},{
						itemId: 'export-table-xlsx',
						text: 'XLSX export',
						iconCls: 'op5-crmbase-datatoolbar-file-export-excel'
					},{
						itemId: 'export-gallery',
						text: 'DL gallery as zip',
						iconCls: 'op5-crmbase-datatoolbar-file-export-gallery'
					}]
				}
			},{
				itemId: 'view',
				text: 'View',
				iconCls: 'op5-crmbase-datatoolbar-view',
				viewConfig: {forceFit: true},
				menu: {
					defaults: {
						handler:me.onItemClick,
						scope:me
					},
					items: [{
						itemId: 'calendar',
						text: 'Calendar',
						iconCls: 'op5-crmbase-datatoolbar-view-calendar'
					},{
						itemId: 'grid',
						text: 'Grid data',
						iconCls: 'op5-crmbase-datatoolbar-view-grid'
					},{
						itemId: 'editgrid',
						text: 'Editable grid',
						iconCls: 'op5-crmbase-datatoolbar-view-editgrid'
					},{
						itemId: 'gmap',
						text: 'GMap/locations',
						iconCls: 'op5-crmbase-datatoolbar-view-gmap'
					},{
						itemId: 'gallery',
						text: 'Img Gallery',
						iconCls: 'op5-crmbase-datatoolbar-view-gallery'
					}]
				}
			},{
				hidden: true,
				itemId: 'options',
				text: 'Options',
				iconCls: 'op5-crmbase-datatoolbar-options',
				viewConfig: {forceFit: true},
				menu: {
					defaults: {
						handler:me.onItemClick,
						scope:me
					},
					items: [{
						itemId: 'toggle-lockadmin',
						text: 'Lock to superuser',
						handler: null,
						checked: false,
						checkHandler : me.onCheckItemChange,
						scope: me
					},{
						itemId: 'toggle-android',
						text: 'Publish to Android',
						handler: null,
						checked: false,
						checkHandler : me.onCheckItemChange,
						scope: me
					},{
						itemId: 'definestore',
						text: 'Store Cfg',
						iconCls: 'op5-crmbase-datatoolbar-options-definestore'
					},{
						itemId: 'truncatestore',
						text: 'Truncate Store',
						iconCls: 'op5-crmbase-datatoolbar-options-truncatestore',
						hidden: true
					},{
						itemId: 'dropstore',
						text: 'Drop Store',
						iconCls: 'op5-crmbase-datatoolbar-options-dropstore',
						hidden: true
					},{
						itemId: 'dataimport-trigger',
						text: 'Trigger on upload',
						icon: 'images/op5img/ico_sql_16.png',
						hidden: false
					}]
				}
			},'->',{
				hidden: true,
				itemId: 'refresh',
				text: 'Refresh',
				iconCls: 'op5-crmbase-datatoolbar-refresh',
				handler:me.onItemClick,
				scope:me
			}]
		});
		// console.dir(this.bibleMenu.items) ;
		this.callParent() ;
	},
	
	reconfigure: function( ajaxData, authStatus ) {
		var me = this ;
		
		// menu File
		var fileMenu = me.child('#file') ;
		fileMenu.menu.hide() ;
		if( typeof ajaxData.tableId !== 'undefined' ) {
			fileMenu.setVisible(true) ;
			fileMenu.menu.child('#export-bible-csv').setVisible(false) ;
			fileMenu.menu.child('#export-bible-xlsx').setVisible(false) ;
			fileMenu.menu.child('#export-file-csv').setVisible(false) ;
			fileMenu.menu.child('#export-file-xlsx').setVisible(false) ;
			fileMenu.menu.child('#export-table-csv').setVisible(true) ;
			fileMenu.menu.child('#export-table-xlsx').setVisible(true) ;
			fileMenu.menu.child('#export-gallery').setVisible( false ) ;
		} else if( typeof ajaxData.fileId !== 'undefined' ) {
			fileMenu.setVisible(true) ;
			fileMenu.menu.child('#export-bible-csv').setVisible(false) ;
			fileMenu.menu.child('#export-bible-xlsx').setVisible(false) ;
			fileMenu.menu.child('#export-file-csv').setVisible(true) ;
			fileMenu.menu.child('#export-file-xlsx').setVisible(true) ;
			fileMenu.menu.child('#export-table-csv').setVisible(false) ;
			fileMenu.menu.child('#export-table-xlsx').setVisible(false) ;
			fileMenu.menu.child('#export-gallery').setVisible( ajaxData.viewmode_gallery ) ;
		} else if( typeof ajaxData.bibleId !== 'undefined' ) {
			fileMenu.setVisible(true) ;
			fileMenu.menu.child('#export-bible-csv').setVisible(true) ;
			fileMenu.menu.child('#export-bible-xlsx').setVisible(true) ;
			fileMenu.menu.child('#export-file-csv').setVisible(false) ;
			fileMenu.menu.child('#export-file-xlsx').setVisible(false) ;
			fileMenu.menu.child('#export-table-csv').setVisible(false) ;
			fileMenu.menu.child('#export-table-xlsx').setVisible(false) ;
			fileMenu.menu.child('#export-gallery').setVisible(false) ;
		} else {
			fileMenu.setVisible(false) ;
		}
		fileMenu.menu.child('#importdata').setVisible(!authStatus.readOnly) ;
		fileMenu.menu.child('menuseparator').setVisible(!authStatus.readOnly) ;
		
		var viewMenu = me.child('#view') ;
		viewMenu.menu.hide() ;
		viewMenu.setVisible(true) ;
		viewMenu.menu.child('#grid').setVisible( ajaxData.viewmode_grid ) ;
		viewMenu.menu.child('#editgrid').setVisible( ajaxData.viewmode_editgrid ) ;
		viewMenu.menu.child('#calendar').setVisible( ajaxData.viewmode_calendar ) ;
		viewMenu.menu.child('#gmap').setVisible( false ) ;
		viewMenu.menu.child('#gallery').setVisible( ajaxData.viewmode_gallery ) ;
		
		var optionsMenu = me.child('#options') ;
		optionsMenu.menu.hide() ;
		if( authStatus != null && authStatus.disableAdmin ) {
			optionsMenu.setVisible(false) ;
		} else {
			optionsMenu.setVisible(true) ;
		}
		optionsMenu.menu.child('#toggle-android').setChecked( ajaxData.isPublished, true ) ;
		if( ajaxData.isPublished ) {
			optionsMenu.menu.child('#toggle-android').addCls( me.clsForPublished ) ;
		} else {
			optionsMenu.menu.child('#toggle-android').removeCls( me.clsForPublished ) ;
		}
		
		optionsMenu.menu.child('#toggle-lockadmin').setVisible( typeof ajaxData.tableId !== 'undefined' ) ;
		if( ajaxData.tableId ) {
			optionsMenu.menu.child('#toggle-lockadmin').setChecked( ajaxData.isLockadmin, true ) ;
			if( ajaxData.isLockadmin ) {
				optionsMenu.menu.child('#toggle-lockadmin').addCls( me.clsForLockadmin ) ;
			} else {
				optionsMenu.menu.child('#toggle-lockadmin').removeCls( me.clsForLockadmin ) ;
			}
		}
		
		
		var refreshBtn = me.child('#refresh') ;
		refreshBtn.setVisible(true) ;
	},
	reconfigureDataimportTrigger(ajaxData) {
		var me = this ;
		
		var optionsMenu = me.child('#options') ;
		if( !ajaxData ) {
			optionsMenu.menu.child('#dataimport-trigger').setVisible( false ) ;
			return ;
		}
		optionsMenu.menu.child('#dataimport-trigger').setVisible( true ) ;
		if( ajaxData.trigger_is_on ) {
			optionsMenu.menu.child('#dataimport-trigger').setText( ajaxData.trigger_qsql_name ) ;
			optionsMenu.menu.child('#dataimport-trigger').addCls( me.clsForTrigger ) ;
		} else {
			optionsMenu.menu.child('#dataimport-trigger').setText( 'Dataimport trigger' ) ;
			optionsMenu.menu.child('#dataimport-trigger').removeCls( me.clsForTrigger ) ;
		}
	},
	enableNew: function( bool ) {
		var me = this ;
		me.child('#new').setVisible(bool) ;
	},
	enableTruncateStore: function( bool ) {
		var me = this ;
		me.child('#options').menu.child('#truncatestore').setVisible(bool) ;
	},
	enableDropStore: function( bool ) {
		var me = this ;
		me.child('#options').menu.child('#dropstore').setVisible(bool) ;
	},
	
	onItemClick:function( item ) {
		var menuItem, toolbarButton ;
		if( item instanceof Ext.menu.Item ) {
			menuItem = item ;
			toolbarButton = item.up().ownerCmp ;
		} else if( item instanceof Ext.button.Button ) {
			menuItem = null ;
			toolbarButton = item ;
		} else {
			return ;
		}
		
		var me = this ;
		me.fireEvent('toolbaritemclick',toolbarButton.itemId,(menuItem ? menuItem.itemId : null),null) ;
	},
	onCheckItemChange: function( checkItem, checked ) {
		var menuItem = checkItem ;
		var toolbarButton = checkItem.up().ownerCmp ;
		
		var me = this ;
		me.fireEvent('toolbaritemclick',toolbarButton.itemId,menuItem.itemId,checked) ;
	}
	
});
