Ext.define('Optima5.Modules.CrmBase.DataWindowTriggerForm',{
	extend:'Ext.form.Panel',
	
	initComponent: function() {
		Ext.apply(this, {
			title: 'Trigger setup',
			bodyCls: 'ux-noframe-bg',
			bodyPadding: '10px 10px',
			border: false,
			frame: true,
			height: 200,
			layout: 'anchor',
			fieldDefaults: {
				labelWidth: 115,
				anchor: '100%'
			},
			items:[{
				xtype: 'fieldset',
				title: 'Enable trigger (to QSQL query)',
				checkboxToggle: true,
				checkboxName: 'trigger_is_on',
				padding: 6,
				items: [{
					xtype: 'comboboxcached',
					itemId: 'cmbQsql',
					name: 'trigger_qsql_id',
					forceSelection: true,
					editable: true,
					typeAhead: true,
					store: {
						fields: [
							{name: 'qsql_id', type:'string'},
							{name: 'qsql_name', type:'string'},
						],
						data: [],
						proxy: {
							type: 'memory'
						}
					},
					queryMode: 'local',
					displayField: 'qsql_name',
					valueField: 'qsql_id'
				}]
			}],
			buttons: [{
				xtype: 'button',
				text: 'OK',
				handler: function( btn ) {
					this.doSave() ;
				},
				scope: this
			}]
		});
		this.callParent() ;
		this.getForm().setValues({autorun_is_on:false}) ;
		this.evalForm() ;
		this.doLoad() ;
	},
	evalForm: function() {
		var form = this.getForm(),
			values = form.getValues() ;
	},
	
	showLoadmask: function() {
		if( this.rendered ) {
			this.doShowLoadmask() ;
		} else {
			this.on('afterrender',this.doShowLoadmask,this,{single:true}) ;
		}
	},
	doShowLoadmask: function() {
		if( this.loadMask ) {
			return ;
		}
		this.loadMask = Ext.create('Ext.LoadMask',{
			target: this,
			msg:"Please wait..."
		}).show();
	},
	hideLoadmask: function() {
		this.un('afterrender',this.doShowLoadmask,this) ;
		if( this.loadMask ) {
			this.loadMask.destroy() ;
			this.loadMask = null ;
		}
	},
	
	doLoad: function() {
		this.showLoadmask() ;
		var me = this ;
		
		me.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_action: 'queries_getToolbarData'
			},
			success: function(response) {
				if( Ext.decode(response.responseText).success == false ) {
					Ext.Msg.alert('Failed', 'Failed');
				}
				var respObj = Ext.decode(response.responseText) ;
				Ext.Array.sort( respObj.data_qsqls, function(o1,o2) {
					var o1text = o1.text.toLowerCase(),
						o2text = o2.text.toLowerCase() ;
					
					if( o1text < o2text ) {
						return -1 ;
					} else if(  o1text > o2text ) {
						return 1 ;
					} else {
						return 0 ;
					}
				}) ;
				
				var storeData = [] ;
				Ext.Array.each( respObj.data_qsqls, function(o) {
					storeData.push({
						qsql_id: o.qsqlId,
						qsql_name: o.text
					});
				}) ;
				this.down('#cmbQsql').getStore().loadData(storeData) ;
			},
			callback: function() {
				this.hideLoadmask() ;
			},
			scope: me
		});
		
		me.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_action: 'data_importTrigger_getCfg',
				data_type: me.dataType,
				table_code: me.tableId
			},
			success: function(response) {
				if( Ext.decode(response.responseText).success == false ) {
					Ext.Msg.alert('Failed', 'Failed');
				}
				this.getForm().setValues( Ext.decode(response.responseText).data ) ;
			},
			callback: function() {
				this.hideLoadmask() ;
			},
			scope: me
		});
	},
	
	
	doSave: function() {
		var me = this ;
		
		var baseForm = this.getForm(),
			values = baseForm.getFieldValues() ;
		Ext.Array.each( ['trigger_qsql_id'], function(fieldName) {
			var field = baseForm.findField(fieldName) ;
			field.allowBlank = !field.isVisible(true) ;
		});
		
		if(baseForm.isValid()){
			this.showLoadmask() ;
			me.optimaModule.getConfiguredAjaxConnection().request({
				params: {
					_action: 'data_importTrigger_setCfg',
					data_type: me.dataType,
					table_code: me.tableId,
					data: Ext.JSON.encode(values)
				},
				success: function(response) {
					if( Ext.decode(response.responseText).success == false ) {
						Ext.Msg.alert('Failed', 'Failed');
					} else {
						// TODO : send event
						this.optimaModule.postCrmEvent('definechange',{
							dataType: me.dataType,
							tableId: me.tableId
						}) ;
						this.destroy() ;
					}
				},
				callback: function() {
					this.hideLoadmask() ;
				},
				scope: me
			});
		}
	}
}) ;
