Ext.define('Optima5.Modules.CrmBase.QappPanel' ,{
	extend: 'Ext.panel.Panel',
	
	_transactionId: null,
	_qappId: null,
	_qappData: null,
	
	initComponent: function() {
		var me = this ;
		if( (me.optimaModule) instanceof Optima5.Module ) {} else {
			Optima5.Helper.logError('CrmBase:QappPanel','No module reference ?') ;
		}
		
		Ext.apply( me, {
			border:false,
			layout: {
				type: 'hbox',
				align: 'stretch'
			},
			items:[{
				xtype:'box',
				cls:'op5-waiting',
				flex:1
			}],
			autoDestroy: true
		}) ;
		
		me.callParent() ;
	},
	
	qappNew: function() {
		var me = this ;
		
		var ajaxParams = new Object() ;
		Ext.apply( ajaxParams, {
			_action: 'qapps_qappTransaction',
			_subaction: 'init',
			is_new: 'true'
		});
		me.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams ,
			success: function(response) {
				if( Ext.decode(response.responseText).success == false ) {
					Ext.Msg.alert('Failed', 'Failed');
				}
				else {
					me._transactionId = Ext.decode(response.responseText).transaction_id ;
					me._qappData = Ext.decode(response.responseText).data ;
					me.addComponents() ;
				}
			},
			scope: this
		});
	},
	qappOpen: function( qappId ) {
		var me = this ;
		
		var ajaxParams = new Object() ;
		Ext.apply( ajaxParams, {
			_action: 'qapps_qappTransaction',
			_subaction: 'init',
			qapp_id: qappId,
			is_new: 'false'
		});
		me.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams ,
			success: function(response) {
				if( Ext.decode(response.responseText).success == false ) {
					Ext.Msg.alert('Failed', 'Failed');
				}
				else {
					me._transactionId = Ext.decode(response.responseText).transaction_id ;
					me._qappId = qappId ;
					me._qappData = Ext.decode(response.responseText).data ;
					me.addComponents() ;
				}
			},
			scope: this
		});
	},
	
	addComponents: function() {
		this.fireEvent('qtransactionopen',this,this._transactionId) ;
		
		this.removeAll() ;
		this.add([{
			width: 250,
			itemId: 'pExplorer',
			title: 'Project',
			xtype: 'treepanel',
			store: {
				fields: [
					{name: 'nodeText', type: 'string'},
					{name: 'groupId', type: 'string'},
					{name: 'file_ssid', type: 'int'},
					{name: 'file_is_main', type: 'boolean'},
					{name: 'asset_id', type: 'string'},
				],
				root: {children:[]},
				proxy: {
					type: 'memory' ,
					reader: {
						type: 'json'
					}
				}
			},
			displayField: 'nodeText',
			rootVisible: false,
			useArrows: true,
			listeners: {
				itemcontextmenu: function( p, record, item, index, event) {
					var gridContextMenuItems ;
					if( record.get('groupId')=='files_add' ) {
						gridContextMenuItems = [{
							iconCls: 'icon-bible-new',
							text: 'Create file',
							handler : function() {
								Ext.Msg.show({
									title:'Create file',
									msg: 'Enter file name :' ,
									width: 200,
									buttons: Ext.Msg.OKCANCEL,
									prompt: true,
									fn:function(buttonId,fileName){
										if( buttonId == 'ok' && !Ext.isEmpty(fileName) ) {
											this.doFileCreate( fileName ) ;
										}
									},
									scope:this
								});
							},
							scope : this
						}];
					}
					if( record.parentNode && record.parentNode.get('groupId')=='files_add' ) {
						gridContextMenuItems = [{
							iconCls: 'icon-bible-delete',
							text: 'Delete file',
							handler : function() {
								Ext.Msg.show({
									title:'Delete file',
									msg: 'Delete file <b>'+record.get('nodeText')+'</b> ?' ,
									buttons: Ext.Msg.YESNO,
									fn:function(buttonId){
										if( buttonId == 'yes' ) {
											this.doFileDelete( record.get('file_ssid') ) ;
										}
									},
									scope:this
								});
							},
							scope : this
						}];
					}
					if( !gridContextMenuItems ){
						return ;
					}
					var gridContextMenu = Ext.create('Ext.menu.Menu',{
						items : gridContextMenuItems,
						listeners: {
							hide: function(menu) {
								Ext.defer(function(){menu.destroy();},10) ;
							}
						}
					}) ;
					
					gridContextMenu.showAt(event.getXY());
				},
				itemdblclick: function( p, record ) {
					if( record.get('file_ssid')>0 ) {
						this.openFile( record.get('file_ssid'), record.get('nodeText') ) ;
					}
				},
				scope: this,
			}
		},{
			flex:1,
			xtype: 'tabpanel',
			itemId: 'tEditor',
			bodyCls: 'ux-noframe-bg',
			items: []
		}]);
		
		this.doLoadFiles(true) ;
	},
	doLoadFiles: function( openMainFiles=false ) {
		var ajaxParams = new Object() ;
		Ext.apply( ajaxParams, {
			_action: 'qapps_qappTransaction',
			_subaction: 'files_getList',
			_transaction_id: this._transactionId,
		});
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams ,
			success: function(response) {
				if( Ext.decode(response.responseText).success == false ) {
					Ext.Msg.alert('Failed', 'Failed');
				}
				else {
					this.onLoadFiles(Ext.decode(response.responseText).data,openMainFiles) ;
				}
			},
			scope: this
		});
	},
	onLoadFiles: function( ajaxData, openMainFiles ) {
		var assetsData = [];
		Ext.Array.each( this._qappData.lib_assets, function(asset) {
			var assetId = asset.asset_id ;
			assetsData.push({
				nodeText: asset.asset_name + ' ' + '(' + asset.asset_version + ')',
				checked: Ext.Array.contains(this._qappData.qapp_cfg_obj.assets,asset.asset_id),
				asset_id: asset.asset_id,
				leaf: true,
			});
		},this);
		var mainFiles = [], additionalFiles = [];
		Ext.Array.each( ajaxData, function(file) {
			var icon ;
			switch( file.file_type ) {
				case 'js' :
					icon = 'images/op5img/ico_file_js_16.png';
					break ;
				case 'css' :
					icon = 'images/op5img/ico_file_css_16.png';
					break ;
				case 'html' :
					icon = 'images/op5img/ico_file_html_16.png';
					break ;
				case 'png' :
				case 'svg' :
					icon = 'images/op5img/ico_file_png_16.png';
					break ;
			}
			var fileEntry = {
				icon: icon,
				file_ssid: file.qapp_file_ssid,
				file_is_main: file.file_is_main,
				nodeText: file.file_name,
				leaf:true,
			};
			if( file.file_is_main ) {
				mainFiles.push(fileEntry);
			} else {
				additionalFiles.push(fileEntry);
			}
		},this);
		var rootNode = {
			root:true,
			expanded: true,
			expandable: false,
			children: [{
				nodeText: 'Components',
				icon: 'images/op5img/ico_storeview_16.png',
				expanded: true,
				expandable: false,
				children: assetsData,
			},{
				nodeText: '<b>App files</b>',
				groupId: 'files_main',
				icon: 'images/op5img/ico_bookmark_16.png',
				expanded: true,
				expandable: false,
				children: mainFiles,
			},{
				nodeText: '<b>Resources</b>',
				groupId: 'files_add',
				icon: 'images/op5img/ico_foldergreen_16.png',
				expanded: true,
				expandable: false,
				children: additionalFiles,
			}],
		};
		this.down('#pExplorer').setRootNode(rootNode);
		
		this.onAfterLoadFiles(openMainFiles) ;
	},
	onAfterLoadFiles: function( openMainFiles=false ) {
		if( openMainFiles ) {
			this.down('#pExplorer').getRootNode().cascadeBy( function(n) {
				if( n.get('file_is_main') ) {
					this.openFile( n.get('file_ssid'), n.get('nodeText'), true );
				}
			},this);
			this.down('#tEditor').setActiveTab(0);
		}
	},
	
	
	openFile: function( fileSsid, fileName, dontFocus=false ) {
		var tEditor = this.down('#tEditor');
		var existingTab = this.down('#tEditor').down('[_fileSsid='+fileSsid+']') ;
		if( existingTab ) {
			tEditor.setActiveTab(existingTab);
			return ;
		}
		var pnl = tEditor.add({
			xtype: 'panel',
			_fileSsid: fileSsid,
			title: fileName,
			closable: true,
			layout: 'fit',
			items: {
				xtype:'box',
				cls:'op5-waiting',
				flex:1
			},
			listeners: {
				beforeclose: this.onBeforeCloseEditor,
				scope: this,
			},
		});
		if( !dontFocus ) {
			tEditor.setActiveTab(pnl);
		}
		
		var ajaxParams = new Object() ;
		Ext.apply( ajaxParams, {
			_action: 'qapps_qappTransaction',
			_subaction: 'file_download',
			_transaction_id: this._transactionId,
			qapp_file_ssid: fileSsid,
		});
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams ,
			success: function(response) {
				if( Ext.decode(response.responseText).success == false ) {
					Ext.Msg.alert('Failed', 'Failed');
				}
				else {
					var fileData = Ext.decode(response.responseText).data ;
					if( fileSsid==fileData.qapp_file_ssid ) {
						this.onLoadFile(fileData) ;
					}
				}
			},
			scope: this
		});
	},
	onLoadFile: function(fileData) {
		var fileSsid = fileData.qapp_file_ssid ;
		
		var tEditor = this.down('#tEditor');
		var existingTab = this.down('#tEditor').down('[_fileSsid='+fileSsid+']') ;
		
		// Create Editor
		existingTab._fileType = fileData.file_type ;
		
		var editorCmp ;
		switch( existingTab._fileType ) {
			case 'html':
			case 'css' :
			case 'js' :
				var aceMode ;
				switch( existingTab._fileType ) {
					case 'js' :
						aceMode = 'javascript' ;
						break ;
					default :
						aceMode = existingTab._fileType ;
						break ;
				}
				
				editorCmp = Ext.create('Ext.ux.dams.AceEditor',{
					itemId: 'cmpEditor',
					myparam: 'paramvalue',
					mode: aceMode,
					value: Ext.util.Base64.decode(fileData.file_base64),
					listeners: {
						change: function() {
							//this.setDirty(true) ;
						},
						//editorready: this.addComponentsOnRenderTextarea,
						scope: this
					}
				});
				break ;
			case 'svg' :
			case 'png' :
				var valueIsRaw = (existingTab._fileType=='png');
				editorCmp = {
					itemId: 'cmpEditor',
					xtype: 'textareafield',
					fieldCls: 'op5-crmbase-query-sql-textarea',
					grow: true,
					value: valueIsRaw ? fileData.file_base64 : Ext.util.Base64.decode(fileData.file_base64),
					valueIsRaw: valueIsRaw,
					anchor: '100%',
				};
				break ;
			default:
				return ;
		}
		if( editorCmp ) {
			existingTab.removeAll();
			existingTab.add(editorCmp);
		}
	},
	onBeforeCloseEditor: function(editorTab) {
		var fileSsid = editorTab._fileSsid ;
		if( editorTab.deleted ) {
			return ;
		}
		this.doUploadFile(fileSsid);
	},
	
	getFileBase64: function(fileSsid) {
		var existingTab = this.down('#tEditor').down('[_fileSsid='+fileSsid+']'),
			cmpEditor = existingTab.down('#cmpEditor') ;
		var file_base64 ;
		if( cmpEditor.getValue()==null ) {
			return null ;
		}
		if( cmpEditor.valueIsRaw ) {
			file_base64 = cmpEditor.getValue();
		} else {
			file_base64 = Ext.util.Base64.encode(cmpEditor.getValue());
		}
		return file_base64;
	},
	doUploadFile: function(fileSsid) {
		var file_base64 = this.getFileBase64(fileSsid) ;
		if( file_base64==null ) {
			return ;
		}
		var ajaxParams = new Object() ;
		Ext.apply( ajaxParams, {
			_action: 'qapps_qappTransaction',
			_subaction: 'file_upload',
			_transaction_id: this._transactionId,
			qapp_file_ssid: fileSsid,
			file_base64: this.getFileBase64(fileSsid),
		});
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams ,
			success: function(response) {
				if( Ext.decode(response.responseText).success == false ) {
					Ext.Msg.alert('Failed', 'Failed');
				}
			},
			scope: this
		});
	},
	
	doFileCreate: function( fileName ) {
		var ajaxParams = new Object() ;
		Ext.apply( ajaxParams, {
			_action: 'qapps_qappTransaction',
			_subaction: 'file_action',
			_transaction_id: this._transactionId,
			file_action: 'new',
			file_name: fileName,
		});
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams ,
			success: function(response) {
				if( Ext.decode(response.responseText).success == false ) {
					Ext.Msg.alert('Failed', Ext.decode(response.responseText).error||'Failed');
				} else {
					this.doLoadFiles();
				}
			},
			scope: this
		});
	},
	doFileDelete: function( fileSsid ) {
		var ajaxParams = new Object() ;
		Ext.apply( ajaxParams, {
			_action: 'qapps_qappTransaction',
			_subaction: 'file_action',
			_transaction_id: this._transactionId,
			file_action: 'delete',
			qapp_file_ssid: fileSsid,
		});
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams ,
			success: function(response) {
				if( Ext.decode(response.responseText).success == false ) {
					Ext.Msg.alert('Failed', Ext.decode(response.responseText).error||'Failed');
				} else {
					var existingTab = this.down('#tEditor').down('[_fileSsid='+fileSsid+']') ;
					if( existingTab ) {
						existingTab.deleted = true ;
						existingTab.close();
					}
					this.doLoadFiles();
				}
			},
			scope: this
		});
	},
	
	remoteAction: function( actionCode, actionParam ) {
		var me = this ;
		switch( actionCode ) {
			case 'submit' :
				me.remoteActionSubmit( Ext.emptyFn, me ) ;
				break ;
			case 'save' :
				me.remoteActionSubmit( me.remoteActionSave, me ) ;
				break ;
			case 'saveas' :
				var newQueryName = actionParam ;
				me.remoteActionSubmit( me.remoteActionSaveAs, me, [newQueryName] ) ;
				break ;
			case 'delete' :
				me.remoteActionSubmit( me.remoteActionDelete, me ) ;
				break ;
				
			case 'toggle_publish' :
				var isPublished = actionParam ;
				me.remoteActionSubmit( me.remoteActionTogglePublish, me, [isPublished]  ) ;
				break ;
				
			case 'build' :
				me.remoteActionSubmit( me.remoteActionBuild, me ) ;
				break ;
				
			default :
				break ;
		}
	},
	remoteActionSubmit: function( callback, callbackScope, callbackArguments ) {
		if( !callback ) {
			callback = Ext.emptyFn ;
		}
		
		var filesData = [] ;
		this.down('#tEditor').items.each( function(p) {
			var fileSsid = p._fileSsid,
				file_base64 = this.getFileBase64(fileSsid);
			if( file_base64==null ) {
				return ;
			}
			filesData.push({
				qapp_file_ssid: fileSsid,
				file_base64: file_base64,
			});
		},this);
		
		var qapp_cfg_obj = this._qappData.qapp_cfg_obj ;
		qapp_cfg_obj.assets = [] ;
		this.down('#pExplorer').getRootNode().cascadeBy( function(n) {
			if( n.get('checked') && n.get('asset_id') ) {
				qapp_cfg_obj.assets.push(n.get('asset_id'));
			}
		},this);
		
		
		var ajaxParams = {} ;
		Ext.apply( ajaxParams, {
			_action: 'qapps_qappTransaction',
			_transaction_id: this._transactionId,
			_subaction: 'submit',
					  
			data: Ext.JSON.encode({
				qapp_cfg_obj: qapp_cfg_obj,
				files: filesData,
			}),
		});
		
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams ,
			success: function(response) {
				if( Ext.decode(response.responseText).success == false ) {
					Ext.Msg.alert('Failed', 'Failed');
				}
				else {
					callback.call( this, callbackArguments ) ;
				}
			},
			scope: this
		});
	},
	remoteActionSave: function() {
		var ajaxParams = {} ;
		Ext.apply( ajaxParams, {
			_action: 'qapps_qappTransaction',
			_transaction_id: this._transactionId,
			_subaction: 'save'
		});
		
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams ,
			success: function(response) {
				if( Ext.decode(response.responseText).success == false ) {
					Ext.Msg.alert('Failed', 'Failed');
					this.fireEvent('querysaved',false) ;
				}
				else {
					this.optimaModule.postCrmEvent('querychange') ;
					this.fireEvent('querysaved',true,Ext.decode(response.responseText).qapp_id) ;
				}
			},
			scope: this
		});
	},
	remoteActionSaveAs: function( newQueryName ) {
		var ajaxParams = {} ;
		Ext.apply( ajaxParams, {
			_action: 'qapps_qappTransaction',
			_transaction_id: this._transactionId,
			_subaction: 'saveas',
			qapp_name: newQueryName
		});
		
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams ,
			success: function(response) {
				if( Ext.decode(response.responseText).success == false ) {
					Ext.Msg.alert('Failed', 'Failed');
					this.fireEvent('querysaved',false) ;
				}
				else {
					this.optimaModule.postCrmEvent('querychange') ;
					this.fireEvent('querysaved',true,Ext.decode(response.responseText).qapp_id) ;
				}
			},
			scope: this
		});
	},
	remoteActionDelete: function() {
		var ajaxParams = {} ;
		Ext.apply( ajaxParams, {
			_action: 'qapps_qappTransaction',
			_transaction_id: this._transactionId,
			_subaction: 'delete'
		});
		
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams ,
			success: function(response) {
				if( Ext.decode(response.responseText).success == false ) {
					Ext.Msg.alert('Failed', 'Failed');
					this.fireEvent('querydelete',false) ;
				}
				else {
					this.optimaModule.postCrmEvent('querychange') ;
					this.fireEvent('querydelete',true ) ;
					this.destroy() ;
				}
			},
			scope: this
		});
	},
	remoteActionTogglePublish: function( isPublished ) {
		var me = this ;
		
		var ajaxParams = {} ;
		Ext.apply( ajaxParams, {
			_action: 'qapps_qappTransaction',
			_transaction_id: this._transactionId,
			_subaction: 'toggle_publish',
			isPublished: isPublished
		});
		
		me.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams ,
			success: function(response) {
				if( Ext.decode(response.responseText).success == false ) {
					Ext.Msg.alert('Failed', 'Failed');
				}
				else {
					me.optimaModule.postCrmEvent('togglepublishqapp',{
						qType:'qapp',
						qappId:me._qappId
					}) ;
				}
			},
			scope: me
		});
	},
	
	remoteActionBuild: function() {
		var me = this ;
		var msgbox = Ext.Msg.wait('Building app.');
		
		var ajaxParams = {} ;
		Ext.apply( ajaxParams, {
			_action: 'qapps_qappTransaction',
			_transaction_id: this._transactionId,
			_subaction: 'build'
		});
		
		me.optimaModule.getConfiguredAjaxConnection().request({
			timeout: (10 * 60 * 1000),
			params: ajaxParams ,
			success: function(response) {
				msgbox.close() ;
				var ajaxData = Ext.decode(response.responseText) ;
				if( ajaxData.success == false ) {
					Ext.Msg.alert('Failed', 'Unknown error / Missing parameters');
				}
				else {
					me.fireEvent( 'qbuildready', this, this._transactionId, ajaxData.build_uuid ) ;
				}
			},
			scope: me
		});
	},
	
});
