Ext.define('Optima5.Modules.CrmBase.QappWindow' ,{
	extend: 'Ext.window.Window',
	requires: [
		'Optima5.Modules.CrmBase.QwindowToolbar',
		'Optima5.Modules.CrmBase.QappPanel',
	],
	
	optimaModule: null,
	
	
	qType:'qapp',
	
	qappId:null,
	qappNew:false,
		
	transaction_id: null,
	buildSystemWindow: null,
		
	getQcfg: function() {
		var me = this ;
		
		var qCfg = {
			qType: 'qapp',
		};
		if( me.qappId == null ) {
			qCfg['qappNew'] = true ;
		} else {
			qCfg['qappId'] = me.qappId ;
		}
		return qCfg
	},
	getAjaxAction: function() {
		return 'qapps_qappTransaction';
	},
	
	initComponent: function() {
		var me = this ;
		if( (me.optimaModule) instanceof Optima5.Module ) {} else {
			Optima5.Helper.logError('CrmBase:Qwindow','No module reference ?') ;
		}
		
		me.qresultWindows = new Ext.util.MixedCollection();
		
		Ext.apply(me,{
			width:1000,
			height:700,
			tbar: Ext.create('Optima5.Modules.CrmBase.QwindowToolbar',{
				itemId:'tbar',
				optimaModule: me.optimaModule,
				qType: me.qType,
				listeners:{
					toolbaritemclick: me.onToolbarItemClick,
					scope:me
				}
			}),
			items:[Ext.create('Optima5.Modules.CrmBase.QappPanel',{
				itemId:'qappPanel',
				optimaModule: me.optimaModule,
				listeners: {
					querysaved: function( success, qappId ) {
						if( success ) {
							me.onQappSaved(qappId);
						}
					},
					querydelete: function( success ) {
						if( success ) {
							me.close();
						}
					},
					qtransactionopen: function( qapppanel, transactionId ) {
						me.onTransactionOpen(transactionId) ;
					},
					qbuildready: function(qpanel, transactionId, build_uuid) {
						if( transactionId != me.transaction_id ) {
							return ;
						}
						me.onBuildReady(build_uuid) ;
					},
					scope:me
				}
			})]
		});
		
		
		me.on('show', function() {
			// configure panel + load data
			me.configureComponents() ;
		},me,{single:true}) ;
		
		me.callParent() ;
		me.on('beforeclose',this.onBeforeClose,this) ;
		
		me.mon(me.optimaModule,'op5broadcast',me.onCrmeventBroadcast,me) ;
	},
	onCrmeventBroadcast: function( crmEvent, eventParams ) {
		var me = this ;
		switch( crmEvent ) {
			case 'togglepublishqapp' :
				break ;
			
			default :
				return ;
		}
		
		switch( crmEvent ) {
			case 'togglepublishqapp' :
				return me.configureComponents(true) ;
		}
	},
	
	onQappSaved: function( qappId ) {
		var me = this ;
		me.qType = 'qapp' ;
		me.qappNew = false ;
		me.qappId = qappId ;
		
		me.configureComponents() ;
	},
	
	getToolbar: function() {
		var me = this ;
		return me.child('#tbar');
	},
	getPanel: function() {
		var me = this ;
		return me.child('#qappPanel') ;
	},
	
	configureComponents: function( toolbarOnly ) {
		var me = this ,
			params = {} ;
			
		if( !toolbarOnly ) {
			if( me.qappNew ) {
				me.getPanel().qappNew() ;
			} else if( me.qappId ) {
				me.getPanel().qappOpen(me.qappId) ;
			} else {
				return; // ???
			}
		}
		
		me.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_action: 'qapps_getToolbarData'
			},
			success: function(response) {
				var ajaxData = Ext.decode(response.responseText),
					winTitle,
					tbarDisableFile=false, tbarIsNew=false, tbarDisableSave=false, tbarIsPublished=false, tbarUuid=null,
					qbookArrZtemplate = null ;
				
				var authReadOnly=false,
						authDisableAdmin=false;
				if( ajaxData.auth_status ) {
					if( ajaxData.auth_status.disableAdmin ) {
						authDisableAdmin = true ;
					}
					if( ajaxData.auth_status.readOnly ) {
						authReadOnly = true ;
					}
				}
				
				if( me.qappNew ) {
					tbarIsNew = tbarDisableSave = true ;
					winTitle = 'App# '+'New App' ;
				} else if( me.qappId > 0 ) {
					Ext.Array.each( ajaxData.data_qapps, function(o) {
						if( o.qappId == me.qappId ) {
							winTitle = 'App# '+o.text ;
							if( o.isPublished ) {
								tbarIsPublished = true;
								tbarDisableSave = true;
								tbarUuid = o.qappUuid;
							}
							return false ;
						}
					});
					
				}
				
				// ** Set window title ***
				me.setTitle( me.optimaModule.getWindowTitle( winTitle ) ) ;
				
				// ** Configure toolbar **
				var tbar = me.getToolbar() ;
				
				var tbarFileMenu = tbar.child('#file') ;
				tbarFileMenu.setVisible(!tbarDisableFile && !authReadOnly) ;
				tbarFileMenu.menu.child('#save').setVisible(!tbarIsNew);
				tbarFileMenu.menu.child('#save').setDisabled(tbarDisableSave);
				tbarFileMenu.menu.child('#saveas').setVisible(true);
				tbarFileMenu.menu.child('#saveas').setDisabled(false);
				tbarFileMenu.menu.child('#delete').setDisabled(!tbarIsNew);
				tbarFileMenu.menu.child('#delete').setDisabled(tbarDisableSave);
				
				var isSuperuser = Optima5.Helper.getApplication().desktopGetCfgRecord().get('auth_is_admin') ;
				
				var tbarRunBtn = tbar.child('#run'),
					tbarRunQbookMenu = tbar.child('#run-qbook'),
					isQbook = (me.qType=='qbook'),
					isQsql = (me.qType=='qsql') ;
				tbar.child('#run').setVisible( false ) ;
				tbar.child('#run-qbook').setVisible( false ) ;
				tbar.child('#build-qapp').setVisible( true ) ;
				
				var tbarZtemplatesBtn = tbar.child('#ztemplates') ;
				tbarZtemplatesBtn.setVisible(false) ;
				
				var tbarOptionsMenu = tbar.child('#options') ;
				tbarOptionsMenu.setVisible(!tbarIsNew);
				tbarOptionsMenu.menu.child('#toggle-android').setVisible(true) ;
				if( tbarIsPublished ) {
					tbarOptionsMenu.menu.child('#toggle-android').setChecked(true,true) ;
					tbarOptionsMenu.menu.child('#toggle-android').addCls(tbar.clsForPublished) ;
				} else {
					tbarOptionsMenu.menu.child('#toggle-android').setChecked(false,true) ;
					tbarOptionsMenu.menu.child('#toggle-android').removeCls(tbar.clsForPublished) ;
				}
				tbarOptionsMenu.menu.child('#toggle-lockadmin').setVisible(false) ;
				tbarOptionsMenu.menu.child('#setup-autorun').setVisible(false) ;
				tbarOptionsMenu.menu.child('#setup-token').setVisible(false) ;
				
				tbarOptionsMenu.menu.child('#publish-uuid').setVisible(!!tbarUuid) ;
				if( tbarUuid ) {
					tbarOptionsMenu.menu.child('#publish-uuid').setText('Permalink : '+'<b>'+tbarUuid+'</b>') ;
					tbarOptionsMenu.menu.child('#publish-uuid')._uuid = tbarUuid ;
				} else {
					tbarOptionsMenu.menu.child('#publish-uuid').setText('') ;
					tbarOptionsMenu.menu.child('#publish-uuid')._uuid = null ;
				}
			},
			scope: me
		});
	},
	
	onToolbarItemClick: function( menuId, menuItemId, input ) {
		var me = this ;
		//console.log(menuId+':'+menuItemId+' '+input) ;
		switch( menuId ) {
			case 'file' :
				switch( menuItemId ) {
					case 'save' :
					case 'saveas' :
						return me.getPanel().remoteAction(menuItemId,input) ;
					case 'delete' :
						Ext.Msg.confirm('Delete app','Delete this app ?',function() {
							return me.getPanel().remoteAction('delete') ;
						},me) ;
					default : break ;
				}
				break ;
				
			case 'build-qapp' :
				return me.getPanel().remoteAction('build') ;
				
			case 'options' :
				switch( menuItemId ) {
					case 'toggle-android' :
						var checked = input ;
						return me.getPanel().remoteAction('toggle_publish',checked) ;
					case 'publish-uuid' :
						var uuid = input ;
						me.onBuildReady(uuid);
						return ;
					default : break ;
				}
				break ;
		}
	},
	
	
	onTransactionOpen: function( transactionId ) {
		if( this.transaction_id != null ) {
			this.doCleanup() ;
		}
		this.transaction_id = transactionId ;
	},
	
	onBuildReady: function( build_uuid ) {
		var relativePath = './' + build_uuid + '/',
			systemWindowName = 'build' + '_' + build_uuid.substr(0,8) ;
		if( this.buildSystemWindow && this.buildSystemWindow.closed ) {
			this.buildSystemWindow = null ;
		}
		if( this.buildSystemWindow && this.buildSystemWindow.name==systemWindowName ) {
			this.buildSystemWindow.location.reload();
			this.buildSystemWindow.focus();
		} else {
			var me = this ;
			this.buildSystemWindow = window.open(relativePath,systemWindowName);
		}
	},
	
	doCleanup: function() {
		// close result windows
		if( this.buildSystemWindow ) {
			if( !this.buildSystemWindow.closed ) {
				this.buildSystemWindow.close();
			}
			this.buildSystemWindow = null;
		}
		
		// end transaction
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_action: this.getAjaxAction(),
				_transaction_id: this.transaction_id ,
				_subaction: 'end'
			}
		});
	},
	doCleanupResult: function(RES_id) {
		// destory result
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_action: this.getAjaxAction(),
				_transaction_id: this.transaction_id ,
				_subaction: 'res_destroy',
				RES_id: RES_id
			}
		});
	},
	onBeforeClose: function() {
		if( this.getPanel().isDirty && this.getPanel().isDirty() && !this.acceptClose ) {
			Ext.Msg.confirm('Not saved ?','App was modified. Quit anyway ?',function(btn){
				if( btn=='yes' ) {
					this.acceptClose = true ;
					this.close() ;
				}
			},this);
			return false ;
		}
		return true ;
	},
	onDestroy: function() {
		this.doCleanup() ;
		this.callParent() ;
	}
});
