Ext.define('QsqlDescModel', {
	extend: 'Ext.data.Model',
	idProperty: 'id',
	fields: [
		{name: 'id', type: 'string'},
		{name: 'sql_database',  type: 'string'},
		{name: 'sql_database_is_local',  type: 'boolean'},
		{name: 'sql_view',  type: 'string'},
		{name: 'sql_field',   type: 'string'},
		{name: 'sql_field_type',   type: 'string'},
		{name: 'text', type: 'string'}
	]
});

Ext.define('Optima5.Modules.CrmBase.QsqlPanel' ,{
	extend: 'Ext.panel.Panel',
			  
	alias: 'widget.op5crmbaseqsql',
			  
	requires: [
		'Optima5.Modules.CrmBase.QueryResultPanel',
		'Ext.ux.dams.WaitMsg',
		'Ext.ux.dams.AceEditor',
	] ,
			  
	initComponent: function() {
		var me = this ;
		if( (me.optimaModule) instanceof Optima5.Module ) {} else {
			Optima5.Helper.logError('CrmBase:QsqlPanel','No module reference ?') ;
		}
		
		Ext.apply( me, {
			border:false,
			layout: {
				type: 'hbox',
				align: 'stretch'
			},
			items:[{
				xtype:'box',
				cls:'op5-waiting',
				flex:1
			}],
			autoDestroy: true
		}) ;
		
		me.callParent() ;
	},
	
	
	qsqlNew: function() {
		var me = this ;
		
		var ajaxParams = new Object() ;
		Ext.apply( ajaxParams, {
			_action: 'queries_qsqlTransaction',
			_subaction: 'init',
			is_new: 'true'
		});
		me.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams ,
			success: function(response) {
				if( Ext.decode(response.responseText).success == false ) {
					Ext.Msg.alert('Failed', 'Failed');
				}
				else {
					me.transaction_id = Ext.decode(response.responseText).transaction_id ;
					me.addComponents( Ext.decode(response.responseText).transaction_id, Ext.decode(response.responseText).data ) ;
				}
			},
			scope: this
		});
	},
	qsqlOpen: function( qsqlId ) {
		var me = this ;
		
		var ajaxParams = new Object() ;
		Ext.apply( ajaxParams, {
			_action: 'queries_qsqlTransaction',
			_subaction: 'init',
			qsql_id: qsqlId,
			is_new: 'false'
		});
		me.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams ,
			success: function(response) {
				if( Ext.decode(response.responseText).success == false ) {
					Ext.Msg.alert('Failed', 'Failed');
				}
				else {
					me.qsql_id = qsqlId ;
					me.qsql_name = Ext.decode(response.responseText).data.qsql_name ;
					me.transaction_id = Ext.decode(response.responseText).transaction_id ;
					me.addComponents( Ext.decode(response.responseText).transaction_id, Ext.decode(response.responseText).data ) ;
				}
			},
			scope: this
		});
	},
	
	
	addComponents: function( transactionId, ajaxData ){
		var me = this ;
		
		me.removeAll();
		
		me.transaction_id = transactionId ;
		me.fireEvent('qtransactionopen',this,me.transaction_id) ;
		if( ajaxData.qsql_id && ajaxData.qsql_id > 0 ) {
			me.qsql_id = ajaxData.qsql_id ;
			me.qsql_name =  ajaxData.qsql_name ;
		}
		
		var treeCfg = {} ;
		Ext.apply( treeCfg, {
			itemId: 'tViews',
			xtype: 'treepanel',
			title: 'Available views',
			flex: 1,
			useArrows: true,
			rootVisible: false,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'top',
				items: [{
					itemId: 'btnSdomain',
					xtype: 'button',
					disabled: false,
					icon: 'images/op5img/ico_blocs_small.gif',
					text: '<b>Available Sdomains</b>',
					menu: {
						xtype: 'menu',
						items: [{
							itemId: 'tDomains',
							xtype: 'treepanel',
							width:250,
							height:300,
							store: {
								fields: ['id','text'],
								root: {
									root: true,
									id: '',
									text: '<b>Available Sdomains</b>',
									expanded: true,
									children: []
								},
								proxy: {
									type: 'memory' ,
									reader: {
										type: 'json'
									}
								}
							},
							displayField: 'text',
							rootVisible: true,
							useArrows: true,
							listeners: {
								checkchange: {
									fn: function(rec,check) {
										var doFireCheckchange = false ;
										if( !check ) {
											this.getRootNode().cascadeBy(function(chrec){
												if( chrec==rec ) {
													chrec.set('checked',true) ;
												}
											},this);
										} else {
											this.getRootNode().cascadeBy(function(chrec){
												if( chrec != rec ) {
													chrec.set('checked',false) ;
												}
											},this);
											doFireCheckchange = true ;
										}
										if( rec == this.getRootNode() ) {
											this.value = null ;
										} else {
											this.value = rec.getId() ;
										}
										
										if( doFireCheckchange ) {
											this.fireEvent('change',this.value) ;
										}
									}
								},
								change: {
									fn: function(selectedValue) {
										this.filterTreeviewDatabase( selectedValue ) ;
									},
									scope: this
								}
							}
						}]
					}
				}]
			}],
			store: {
				model: 'QsqlDescModel',
				nodeParam: 'id',
				root: {children:[]}
			},
			columns: [{
				xtype: 'treecolumn', //this is so we know which column will show the tree
				text: 'View/Field',
				flex: 2,
				sortable: false,
				dataIndex: 'text',
				menuDisabled: false
			},{
				hidden: true,
				text: 'Type',
				flex: 1,
				sortable: false,
				dataIndex: 'sql_field_type',
				menuDisabled: true
			}],
			viewConfig: {
				plugins: {
					ptype: 'treeviewdragdrop',
					enableDrag: true,
					enableDrop: false,
					ddGroup: 'TreeToGrids'+me.getId()
				}
			}
		}) ;
		
		me.add(treeCfg) ;
		me.add({
			flex: 2,
			title: 'SQL Query string',
			xtype:'form',
			layout: 'fit',
			dockedItems: [{
				xtype: 'form',
				layout: 'hbox',
				dock: 'top',
				bodyCls: 'ux-noframe-bg',
				bodyPadding: '2px 8px',
				defaults: {
					listeners: {
						change: function() {
							this.addComponentsEvalForm();
						},
						scope: me
					}
				},
				items: [{
					itemId: 'fIsRw',
					xtype: 'checkbox',
					boxLabel: 'Read / write',
					value: ajaxData.data_sqlwrite,
					readOnly: ajaxData.auth_readonly
				},{
					xtype: 'box',
					width: 24
				},{
					itemId: 'fIsSuperUser',
					xtype: 'checkbox',
					boxLabel: '<font color="red">SuperUser</font>',
					value: ajaxData.data_sqlsu,
					readOnly: ajaxData.auth_readonly
				}]
			}],
			items: [/*{
				itemId: 'fQuerystring',
				xtype: 'textareafield',
				fieldCls: 'op5-crmbase-query-sql-textarea',
				grow: true,
				name: 'message',
				value: ajaxData.data_sqlquerystring,
				readOnly: ajaxData.auth_readonly,
				anchor: '100%',
				listeners: {
					change: function() {
						this.setDirty(true) ;
					},
					render: this.addComponentsOnRenderTextarea,
					scope: this
				}
			},*/
			Ext.create('Ext.ux.dams.AceEditor',{
				itemId: 'fQuerystring',
				myparam: 'paramvalue',
				mode: 'mysql',
				value: ajaxData.data_sqlquerystring,
				listeners: {
					change: function() {
						this.setDirty(true) ;
					},
					editorready: this.addComponentsOnRenderTextarea,
					scope: this
				}
			})]
		}) ;
		
		if( me.loadMask ) {
			me.loadMask.hide() ;
		}
		me.setDirty(false);
		
		// current Sdomain
		me.addComponentsEvalForm() ;
		
		me.fetchMetaData() ;
	},
	addComponentsEvalForm: function() {
		var me = this ;
		me.down('#fIsSuperUser').setVisible( me.down('#fIsRw').getValue() ) ;
	},
	addComponentsOnRenderTextarea: function(field) {
		var me = this ;
		
		var gridPanelDropTargetEl =  field.getAceEditor().container; // AceEditor
		var gridPanelDropTarget = Ext.create('Ext.dd.DropTarget', gridPanelDropTargetEl, {
			ddGroup: 'TreeToGrids'+me.getId(),
			notifyEnter: function(ddSource, e, data) {
				field.highlight() ; // AceEditor
			},
			notifyDrop: function(ddSource, e, data){
				var selectedRecord = ddSource.dragData.records[0];
				
				var toInsert ;
				if( !Ext.isEmpty(selectedRecord.get('sql_field')) ) {
					toInsert = ' `'+selectedRecord.get('sql_field')+'` ' ;
				} else if( selectedRecord.get('sql_database_is_local') ) {
					toInsert = ' `'+selectedRecord.get('sql_view')+'` ' ;
				} else {
					toInsert = ' `'+selectedRecord.get('sql_database')+'`.`'+selectedRecord.get('sql_view')+'` ' ;
				}
				
				field.insertTextAtCursor(toInsert) ;  // AceEditor
			}
		});
	},
	
	fetchMetaData: function() {
		var me = this ;
		
		var ajaxParams = new Object() ;
		Ext.apply( ajaxParams, {
			_action: 'queries_qsqlTransaction',
			_subaction: 'metadata',
			_transaction_id: me.transaction_id,
			is_new: 'false'
		});
		me.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams ,
			success: function(response) {
				if( Ext.decode(response.responseText).success == false ) {
					Ext.Msg.alert('Failed', 'Failed');
				}
				var ajaxData = Ext.decode(response.responseText).data ;
				
				this.cfgAjaxData = ajaxData ;
				
				var sdomainsChidren = [] ;
				Ext.Array.each( ajaxData.db_sdomains, function( sdomainRow ) {
					sdomainsChidren.push({
						leaf: true,
						checked: false,
						id: sdomainRow.sdomain_id,
						text: sdomainRow.sdomain_id
					}) ;
				}) ;
				this.down('#tViews').down('#tDomains').getStore().setRoot({
					root: true,
					id: '',
					text: '<b>Available Sdomains</b>',
					expanded: true,
					children: sdomainsChidren
				});
				this.filterTreeviewDatabase( this.optimaModule.getSdomainRecord().get('sdomain_id') ) ;
			},
			scope: this
		});
	},
	
	filterTreeviewDatabase: function(sdomainId, doLock) {
		// ajaxData
		var ajaxData = this.cfgAjaxData ;
		
		var sqlDatabase = null, sqlDatabaseIsLocal = null ;
		Ext.Array.each( ajaxData.db_sdomains, function( sdomainRow ) {
			if( sdomainRow.sdomain_id == sdomainId ) {
				sqlDatabase = sdomainRow.database_name ;
				sqlDatabaseIsLocal = sdomainRow.database_is_local ;
				return ;
			}
		},this) ;
		
		// Build tree store
		var rootViews = [] ;
		Ext.Array.each( ajaxData.db_schema, function(viewRow) {
			if( viewRow.database_name != sqlDatabase ) {
				return ;
			}
			var viewFields = [] ;
			Ext.Array.each( viewRow.view_fields, function(viewField) {
				viewFields.push({
					id: viewRow.view_name + '::' + viewField.field_name,
					text: viewField.field_name,
					sql_database: viewRow.database_name,
					sql_database_is_local: sqlDatabaseIsLocal,
					sql_view: viewRow.view_name,
					sql_field: viewField.field_name,
					sql_field_type: viewField.field_type,
					leaf: true
				});
			});
			rootViews.push({
				id: viewRow.view_name,
				text: '<b>'+viewRow.view_name+'</b>',
				sql_database: viewRow.database_name,
				sql_database_is_local: sqlDatabaseIsLocal,
				sql_view: viewRow.view_name,
				children: viewFields,
				expanded: false,
				expandable: true
			});
		}) ;
		var rootData = {
			root: true,
			children: rootViews,
			expanded: true
		} ;
		
		this.down('#tViews').getStore().setRootNode(rootData) ;
		
		this.down('toolbar').down('#btnSdomain').setText( '<b>'+sdomainId+'</b>' ) ;
		if( doLock ) {
			this.down('toolbar').down('#btnSdomain').setDisabled() ;
		}
	},
	
	jsInsertTextAtCursor: function(el, text) {
		return ; //AceEditor
		
		var val = el.value, endIndex, range;
		if (typeof el.selectionStart != "undefined" && typeof el.selectionEnd != "undefined") {
			endIndex = el.selectionEnd;
			el.value = val.slice(0, el.selectionStart) + text + val.slice(endIndex);
			el.selectionStart = el.selectionEnd = endIndex + text.length;
		} else if (typeof document.selection != "undefined" && typeof document.selection.createRange != "undefined") {
			el.focus();
			range = document.selection.createRange();
			range.collapse(false);
			range.text = text;
			range.select();
		}
	},
	
	
	getQueryPanelTreeStore: function() {
		var me = this ;
		
		return me.query('>treepanel')[0].getStore() ;
	},
			  
	remoteAction: function( actionCode, actionParam ) {
		var me = this ;
		switch( actionCode ) {
			case 'submit' :
				me.remoteActionSubmit( Ext.emptyFn, me ) ;
				break ;
			case 'save' :
				me.remoteActionSubmit( me.remoteActionSave, me ) ;
				break ;
			case 'saveas' :
				var newQueryName = actionParam ;
				me.remoteActionSubmit( me.remoteActionSaveAs, me, [newQueryName] ) ;
				break ;
			case 'delete' :
				me.remoteActionSubmit( me.remoteActionDelete, me ) ;
				break ;
				
			case 'toggle_lockadmin' :
				var isLocked = actionParam ;
				me.remoteActionSubmit( me.remoteActionToggleLockadmin, me, [isLocked]  ) ;
				break ;
			case 'toggle_publish' :
				var isPublished = actionParam ;
				me.remoteActionSubmit( me.remoteActionTogglePublish, me, [isPublished]  ) ;
				break ;
			case 'setup_autorun' :
				me.openAutorunSetup() ;
				break ;
			case 'setup_token' :
				me.openTokenSetup() ;
				break ;
				
			case 'run' :
				me.remoteActionSubmit( me.remoteActionRun, me ) ;
				break ;
				
			default :
				break ;
		}
	},
	remoteActionSubmit: function( callback, callbackScope, callbackArguments ) {
		var me = this ;
		
		if( !callback ) {
			callback = Ext.emptyFn ;
		}
		
		var ajaxParams = {} ;
		Ext.apply( ajaxParams, {
			_action: 'queries_qsqlTransaction',
			_transaction_id: me.transaction_id ,
			_subaction: 'submit',
					  
			data_sqlquerystring: Ext.JSON.encode(me.down('#fQuerystring').getValue()),
			data_sqlwrite: ( me.down('#fIsRw').getValue() ? 1 : 0 ),
			data_sqlsu: ( me.down('#fIsSuperUser').getValue() ? 1 : 0 )
		});
		
		me.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams ,
			success: function(response) {
				if( Ext.decode(response.responseText).success == false ) {
					Ext.Msg.alert('Failed', 'Failed');
				}
				else {
					callback.call( me, callbackArguments ) ;
				}
			},
			scope: me
		});
	},
	remoteActionSave: function() {
		var me = this ;
		
		var ajaxParams = {} ;
		Ext.apply( ajaxParams, {
			_action: 'queries_qsqlTransaction',
			_transaction_id: me.transaction_id ,
			_subaction: 'save'
		});
		
		me.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams ,
			success: function(response) {
				if( Ext.decode(response.responseText).success == false ) {
					Ext.Msg.alert('Failed', 'Failed');
					me.fireEvent('querysaved',false) ;
				}
				else {
					me.optimaModule.postCrmEvent('querychange') ;
					me.fireEvent('querysaved',true,Ext.decode(response.responseText).qsql_id) ;
				}
			},
			scope: me
		});
	},
	remoteActionSaveAs: function( newQueryName ) {
		var me = this ;
		
		var ajaxParams = {} ;
		Ext.apply( ajaxParams, {
			_action: 'queries_qsqlTransaction',
			_transaction_id: me.transaction_id ,
			_subaction: 'saveas',
			qsql_name: newQueryName
		});
		
		me.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams ,
			success: function(response) {
				if( Ext.decode(response.responseText).success == false ) {
					Ext.Msg.alert('Failed', 'Failed');
					me.fireEvent('querysaved',false) ;
				}
				else {
					me.optimaModule.postCrmEvent('querychange') ;
					me.fireEvent('querysaved',true,Ext.decode(response.responseText).qsql_id) ;
				}
			},
			scope: me
		});
	},
	remoteActionDelete: function() {
		var me = this ;
		
		var ajaxParams = {} ;
		Ext.apply( ajaxParams, {
			_action: 'queries_qsqlTransaction',
			_transaction_id: me.transaction_id ,
			_subaction: 'delete'
		});
		
		me.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams ,
			success: function(response) {
				if( Ext.decode(response.responseText).success == false ) {
					Ext.Msg.alert('Failed', 'Failed');
					me.fireEvent('querydelete',false) ;
				}
				else {
					me.optimaModule.postCrmEvent('querychange') ;
					me.fireEvent('querydelete',true ) ;
					me.destroy() ;
				}
			},
			scope: me
		});
	},
	remoteActionToggleLockadmin: function( isLocked ) {
		var me = this ;
		
		var ajaxParams = {} ;
		Ext.apply( ajaxParams, {
			_action: 'queries_qsqlTransaction',
			_transaction_id: me.transaction_id ,
			_subaction: 'toggle_lockadmin',
			isLocked: isLocked
		});
		
		me.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams ,
			success: function(response) {
				if( Ext.decode(response.responseText).success == false ) {
					Ext.Msg.alert('Failed', 'Failed');
				}
				else {
					me.optimaModule.postCrmEvent('togglelockquery',{
						qType:'qsql',
						queryId:me.qsql_id
					}) ;
				}
			},
			scope: me
		});
	},
	remoteActionTogglePublish: function( isPublished ) {
		var me = this ;
		
		var ajaxParams = {} ;
		Ext.apply( ajaxParams, {
			_action: 'queries_qsqlTransaction',
			_transaction_id: me.transaction_id ,
			_subaction: 'toggle_publish',
			isPublished: isPublished
		});
		
		me.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams ,
			success: function(response) {
				if( Ext.decode(response.responseText).success == false ) {
					Ext.Msg.alert('Failed', 'Failed');
				}
				else {
					me.optimaModule.postCrmEvent('togglepublishquery',{
						qType:'qsql',
						queryId:me.qsql_id
					}) ;
				}
			},
			scope: me
		});
	},
	remoteActionToggleAutorun: function( isAutorun ) {
		var me = this ;
		
		var ajaxParams = {} ;
		Ext.apply( ajaxParams, {
			_action: 'queries_qsqlTransaction',
			_transaction_id: me.transaction_id ,
			_subaction: 'toggle_autorun',
			isAutorun: isAutorun
		});
		
		me.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams ,
			success: function(response) {
				if( Ext.decode(response.responseText).success == false ) {
					Ext.Msg.alert('Failed', 'Failed');
				}
				else {
					me.optimaModule.postCrmEvent('toggleautorunquery',{
						qType:'qsql',
						queryId:me.qsql_id
					}) ;
				}
			},
			scope: me
		});
	},
	remoteActionRun: function() {
		var me = this ;
		var msgbox = Ext.ux.dams.WaitMsg.wait(null,'Running query. Please Wait.',function(btn){
			if( btn=='no' ) {
				console.log('aborting?') ;
				this.remoteActionRunAbort() ;
			}
		},this);
		
		var ajaxParams = {} ;
		Ext.apply( ajaxParams, {
			_action: 'queries_qsqlTransaction',
			_transaction_id: me.transaction_id ,
			_subaction: 'run'
		});
		
		this._remoteActionRun_isRunning = true ;
		me.optimaModule.getConfiguredAjaxConnection().request({
			timeout: (10 * 60 * 1000),
			params: ajaxParams ,
			success: function(response) {
				var remoteActionRun_isRunning = this._remoteActionRun_isRunning ;
				msgbox.close() ;
				if( !remoteActionRun_isRunning ) {
					return ;
				}
				var ajaxData = Ext.decode(response.responseText) ;
				if( ajaxData.success == false ) {
					if( ajaxData.query_error ) {
						Ext.Msg.alert('Query status', ajaxData.query_error);
					} else {
						Ext.Msg.alert('Failed', 'Unknown error / Missing parameters');
					}
				}
				else {
					me.fireEvent( 'qresultready', this, me.transaction_id, ajaxData.RES_id ) ;
				}
				this._remoteActionRun_isRunning = false ;
			},
			scope: me
		});
	},
	remoteActionRunAbort: function() {
		var me = this ;
		if( this._remoteActionRun_isRunning ) {
			this._remoteActionRun_isRunning = false ;
		}
		var ajaxParams = {} ;
		Ext.apply( ajaxParams, {
			_action: 'queries_qsqlTransaction',
			_transaction_id: me.transaction_id ,
			_subaction: 'run_abort'
		});
		me.optimaModule.getConfiguredAjaxConnection().request({
			timeout: (10 * 60 * 1000),
			params: ajaxParams ,
			success: function(response) {
				var ajaxData = Ext.decode(response.responseText) ;
			},
			scope: me
		});
	},
	
	setDirty: function(torf) {
		this.dirtyEdit = torf ;
	},
	isDirty: function() {
		return this.dirtyEdit ;
	},
	
	openAutorunSetup: function() {
		var me = this ;
		var ajaxParams = {} ;
		Ext.apply( ajaxParams, {
			_action: 'queries_qsqlTransaction',
			_transaction_id: me.transaction_id ,
			qsql_id: me.qsql_id
		});
		
		this.getEl().mask() ;
		// Open panel
		var createPanel = Ext.create('Optima5.Modules.CrmBase.QwindowAutorunForm',{
			optimaModule: this.optimaModule,
				_ajaxParams: ajaxParams,
				qType:'qsql',
				queryId: me.qsql_id,
			width:400, // dummy initial size, for border layout to work
			height:null, // ...
			floating: true,
			draggable: true,
			resizable: true,
			renderTo: this.getEl(),
			tools: [{
				type: 'close',
				handler: function(e, t, p) {
					p.ownerCt.destroy();
				},
				scope: this
			}]
		});
		createPanel.on('saved', function(p) {
			this.doTreeLoad() ;
		},this,{single:true}) ;
		createPanel.on('destroy',function(p) {
			this.getEl().unmask() ;
			this.floatingPanel = null ;
		},this,{single:true}) ;
		
		createPanel.show();
		createPanel.getEl().alignTo(this.getEl(), 'c-c?');
	},
	openTokenSetup: function() {
		var me = this ;
		var ajaxParams = {} ;
		Ext.apply( ajaxParams, {
			_action: 'queries_qsqlTransaction',
			_transaction_id: me.transaction_id ,
			qsql_id: me.qsql_id
		});
		
		
		var setSizeFromParent = function( parentPanel, targetPanel ) {
			targetPanel.setSize({
				width: parentPanel.getSize().width - 20,
				height: parentPanel.getSize().height - 60
			}) ;
		};
		
		
		this.getEl().mask() ;
		// Open panel
		var createPanel = Ext.create('Optima5.Modules.CrmBase.QwindowTokenPanel',{
			optimaModule: this.optimaModule,
				_ajaxParams: ajaxParams,
				qType:'qsql',
				queryId: me.qsql_id,
			width:400, // dummy initial size, for border layout to work
			height:null, // ...
			floating: true,
			draggable: true,
			resizable: true,
			renderTo: this.getEl(),
			constrain: true,
			tools: [{
				type: 'close',
				handler: function(e, t, p) {
					p.ownerCt.destroy();
				},
				scope: this
			}]
		});
		
		createPanel.mon(me,'resize', function() {
			setSizeFromParent( me, createPanel ) ;
		},me) ;
		
		// Size + position
		setSizeFromParent(me,createPanel) ;
		createPanel.on('destroy',function() {
			me.getEl().unmask() ;
			// me.fireEvent('qbookztemplatechange') ;
		},me,{single:true}) ;
		me.getEl().mask() ;
		
		createPanel.show();
		createPanel.getEl().alignTo(this.getEl(), 'c-c?');
	},
	
	dummyFn: Ext.emptyFn
});
