Ext.define('Optima5.Modules.Spec.DbsEmbramach.MachMilestonePanel',{
	extend:'Ext.panel.Panel',
	
	requires: ['Optima5.Modules.Spec.DbsEmbramach.CfgParamField'],
	
	editDisabled: null,

	initComponent: function() {
		var me = this ;
		Ext.apply( me, {
			layout:{
				type:'vbox',
				align:'stretch'
			},
			frame: true,
			items:[ me.initHeaderCfg(), {
				itemId: 'pForm',
				border: false,
				xtype:'form',
				height: 250,
				bodyCls: 'ux-noframe-bg',
				bodyPadding: 15,
				layout:'anchor',
				fieldDefaults: {
					labelWidth: 100,
					anchor: '100%'
				},
				items: [{
					xtype: 'fieldset',
					title: 'Milestone actual date/time',
					items: [{
						xtype: 'hiddenfield',
						name: 'milestone_code',
					},{
						xtype: 'checkboxfield',
						boxLabel: 'Clear actual time',
						name: 'ACTUAL_dateSql_null',
						listeners: {
							change: function(chk,val) {
								this.down('#pForm').getForm().findField('ACTUAL_dateSql').setVisible(!val) ;
							},
							scope: this
						}
					},{
						xtype: 'datetimefield',
						fieldLabel: 'Actual time',
						name: 'ACTUAL_dateSql',
					},{
						xtype: 'fieldcontainer',
						layout: {
							type: 'hbox',
							pack: 'end',
						},
						items: [{
							xtype: 'button',
							text: 'Set to now',
							handler: function() {
								this.down('#pForm').getForm().setValues({
									ACTUAL_dateSql: new Date(),
									ACTUAL_dateSql_null: false
								}) ;
							},
							scope: this
						}]
					}]
				}]
			}],
			buttons:[{
				itemId: 'btnSubmit',
				text: 'Validation',
				handler: function() {
					this.handleSubmit() ;
				},
				scope: this
			}]
		});
		
		this.callParent() ;
		
		this.down('#pHeader').on('headeraction',function(h,actionCode) {
			if( actionCode=='attachments' ) {
				this.fireEvent('historyopen',this,this.machRecord.get('_filerecord_id')) ;
			}
		},this) ;
		
		if( this.machRecord ) {
			var headerData = {
				delivery_id: this.machRecord.get('primary_key').join(' '),
				shipto_txt: this.machRecord.get('shipto_key').join(' '),
				milestone_txt: this.milestoneCode
			};
			this.down('#pHeader').update(headerData) ;
			
			var machRecordData = this.machRecord.getData(),
				machRecordMilestoneKey = 'milestone'+'_'+this.milestoneCode,
				machRecordMilestoneData = machRecordData[machRecordMilestoneKey] ;
			if( machRecordMilestoneData ) {
				this.down('#pForm').getForm().setValues({
					milestone_code: machRecordMilestoneData.milestone_code,
					ACTUAL_dateSql: machRecordMilestoneData.ACTUAL_dateSql,
				});
			} else {
				this.down('#pForm').setVisible(false) ;
			}
		}
		
		this.down('#pForm').getForm().getFields().each(function(field) {
			field.on('change',function(){
				me.onChange() ;
			},me) ;
		},me) ;
	},
	onChange: function() {
		
	},
	initHeaderCfg: function() {
		var headerCfg = {
			itemId: 'pHeader',
			xtype:'component',
			tpl: [
				'<div class="op5-spec-dbspeople-realvalidhdr">',
					'<div class="op5-spec-dbspeople-realvalidhdr-inline-tbl">',
						'<div class="op5-spec-dbspeople-realvalidhdr-inline-elem op5-spec-dbstracy-warning-icon">',
						'</div>',
						'<div class="op5-spec-dbspeople-realvalidhdr-inline-elem">',
							'<table class="op5-spec-dbspeople-realvalidhdr-tbl">',
							'<tr>',
								'<td class="op5-spec-dbspeople-realvalidhdr-tdlabel">Picking :</td>',
								'<td class="op5-spec-dbspeople-realvalidhdr-tdvalue">{delivery_id}</td>',
							'</tr>',
							'<tr>',
								'<td class="op5-spec-dbspeople-realvalidhdr-tdlabel">Customer :</td>',
								'<td class="op5-spec-dbspeople-realvalidhdr-tdvalue">{shipto_txt}</td>',
							'</tr>',
							'<tr>',
								'<td class="op5-spec-dbspeople-realvalidhdr-tdlabel">Milestone :</td>',
								'<td class="op5-spec-dbspeople-realvalidhdr-tdvalue">{milestone_txt}</td>',
							'</tr>',
							'</table>',
						'</div>',
					'</div>',
				'</div>',
				{
					disableFormats: true
				}
			]
		} ;
		
		return headerCfg ;
	},
	
	getSubmitData: function() {
		var formPanel = this.down('#pForm'),
			form = formPanel.getForm() ;
		return {
			milestone_code: form.findField('milestone_code').getValue(),
			ACTUAL_dateSql_null: form.findField('ACTUAL_dateSql_null').getValue(),
			ACTUAL_dateSql: form.findField('ACTUAL_dateSql').getRawValue()
		}
	},
	handleSubmit: function() {
		var submitData = this.getSubmitData() ;
		var error ;
		if( (submitData.ACTUAL_dateSql==null) && !submitData.ACTUAL_dateSql_null ) {
			error = 'No date specified' ;
		}
		if( error ) {
			Ext.Msg.alert('Error',error);
			return ;
		}
		return this.doSubmit() ;
	},
	doSubmit: function() {
		var submitData = this.getSubmitData() ;
		
		this.loadMask = Ext.create('Ext.LoadMask',{
			target: this,
			msg:"Please wait..."
		}).show();
		
		var ajaxParams = this.optimaModule.getConfiguredAjaxParams() ;
		Ext.apply( ajaxParams, {
			_moduleId: 'spec_dbs_embramach',
			_action: 'mach_setMilestone',
			flow_code: this.flowCode,
			_filerecord_id: this.machRecord.get('_filerecord_id'),
			data: Ext.JSON.encode(submitData)
		}) ;
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams,
			success: function(response) {
				var jsonResponse = Ext.JSON.decode(response.responseText) ;
				if( jsonResponse.success != true ) {
					return ;
				}
				this.optimaModule.postCrmEvent('datachange',{}) ;
				this.fireEvent('eventsaved',this,this.machRecord.get('_filerecord_id'),null) ;
				this.destroy() ;
			},
			callback: function() {
				this.loadMask.destroy() ;
			},
			scope: this
		}) ;
	}
}) ;
