Ext.define('DbsEzeerAdrbookEmailModel',{
	extend: 'Ext.data.Model',
	idProperty: 'id',
	fields: [
		{name: 'header_list_id', type: 'string'},
		{name: 'header_list_txt', type: 'string'},
		
		{name: 'email_adr', type:'string'},
		{
			name: 'email_domain',
			type:'string',
			convert: function( v, record ) {
				v = record.get('email_adr');
				if( !Ext.isString(v) ) {
					return '' ;
				}
				var ttmp = v.split('@') ;
				if( ttmp.length > 1 ) {
					return ttmp[ttmp.length-1] ;
				}
				return '';
			},
		},
		
		{name: 'date_add', type: 'date', dateFormat: 'Y-m-d H:i:s'},
		{name: 'date_last', type: 'date', dateFormat: 'Y-m-d H:i:s'},
		
		{name: 'link_lists', type: 'auto'},
		{name: 'link_groups', type: 'auto'},
	],
});

Ext.define('Optima5.Modules.Spec.DbsEzeer.AdrbookLinkField',{
	extend: 'Ext.form.FieldContainer',
	
	mixins: [
		'Ext.form.field.Field'
	],
	
	initComponent: function() {
		var me = this ;
		
		this._storeLists = Ext.create('Ext.data.Store',{
			data: [],
			fields: [
				{name: 'list_id', type:'string'},
				{name: 'list_txt', type: 'string'}
			],
			proxy: {
				type: 'memory'
			}
		});
		
		Ext.apply(me,{
			layout: {
				type: 'vbox',
				align: 'stretch'
			},
			items: [{
				itemId: 'cmbAdd',
				xtype: 'combobox',
				width: 175,
				forceSelection: true,
				editable: false,
				queryMode: 'local',
				displayField: 'list_txt',
				valueField: 'list_id',
				store: this._storeLists,
				matchFieldWidth: false,
				listConfig: {
					width: 350,
					getInnerTpl: function(displayField) {
						return '<div style="padding-bottom:6px"><div>{list_id}</div><div style="text:10px">Email&#160;:&#160;<b>{list_txt}</b></div></div>' ;
					}
				},
				listeners: {
					select: function() {
						this.handleAdd();
					},
					scope: this
				}
			},{
				//height:75,
				itemId: 'dvTags',
				xtype: 'dataview',
				cls: 'op5-spec-dbsezeer-headertags-field',
				tpl: [
					'<tpl for=".">',
						'<div class="op5-spec-dbsezeer-headertags">',
							'<tpl if="_deletable">',
								'<div class="op5-spec-dbsezeer-headertags-ico op5-spec-dbsezeer-headertags-ico-delete">',
								'</div>',
							'</tpl>',
							'<div class="op5-spec-dbsezeer-headertags-ico op5-spec-dbsezeer-headertags-ico-emailadr">',
							'</div>',
							'<div class="op5-spec-dbsezeer-headertags-text">',
							'{[this.getListTxt(values.list_id)]}',
							'</div>',
						'</div>',
					'</tpl>',
					{
						// XTemplate configuration:
						disableFormats: true,
						// Member functions
						getListTxt: function( listId ) {
							var store = me._storeLists ;
							var idx = store.find('list_id',listId);
							if( idx>=0 ) {
								return store.getAt(idx).get('list_txt') ;
							}
							return listId;
						}
					}
				],
				itemSelector: 'div.op5-spec-dbsezeer-headertags',
				store: {
					data: [],
					fields: [
						{name:'_deletable', type:'boolean'},
						{name:'list_id', type:'string'},
					]
				},
				prepareData: function(data) {
					return data;
				},
				listeners: {
					itemmouseleave: function(dv, record, item, index, e, eOpts) {
						Ext.defer(function() {
							if( record.get('_deletable') ) {
								record.set('_deletable',false) ;
								return ;
							}
						},100) ;
					},
					itemclick: function(dv, record, item, index, e, eOpts) {
						if( !record.get('_deletable') ) {
							record.set('_deletable',true) ;
							return ;
						}
						if( e.getTarget('div.op5-spec-dbsezeer-headertags-ico-delete') ) {
							this.deleteTag(record) ;
						}
						e.stopEvent() ;
					},
					scope: this
					
				}
			}]
		}) ;
		me.mixins.field.constructor.call(me);
		me.callParent() ;
		me.populateLists() ;
	},
	
	
	getStore: function() {
		return this.down('#dvTags').getStore() ;
	},
	getRawValue: function() {
		var values = this.getValue() ;
		return Ext.JSON.encode(values) ;
	},
	getValue: function() {
		var values = [] ;
		this.getStore().each( function(rec) {
			var v = rec.getData(),
				listId = v.list_id ;
			if( Ext.isEmpty(listId) ) {
				return ;
			}
			values.push(listId) ;
		},this) ;
		return values ;
	},
	setRawValue: function(jsonValues) {
		var values = Ext.JSON.decode( jsonValues );
		this.setValue(values) ;
	},
	setValue: function(values) {
		if( Ext.isEmpty(values) || !Ext.isArray(values) ) {
			this.getStore().removeAll() ;
			return ;
		}
		var storeData = [] ;
		Ext.Array.each(values,function(v) {
			storeData.push({list_id:v}) ;
		});
		this.getStore().loadData(storeData) ;
	},
	handleAdd: function() {
		var cmbAdd = this.down('#cmbAdd'),
			dvTags = this.down('#dvTags') ; 
		if( Ext.isEmpty(cmbAdd.getRawValue()) ) {
			return ;
		}
		
		var test = dvTags.getStore().findExact('list_id',cmbAdd.getValue(),0);
		if (test == -1){
			dvTags.getStore().insert(0,{
				list_id: cmbAdd.getValue()
			});
			cmbAdd.reset() ;
		}
	},
	deleteTag: function(tagRecord) {
		this.down('#dvTags').getStore().remove(tagRecord) ;
	},
	
	
	
	
	
	populateLists: function() {
		var listsData = [];
		listsData = Optima5.Modules.Spec.DbsEzeer.HelperCache.getPeopleListAll();
		
		var store = this._storeLists ;
		store.removeAll() ;
		store.loadData(listsData) ;
	}
});


Ext.define('Optima5.Modules.Spec.DbsEzeer.AdrbookPanel',{
	extend:'Ext.panel.Panel',
	
	initComponent: function() {
		Ext.apply(this, {
			width:800,
			height:400,
			title: 'Addressbook Mgmt',
			layout: 'border',
			tbar: [{
				itemId: 'tbViewmode',
				viewConfig: {forceFit: true},
				menu: {
					defaults: {
						handler:function(menuitem) {
							//console.log('ch view '+menuitem.itemId) ;
							this.onViewSelect( menuitem.itemId ) ;
						},
						scope:this
					},
					items: [{
						itemId: 'email',
						text: 'Emails',
						iconCls: 'op5-spec-dbsezeer-explorer-status-owned',
					},{
						itemId: 'list',
						text: 'Lists/groups',
						iconCls: 'op5-spec-dbsezeer-explorer-status-scope'
					}]
				}
			},{
				xtype: 'textfield',
				itemId: 'btnSearch',
				width: 150,
				allowBlank:true,
				triggers: {
					clear: {
						cls: Ext.baseCSSPrefix + 'form-clear-trigger',
						handler: function(field) {
							field.reset() ;
						},
						scope: this,
					}
				},
				enableKeyEvents: true,
				listeners: {
					change: {
						fn: function(field) {
							this.onSearchChange() ;
						},
						scope: this,
						buffer: 500
					},
					afterrender: function( field ) {
						var triggers = field.getTriggers() ;
						if( triggers.picker ) {
							triggers.picker.hide() ;
						}
					},
					scope: this
				}
			},'->',{
				hidden: true,
				itemId: 'btnNew',
				icon: 'images/op5img/ico_new_16.gif',
				text: 'Add email(s)',
				handler: function() {
					this.handleBtnNew();
				},
				scope: this,
			},{
				hidden: true,
				itemId: 'btnDelete',
				icon: 'images/op5img/ico_delete_16.gif',
				text: 'Delete contact',
				handler: function() {
					this.handleBtnDelete();
				},
				scope: this,
			}],
			items:[{
				flex: 1,
				itemId: 'pGrid',
				region: 'center',
				xtype: 'grid',
				bufferedRenderer: true,
				store: {
					model: 'DbsEzeerAdrbookEmailModel',
					autoLoad: true,
					proxy: {
						type: 'memory',
						reader: {
							type: 'json',
						}
					},
					sorters: [{
						property: 'email_adr',
						direction: 'ASC',
					}],
					listeners: {
						load: function( store ) {
							this.applySmartGrouping();
						},
						sort: function( store ) {
							this.applySmartGrouping();
						},
						scope: this,
					}
				},
				features: [{
					ftype:'grouping',
					//hideGroupedHeader: true,
					groupHeaderTpl:Ext.create('Ext.XTemplate',
						'<div>{[this.renderer(values)]}</div>',
						{
							renderer: function(values) {
								if( values.rows.length == 0 ) {
									return '' ;
								}
								
								var retVal = '' ;
								switch( values.groupField ) {
									case 'email_domain' :
										return '@ '+ values.rows[0].data.email_domain ;
									case 'header_list_id' :
										if( Ext.isEmpty(values.rows[0].data.header_list_id) ) {
											return '<i>'+'no group'+'</i>' ;
										}
										return values.rows[0].data.header_list_txt ;
								}
							}
						}
					)
				}],
				columns: [{
					flex: 1,
					minWidth: 280,
					dataIndex: 'email_adr',
					text: 'Email Addr.',
				},{
					hidden: true,
					width: 100,
					dataIndex: 'email_domain',
					text: 'Email Domain',
				},{
					xtype: 'datecolumn',
					format: 'd/m/Y',
					width: 100,
					dataIndex: 'date_add',
					text: 'Date added',
					
				}],
				listeners: {
					itemdblclick: function(p,r) {
						this.setEmailRecord(r);
					},
					scope: this,
				},
			},{
				hidden: true,
				frame: true,
				flex: 1,
				border: false,
				region: 'east',
				headerPosition: 'left',
				collapsible: false,
				itemId: 'pForm',
				//collapsed: true,
				xtype: 'form',
				bodyCls: 'ux-noframe-bg',
				bodyPadding: 10,
				layout: 'anchor',
				title: 'Insert / Edit',
				fieldDefaults: {
					labelAlign: 'top',
					labelWidth: 85,
					anchor: '100%',
				},
				items: [{
					xtype: 'textfield',
					fieldLabel: 'Email Adr',
					name: 'email_adr',
				},{
					xtype: 'textarea',
					fieldLabel: 'Email Adr(s)',
					name: 'email_adrs',
				},{
					//height: 300,
					optimaModule: this.optimaModule,
					xtype: 'op5crmbasebibletreepicker',
					bibleId: 'PPL_GROUP',
					fieldLabel: 'Groups',
					name: 'link_groups',
				},Ext.create('Optima5.Modules.Spec.DbsEzeer.AdrbookLinkField',{
					fieldLabel: 'Mailing lists',
					name: 'link_lists',
				})],
				buttons: [{
					xtype: 'button',
					text: 'Submit',
					handler:function(btn){ 
						this.submitEmailForm();
					},
					scope: this
				}],
			}]
		});
		this.callParent() ;
		this.dismissForm();
		this.onViewSelect('email');
	},
	getViewMode: function() {
		return this.down('#tbViewmode').tbViewmodeItemId;
	},
	onViewSelect: function(viewId,dontLoad=false) {
		var tbViewmode = this.down('#tbViewmode'),
			tbViewmodeItem = tbViewmode.menu.getComponent(viewId),
			iconCls, text ;
		if( !tbViewmodeItem ) {
			return ;
		}
		tbViewmode.tbViewmodeItemId = viewId ;
		// View mode
		var tbViewmodeItem = tbViewmode.menu.getComponent(viewId) ;
		if( tbViewmodeItem ) {
			var txt = '<b>' + tbViewmodeItem.text + '</b>' ;
			tbViewmode.setText( txt );
			tbViewmode.setIconCls( tbViewmodeItem.iconCls );
		}
		
		this.doLoad();
	},
	getGrid: function() {
		return this.down('#pGrid') ;
	},
	applySmartGrouping: function() {
		var store = this.getGrid().getStore();
		var sorters = store.getSorters(),
			groupField = null, groupDir=null;
		switch( this.getViewMode() ) {
			case 'email' :
				if( sorters.get('email_adr') ) {
					groupField = 'email_domain' ;
					groupDir = sorters.get('email_adr').getDirection();
					console.log(groupDir);
				}
				break ;
			case 'list' :
				groupField = 'header_list_id' ;
				groupDir = 'ASC';
				break ;
		}
		store.clearGrouping() ;
		if( !groupField ) {
			return ;
		}
		store.group(groupField,groupDir) ;
	},
	doLoad: function() {
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_ezeer',
				_action: 'cfg_getAdrbookEmail',
			},
			success: function(response) {
				var ajaxData = Ext.decode(response.responseText) ;
				if( ajaxData.success == false ) {
					return ;
				}
				this.onLoad(ajaxData.data) ;
			},
			scope: this
		});
	},
	onLoad: function(ajaxData) {
		switch( this.getViewMode() ) {
			case 'email' :
				this.getGrid().getStore().loadData(ajaxData);
				break;
			case 'list' :
				var map_listId_listTxt = {} ;
				Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getPeopleListAll(), function(l) {
					map_listId_listTxt[l.list_id] = l.list_txt ;
				});
				var gridData = [] ;
				Ext.Array.each( ajaxData, function(r) {
					if( Ext.isEmpty(r.link_lists) ) {
						gridData.push(r);
						return ;
					}
					Ext.Array.each( r.link_lists, function(listId) {
						var newR = Ext.clone(r);
						newR.header_list_id = listId ;
						newR.header_list_txt = map_listId_listTxt[listId];
						gridData.push(newR);
					});
				});
				this.getGrid().getStore().loadRawData(gridData);
				break;
		}
		this.applySmartGrouping();
	},
	
	onSearchChange: function() {
		var btnSearch = this.down('#btnSearch') ;
		var btnSearchTxt = btnSearch.getValue().toLowerCase() ;
		
		var gridPanel = this.down('#pGrid') ;
		var gridStore = this.down('#pGrid').getStore() ;
		gridStore.clearFilter() ;
		
		if( Ext.isEmpty(btnSearchTxt) ) {
			return ;
		}
		
		// visible fields if the grid header
		var visibleDataIndexes = ['email_adr'] ;
		
		// do filtering with a custom function
		gridStore.filterBy( function(record) {
			// For each record, iterate over the FIELDS, and for each field "string compare" to btnSearchTxt
			var isItAMatchIdx = [] ;
			Ext.Array.each( [btnSearchTxt], function(btnSearchWord,idx) {
				isItAMatchIdx[idx] = false ;
				Ext.Array.each( visibleDataIndexes, function( dataIndex ) {
					var recordFieldValue = record.get(dataIndex) ;
					if( !Ext.isString(recordFieldValue) ) {
						return ;
					}
					if( recordFieldValue.toLowerCase().indexOf(btnSearchWord) != -1 ) {
						isItAMatchIdx[idx] = true ;
					}
				}) ;
			}) ;
			var isItAMatch = true ;
			Ext.Array.each( isItAMatchIdx,function(torf) {
				if(!torf) {
					isItAMatch = false ;
				}
			}) ;
			return isItAMatch ;
		}) ;
	},
	
	handleBtnNew: function() {
		this.setEmailRecord(null);
	},
	handleBtnDelete: function() {
		var doDelete=true;
		this.submitEmailForm(doDelete);
	},
	
	setEmailRecord: function(rec) {
		var formPanel = this.down('#pForm');
			form = formPanel.getForm();
		
		form.reset();
		form.findField('email_adr').setVisible(!!rec) ;
		form.findField('email_adr').setReadOnly(true) ;
		form.findField('email_adrs').setVisible(!rec) ;
		if( !!rec ) {
			this.down('#pForm').getForm().setValues({
				email_adr: rec.get('email_adr'),
				link_groups: Ext.JSON.encode(rec.get('link_groups')),
				link_lists: rec.get('link_lists'),
			});
		}
		this.down('toolbar').down('#btnNew').setVisible(false);
		this.down('toolbar').down('#btnDelete').setVisible(!!rec);
		formPanel.setVisible(true) ;
	},
	submitEmailForm: function(doDelete=false) {
		var form = this.down('#pForm').getForm(),
			values = form.getFieldValues();
		
		var submitObj = {} ;
		if( form.findField('email_adr').isVisible() ) {
			submitObj['email_adr'] = values['email_adr'];
		}
		if( form.findField('email_adrs').isVisible() ) {
			tArr = [] ;
			Ext.Array.each( values['email_adrs'].split('\n') , function(str) {
				var oneEmail = str.trim() ;
				var ereg = /^\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/;
				if( ereg.test(oneEmail) ) {
					tArr.push(oneEmail) ;
				}
			});
			submitObj['email_adr'] = tArr;
		}
		submitObj['link_groups'] = Ext.JSON.decode(values['link_groups']) ;
		submitObj['link_lists'] = values['link_lists'] ;
		
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_ezeer',
				_action: 'cfg_setAdrbookEmailRecord',
				data: Ext.JSON.encode(submitObj),
				do_delete: doDelete ? 1 : 0, 
			},
			success: function(response) {
				var ajaxData = Ext.decode(response.responseText) ;
				if( ajaxData.success == false ) {
					Ext.Msg.alert('Failed', 'Error');
					return ;
				}
				this.dismissForm();
				this.doLoad() ;
			},
			scope: this
		});
	},
	dismissForm: function() {
		this.down('#pForm').setVisible(false);
		this.down('toolbar').down('#btnDelete').setVisible(false);
		this.down('toolbar').down('#btnNew').setVisible(true);
	}
}) ;
