Ext.define('DbsEzeerCfgParamTreeModel', {
    extend: 'Ext.data.Model',
	 idProperty: 'nodeId',
    fields: [
        {name: 'nodeId',  type: 'string'},
		  {name: 'nodeType', type: 'string'},
		  {name: 'nodeKey',  type: 'string'},
        {name: 'nodeText',   type: 'string'},
		  {name: 'leaf_only', type:'boolean'}
     ]
});

Ext.define('Optima5.Modules.Spec.DbsEzeer.CfgParamTree',{
	extend:'Ext.tree.Panel',
	
	optimaModule: null,
	cfgParam_id: '',
	value: null,
	forceValue: false,
	
	initComponent: function() {
		var me = this ;
		if( (me.optimaModule) instanceof Optima5.Module ) {} else {
			Optima5.Helper.logError('DbsEzeer:CfgParamTree','No module reference ?') ;
		}
		
		Ext.apply(me,{
			store: {
				model: 'DbsEzeerCfgParamTreeModel',
				root: {children:[]},
				proxy: {
					type: 'memory' ,
					reader: {
						type: 'json'
					}
				}
			},
			displayField: 'nodeText',
			rootVisible: true,
			useArrows: true
		});
		this.callParent() ;
		me.startLoading() ;
	},
	startLoading: function() {
		if( this.cfgParam_root ) {
			this.doLoading(this.cfgParam_root) ;
			return ;
		}
		if( !Ext.isEmpty(this.cfgParam_id) ) {
			var tarr = this.cfgParam_id.split(':') ;
			if( tarr.length > 1 ) {
				this.cfgParam_id = tarr.shift() ;
				this.cfgParam_param = tarr.join(':') ;
			}
		}
		
		var rootNode, rootChildren = [] ;
		switch( this.cfgParam_id ) {
			case 'PEOPLE_GROUP' :
				data = Optima5.Modules.Spec.DbsEzeer.HelperCache.getPeopleGroupAll() ;
				Ext.Array.each( data, function(row) {
					rootChildren.push({
						nodeId: row.group_id,
						nodeType: 'entry',
						nodeKey: row.group_id,
						nodeText: row.group_txt,
						leaf: true
					}) ;
				}) ;
				rootNode = {
					root: true,
					children: rootChildren,
					nodeText: '<b>People Groups</b>',
					expanded: true
				}
				break ;
				
			case 'PEOPLE' :
				Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getPeopleGroupAll(), function(row) {
					if( row['login_is_exclude'] ) {
						return ;
					}
					rootChildren.push({
						nodeId: 'group'+'|'+row.group_id,
						nodeType: 'treenode',
						nodeKey: row.group_id,
						nodeText: row.group_txt,
						expanded: true,
						icon: 'images/modules/admin-users-16.png',
						children: [{
							nodeId: 'group'+'|'+row.group_id+'|'+'nouser',
							nodeType: 'treenode',
							nodeKey: row.group_id,
							nodeText: '<i>'+'not assigned'+'</i>',
							leaf: true,
							icon: 'images/modules/admin-user-disabled-16.png',
						}]
					}) ;
				}) ;
				Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getPeopleUserAll(), function(row) {
					if( row['login_is_exclude'] ) {
						return ;
					}
					rootChildren.push({
						nodeId: 'user'+'|'+row.user_id,
						nodeType: 'entry',
						nodeKey: row.user_id,
						nodeText: row.user_name,
						leaf: true,
						icon: 'images/modules/admin-user-16.png',
					}) ;
				}) ;
				rootNode = {
					root: true,
					children: rootChildren,
					nodeText: '<b>People / Groups</b>',
					expanded: true
				}
				break ;
				
			case 'CATEGORY' :
				data = Optima5.Modules.Spec.DbsEzeer.HelperCache.getCategoryAll() ;
				Ext.Array.each( data, function(row) {
					var catSubcategories = [];
					Ext.Array.each( row.category_sub_lists, function(list) {
						var choices = [] ;
						Ext.Array.each( list.list_rows, function(listRow) {
							var nodeId = row.category_code + '|' + list.list_id+'='+listRow.row_txt;
							choices.push({
								nodeId: nodeId,
								nodeType: 'entry',
								nodeKey: nodeId,
								nodeText: listRow.row_txt,
								leaf:true,
							})
						});
						var nodeId = row.category_code + '|' + list.list_id;
						catSubcategories.push({
							nodeId: nodeId,
							nodeType: 'entry',
							nodeKey: list.list_id,
							nodeText: list.list_txt,
							children: choices,
						})
					});
					rootChildren.push({
						nodeId: row.category_code,
						nodeType: 'entry',
						nodeKey: row.category_code,
						nodeText: row.category_txt,
						children: catSubcategories,
					}) ;
				}) ;
				rootNode = {
					root: true,
					children: rootChildren,
					nodeText: '<b>Categories</b>',
					expanded: true
				}
				break ;
				
			case 'PRIORITY' :
				data = Optima5.Modules.Spec.DbsEzeer.HelperCache.getPriorityAll() ;
				Ext.Array.each( data, function(row) {
					rootChildren.push({
						nodeId: row.priority_code,
						nodeType: 'entry',
						nodeKey: row.priority_code,
						nodeText: row.priority_code + ' - ' + row.priority_txt,
						leaf: true
					}) ;
				}) ;
				rootNode = {
					root: true,
					children: rootChildren,
					nodeText: '<b>Priorities</b>',
					expanded: true
				}
				break ;
				
			case 'CLOSE' :
				data = Optima5.Modules.Spec.DbsEzeer.HelperCache.getCloseAll() ;
				var getNameOf = function( closeCode ) {
					var retValue = null ;
					Ext.Array.each( data, function(row) {
						if( row.close_code == closeCode ) {
							retValue = row.close_txt ;
							return false ;
						}
					}) ;
					return retValue ;
				};
				var getChildrenOf = function( closeCode ) {
					var children = [] ;
					Ext.Array.each( data, function(row) {
						if( row.parent_code == closeCode ) {
							var nextChildren = getChildrenOf(row.close_code) ;
							children.push({
								nodeId: row.close_code,
								nodeType: nextChildren ? 'treenode' : 'entry',
								nodeKey: row.close_code,
								nodeText: row.close_txt,
								leaf: (!nextChildren || nextChildren.length==0) ? true : false,
								expanded: false,
								children: nextChildren ? nextChildren : null
							});
						}
					}) ;
					if( children.length > 0 ) {
						return children ;
					}
					return [] ;
				};
				
				if( !Ext.isEmpty(this.cfgParam_param) ) {
					rootNode = {
						root: true,
						children: getChildrenOf(this.cfgParam_param),
						nodeText: '<b>'+getNameOf(this.cfgParam_param)+'</b>',
						expanded: true
					}
				} else {
					rootNode = {
						root: true,
						children: getChildrenOf(''),
						nodeText: '<b>Reason codes</b>',
						expanded: true
					}
				}
				break ;
				
			default :
				rootNode = {
					root: true,
					children: [],
					nodeText: 'Not defined',
					expanded: true
				}
		}
		this.getStore().setRootNode(rootNode) ;
		this.onAfterLoad() ;
		this.fireEvent('load',this) ;
	},
	setRootNode: function(rootNode) {
		this.callParent([rootNode]) ;
		this.onAfterLoad() ;
	},
	onAfterLoad: function() {
		this.getRootNode().cascadeBy(function(node) {
			if( this.cfgParam_leafOnly && !node.isLeaf() ) {
				return ;
			}
			if( node.isRoot() && Ext.isEmpty(this.value) ) {
				node.set('checked',true) ;
				return ;
			}
			node.set('checked', (node.getId()==this.value) );
		},this);
		
		this.getView().on('checkchange',function(rec,check){
			var doFireCheckchange = false ;
			if( !check ) {
				this.getRootNode().cascadeBy(function(chrec){
					if( (chrec.get('checked')===false) && (chrec==rec) ) {
						chrec.set('checked',true) ;
					}
				},this);
			} else {
				this.getRootNode().cascadeBy(function(chrec){
					if( (chrec.get('checked')===true) && (chrec!=rec) ) {
						chrec.set('checked',false) ;
					}
				},this);
				doFireCheckchange = true ;
			}
			if( rec == this.getRootNode() ) {
				this.value = null ;
			} else {
				this.value = rec.getId() ;
			}
			
			if( doFireCheckchange ) {
				this.fireEvent('change',this.value) ;
			}
		},this) ;
	},
	getValue: function() {
		return this.value ;
	},
	getCheckedNode: function() {
		var storeNode ;
		if( Ext.isEmpty(this.value) ) {
			storeNode = (this.forceValue ? this.getRootNode() : null) ;
		} else {
			storeNode = this.getStore().getNodeById( this.value ) ;
		}
		return storeNode ;
	},
	getNode: function() {
		var storeNode = this.getCheckedNode() ;
		if( storeNode == null ) {
			return null ;
		}
		return storeNode.data ;
	},
	getLeafNodesKey: function() {
		var storeNode = this.getCheckedNode() ;
		if( storeNode == null ) {
			return null ;
		}
		
		var leafs ;
		if( storeNode.isLeaf() ) {
			leafs = [storeNode.data.nodeKey] ;
		} else {
			leafs = [] ;
			storeNode.cascadeBy(function(node) {
				if( node.isLeaf() ) {
					leafs.push(node.data.nodeKey) ;
				}
			});
		}
		return leafs ;
	},
	
	setValue: function( nodeId, silent ) {
		if( !Ext.isEmpty(nodeId) && this.getStore().getNodeById(nodeId) == null ) {
			return ;
		}
		
		this.value = nodeId ;
		if( this.value == null ) {
			this.getRootNode().cascadeBy(function(node) {
				node.set('checked', node.isRoot());
			},this) ;
		} else {
			this.getRootNode().cascadeBy(function(node) {
				node.set('checked', (node.getId()==this.value) );
			},this);
		}
		
		if( silent === undefined || !silent ) {
			this.fireEvent('change',this.value) ;
		}
	},
	
	autoAdvance: function() {
		var setValue ;
		this.getRootNode().cascadeBy( function(node) {
			if( node.childNodes.length > 1 ) {
				return false ;
			}
			if( node.childNodes.length == 1 ) {
				var uniqueChildNode = node.childNodes[0] ;
				if( !uniqueChildNode.isLeaf() ) {
					setValue = uniqueChildNode.getId() ;
				}
			}
			if( !node.get('expandable') ) {
				return false ;
			}
		}) ;
		if( setValue != null ) {
			this.setValue(setValue) ;
		}
	}
}) ;
