Ext.define('DbsEzeerAttachmentModel',{
	extend: 'Ext.data.Model',
	idProperty: 'attach_filerecord_id',
	fields: [
		{name: 'attach_filerecord_id', type:'int'},
		{name: 'attach_filename', type:'string'},
		{name: 'attach_filedate', type:'date', dateFormat: 'Y-m-d H:i:s'},
		
		{name: 'status_is_cancel', type: 'boolean'},
		
		{name: 'ticketaction_filerecord_id', type:'int'}
	]
});

Ext.define('DbsEzeerAttachmentPopupModel',{
	extend: 'DbsEzeerAttachmentModel',
	idProperty: 'attach_filerecord_id',
	fields: [
		{name: '_checked', type:'boolean'},
		{name: '_checked_readonly', type:'boolean'},
	]
});

Ext.define('DbsEzeerTicketActionPropchangeModel',{
	extend: 'Ext.data.Model',
	fields: [
		{name: 'propchange_sign', type:'int'}, // -1 / +1
		{name: 'propchange_type', type:'string'},
		{name: 'propchange_id', type:'string'}, // group|GOM , OP5TRACY|trspt:123456 , P2
		{name: 'propchange_txt', type:'string'}
	],
});
Ext.define('DbsEzeerTicketActionModel',{
	extend: 'Ext.data.Model',
	idProperty: 'ticketaction_filerecord_id',
	fields: [
		{name: 'ticketaction_filerecord_id', type:'int'},
		
		{name: 'ticket_filerecord_id', type:'int'},
		{name: 'ticket_base_filerecord_id', type:'int'},
		
		{name: 'action_user', type: 'string'},
		{name: 'action_date', type: 'date', dateFormat: 'Y-m-d H:i:s'},
		
		{name: 'spec_email_is_on', type: 'boolean'},
		{name: 'spec_email_is_inbox', type: 'boolean'},
		{name: 'spec_email_is_outbox', type: 'boolean'},
		{name: 'spec_email_subject', type: 'string'},
		{name: 'spec_email_from', type: 'string'},
		{name: 'spec_email_to', type: 'string'},
		{name: 'spec_email_cc', type: 'string'},
		{name: 'spec_email_date', type: 'date', dateFormat: 'Y-m-d H:i:s'},
		
		{name: 'body_txt', type: 'string'},
		{name: 'body_html', type: 'string'},
		{name: 'body_html_hasNext', type: 'boolean'},
		
		{name: 'phonecall_is_on', type: 'boolean'},
		{name: 'phonecall_obj', type: 'auto'},
		
		{name: 'extlink_is_sync', type: 'boolean'},
	],
	hasMany: [{
		model: 'DbsEzeerAttachmentModel',
		name: 'attachments',
		associationKey: 'attachments'
	},{
		model: 'DbsEzeerTicketActionPropchangeModel',
		name: 'changeprops',
		associationKey: 'changeprops'
	}]
});

Ext.define('DbsEzeerTicketLineModel',{
	extend: 'DbsEzeerTicketActionModel',
	idProperty: 'id',
	fields: [
		{name: '_spec_closed_is_on', type:'boolean'},
		{name: '_spec_closed_date', type:'date'},
		{name: '_spec_closed_code', type:'string'},
	],
	hasMany: [{
		model: 'DbsEzeerAttachmentModel',
		name: 'attachments',
		associationKey: 'attachments'
	},{
		model: 'DbsEzeerTicketActionPropchangeModel',
		name: 'changeprops',
		associationKey: 'changeprops'
	}]
});

Ext.define('DbsEzeerTicketModel',{
	extend: 'Ext.data.Model',
	idProperty: 'ticket_filerecord_id',
	fields: [
		{name: 'ticket_filerecord_id', type:'int'},
		
		{name: 'prop_title', type:'string'},
		{name: 'prop_category', type:'string'},
		{name: 'prop_category_main', type:'string'},
		{name: 'prop_category_lists', type:'auto'},
		{name: 'prop_origin', type:'string'},
		{name: 'prop_priority', type:'string'},
		{name: 'prop_people', type:'auto'}, // Array
			{name: 'prop_people_owner', type:'auto'}, // Object
		{name: 'prop_links', type:'auto'}, // Array
		
		{name: 'spec_email_from', type: 'string' },
		
		{name: 'assign_people_type', type: 'string' },
		{name: 'assign_people_id', type: 'string' },
		
		{name: 'lastaction_people_type', type: 'string' },
		{name: 'lastaction_people_id', type: 'string' },
		
		{name: 'assign_is_login', type: 'boolean'},
		{name: 'assign_is_ext', type: 'boolean'},
		{name: 'assign_is_ext_tmp', type: 'boolean'},
		
		{name: 'login_is_owner', type: 'boolean'},
		{name: 'login_is_owner_ext', type: 'boolean'},
		{name: 'login_is_assign', type: 'boolean'},
		
		{name: 'notification_is_on', type: 'boolean'},
		
		{name: 'date_create', type: 'date', dateFormat: 'Y-m-d H:i:s'},
		{name: 'date_update', type: 'date', dateFormat: 'Y-m-d H:i:s'},
		{name: 'date_due', type: 'date', dateFormat: 'Y-m-d H:i:s', allowNull:true},
		{
			name: 'date_review',
			type: 'date',
			dateFormat: 'Y-m-d H:i:s',
			sortType: function(v) {
				if( Ext.isEmpty(v) ) {
					return Number.MAX_SAFE_INTEGER ;
				}
				return Ext.data.SortTypes.asDate(v) ;
			},
		},
		{name: 'date_review_is_late', type: 'boolean'},
		
		{name: 'status_is_new', type: 'boolean'},
		{name: 'status_is_new_reset', type: 'boolean'},
		
		{name: 'closed_is_on', type: 'boolean'},
		{name: 'closed_date', type: 'date', dateFormat: 'Y-m-d H:i:s'},
		{name: 'closed_code', type: 'string'},
		{name: 'closed_feedback', type: 'string'}
	],
	hasMany: [{
		model: 'DbsEzeerTicketActionModel',
		name: 'actions',
		associationKey: 'actions'
	}]
}) ;

Ext.define('DbsEzeerNotificationModel',{ // TO: RsiRecouveoNotificationModel
	extend: 'Ext.data.Model',
	idProperty: 'notification_filerecord_id',
	fields: [
		{name: 'notification_filerecord_id', type:'int'},
		{name: 'ticket_filerecord_id', type:'string'},
		{name: 'ticket_title', type:'string'},
		{name: 'notification_date', type:'date', dateFormat:'Y-m-d H:i:s'},
		{name: 'notification_txt', type:'string'}
	]
}) ;







Ext.define('Optima5.Modules.Spec.DbsEzeer.DbsEzeerModule', {
	extend: 'Optima5.Module',
	requires: [
		'Optima5.Modules.Spec.DbsEzeer.MainPanel'
	],
	
	moduleParams: null,
	
	initModule: function() {
		var me = this ;
		
		me.createWindow({
			width:1100,
			height:600,
			resizable:true,
			layout:'fit',
			tools: [{
				type: 'restore',
				handler: function() {
					this.postCrmEvent('opengun') ;
				},
				scope: me
			}],
			items:[Ext.create('Optima5.Modules.Spec.DbsEzeer.MainPanel',{
				itemId: 'pMain',
				optimaModule: me,
				border: false
			})]
		}) ;
	},
	postCrmEvent: function( crmEvent, postParams ) {
		var me = this ;
		if( typeof postParams === 'undefined' ) {
			postParams = {} ;
		}
		
		var eventParams = {} ;
		switch( crmEvent ) {
			case 'datachange' :
				break ;
			case 'openexplorer' :
				break ;
			case 'openticket' :
				Ext.apply( eventParams, {
					ticketFilerecordId: postParams.ticketFilerecordId
				}) ;
				break ;
			case 'attachmentschange' :
				Ext.apply( eventParams, {
					orderFilerecordId: postParams.orderFilerecordId
				}) ;
				break ;
			case 'maybenotificationschange' :
				break ;
			default :
				return ;
		}
		me.fireEvent('op5broadcast',crmEvent,eventParams) ;
	},
	
	getOpenedTickets: function() {
		var returnArr = []
		this.down('#pMain').items.each( function(p) {
			if( p._ticketFilerecordId ) {
				returnArr.push({
					'ticket_filerecord_id': p._ticketFilerecordId,
					'ticket_description': p.getTitle()
				});
			}
		});
		return returnArr ;
	},
});
