Ext.define('DbsEzeerCfgPriorityModel',{
	extend: 'Ext.data.Model',
	idProperty: 'priority_code',
	fields: [
		{name: 'priority_code', type:'string'},
		{name: 'priority_txt', type:'string'},
		{name: 'priority_idx', type:'int'},
		{name: 'priority_color', type:'string'}
	]
});
Ext.define('DbsEzeerCfgCategoryModel',{
	extend: 'Ext.data.Model',
	idProperty: 'category_code',
	fields: [
		{name: 'category_code', type:'string'},
		{name: 'category_txt', type:'string'},
		{name: 'category_color', type:'string'},
		{name: 'category_closeRoot', type:'string'},
		{name: 'category_sub_lists', type: 'auto'},
	]
});
Ext.define('DbsEzeerCfgOriginModel',{
	extend: 'Ext.data.Model',
	idProperty: 'origin_code',
	fields: [
		{name: 'origin_code', type:'string'},
		{name: 'origin_txt', type:'string'},
		{name: 'origin_color', type:'string'}
	]
});

Ext.define('DbsEzeerCfgAdrbookEmailModel',{
	extend: 'Ext.data.Model',
	idProperty: 'email_adr',
	fields: [
		{name: 'email_group', type:'string'},
		{name: 'email_name', type:'string'},
		{name: 'email_adr', type:'string'}
	]
});

Ext.define('DbsEzeerCfgTplEmailModel',{
	extend: 'Ext.data.Model',
	idProperty: 'tpl_code',
	fields: [
		{name: 'tpl_code', type:'string'},
		{name: 'tpl_title', type:'string'},
		{name: 'tpl_body', type:'string'},
	]
});

Ext.define('DbsEzeerCfgPeopleGroupModel',{
	extend: 'Ext.data.Model',
	idProperty: 'group_id',
	fields: [
		{name: 'group_id', type:'string'},
		{name: 'group_txt', type:'string'},
		{name: 'login_is_exclude', type:'boolean'},
	]
});
Ext.define('DbsEzeerCfgPeopleUserModel',{
	extend: 'Ext.data.Model',
	idProperty: 'user_id',
	fields: [
		{name: 'user_id', type:'string'},
		{name: 'user_name', type:'string'},
		{name: 'group_ids', type:'auto'},
		{name: 'login_is_exclude', type:'boolean'},
	]
});
Ext.define('DbsEzeerCfgPeopleListModel',{
	extend: 'Ext.data.Model',
	idProperty: 'list_id',
	fields: [
		{name: 'list_id', type:'string'},
		{name: 'list_txt', type:'string'},
	]
});

Ext.define('DbsEzeerCfgLinkModel',{
	extend: 'Ext.data.Model',
	idProperty: 'link_cfgcode',
	fields: [
		{name: 'link_class', type:'string'},
		{name: 'link_class_isSearch', type:'boolean'},
		{name: 'link_cfgcode', type:'string'},
		{name: 'link_cfgtxt', type:'string'}
	]
});

Ext.define('DbsEzeerCfgCloseModel',{
	extend: 'Ext.data.Model',
	idProperty: 'close_code',
	fields: [
		{name: 'parent_code', type:'string'},
		{name: 'close_code', type:'string'},
		{name: 'close_txt', type:'string'}
	]
});



Ext.define('Optima5.Modules.Spec.DbsEzeer.HelperCache',{
	mixins: {
		observable: 'Ext.util.Observable'
	},
	
	singleton:true,
	
	cfgSocStore: null,
	cfgListStore: null,
	cfgPriorityStore: null,
	
	isReady: false,
	nbLoaded: 0,
	nbToLoad: 0,
	
	constructor: function(config) {
		//build store
		var me = this ;
		me.mixins.observable.constructor.call(this, config);
	},
	init: function(optimaModule) {
		var me = this ;
		me.optimaModule = optimaModule ;
		
		me.isReady = false ;
		me.nbLoaded = 0 ;
		
		Ext.defer(function() {
			me.startLoading() ;
		},200,me) ;
	},
	startLoading: function() {
		var me = this ;
		
		me.nbToLoad = 3 ;
		
		me.authHelperInit() ;
		me.fetchConfig() ;
		me.doInit() ;
	},
	onLoad: function() {
		var me = this ;
		me.nbLoaded++ ;
		if( me.nbToLoad <= me.nbLoaded ) {
			me.isReady = true ;
			me.fireEvent('ready') ;
		}
	},
	
	doInit: function() {
		// Query Bible
		var ajaxParams = {} ;
		Ext.apply( ajaxParams, {
			_moduleId: 'spec_dbs_ezeer',
			_action: 'cfg_doInit'
		});
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams ,
			success: function(response) {
				var ajaxData = Ext.decode(response.responseText) ;
				if( ajaxData.success == false ) {
					Ext.Msg.alert('Failed', 'Unknown error');
				}
				this.onLoad() ;
			},
			scope: this
		});
	},
	
	fetchConfig: function() {
		// Query Bible
		var ajaxParams = {} ;
		Ext.apply( ajaxParams, {
			_moduleId: 'spec_dbs_ezeer',
			_action: 'cfg_getConfig'
		});
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams ,
			success: function(response) {
				var ajaxData = Ext.decode(response.responseText) ;
				if( ajaxData.success == false ) {
					Ext.Msg.alert('Failed', 'Unknown error');
				}
				else {
					this.onLoadConfig( ajaxData ) ;
				}
			},
			scope: this
		});
	},
	onLoadConfig: function( ajaxData ) {
		this.cfgPriorityStore = Ext.create('Ext.data.Store',{
			model: 'DbsEzeerCfgPriorityModel',
			data : ajaxData.data.cfg_priority
		}) ;
		this.cfgCategoryStore = Ext.create('Ext.data.Store',{
			model: 'DbsEzeerCfgCategoryModel',
			data : ajaxData.data.cfg_category
		}) ;
		this.cfgOriginStore = Ext.create('Ext.data.Store',{
			model: 'DbsEzeerCfgOriginModel',
			data : ajaxData.data.cfg_origin
		}) ;
		this.cfgPeopleGroupStore = Ext.create('Ext.data.Store',{
			model: 'DbsEzeerCfgPeopleGroupModel',
			data : ajaxData.data.cfg_people_group
		}) ;
		this.cfgPeopleUserStore = Ext.create('Ext.data.Store',{
			model: 'DbsEzeerCfgPeopleUserModel',
			data : ajaxData.data.cfg_people_user
		}) ;
		this.cfgPeopleListStore = Ext.create('Ext.data.Store',{
			model: 'DbsEzeerCfgPeopleListModel',
			data : ajaxData.data.cfg_people_list
		}) ;
		this.cfgLinkStore = Ext.create('Ext.data.Store',{
			model: 'DbsEzeerCfgLinkModel',
			data : ajaxData.data.cfg_link
		}) ;
		this.cfgCloseStore = Ext.create('Ext.data.Store',{
			model: 'DbsEzeerCfgCloseModel',
			data : ajaxData.data.cfg_close
		}) ;
		this.cfgAdrbookEmailStore = Ext.create('Ext.data.Store',{
			model: 'DbsEzeerCfgAdrbookEmailModel',
			data : ajaxData.data.cfg_adrbook_email
		}) ;
		this.cfgTplEmailStore = Ext.create('Ext.data.Store',{
			model: 'DbsEzeerCfgTplEmailModel',
			data : ajaxData.data.cfg_tpl_email
		}) ;
		
		this.onLoad() ;
	},
	
	authHelperInit: function() {
		var me = this ;
		
		me.authPages = {} ; // userId => [pages]
		me.authNodes = [] ; // [userId@whseCode@teamCode]
		
		// Query Bible
		var ajaxParams = {} ;
		Ext.apply( ajaxParams, {
			_moduleId: 'spec_dbs_ezeer',
			_action: 'cfg_getAuth'
		});
		me.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams ,
			success: function(response) {
				var ajaxData = Ext.decode(response.responseText) ;
				if( ajaxData.success == false ) {
					Ext.Msg.alert('Failed', 'Unknown error');
				}
				else {
					me.authPage = ajaxData.authPage ;
				}
				
				me.onLoad() ;
			},
			scope: me
		});
	},
	authHelperHasAll: function() {
		var me = this ;
		if( me.optimaModule.getSdomainRecord().get('auth_has_all') ) {
			return true ;
		}
		return false ;
	},
	authHelperQueryPage: function( pageCode ) {
		var me = this ;
			
		if( me.optimaModule.getSdomainRecord().get('auth_has_all') ) {
			return true ;
		}
		return ( !Ext.isEmpty(me.authPage) && Ext.Array.contains( me.authPage, pageCode ) ) ;
	},
	authHelperIsReadOnly: function() {
		var me = this ;
			
		if( me.optimaModule.getSdomainRecord().get('auth_has_all') ) {
			return false ;
		}
		return Ext.isEmpty(me.authPage) ;
	},
	authHelperGetUserId: function() {
		return this.optimaModule.getDelegateUserId() ;
	},
	
	getPeopleGroupAll: function() {
		return Ext.pluck( this.cfgPeopleGroupStore.getRange(), 'data' ) ;
	},
	getPeopleUserAll: function() {
		return Ext.pluck( this.cfgPeopleUserStore.getRange(), 'data' ) ;
	},
	getPeopleListAll: function() {
		return Ext.pluck( this.cfgPeopleListStore.getRange(), 'data' ) ;
	},
	getPriorityAll: function() {
		return Ext.pluck( this.cfgPriorityStore.getRange(), 'data' ) ;
	},
	getCategoryAll: function() {
		return Ext.pluck( this.cfgCategoryStore.getRange(), 'data' ) ;
	},
	getOriginAll: function() {
		return Ext.pluck( this.cfgOriginStore.getRange(), 'data' ) ;
	},
	getAdrbookEmailAll: function() {
		return Ext.pluck( this.cfgAdrbookEmailStore.getRange(), 'data' ) ;
	},
	getTplEmailAll: function() {
		return Ext.pluck( this.cfgTplEmailStore.getRange(), 'data' ) ;
	},
	getLinkAll: function() {
		return Ext.pluck( this.cfgLinkStore.getRange(), 'data' ) ;
	},
	getCloseAll: function() {
		return Ext.pluck( this.cfgCloseStore.getRange(), 'data' ) ;
	},
	
	libBinaryDownload: function(base64, filename ) {
			var binary_string = window.atob(base64);
			var len = binary_string.length;
			var bytes = new Uint8Array(len);
			for (var i = 0; i < len; i++) {
				bytes[i] = binary_string.charCodeAt(i);
			}
			var body = bytes.buffer;
		
		var blob = new Blob([body]);
		//var fileName = `${filename}.${extension}`;
		if (navigator.msSaveBlob) {
			// IE 10+
			navigator.msSaveBlob(blob, filename);
		} else {
			var link = document.createElement('a');
			// Browsers that support HTML5 download attribute
			if (link.download !== undefined) {
				var url = URL.createObjectURL(blob);
				link.setAttribute('href', url);
				link.setAttribute('download', filename);
				link.style.visibility = 'hidden';
				document.body.appendChild(link);
				link.click();
				document.body.removeChild(link);
			}
		}
	},
	
	libBinaryPreview: function(base64, mimetype ) {
		if( Ext.isEmpty(mimetype) ) {
			return false ;
		}
		var arrMime = mimetype.split('/') ;
		switch( arrMime[0] ) {
			case 'image' :
			case 'text' :
				break ;
			case 'application' :
				if( arrMime[1] == 'pdf' ) {
					break ;
				}
			default :
				return false ;
		}
			var binary_string = window.atob(base64);
			var len = binary_string.length;
			var bytes = new Uint8Array(len);
			for (var i = 0; i < len; i++) {
				bytes[i] = binary_string.charCodeAt(i);
			}
			var body = bytes.buffer;
		
		var file = new Blob([body], {type: mimetype});
       var fileURL = URL.createObjectURL(file);
       window.open(fileURL);
		return true ;
	},
	
	
	dateDiffInDays(a, b) {
		const _MS_PER_DAY = 1000 * 60 * 60 * 24;
		// Discard the time and time-zone information.
		const utc1 = Date.UTC(a.getFullYear(), a.getMonth(), a.getDate());
		const utc2 = Date.UTC(b.getFullYear(), b.getMonth(), b.getDate());

		return Math.floor((utc2 - utc1) / _MS_PER_DAY);
	}
	
});
