Ext.define('Optima5.Modules.Spec.DbsEzeer.HtmlPreviewPanel',{
	extend: 'Ext.panel.Panel',
	
	_bodyHtml: null,
	
	initComponent: function() {
		Ext.apply(this,{
			layout: {
				type: 'vbox',
				align: 'stretch'
			},
			bodyCls: 'op5-spec-dbsezeer-preview',
			bodyPadding: '0 10 0 10',
			items: [{
				xtype: 'box',
				cls:'op5-waiting'
			}]
		}) ;
		this.callParent() ;
		
		if( this._bodyHtml ) {
			Ext.defer( function() {
				this.addHtmlContent( this._bodyTitle, this._bodyHtml ) ;
			},1000,this) ;
		}
	},
	addHtmlContent: function( bodyTitle, bodyHtml ) {
		this.removeAll() ;
		
		this.add({
			xtype: 'component',
			tpl: [
				'<div class="op5-spec-dbsezeer-ticketaction-group op5-spec-dbsezeer-ticketaction-group-{ticket_type}">',
					'<div class="op5-spec-dbsezeer-ticketaction-rows-container">',
						'<div class="op5-spec-dbsezeer-ticketaction-rows">',
						'<tpl for="header">',
							'<div class="op5-spec-dbsezeer-ticketaction-row">',
								'<div class="op5-spec-dbsezeer-ticketaction-row-title">{title}</div>',
								'<div>&nbsp;<b>:</b>&nbsp;</div>',
								'<div class="op5-spec-dbsezeer-ticketaction-row-value">{value}</div>',
							'</div>',
						'</tpl>',
						'</div>',
					'</div>',
				'</div>',
			],
			data: {
				ticket_type: 'email',
				header: [{
					title: 'Date',
					value: Ext.util.Format.date(new Date(),'d/m/Y H:i')
				},{
					title: 'Subject',
					value: bodyTitle
				}]
			}
		},Ext.create('Ext.ux.dams.IFrameContent',{
			cls: 'op5-spec-dbsezeer-preview-cmp',
			itemId: 'iframeBody',
			flex: 1,
			content: bodyHtml
		}));
	}
});
