Ext.define('Optima5.Modules.Spec.DbsEzeer.MainPanel',{
	extend:'Ext.tab.Panel',
	requires:[
		'Optima5.Modules.Spec.DbsEzeer.HelperCache',
		'Optima5.Modules.Spec.DbsEzeer.MainMenu',
		'Optima5.Modules.Spec.DbsEzeer.TicketsExplorerPanel',
		'Optima5.Modules.Spec.DbsEzeer.TicketActionPanel',
		'Optima5.Modules.Spec.DbsEzeer.AdrbookPanel',
		
		'Optima5.Modules.Spec.DbsEzeer.ReportForm',
	],
	
	_readonlyMode: false,
	
	initComponent: function() {
		var me = this ;
			
		Ext.apply(me,{
			layout:'fit',
			items:[{
				xtype:'box',
				cls:'op5-spec-dbsezeer-mainmenu',
				flex:1,
				html: '<div class="op5-spec-dbsezeer-logo"></span>' 
			}]
		});
		
		this.on('afterrender', function(){
			Ext.defer(this.onEndAnimation, 500, this) ;
		}, me) ;
		
		this.callParent() ;
		this.mon(this.optimaModule,'op5broadcast',this.onCrmeventBroadcast,this) ;
	},
	startAnimation: function() {
		var logoEl = Ext.get( Ext.DomQuery.selectNode('div.op5-spec-dbsezeer-logo') );
		logoEl.animate({
			duration: 1000,
			to: {
				opacity: 1
			}
		});
		Ext.defer( this.onEndAnimation, 2000, this) ;
	},
	onEndAnimation: function() {
		var me = this ;
		
		var helperCache = Optima5.Modules.Spec.DbsEzeer.HelperCache ;
		helperCache.init(me.optimaModule) ;
		if( helperCache.isReady ) {
			this.switchToMainMenu() ;
		} else {
			this.mon(helperCache,'ready',function() {
				this.switchToMainMenu() ;
			},me,{single:true}) ;
		}
	},
	switchToMainMenu: function() {
		this._readonlyMode = Optima5.Modules.Spec.DbsEzeer.HelperCache.authHelperIsReadOnly() ;
		
		if( this._readonlyMode ) {
			//return this.switchToAppPanel('Optima5.Modules.Spec.DbsEzeer.FilesGrid',{}) ;
		}
		if( !Optima5.Modules.Spec.DbsEzeer.HelperCache.authHelperQueryPage('USER') ) {
			Ext.Msg.alert('Disabled', 'User disabled');
			return;
		}
		
		var me = this ;
		var mainMenuView = Ext.create('Optima5.Modules.Spec.DbsEzeer.MainMenu',{
			listeners: {
				actionclick: function( view, actionCode ) {
					me.onActionClick(actionCode) ;
				},
				scope: me
			}
		}) ;
		
		this.removeAll() ;
		this.add( {
			_mainTab: true,
			xtype: 'panel',
			title: 'Menu',
			layout: 'fit',
			cls:'op5-spec-dbslam-mainmenu',
			items: [mainMenuView],
			border: false,
			listeners: {
				beforeclose: this.onBeforeCloseMain,
				destroy: this.onCloseMain,
				scope: this
			}
		}) ;
		this.setActiveTab(0) ;
	},
	onActionClick: function( actionCode, actionReadonly=null ) {
		var me = this ;
		//console.log("Action: "+actionCode) ;
		
		switch( actionCode ) {
			case 'tickets' :
				return me.openExplorer() ;
			case 'ticket_new' :
				return me.doTicketNew() ;
			case 'form_report' :
				return me.openReportPopup() ;
			case 'form_adrbook' :
				return me.openAdrbookPopup() ;
			default :
				return ;
		}
	},
	openAppPanel: function( className, tabTitle, paramReadonly=false ) {
		// recherche d'une fenetre deja ouverte
		var doOpen = true ;
		this.eachPanel(function(pnl){
			if( !(Ext.getClassName(pnl) == className) ) {
				return true ;
			}
			this.focusPanel(pnl) ;
			doOpen = false ;
			return false ;
		},this) ;
		if( !doOpen ) {
			return ;
		}
		
		//open
		var pnl = Ext.create(className,{
			optimaModule: this.optimaModule,
			_mode_readOnly: paramReadonly,
			
			border: false,
			
			title: tabTitle,
			closable: true,
			
			listeners: {
				op5ezeerticketopen: this.onTicketOpenEvent,
				scope: this
			}
		}) ;
		this.addPanel(pnl) ;
		this.focusPanel(pnl) ;
	},
	
	openExplorer: function() {
		this.openAppPanel('Optima5.Modules.Spec.DbsEzeer.TicketsExplorerPanel','Explorer') ;
	},
	
	cleanOpenPopup: function() {
		if( this._floatingPanel ) {
			this._floatingPanel.destroy() ;
		}
	},
	openReportPopup: function() {
		this.cleanOpenPopup();
		this.getEl().mask() ;
		// Open panel
		var createPanel = Ext.create('Optima5.Modules.Spec.DbsEzeer.ReportForm',{
			optimaModule: this.optimaModule,
			width:400, // dummy initial size, for border layout to work
			height:null, // ...
			floating: true,
			draggable: true,
			resizable: true,
			renderTo: this.getEl(),
			tools: [{
				type: 'close',
				handler: function(e, t, p) {
					p.ownerCt.destroy();
				},
				scope: this
			}]
		});
		createPanel.on('saved', function(p) {
			this.doTreeLoad() ;
		},this,{single:true}) ;
		createPanel.on('destroy',function(p) {
			this.getEl().unmask() ;
			this._floatingPanel = null ;
		},this,{single:true}) ;
		
		createPanel.show();
		createPanel.getEl().alignTo(this.getEl(), 'c-c?');
		this._floatingPanel = createPanel;
	},
	openAdrbookPopup: function() {
		this.cleanOpenPopup();
		this.getEl().mask() ;
		// Open panel
		var createPanel = Ext.create('Optima5.Modules.Spec.DbsEzeer.AdrbookPanel',{
			optimaModule: this.optimaModule,
			width:400, // dummy initial size, for border layout to work
			height:null, // ...
			floating: true,
			draggable: true,
			resizable: true,
			renderTo: this.getEl(),
			tools: [{
				type: 'close',
				handler: function(e, t, p) {
					p.ownerCt.destroy();
				},
				scope: this
			}]
		});
		createPanel.on('saved', function(p) {
			this.doTreeLoad() ;
		},this,{single:true}) ;
		createPanel.on('destroy',function(p) {
			this.getEl().unmask() ;
			this._floatingPanel = null ;
		},this,{single:true}) ;
		
		createPanel.show();
		createPanel.getEl().alignTo(this.getEl(), 'c-c?');
		this._floatingPanel = createPanel;
	},
	
	
	doTicketNew: function() {
		var className = 'Optima5.Modules.Spec.DbsEzeer.TicketActionPanel' ;
		
		var doOpen = true ;
		this.eachPanel(function(pnl){
			if( !(Ext.getClassName(pnl) == className) ) {
				return true ;
			}
			if( pnl._ticketFilerecordId ) {
				return true ;
			}
			this.focusPanel(pnl) ;
			doOpen = false ;
			return false ;
		},this) ;
		if( !doOpen ) {
			return ;
		}
		
		//open
		var pnl = Ext.create(className,{
			optimaModule: this.optimaModule,
			//_mode_readOnly: paramReadonly,
			
			border: false,
			
			title: 'New ticket',
			closable: true,
			
			_ticketNew: true
		}) ;
		this.addPanel(pnl) ;
		this.focusPanel(pnl) ;
	},
	onTicketOpenEvent: function(pnl, ticketFilerecordId) {
		var className = 'Optima5.Modules.Spec.DbsEzeer.TicketActionPanel' ;
		
		var doOpen = true ;
		this.eachPanel(function(pnl){
			if( !(Ext.getClassName(pnl) == className) ) {
				return true ;
			}
			if( pnl._ticketFilerecordId != ticketFilerecordId ) {
				return true ;
			}
			this.focusPanel(pnl) ;
			doOpen = false ;
			return false ;
		},this) ;
		if( !doOpen ) {
			return ;
		}
		
		//open
		var pnl = Ext.create(className,{
			optimaModule: this.optimaModule,
			//_mode_readOnly: paramReadonly,
			
			border: false,
			
			title: 'Ticket #'+ticketFilerecordId,
			closable: true,
			
			_ticketFilerecordId: ticketFilerecordId,
		}) ;
		this.addPanel(pnl) ;
		this.focusPanel(pnl) ;
	},
	
	onCrmeventBroadcast: function(crmEvent, eventParams) {
		switch( crmEvent ) {
			case 'datachange' :
				break ;
			case 'openexplorer':
				this.openExplorer() ;
				break ;
			case 'openticket':
				this.onTicketOpenEvent(this,eventParams.ticketFilerecordId) ;
				break ;
			
			default: break ;
		}
	},
	
	
	eachPanel: function(fn,scope) {
		this.items.each(fn,scope) ;
	},
	focusPanel: function(pnl) {
		this.setActiveItem(pnl) ;
	},
	addPanel: function(panel) {
		this.add(panel) ;
	},
	closeActive: function() {
		if( this.getActiveTab().closable ) {
			this.getActiveTab().close() ;	
		}
	},
	onBeforeCloseMain: function(tab) {
		if( this.allowClose ) {
			return true ;
		}
		var nbOpen = this.items.getCount() ;
		if( nbOpen > 1 ) {
			return false ;
		}
		Ext.Msg.confirm('Fermeture', 'Quitter l\'application ?', function(btn){
			if( btn == 'yes' ){
				this.allowClose = true ;
				tab.close() ;
			}
		},this) ;
		return false ;
	},
	onCloseMain: function() {
		this.destroy() ;
	},
	
	onDestroy: function() {
		this.cleanOpenPopup();
	},
}) ;
