Ext.define('Optima5.Modules.Spec.DbsEzeer.TicketActionEmailForm',{
	extend: 'Ext.form.Panel',
	
	requires: [
		'Ext.ux.form.field.HtmlEditor7',
		
		'Optima5.Modules.Spec.DbsEzeer.TicketPropPeopleField',
		'Optima5.Modules.Spec.DbsEzeer.TicketPropLinkField',
		
		'Optima5.Modules.Spec.DbsEzeer.TicketAttachmentsGrid',
		
		'Optima5.Modules.Spec.DbsEzeer.CfgParamField'
	],
	
	initComponent: function() {
		var thisFields = [
			{name:'people_type', type:'string'},
			{name:'people_id', type:'string'},
			{name:'people_txt', type:'string'}
		] ;
		var comboboxData = [] ;
		Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getPeopleGroupAll(), function(row) {
			comboboxData.push({
				people_type: 'group',
				people_type_txt: 'Group',
				people_id: row.group_id,
				people_txt: row.group_txt
			}) ;
		});
		Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getPeopleUserAll(), function(row) {
			comboboxData.push({
				people_type: 'user',
				people_type_txt: 'User',
				people_id: row.user_id,
				people_txt: row.user_name
			}) ;
		});
		
		Ext.apply(this,{
			bodyCls: 'ux-noframe-bg',
			xtype: 'form',
			layout: {
				type: 'vbox',
				align: 'stretch'
			},
			bodyPadding: 36,
			fieldDefaults: {
				anchor: '100%',
				labelWidth: 100
			},
			items: [{
				xtype: 'component',
				tpl: [
					'<div style="position:relative">',
						'<div style="display: table; width:100% ; margin-bottom:4px ; min-height: 84px">',
							//'{[console.dir(values)]}',
							'<div class="op5-spec-dbsezeer-form-icon-new" style="display: table-cell; width:84px"></div>',
							'<div style="display: table-cell; vertical-align: middle">',
								'<div style="font-size: 16px; font-weight:bold; line-height:24px">',
								'New incoming email',
								'</div>',
				
								'<div style="padding-left:10px">',
								'Select action',
								'</div>',
							'</div>',
					'</div>'
				],
				data: {
					value: 'test'
				}
			},{
				xtype: 'fieldset',
				title: 'Select action for incoming email',
				layout: 'anchor',
				items: [{
					xtype: 'radiogroup',
					itemId: 'rgNewAction',
					columns: 1,
					vertical: true,
					defaults: {
						name: 'ticketnew_action'
					},
					items: [
							{ boxLabel: 'Create ticket', inputValue: 'new'},
							{ boxLabel: 'Link to existing ticket', inputValue: 'link' }
					],
					listeners: {
						change: function(rg, value) {
							var form = this.getForm(),
								formValues = form.getValues(),
								fieldset = this.down('#cntTicketsList');

							form.findField('link_ticketFilerecordId').setVisible( formValues.ticketnew_action == 'link' ) ;
							if( formValues.ticketnew_action !== 'link' ){
								fieldset.collapse();
							}
							fieldset.setHidden(false);
						},
						scope: this
					}
				},{
					xtype: 'combobox',
					itemId: 'cmbLinkToTicket',
					hidden: true,
					allowBlankIfVisible: false,
					name: 'link_ticketFilerecordId',
					fieldLabel: 'Link to ticket',
					width: 200,
					forceSelection: true,
					editable: true,
					queryMode: 'remote',
					valueField: 'ticket_filerecord_id',
					displayField: 'txt',
					queryParam: 'filter',
					minChars: 0,
					triggerAction: 'query',
					store: {
						// autoLoad: true,
						fields: [
							{name: 'ticket_filerecord_id', type: 'int'},
							{name: 'ticket_title', type: 'string'},
							{name: 'txt', type: 'string', calculate: function(data){return '#'+data.ticket_filerecord_id+' / '+data.ticket_title ;}}
						],
						proxy: this.optimaModule.getConfiguredAjaxProxy({
							extraParams : {
								_moduleId: 'spec_dbs_ezeer',
								_action: 'search_ticket'
							},
							reader: {
								type: 'json',
								rootProperty: 'data'
							}
						}),
						listeners: {
							beforeload: function(store,options) {
								var params = options.getParams() || {} ;
								if( this._ticketRecord ) {
									params.incoming_subject = this._ticketRecord.get('prop_title')
								}
								params.test_dm = 'abcdef' ;
								options.setParams(params) ;
							},
							scope: this
						}
					},
					listConfig: {
						getInnerTpl: function() {
							return '<div style="padding-bottom:6px">'
							+'<b>#{ticket_filerecord_id}</b>'
							+'&nbsp;:&nbsp;'
							+'{ticket_title}'
							+'</div>' ;
						}
					},
					matchFieldWidth: true,
					anyMatch: true
				}]
			},{
				xtype: 'fieldset',
				itemId: 'cntTicketsList',
				title: 'Select from grid',
				collapsible: true,
				collapsed: true,
				height: 150,
				layout: 'fit',
				items: [{
					xtype: 'grid',
					store: {
						autoLoad: true,
						fields: [
							{name: 'id', type: 'int', mapping: 'ticket_filerecord_id'},
							{name: 'ticket_filerecord_id', type: 'int'},
							{name: 'ticket_title', type: 'string'},
							{name: 'spec_email_from', type: 'string'},
							{name: '_similar_text', type:'number'},
						],
						sorters:[{
							property: '_similar_text',
							direction: 'DESC',
						}],
						proxy: this.optimaModule.getConfiguredAjaxProxy({
							extraParams : {
								_moduleId: 'spec_dbs_ezeer',
								_action: 'search_ticket'
							},
							reader: {
								type: 'json',
								rootProperty: 'data'
							},
						}),
						listeners: {
							beforeload: function(store,options) {
								var params = options.getParams() || {} ;
								if( this._ticketRecord ) {
									params.incoming_subject = this._ticketRecord.get('prop_title')
								}
								options.setParams(params) ;
							},
							load: function(store, records){
								var fieldset = this.down('#cntTicketsList');
								Ext.Array.each(records, function(record){
									if( record.get('_similar_text') > 50 ){
										fieldset.expand();
									}
								})
								if( store.getCount() > 0 ) {
									var grid = fieldset.down('grid'),
										firstRecord = store.getAt(0) ;
									if( firstRecord.get('_similar_text') >= 90 ) {
										grid.getSelectionModel().select(firstRecord) ;
									}
								}
								
							},
							scope: this
						}
					},
					columns: [
						{
							text: 'Id',
							dataIndex: 'ticket_filerecord_id',
							width: 90,
							renderer: function(v){
								return '#<b>' + v + '</b>';
							}
						},{
							text: 'Subject',
							dataIndex: 'ticket_title',
							width: 300
						},{
							text: 'Email (From)',
							dataIndex: 'spec_email_from',
							width: 210
						},{
							text: 'Matching (%)',
							dataIndex: '_similar_text',
							width: 90,
							renderer: function(v){
								return v.toFixed(2) + ' %';
							}
						}
					],
					selModel: {
						selType: 'checkboxmodel',
						mode: 'SINGLE',
						listeners: {
							selectionchange: function(cbm, selected){
								var selectedObjData = selected[0].getData(),
									{ ticket_filerecord_id, ticket_title } = selectedObjData,
									radiogroup = this.down('#rgNewAction'),
									combobox = this.down('#cmbLinkToTicket');

								radiogroup.setValue({ticketnew_action: 'link'});
								combobox.getStore().loadData([selectedObjData]);
								combobox.setValue(ticket_filerecord_id);
							},
							scope: this
						}
					}
				}],
				listeners: {
					expand: function(fs){
						fs.down('grid').getSelectionModel().deselectAll();
					}
				}
			},{
				xtype: 'container',
				layout: {
					type: 'hbox',
					align: 'pack',
					pack: 'end',
				},
				items: [{
					xtype: 'button',
					scale: 'medium',
					text: 'Continue',
					width: 80,
					handler: function() {
						this.handleSubmit() ;
					},
					scope: this
				}]
			}]
		}) ;
		
		this.callParent() ;
		this.getForm().getFields().each( function(f) {
			/*
			f.on('change',function(){
				console.log('fieldchange') ;
			},this) ;
			*/
		}) ;
		
		if( this._ticketFilerecordId ) {
			this.setForNew() ;
		} else {
			this.setForNew() ;
		}
		
	},
	
	setForNew: function() {
		
	},
	
	
	handleSubmit: function() {
		var form = this.getForm(),
			formValues = form.getFieldValues() ;
			  
		form.getFields().each(function(f){
			if( f.allowBlankIfVisible === false ) {
				f.allowBlank = !f.isVisible(true) ;
			}
		}) ;
		
		console.dir(formValues) ;
		
		var error ;
		while( true ) {
			if( !form.isValid() ) {
				error = 'Incomplete action' ;
				break;
			}
			
			break;
		}
		if( error ) {
			Ext.Msg.alert('New ticket Action', error);
			return ;
		}
		
		this.showLoadmask() ;
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_ezeer',
				_action: 'ticket_postUpdateNew',
				ticket_filerecord_id: this._ticketFilerecordId,
				form_data: Ext.JSON.encode(formValues)
			},
			success: function(response) {
				var ajaxData = Ext.decode(response.responseText) ;
				if( ajaxData.success == false ) {
					Ext.Msg.alert('Failed', 'Unknown error');
					return ;
				}
				this.fireEvent('saved',this, ajaxData.ticket_filerecord_id) ;
			},
			callback: function() {
				this.hideLoadmask() ;
			},
			scope: this
		});
	},
	
	
	
	showLoadmask: function() {
		if( this.rendered ) {
			this.doShowLoadmask() ;
		} else {
			this.on('afterrender',this.doShowLoadmask,this,{single:true}) ;
		}
	},
	doShowLoadmask: function() {
		if( this.loadMask ) {
			return ;
		}
		this.loadMask = Ext.create('Ext.LoadMask',{
			target: this,
			msg:"Please wait..."
		}).show();
	},
	hideLoadmask: function() {
		this.un('afterrender',this.doShowLoadmask,this) ;
		if( this.loadMask ) {
			this.loadMask.destroy() ;
			this.loadMask = null ;
		}
	},
});
