Ext.define('Optima5.Modules.Spec.RsiRecouveo.TicketActionFormModeField',{
	extend: 'Ext.view.View',
	mixins: ['Ext.form.field.Field'],
	
	initComponent: function() {
		var me = this ;
		
		Ext.apply(me,{
			xtype: 'dataview',
			cls: 'op5-spec-dbsezeer-headertags-field',
			tpl: [
				'<tpl for=".">',
					'<tpl if="!disabled">',
					'<div class="op5-spec-dbsezeer-headertags {[this.getIsSelectedBg(values)]}">',
						'<div class="op5-spec-dbsezeer-headertags-ico {iconCls}">',
						'</div>',
						'<div class="op5-spec-dbsezeer-headertags-text">',
						'{text}',
						'</div>',
					'</div>',
					'</tpl>',
				'</tpl>',
				{
					getIsSelectedBg: function(v) {
						var dv = this.owner,
							fp = dv.ownerCt ;
						if( v._selected ) {
							return 'op5-spec-dbsezeer-headertags-assigned' ;
						}
						return '' ;
					},
				}
			],
			itemSelector: 'div.op5-spec-dbsezeer-headertags',
			store: {
				data: [
					{mode: 'note', iconCls: 'op5-spec-dbsezeer-headertags-ico-note', text: 'Ticket action / note'},
					{mode: 'email', iconCls: 'op5-spec-dbsezeer-headertags-ico-emailadr', text: 'Send email'},
					{mode: 'phone', iconCls: 'op5-spec-dbsezeer-headertags-ico-phone', text: 'Phone call'},
					{mode: 'paracrm', iconCls: 'op5-spec-dbsezeer-headertags-ico-dbs', text: 'Action to Tracy', disabled:true},
				],
				fields: [
					{name:'iconCls', type:'string'},
					{name:'text', type:'string'},
					{name:'mode', type:'string'},
					{name:'disabled', type:'boolean'},
				]
			},
			prepareData: function(data) {
				if( this.getValue() == data.mode ) {
					data['_selected'] = true ;
				} else {
					data['_selected'] = false ;
				}
				return data;
			},
			listeners: {
				selectionchange: this.onSelectionChange,
				scope: this
			}
		}) ;
		
		me.callParent() ;
		me.mixins.field.constructor.call(me);
	},
	onSelectionChange: function(selModel, records) {
		if( records.length == 1 ) {
			this.setValue(records[0].get('mode')) ;
		}
	},
	setValue: function(value) {
		this.mixins.field.setValue.call(this, value);
		this.refresh() ;
	},
	setItemVisible: function(mode,isVisible) {
		this.getStore().each( function(r) {
			if( r.get('mode')==mode ) {
				r.set('disabled',!isVisible) ;
			}
		});
		this.refresh() ;
	},
});

Ext.define('Optima5.Modules.Spec.RsiRecouveo.TicketActionFeedbackField',{
	extend: 'Ext.view.View',
	mixins: ['Ext.form.field.Field'],
	
	initComponent: function() {
		var me = this ;
		
		Ext.apply(me,{
			xtype: 'dataview',
			cls: 'op5-spec-dbsezeer-headertags-field',
			tpl: [
				'<tpl for=".">',
					'<div class="op5-spec-dbsezeer-headertags {[this.getIsSelectedBg(values)]}">',
						'<div class="op5-spec-dbsezeer-headertags-ico {iconCls}">',
						'</div>',
					'</div>',
				'</tpl>',
				{
					getIsSelectedBg: function(v) {
						var dv = this.owner,
							fp = dv.ownerCt ;
						if( v._selected ) {
							return 'op5-spec-dbsezeer-headertags-assigned' ;
						}
						return '' ;
					},
				}
			],
			itemSelector: 'div.op5-spec-dbsezeer-headertags',
			store: {
				data: [
					{feedback_value: '1', iconCls: 'op5-spec-dbsezeer-headertags-ico-feed-yes'},
					{feedback_value: '0', iconCls: 'op5-spec-dbsezeer-headertags-ico-feed-no'},
				],
				fields: [
					{name:'iconCls', type:'string'},
					{name:'feedback_value', type:'string'},
				]
			},
			prepareData: function(data) {
				if( this.getValue() == data.feedback_value ) {
					data['_selected'] = true ;
				} else {
					data['_selected'] = false ;
				}
				return data;
			},
			listeners: {
				selectionchange: this.onSelectionChange,
				scope: this
			}
		}) ;
		
		me.callParent() ;
		me.mixins.field.constructor.call(me);
	},
	onSelectionChange: function(selModel, records) {
		if( records.length == 1 ) {
			this.setValue(records[0].get('feedback_value')) ;
		}
	},
	setValue: function(value) {
		this.mixins.field.setValue.call(this, value);
		this.refresh() ;
	},
	isValid: function() {
		if( !this.allowBlank && Ext.isEmpty(this.getValue()) ) {
			return false;
		}
		return true;
	},
});

Ext.define('Optima5.Modules.Spec.DbsEzeer.TicketActionCallContactField',{
	extend: 'Ext.form.FieldContainer',
	
	mixins: [
		'Ext.form.field.Field'
	],
	
	initComponent: function() {
		var me = this ;
		
		this._storeEmails = Ext.create('Ext.data.Store',{
			data: [],
			fields: [{name:'email_name', type:'string'}, {name: 'email_adr', type: 'string'}],
			proxy: {
				type: 'memory'
			}
		});
		
		Ext.apply(me,{
			layout: {
				type: 'hbox',
				align: 'stretch'
			},
			items: [{
				flex: 1,
				itemId: 'cmb',
				xtype: 'combobox',
				forceSelection: false,
				editable: true,
				queryMode: 'local',
				displayField: 'email_adr',
				valueField: 'email_adr',
				store: this._storeEmails,
				matchFieldWidth: false,
				listConfig: {
					width: 350,
					getInnerTpl: function(displayField) {
						return '<div style="padding-bottom:6px"><div>{email_name}</div><div style="text:10px">Email&#160;:&#160;<b>{email_adr}</b></div></div>' ;
					}
				}
			}]
		}) ;
		me.mixins.field.constructor.call(me);
		me.callParent() ;
		me.populateEmails() ;
	},
	getValue: function() {
		return this.down('#cmb').getValue() ;
	},
	setValue: function(v) {
		this.down('#cmb').setValue(v) ;
	},
	populateEmails: function( arrEmails=[] ) {
		var emailData = Optima5.Modules.Spec.DbsEzeer.HelperCache.getAdrbookEmailAll() ;
		if( arrEmails ) {
			Ext.Array.each( arrEmails, function(e) {
				emailData.push({email_name:e, email_adr:e}) ;
			});
		}
		
		var store = this._storeEmails ;
		store.removeAll() ;
		store.loadData(emailData) ;
	}
});

Ext.define('Optima5.Modules.Spec.DbsEzeer.TicketActionForm',{
	extend: 'Ext.form.Panel',
	
	requires: [
		'Ext.ux.form.field.HtmlEditor7',
		
		'Optima5.Modules.Spec.DbsEzeer.TicketPropPeopleField',
		'Optima5.Modules.Spec.DbsEzeer.TicketPropLinkField',
		'Optima5.Modules.Spec.DbsEzeer.TicketPropCategoryField',
		'Optima5.Modules.Spec.DbsEzeer.TicketCloseReasonField',
		
		'Optima5.Modules.Spec.DbsEzeer.TicketEmailAdrField',
		
		'Optima5.Modules.Spec.DbsEzeer.TicketAttachmentsGrid',
		
		'Optima5.Modules.Spec.DbsEzeer.HtmlPreviewPanel',
		
		'Optima5.Modules.Spec.DbsEzeer.CfgParamField'
	],
	
	initComponent: function() {
		var thisFields = [
			{name:'people_type', type:'string'},
			{name:'people_id', type:'string'},
			{name:'people_txt', type:'string'}
		] ;
		var comboboxData = [] ;
		Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getPeopleGroupAll(), function(row) {
			comboboxData.push({
				people_type: 'group',
				people_type_txt: 'Group',
				people_id: row.group_id,
				people_txt: row.group_txt
			}) ;
		});
		Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getPeopleUserAll(), function(row) {
			comboboxData.push({
				people_type: 'user',
				people_type_txt: 'User',
				people_id: row.user_id,
				people_txt: row.user_name
			}) ;
		});
		
		Ext.apply(this,{
			bodyCls: 'ux-noframe-bg',
			xtype: 'form',
			layout: {
				type: 'vbox',
				align: 'stretch'
			},
			bodyPadding: 10,
			fieldDefaults: {
				anchor: '100%',
				labelWidth: 75
			},
			items: [{
				xtype: 'textfield',
				name: 'prop_title',
				fieldLabel: 'Ticket title',
				allowBlank: false,
			},{
				xtype: 'fieldset',
				itemId: 'fsProps',
				title: 'Properties',
				layout: 'anchor',
				collapsible: true,
				listeners: {
					expand: function(fs) {
						fs._wasExpanded = true ;
					}
				},
				items: [Ext.create('Optima5.Modules.Spec.DbsEzeer.TicketPropCategoryField',{
					optimaModule: this.optimaModule,
					
					name: 'prop_category',
					fieldLabel: 'Category',
				}),{
					width:300,
					anchor: '',
					xtype: 'colorcombo',
					allowBlank: false,
					queryMode: 'local',
					forceSelection: true,
					editable: false,
					displayField: 'origin_txt',
					valueField: 'origin_code',
					iconColorField: 'origin_color',
					store: {
						fields: 'DbsEzeerCfgOriginModel',
						data : Optima5.Modules.Spec.DbsEzeer.HelperCache.getOriginAll()
					},
					fieldLabel: 'Origin',
					name : 'prop_origin',
				},{
					xtype: 'fieldcontainer',
					layout: {
						type: 'hbox',
						align: 'begin',
					},
					items: [{
						width:300,
						anchor: '',
						xtype: 'colorcombo',
						allowBlank: false,
						queryMode: 'local',
						forceSelection: true,
						editable: false,
						displayField: 'priority_txt',
						valueField: 'priority_code',
						iconColorField: 'priority_color',
						store: {
							fields: 'DbsEzeerCfgPriorityModel',
							data : Optima5.Modules.Spec.DbsEzeer.HelperCache.getPriorityAll()
						},
						fieldLabel: 'Priority',
						name : 'prop_priority',
						listeners: {
							select: function(cmb,r) {
								var nbDays ;
								switch(r.get('priority_code')) {
									case 'P1' :
										nbDays = 0;
										break ;
									case 'P2' :
										nbDays = 1;
										break ;
									case 'P3' :
										nbDays = 2;
										break ;
									case 'P4' :
										nbDays = 30;
										break ;
								}
								var dateBase ;
								if( this._ticketNew ) {
									dateBase = new Date() ;
								} else {
									dateBase = this._ticketRecord.get('date_create') ;
								}
								var dateTarget = Ext.clone(dateBase);
								dateTarget.setDate( dateTarget.getDate() + nbDays );
								this.getForm().findField('date_due').setValue(dateTarget) ;
							},
							scope: this,
						}
					},{
						xtype: 'box',
						width: 32,
					},{
						xtype: 'datefield',
						name: 'date_due',
						labelWidth: 60,
						format: 'Y-m-d',
						fieldLabel: 'Due date',
					}]
				},Ext.create('Optima5.Modules.Spec.DbsEzeer.TicketPropPeopleField',{
					optimaModule: this.optimaModule,
					
					name: 'prop_people_owner',
					fieldLabel: 'Owner',
					
					_peopleMode: 'owner',
					
					listeners: {
						peoplereplace: function(cmp,prevPeople) {
							if( prevPeople && (prevPeople.people_type=='group') ) {
								cmp.up('form').getForm().findField('prop_people').extAddPeople(prevPeople.people_type,prevPeople.people_id) ;
							}
						},
						scope: this
					},
				}),Ext.create('Optima5.Modules.Spec.DbsEzeer.TicketPropPeopleField',{
					optimaModule: this.optimaModule,
					
					name: 'prop_people',
					fieldLabel: 'People',
					
					_peopleMode: 'cc_only'
				}),Ext.create('Optima5.Modules.Spec.DbsEzeer.TicketPropLinkField',{
					optimaModule: this.optimaModule,
					
					name: 'prop_links',
					fieldLabel: 'Links'
				})]
			},{
				padding: '6px 0px',
				xtype: 'fieldcontainer',
				fieldLabel: 'Action type',
				labelStyle: 'font-weight: bold',
				layout: {
					type: 'hbox',
					pack: 'left',
				},
				items: [Ext.create('Optima5.Modules.Spec.RsiRecouveo.TicketActionFormModeField',{
					flex:1,
					fieldLabel: 'Action type',
					name: '_mode',
					//padding: '10px 0px',
				}),{
					itemId: 'cmpLoadTemplate',
					hidden: true,
					xtype: 'box',
					width: 40,
					height: 30,
					cls: 'ux-noframe-bg',
					tpl: [
						'<div class="op5-spec-dbsezeer-ticketaction-buttons">',
							'<tpl if="btn_browse">',
								'<div class="op5-spec-dbsezeer-ticketaction-buttons-btn op5-spec-dbsezeer-ticketaction-buttons-btn-template">',
								'</div>',
							'</tpl>',
						'</div>',
					],
					onButtonClick: function(e) {
						if( e.getTarget('.op5-spec-dbsezeer-ticketaction-buttons-btn-template') ) {
							this.openTemplatePopup() ;
						}
					},
					data: {
						btn_browse: true,
						btn_list: true,
					},
					listeners: {
						afterrender: function(cmp) {
							cmp.getEl().un('click',cmp.onButtonClick,this) ;
							cmp.getEl().on('click',cmp.onButtonClick,this) ;
						},
						scope: this,
					}
				}]
			},{
				hidden: true,
				xtype: 'fieldset',
				title: 'Action to Email / Public notification',
				layout: 'anchor',
				itemId: 'fsEmailOut',
				items: [{
					hidden: true,
					xtype: 'checkboxfield',
					name: 'outemail_is_on'
				},{
					xtype: 'container',
					layout: {
						type: 'hbox',
						align: 'stretch',
					},
					items: [{
						flex: 1,
						xtype: 'checkboxfield',
						boxLabel: 'Assign to external email address',
						name: 'outemail_assign_is_on',
						listeners: {
							change: function(chk,v) {
								this.onOutemailAssign() ;
							},
							scope: this
						}
					},{
						flex: 0,
						xtype: 'button',
						text: 'Add all addresses',
						handler: function() {
							this.onOutemailAddAll() ;
						},
						scope: this
					}]
				},
					Ext.create('Optima5.Modules.Spec.DbsEzeer.TicketEmailAdrField',{
						optimaModule: this.optimaModule,
						
						name: 'outemail_to',
						fieldLabel: 'Email To',
					}),
					Ext.create('Optima5.Modules.Spec.DbsEzeer.TicketEmailAdrField',{
						optimaModule: this.optimaModule,
						
						name: 'outemail_cc',
						fieldLabel: 'Email Cc',
					})
				]
			},{
				itemId: 'fsHtml',
				flex: 1,
				xtype: 'htmleditor7',
				enableColors: true,
				enableAlignements: true,
				name: 'body_html',
				height: 250,
				listeners: {
					activate: function() {
						this.collapsePropsIfComplete() ;
					},
					initialize: function(editor) {
						/*
						var me = this ;
						var editorDom = editor.getEditorBody() ;
						editorDom.addEventListener( 'paste' , function(e) {
							me.onEditorPaste(editor,e) ;
						}) ;
						*/
					},
					scope: this
				}
			},{
				itemId: 'fsPhone',
				flex: 1,
				xtype: 'fieldset',
				title: 'Phone call summary',
				fieldDefaults: {
					labelWidth: 150,
					labelAlign: 'left',
					anchor: '',
				},
				defaults: {
					listeners: {
						change: function(f) {
							if( Ext.Array.contains(['call_telno','call_txt'],f.getName()) ) {
								return ;
							}
							this.doCallFormLayout();
						},
						scope: this
					}
				},
				items: [{
					xtype: 'radiogroup',
					fieldLabel: 'Type d\'appel',
					// Arrange radio buttons into two columns, distributed vertically
					columns: 3,
					vertical: true,
					allowBlankIfVisible: false,
					defaults: {
						name: 'call_direction',
					},
					items: [
						{ boxLabel: 'Appel entrant', inputValue: 'incoming' },
						{ boxLabel: 'Appel sortant', inputValue: 'outgoing' },
					],
				},Ext.create('Optima5.Modules.Spec.DbsEzeer.TicketActionCallContactField',{
					anchor: '',
					width: 400,
					fieldLabel: '(opt) Correspondant',
					name: 'call_contact',
					forceSelection: false,
				}),{
					xtype: 'radiogroup',
					itemId: 'rgCallSuccess',
					fieldLabel: 'Correspondant contacté ?',
					// Arrange radio buttons into two columns, distributed vertically
					columns: 4,
					vertical: true,
					allowBlankIfVisible: false,
					defaults: {
						name: 'call_success',
					},
					items: [
						{ boxLabel: 'Oui', inputValue: 'yes' },
						{ boxLabel: 'Non', inputValue: 'no' },
					],
				},{
					xtype: 'radiogroup',
					itemId: 'rgCallDuration',
					fieldLabel: 'Durée appel',
					// Arrange radio buttons into two columns, distributed vertically
					columns: 4,
					vertical: true,
					allowBlankIfVisible: false,
					defaults: {
						name: 'call_duration',
					},
					items: [
						{ boxLabel: '~ 1-2 mn', inputValue: '1_to_2' },
						{ boxLabel: '~ 5 mn', inputValue: 'avg_5' },
						{ boxLabel: '>= 10 mn', inputValue: 'more_10' },
					],
				},{
					xtype: 'textarea',
					itemId: 'txtCallSummary',
					allowBlankIfVisible: false,
					name: 'call_txt',
					fieldLabel: 'Call summary',
					anchor: '100%'
				}]
			},{
				xtype: 'splitter'
			},{
				height: 150,
				xtype: 'container',
				layout: {
					type: 'hbox',
					align: 'stretch'
				},
				items: [Ext.create('Optima5.Modules.Spec.DbsEzeer.TicketAttachmentsGrid',{
					optimaModule: this.optimaModule,
					flex: 1,
					border: false,
					
					name: 'attachments',
					
					listeners: {
						list: function(attachGrid) {
							var existingAttachIds = [] ;
							attachGrid.getStore().each( function(r) {
								if( r.get('fromAttachId')>0 ) {
									existingAttachIds.push(r.get('fromAttachId')) ;
								}
							});
							if( this._cmpDvLine ) {
								var attachPopup = this._cmpDvLine.openAttachmentsPopup() ;
								attachPopup.setCheckedIds(existingAttachIds) ;
								this.mon(attachPopup,'submit',function(p,tmpAttachRows){
									attachGrid.getStore().add(tmpAttachRows) ;
									p.destroy() ;
								}) ;
							}
						},
						scope: this,
					}
				}),{
					xtype: 'box',
					width: 16
				},{
					flex: 1,
					xtype: 'fieldset',
					title: 'Next actions',
					layout: {
						type: 'vbox',
						align: 'stretch'
					},
					fieldDefaults: {
						labelWidth: 60,
					},
					items: [{
						xtype: 'combobox',
						allowBlank: false,
						queryMode: 'local',
						forceSelection: true,
						editable: false,
						displayField: 'eventType_txt',
						valueField: 'eventType_code',
						store: {
							fields: ['eventType_code','eventType_txt','eventType_iconCls'],
							data : [
								{eventType_code:'date',eventType_txt:'Next review',eventType_iconCls:'op5-spec-dbspeople-icon-role'},
								{eventType_code:'people',eventType_txt:'Assign task',eventType_iconCls:'op5-spec-dbspeople-icon-move'},
								{eventType_code:'close',eventType_txt:'Close ticket',eventType_iconCls:'op5-spec-dbspeople-icon-absence'},
								{eventType_code:'link',eventType_txt:'Link to other ticket',eventType_iconCls:'op5-spec-dbspeople-icon-absence'}
							]
						},
						fieldLabel: 'Action',
						name: 'next_?',
						listeners: {
							change: function(cmb,value) {
								if( value=='close' ) {
									this.onChangeForNextClose() ;
								}
								cmb.up('form').down('#cntNextPeople').setVisible(value=='people') ;
								cmb.up('form').down('#cntNextDate').setVisible((value=='date') || (value=='people')) ;
								cmb.up('form').down('#cntNextClose').setVisible(value=='close') ;
								cmb.up('form').down('#cntNextFeedback').setVisible(value=='close') ;
								cmb.up('form').down('#cntNextLink').setVisible(value=='link') ;
							},
							scope: this
						}
					},{
						itemId: 'cntNextPeople',
						hidden: true,
						allowBlankIfVisible: false,
						xtype: 'combobox',
						width: 175,
						forceSelection: false,
						editable: true,
						queryMode: 'local',
						valueField: 'people_txt',
						displayField: 'people_txt',
						store: {
							data: comboboxData,
							fields: thisFields
						},
						name: 'next_people',
						fieldLabel: 'Assignee',
						matchFieldWidth: false,
						anyMatch: true,
						listConfig: {
							width: 250,
							getInnerTpl: function() {
								return '<div style="padding-bottom:6px">'
								+'<b>{people_type_txt}</b>'
								+'&nbsp;:&nbsp;'
								+'{people_txt}'
								+'</div>' ;
							}
						},
						getValue: function() {
							if( this.getSelection() ) {
								return this.getSelection().getData() ;
							}
							var ereg = /^\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/;
							if( ereg.test(this.getRawValue()) ) {
								//console.log('email valide !!');
								return {
									people_type: 'email',
									people_id: this.getRawValue(),
									people_txt: this.getRawValue()
								};
							}
							return null ;
						},
						getErrors: function() {
							if( !this.getValue() && !this.allowBlank ) {
								return ["Invalid assignee"] ;
							}
							return [] ;
						},
						enableKeyEvents: true,
						listeners: {
							keydown: function(f) {
								f.setSelection(null) ;
							}
						}
					},{
						itemId: 'cntNextDate',
						hidden: true,
						allowBlankIfVisible: false,
						xtype: 'datefield',
						name: 'next_date',
						format: 'Y-m-d',
						fieldLabel: 'Date',
						value: new Date()
					},Ext.create('Optima5.Modules.Spec.DbsEzeer.TicketCloseReasonField',{
						optimaModule: this.optimaModule,
						
						itemId: 'cntNextClose',
						hidden: true,
						labelAlign: 'top',
						fieldLabel: 'Resolve / Reason',
						name: 'next_close',
					}),{
						itemId: 'cntNextLink',
						xtype: 'combobox',
						hidden: true,
						allowBlankIfVisible: false,
						name: 'next_link',
						labelAlign: 'top',
						fieldLabel: 'Link to ticket',
						forceSelection: true,
						editable: true,
						queryMode: 'remote',
						valueField: 'ticket_filerecord_id',
						displayField: 'txt',
						queryParam: 'filter',
						minChars: 3,
						triggerAction: 'query',
						store: {
							//autoLoad: true,
							fields: [
								{name: 'ticket_filerecord_id', type: 'int'},
								{name: 'ticket_title', type: 'string'},
								{name: 'txt', type: 'string', calculate: function(data){return '#'+data.ticket_filerecord_id+' / '+data.ticket_title ;}}
							],
							proxy: this.optimaModule.getConfiguredAjaxProxy({
								extraParams : {
									_moduleId: 'spec_dbs_ezeer',
									_action: 'search_ticket'
								},
								reader: {
									type: 'json',
									rootProperty: 'data'
								}
							})
						},
						listConfig: {
							getInnerTpl: function() {
								return '<div style="padding-bottom:6px">'
								+'<b>#{ticket_filerecord_id}</b>'
								+'&nbsp;:&nbsp;'
								+'{ticket_title}'
								+'</div>' ;
							}
						},
						matchFieldWidth: true,
						anyMatch: true
					},{
						xtype: 'box',
						flex:1
					},{
						xtype: 'container',
						layout: {
							type: 'hbox',
							pack: 'end',
							align: 'middle',
						},
						items: [{
							flex: 1,
							hidden: true,
							itemId: 'cntNextFeedback',
							xtype: 'container',
							layout: {
								type:'vbox',
								align: 'begin',
							},
							items: [{
								xtype: 'box',
								html: '<i>Feedback</i>',
							},Ext.create('Optima5.Modules.Spec.RsiRecouveo.TicketActionFeedbackField',{
								height: 24,
								allowBlankIfVisible: false,
								name: 'next_feedback',
							})]
						},{
							margin: 4,
							xtype: 'button',
							itemId: 'btnPreview',
							text: 'Preview',
							handler: function( btn ) {
								this.handlePreview() ;
							},
							scope: this
						},{
							margin: 4,
							xtype: 'button',
							itemId: 'btnSubmit',
							text: 'Submit ticket action',
							handler: function( btn ) {
								this.handleSubmit() ;
							},
							scope: this
						}]
					}]
				}]
			}]
		}) ;
		
		this.callParent() ;
		this.getForm().getFields().each( function(f) {
			if( f.getName() == '_mode' ) {
				f.on('change',function(){
					this.onChangeMode( f.getValue() ) ;
				},this) ;
			}
			if( f.getName() == 'prop_category' ) {
				f.on('change',function(){
					this.onChangeForNextClose() ;
				},this) ;
			}
			if( f.getName() == 'prop_origin' ) {
				f.on('change',function(){
					this.onChangeForNextClose() ;
				},this) ;
			}
		},this) ;
		this.doCallFormLayout() ;
		
		if( this._ticketFilerecordId && this._ticketRecord ) {
			this.onLoadTicket( this._ticketRecord ) ;
			if( this._ticketNew ) {
				this.setForNew() ;
			}
		} else if( this._ticketNew ) {
			this.setForNew() ;
		} else {
			this.destroy() ;
		}
		
	},
	
	setForNew: function() {
		var setValues = {
			_mode: 'note',
		};
		var userId = Optima5.Modules.Spec.DbsEzeer.HelperCache.authHelperGetUserId() ;
		if( userId !== false ) {
			var propPeopleGroups = [];
			Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getPeopleUserAll(), function(userRow) {
				if( (userRow.user_id == userId) && Ext.isArray(userRow.group_ids) ) {
					Ext.Array.each( userRow.group_ids, function(groupId) {
						propPeopleGroups.push({
							people_type: 'group',
							people_id: groupId
						});
					});
				}
			}) ;
			Ext.apply(setValues,{
				prop_people_owner: [{
					people_type: 'user',
					people_id: userId
				}],
				prop_people: propPeopleGroups
			});
			
			if( this._ticketRecord ) {
				var ticketRecord = this._ticketRecord,
					propPeople = ticketRecord.get('prop_people') ;
				Ext.Array.each( propPeople, function(o) {
					if( o.assign_is_on && (o.people_type!='user') ) {
						o.owner_is_on = false ;
						o.assign_is_on = false ;
						o.assign_is_off = true ;
					}
				}) ;
				Ext.apply(setValues,{
					prop_people: propPeople,
				});
			}
		}
		this.getForm().setValues(setValues);
	},
	onLoadTicket: function( ticketRecord ) {
		this.getForm().setValues({
			prop_title: ticketRecord.get('prop_title'),
			
			prop_category: {
				value: ticketRecord.get('prop_category_main'),
				lists: ticketRecord.get('prop_category_lists'),
			},
			prop_origin: ticketRecord.get('prop_origin'),
			prop_priority: ticketRecord.get('prop_priority'),
			
			prop_people: ticketRecord.get('prop_people'),
			prop_people_owner: ticketRecord.get('prop_people_owner'),
			prop_links: ticketRecord.get('prop_links'),
			
			date_due: ticketRecord.get('date_due'),
			
			next_date: ( (Ext.isEmpty(ticketRecord.get('date_review')) || ticketRecord.get('date_review_is_late')) ? null : ticketRecord.get('date_review')),
			
			_mode: 'note',
		});
		if( ticketRecord.get('closed_is_on') ) {
			this.convertToReadOnly() ;
			return ;
		}
		var fieldSelectMode = this.getForm().findField('_mode') ;
		if( ticketRecord.get('status_is_new') ) {
			fieldSelectMode.setVisible(false) ;
		} else if( !ticketRecord.get('login_is_owner') && ticketRecord.get('login_is_assign') ) {
			fieldSelectMode.setVisible(false) ;
		} else {
			fieldSelectMode.setVisible(true) ;
		}
		
		this.getForm().findField('_mode').setItemVisible( 'paracrm', !Ext.isEmpty(ticketRecord.get('prop_links')) ) ;
		this.getForm().findField('prop_links').setReadOnly( true );
		
		var formFieldNext = this.getForm().findField('next_?') ;
		if( ticketRecord.get('assign_is_ext') && !ticketRecord.get('login_is_owner') && ticketRecord.get('login_is_assign') ) {
			formFieldNext.getStore().loadData([
				{eventType_code:'date',eventType_txt:'Next review',eventType_iconCls:'op5-spec-dbspeople-icon-role'},
				{eventType_code:'return',eventType_txt:'Return to owner',eventType_iconCls:'op5-spec-dbspeople-icon-move'}
			]) ;
		}
	},
	convertToReadOnly: function() {
		var itemsToDelete = [], hasSeenFsProps = false;
		this.items.each(function(i) {
			if( hasSeenFsProps ) {
				itemsToDelete.push(i) ;
			}
			if( i.itemId == 'fsProps' ) {
				i.expand()
				hasSeenFsProps = true ;
				return ;
			}
		});
		Ext.Array.each( itemsToDelete, function(i) {
			this.remove(i);
		},this);
		this.add({
			itemId: 'pClosed',
			flex: 1,
			xtype: 'box',
			cls:'op5-spec-dbsezeer-bg-closed'
		});
		this.getForm().getFields().each(function(f) {
			if( f.setReadOnly ) {
				f.setReadOnly(true) ;
			}
		});
	},
	
	collapsePropsIfComplete: function() {
		if( !this._ticketRecord ) {
			return ;
		}
		if( this._ticketRecord.get('status_is_new') ) {
			return ;
		}
		var form = this.getForm(),
			formValues = form.getFieldValues(),
			isComplete = true ;
		Ext.Array.each(['prop_title','prop_category','prop_priority','prop_people_owner'],function(k) {
			if( Ext.isEmpty(formValues[k]) ) {
				isComplete = false ;
			}
		}) ;
		if( !isComplete ) {
			return ;
		}
		if( this.down('#fsProps')._wasExpanded ) {
			return ;
		}
		this.down('#fsProps').collapse() ;
	},
	
	onChangeMode: function(mode) {
		this.onChangeEmailOut( mode=='email' ) ;
		
		if( this._cmpDvLine ) {
			this._cmpDvLine.setModeSelect( Ext.Array.contains(['email','paracrm'],mode), mode=='email' ) ;
		}
		
		this.down('#fsHtml').setVisible( mode!='phone' ) ;
		this.down('#fsPhone').setVisible( mode=='phone' ) ; // TMP
	},
	
	onChangeEmailOut: function(torf) {
		this.getForm().findField('outemail_is_on').setValue( torf ) ;
		
		this.down('#cmpLoadTemplate').setVisible( torf ) ;
		this.down('#btnPreview').setVisible( torf ) ;
		this.down('#fsEmailOut').setVisible( torf ) ;
		if( torf ) {
			this.onExpandEmailOut() ;
		}
	},
	onExpandEmailOut: function() {
		if( !this._ticketRecord ) {
			return ;
		}
		var firstAction = this._ticketRecord.actions().getAt(0) ;
		if( !firstAction.get('spec_email_is_on') ) {
			return ;
		}
		
		var emailTo = [], emailCc = [] ;
		if( !Ext.isEmpty(firstAction.get('spec_email_from')) ) {
			emailTo.push( firstAction.get('spec_email_from') ) ;
		}
		Ext.Array.each( firstAction.get('spec_email_to').split(','), function(e) {
			if( Ext.isEmpty(e) ) {
				return ;
			}
			emailCc.push(e) ;
		}) ;
		Ext.Array.each( firstAction.get('spec_email_cc').split(','), function(e) {
			if( Ext.isEmpty(e) ) {
				return ;
			}
			emailCc.push(e) ;
		}) ;
		this.getForm().setValues({
			outemail_to: emailTo,
			//outemail_cc: emailCc
		}) ;
		
		var conversationEmails = [] ;
		var conversationAddEmail = function(e) {
			if( !Ext.Array.contains(conversationEmails,e) ) {
				conversationEmails.push(e) ;
			}
		};
		this._ticketRecord.actions().each( function(rec) {
			if( !rec.get('spec_email_is_on') ) {
				return ;
			}
			conversationAddEmail(rec.get('spec_email_from'));
			Ext.Array.each( rec.get('spec_email_to').split(','), function(e) {
				if( Ext.isEmpty(e) ) {
					return ;
				}
				conversationAddEmail(e) ;
			}) ;
			Ext.Array.each( rec.get('spec_email_cc').split(','), function(e) {
				if( Ext.isEmpty(e) ) {
					return ;
				}
				conversationAddEmail(e) ;
			}) ;
		}) ;
		this.getForm().findField('outemail_to').populateEmails(conversationEmails) ;
		this.getForm().findField('outemail_cc').populateEmails(conversationEmails) ;
	},
	onOutemailAssign: function() {
		var form = this.getForm() ;
		
		var isOutemailAssign = form.getFieldValues()['outemail_assign_is_on'] ;
		form.findField('next_?').reset() ;
		form.findField('next_?').setVisible(!isOutemailAssign) ;
		form.findField('next_?').allowBlank = isOutemailAssign ;
	},
	onOutemailAddAll: function() {
		if( !this._ticketRecord ) {
			return ;
		}
		
		var outemail_ticketActionFilerecordIds = [] ;
		if( this._cmpDvLine ) {
			outemail_ticketActionFilerecordIds = this._cmpDvLine.getModeSelectIds() ;
		}
		Ext.Array.each( outemail_ticketActionFilerecordIds, function(v,idx) {
			outemail_ticketActionFilerecordIds[idx] = parseInt(v) ;
		});
		
		var emailsTo = [],
			emailsCc = [] ;
		this._ticketRecord.actions().each( function(rec) {
			if( !Ext.Array.contains(outemail_ticketActionFilerecordIds,rec.get('ticketaction_filerecord_id')) ) {
				return ;
			}
			if( !rec.get('spec_email_is_on') ) {
				return ;
			}
			//conversationAddEmail(rec.get('spec_email_from'));
			if( !Ext.Array.contains(emailsTo,rec.get('spec_email_from').toLowerCase()) ) {
				emailsTo.push(rec.get('spec_email_from').toLowerCase()) ;
			}
			Ext.Array.each( rec.get('spec_email_to').split(','), function(e) {
				if( Ext.isEmpty(e) ) {
					return ;
				}
				if( !Ext.Array.contains(emailsCc,e.toLowerCase()) ) {
					emailsCc.push(e.toLowerCase()) ;
				}
			}) ;
			Ext.Array.each( rec.get('spec_email_cc').split(','), function(e) {
				if( Ext.isEmpty(e) ) {
					return ;
				}
				if( !Ext.Array.contains(emailsCc,e.toLowerCase()) ) {
					emailsCc.push(e.toLowerCase()) ;
				}
			}) ;
		}) ;
		this.getForm().setValues({
			outemail_to: emailsTo,
			outemail_cc: emailsCc
		}) ;
	},
	
	doCallFormLayout: function() {
		var form = this.getForm(),
			formValues = form.getFieldValues() ;
			
		switch( formValues['call_direction'] ) {
			case 'incoming' :
				this.down('#rgCallSuccess').setVisible(false) ;
				this.getForm().setValues({call_success:'yes'}) ;
				formValues['call_success'] = 'yes' ;
				break ;
				
			case 'outgoing' :
				this.down('#rgCallSuccess').setVisible(true) ;
				break ;
				
			default :
				this.down('#rgCallSuccess').setVisible(false) ;
				break ;
		}
		
		switch( formValues['call_success'] ) {
			case 'yes' :
				this.down('#rgCallDuration').setVisible(true) ;
				this.down('#txtCallSummary').setVisible(true) ;
				break ;
				
			default :
				this.down('#rgCallDuration').setVisible(false) ;
				this.down('#txtCallSummary').setVisible(false) ;
				return ;
		}
	},
	
	onChangeForNextClose: function() {
		var form = this.getForm(),
			formValues = form.getFieldValues() ;
		
		var cntNextClose = this.down('#cntNextClose') ;
		cntNextClose.setFormValues(formValues);
	},
	
	buildSubmitValues: function() {
		var form = this.getForm(),
			formValues = form.getFieldValues(),
			propCategoryObj = formValues['prop_category'] ;
		formValues['prop_category'] = propCategoryObj['value'];
		formValues['prop_category_lists'] = propCategoryObj['lists'];
		switch( formValues['_mode'] ) {
			case 'email' :
				if( this._cmpDvLine ) {
					formValues['outemail_ticketActionFilerecordIds'] = this._cmpDvLine.getModeSelectIds() ;
				}
				if( formValues['outemail_assign_is_on'] ) {
					var emailAssign = null ;
					Ext.Array.each( formValues['outemail_to'], function(r) {
						if( Ext.isString(r) ) {
							emailAssign = r ;
							return false ;
						}
						switch( r.type ) {
							case 'email' :
								emailAssign = r.email_adr ;
								return false ;
							default:
								break ;
						}
					});
					if( emailAssign != null ) {
						formValues['next_?'] = 'people' ;
						formValues['next_people'] = {
							people_type: 'email',
							people_id: emailAssign,
							people_txt: emailAssign
						} ;
					}
				}
				break ;
			case 'paracrm' :
				if( this._cmpDvLine ) {
					formValues['extlink_ticketActionFilerecordIds'] = this._cmpDvLine.getModeSelectIds() ;
				}
				break ;
		}
		return formValues ;
	},
	handlePreview: function() {
		var formValues = this.buildSubmitValues() ;
		
		this.showLoadmask() ;
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_ezeer',
				_action: 'ticket_getPreviewHtml',
				ticket_filerecord_id: this._ticketFilerecordId || 0,
				form_data: Ext.JSON.encode(formValues)
			},
			success: function(response) {
				var ajaxData = Ext.decode(response.responseText) ;
				if( ajaxData.success == false ) {
					return ;
				}
				this.optimaModule.createWindow({
					width:750,
					height:800,
					iconCls: 'op5-crmbase-qresultwindow-icon',
					animCollapse:false,
					border: false,
					layout:'fit',
					title: 'Preview Email',
					items:[Ext.create('Optima5.Modules.Spec.DbsEzeer.HtmlPreviewPanel',{
						optimaModule: this.optimaModule,
						_bodyTitle: formValues['prop_title'],
						_bodyHtml: ajaxData.html,
						listeners: {
							destroy: function(p) {
								//...
							},
							scope: this
						}
					})]
				}) ;
			},
			callback: function() {
				this.hideLoadmask() ;
			},
			scope: this
		});
	},
	handleSubmit: function(confirm=false) {
		Ext.Array.each( this.query('form'), function(subform) {
			subform.destroy() ;
		}) ;
		var form = this.getForm(),
			formValues = this.buildSubmitValues() ;
			  
		form.getFields().each(function(f){
			if( f.allowBlankIfVisible === false ) {
				f.allowBlank = !f.isVisible(true) ;
			}
		}) ;
		
		// HACK prop_category_valid ?
		form.findField('prop_category').down('#cmbProp').allowBlank = false ;
		form.findField('prop_category').down('#cmbPropSub').allowBlank = !(formValues['next_?']=='close') ;
		
		//console.dir(formValues) ;
		
		var error ;
		while( true ) {
			if( !form.isValid() ) {
				error = 'Incomplete ticket description' ;
				break;
			}
			if( Ext.isEmpty(formValues.prop_people_owner) ) {
				error = 'No ticket owner' ;
				break;
			}
			
			var hasGroup = false ;
			if( formValues.prop_people_owner && (formValues.prop_people_owner['people_type']=='group') ) {
				hasGroup = true ;
			}
			Ext.Array.each( formValues.prop_people, function(peopleRow) {
				if( peopleRow['people_type']=='group' ) {
					hasGroup = true ;
				}
			}) ;
			if( !hasGroup ) {
				error = 'Not attached to any group' ;
			}
			
			if( Ext.isEmpty(formValues.body_html) && Ext.isEmpty(formValues.attachments) ) {
				//error = 'Empty (no body / no new files)' ;
				break;
			}
			
			// TODO : check remove assignee ??
			
			break;
		}
		if( error ) {
			Ext.Msg.alert('Ticket Action', error);
			return ;
		}
		
		if( (formValues['next_?'] == 'close') && !confirm ) {
			Ext.Msg.confirm('Close ticket ?', 'Confirm close ticket', function(btn) {
				if( btn=='yes' ) {
					this.handleSubmit(true) ;
				}
			},this) ;
			return ;
		}
		
		if( !Ext.isEmpty(formValues.body_html) ) {
			// HACK ?
			formValues.body_html = '<span style="font-size: 10pt; font-family: Verdana,sans-serif">' + formValues.body_html + '</span>' ;
		}
		
		if( formValues._mode == 'phone' ) {
			var phonecallObj = {} ;
			Ext.Object.each( formValues, function(k,v) {
				if( k.indexOf('call_')===0 ) {
					phonecallObj[k] = v ;
				}
			});
			formValues['phonecall_obj'] = phonecallObj ;
		}
		
		this.showLoadmask() ;
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_ezeer',
				_action: 'ticket_postAction',
				ticket_filerecord_id: this._ticketFilerecordId || 0,
				form_data: Ext.JSON.encode(formValues)
			},
			success: function(response) {
				var ajaxData = Ext.decode(response.responseText) ;
				if( ajaxData.success == false ) {
					Ext.Msg.alert('Failed', ajaxData.error || 'Unknown error');
					this.down('#fsProps').expand() ;
					return ;
				}
				var forward_ticketFilerecordId = ajaxData.ticket_filerecord_id ;
				if( ajaxData.forward_ticketFilerecordId ) {
					forward_ticketFilerecordId = ajaxData.forward_ticketFilerecordId ;
				}
				this.fireEvent('saved',this,forward_ticketFilerecordId,ajaxData.ticketaction_filerecord_id) ;
			},
			callback: function() {
				this.hideLoadmask() ;
			},
			scope: this
		});
	},
	
	
	openTemplatePopup: function() {
		var addPeoplePanel = Ext.create('Ext.form.Panel',{
			title: 'Load template',
			layout: 'anchor',
			border: false,
			cls: 'ux-noframe-bg',
			bodyCls: 'ux-noframe-bg',
			bodyPadding: 10,
			fieldDefaults: {
				labelWidth: 75,
				anchor: '100%'
			},
			items: [{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				items: [{
					flex: 1,
					xtype:'combobox',
					//matchFieldWidth:false,
					//listConfig:{width:350},
					forceSelection:true,
					//allowBlank:false,
					editable:true,
					anyMatch: true,
					selectOnTab: true,
					//typeAhead:true,
					//selectOnFocus: true,
					queryMode: 'local',
					displayField: 'tpl_title',
					valueField: 'tpl_code',
					fieldLabel: 'Role',
					name: 'tpl_code' ,
					store: {
						model:'DbsEzeerCfgTplEmailModel',
						data: Optima5.Modules.Spec.DbsEzeer.HelperCache.getTplEmailAll(),
					}
				},{
					xtype: 'button',
					margin: {
						left: 4,
						right: 8
					},
					iconCls: 'op5-spec-dbsezeer-ticketaction-buttons-btn-select-no',
					handler: function(btn) {
						var values = btn.up('form').getForm().getValues() ;
						if( !Ext.isEmpty(values['tpl_code']) ) {
							this.handleLoadTemplate(values['tpl_code']) ;
							btn.up('form').destroy();
						}
					},
					scope: this
				}]
			}],
			width:450, // dummy initial size, for border layout to work
			height:100, // ...
			floating: true,
			draggable: true,
			constrain: true,
			renderTo: this.getEl(),
			tools: [{
				type: 'close',
				handler: function(e, t, p) {
					p.ownerCt.destroy();
				},
				scope: this
			}]
		});
		
		// Size + position
		addPeoplePanel.on('destroy',function(addPeoplePanel) {
			this.getEl().unmask() ;
			this._templatePopup = null ;
		},this,{single:true}) ;
		this.getEl().mask() ;
		
		addPeoplePanel.show();
		
		addPeoplePanel.getEl().alignTo(this.getEl(), 'c-c?');
		//Optima5.Helper.floatInsideParent( addPeoplePanel ) ;
		
		this._templatePopup = addPeoplePanel ;
	},
	handleLoadTemplate: function(tplCode) {
		var field = this.down('#fsHtml');
		Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getTplEmailAll(), function(tpl) {
			if( tpl.tpl_code==tplCode ) {
				field.setValue( tpl.tpl_body ) ;
				if( field.getEl() ) {
					field.getEl().highlight();
				}
				return false ;
			}
		});
	},
	
	
	showLoadmask: function() {
		if( this.rendered ) {
			this.doShowLoadmask() ;
		} else {
			this.on('afterrender',this.doShowLoadmask,this,{single:true}) ;
		}
	},
	doShowLoadmask: function() {
		if( this.loadMask ) {
			return ;
		}
		this.loadMask = Ext.create('Ext.LoadMask',{
			target: this,
			msg:"Please wait..."
		}).show();
	},
	hideLoadmask: function() {
		this.un('afterrender',this.doShowLoadmask,this) ;
		if( this.loadMask ) {
			this.loadMask.destroy() ;
			this.loadMask = null ;
		}
	},
	
	onDestroy: function() {
		if( this._templatePopup ) {
			this._templatePopup.destroy() ;
		}
	}
});
