Ext.define('Optima5.Modules.Spec.DbsEzeer.TicketActionPanel',{
	extend:'Ext.panel.Panel',
	
	requires: [
		'Optima5.Modules.Spec.DbsEzeer.TicketActionForm',
		'Optima5.Modules.Spec.DbsEzeer.TicketActionEmailForm',
		'Optima5.Modules.Spec.DbsEzeer.TicketLineView'
	],
	
	initComponent: function() {
		
		Ext.apply(this,{
			layout: {
				type: 'hbox',
				pack: 'middle',
				align: 'stretch'
			},
			items: [{
				xtype: 'box',
				flex: 1,
				cls:'op5-waiting'
			}]
		}) ;
		this.callParent() ;
		this.doLoad() ;
	},
	
	doLoad: function() {
		this.removeAll() ;
		this.removeBodyCls('op5-spec-dbsezeer-ticketform-single') ;
		if( this._ticketFilerecordId ) {
			this.loadForTicket(this._ticketFilerecordId) ;
		}
		else if( this._ticketNew ) {
			this.setForNew() ;
		}
	},
	
	setForNew: function() {
		this.removeAll() ;
		this.removeBodyCls('op5-spec-dbsezeer-ticketform-single') ;
		this.addBodyCls('op5-spec-dbsezeer-ticketform-single') ;
		this.add(Ext.create('Optima5.Modules.Spec.DbsEzeer.TicketActionForm',{
			optimaModule: this.optimaModule,
			maxWidth: 800,
			flex:1,
			
			_ticketNew: true,
			
			listeners: {
				saved: function(f,ticketFilerecordId,ticketactionFilerecordId) {
					this.onAfterTicketAction(ticketFilerecordId,true) ;
				},
				scope: this
			}
		})) ;
	},
	
	loadForTicket: function(ticketFilerecordId,isNew=false,isRecycle=false) {
		this._ticketFilerecordId = ticketFilerecordId ;
		
		this.showLoadmask() ;
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_ezeer',
				_action: 'ticket_getRecord',
				ticket_filerecord_id: ticketFilerecordId,
				do_flag: 1
			},
			success: function(response) {
				var ajaxData = Ext.decode(response.responseText) ;
				if( ajaxData.success == false ) {
					Ext.Msg.alert('Failed', 'Unknown error');
				}
				var ticketRecord = Ext.ux.dams.ModelManager.create('DbsEzeerTicketModel',ajaxData.data) ;
				this.onLoadTicket(ticketRecord,isNew,isRecycle) ;
			},
			callback: function() {
				this.hideLoadmask() ;
			},
			scope: this
		});
	},
	onLoadTicket: function( ticketRecord, isNew=false, isRecycle=false ) {
		this.optimaModule.postCrmEvent('maybenotificationschange',{});
		
		this.removeAll() ;
		this.removeBodyCls('op5-spec-dbsezeer-ticketform-single') ;
		this.add(Ext.create('Optima5.Modules.Spec.DbsEzeer.TicketLineView',{
			scrollable: 'vertical',
			itemId: 'dvLine',
			border: false,
			optimaModule: this.optimaModule,
			flex:1,
			
			_ticketFilerecordId: ticketRecord.get('ticket_filerecord_id'),
			_ticketRecord: ticketRecord,
			
			listeners: {
				saved: function(f,ticketFilerecordId) {
					this.onAfterTicketNew(ticketFilerecordId) ;
				},
				scope: this
			}
		})) ;
		var cmpDvLine = this.down('#dvLine') ;
		if( ticketRecord.get('status_is_new') ) {
			if( !Ext.isEmpty(ticketRecord.get('prop_links')) ) {
				this.add({
					itemId: 'pWait',
					flex: 1,
					xtype: 'box',
					cls:'op5-waiting'
				});
				this.optimaModule.getConfiguredAjaxConnection().request({
					params: {
						_moduleId: 'spec_dbs_ezeer',
						_action: 'ticket_postUpdateNew',
						ticket_filerecord_id: ticketRecord.get('ticket_filerecord_id'),
						form_data: Ext.JSON.encode({ticketnew_action:'new'}),
					},
					success: function(response) {
						var ajaxData = Ext.decode(response.responseText) ;
						if( ajaxData.success == false ) {
							Ext.Msg.alert('Failed', 'Unknown error');
							return ;
						}
						this.onAfterTicketNew(ajaxData.ticket_filerecord_id) ;
					},
					callback: function() {
						this.hideLoadmask() ;
					},
					scope: this
				});
			} else {
				this.add(Ext.create('Optima5.Modules.Spec.DbsEzeer.TicketActionEmailForm',{
					itemId: 'pForm',
					flex:1,
					
					optimaModule: this.optimaModule,
					
					_ticketFilerecordId: ticketRecord.get('ticket_filerecord_id'),
					_ticketRecord: ticketRecord,
					
					listeners: {
						saved: function(f,ticketFilerecordId) {
							this.onAfterTicketNew(ticketFilerecordId) ;
						},
						scope: this
					}
				}));
			}
		} else {
			this.add(Ext.create('Optima5.Modules.Spec.DbsEzeer.TicketActionForm',{
				itemId: 'pForm',
				flex:1,
				
				optimaModule: this.optimaModule,
				
				//title: 'New action',
				headerPosition: 'left',
				collapsible: true,
				collapseDirection: 'right',
				collapsed: false,
				
				hidden: isRecycle,
				
				_ticketFilerecordId: ticketRecord.get('ticket_filerecord_id'),
				_ticketRecord: ticketRecord,
				
				_ticketNew: isNew,
				
				_cmpDvLine: cmpDvLine,
				
				listeners: {
					collapse: function(p) {
						var lDvLine = this.getTicketLine() ;
						if( lDvLine ) {
							lDvLine.setWideMode(true) ;
						}
					},
					expand: function(p) {
						var lDvLine = this.getTicketLine() ;
						if( lDvLine ) {
							lDvLine.setWideMode(false) ;
						}
					},
					saved: function(f,ticketFilerecordId,ticketactionFilerecordId) {
						this.onAfterTicketAction(ticketFilerecordId) ;
					},
					scope: this
				}
			})) ;
			if( isRecycle ) {
				this.add({
					itemId: 'pWait',
					flex: 1,
					xtype: 'box',
					cls:'op5-waiting'
				});
			}
		}
		
		var title = '#'+ticketRecord.get('ticket_filerecord_id')+' : '+ticketRecord.get('prop_title') ;
		this.setTitle(title) ;
		
		if( isRecycle && this.down('#pForm') ) {
			Ext.defer( function() {
				if( this.isDestroyed ) {
					return ;
				}
				this.down('#pWait').setVisible(false) ;
				this.down('#pForm').setVisible(true) ;
				this.down('#pWait').destroy() ;
			},3000,this);
		}
	},
	
	getTicketLine: function() {
		return this.down('#dvLine') ;
	},
	
	
	
	
	showLoadmask: function() {
		if( this.rendered ) {
			this.doShowLoadmask() ;
		} else {
			this.on('afterrender',this.doShowLoadmask,this,{single:true}) ;
		}
	},
	doShowLoadmask: function() {
		if( this.loadMask ) {
			return ;
		}
		this.loadMask = Ext.create('Ext.LoadMask',{
			target: this,
			msg:"Please wait..."
		}).show();
	},
	hideLoadmask: function() {
		this.un('afterrender',this.doShowLoadmask,this) ;
		if( this.loadMask ) {
			this.loadMask.destroy() ;
			this.loadMask = null ;
		}
	},
	
	onAfterTicketAction: function(ticketFilerecordId,isNew=false) {
		this.optimaModule.postCrmEvent('datachange',{}) ;
		Ext.defer(function() {
			this.loadForTicket(ticketFilerecordId,false,true) ;
		},100,this) ;
	},
	onAfterTicketNew: function(ticketFilerecordId) {
		this.optimaModule.postCrmEvent('datachange',{}) ;
		if( ticketFilerecordId ) {
			this.loadForTicket(ticketFilerecordId,true) ;
		} else {
			Ext.defer(function() {
				this.destroy() ;
			},100,this) ;
		}
	},
	
}) ;
