Ext.define('Optima5.Modules.Spec.DbsEzeer.TicketAttachmentsGrid',{
	extend: 'Ext.container.Container',
	
	mixins: [
		'Ext.form.field.Field'
	],
	
	initComponent: function() {
		this.attachmentsStore = Ext.create('Ext.data.Store', {
			fields: ['name', 'size', 'file', 'status','tmpMediaId',{name:'fromAttachId',type:'int'}],
			proxy: {
				type: 'memory',
				reader: {
					type: 'json'
				}
			}
		});
		
		var me = this ;
		Ext.apply(this,{
			//xtype: 'container',
			layout: {
				type: 'hbox',
				align: 'stretch',
			},
			items: [{
				itemId: 'cmpButtons',
				xtype: 'box',
				width: 40,
				cls: 'ux-noframe-bg',
				tpl: [
					'<div class="op5-spec-dbsezeer-ticketaction-buttons">',
						'<tpl if="btn_browse">',
							'<div class="op5-spec-dbsezeer-ticketaction-buttons-btn op5-spec-dbsezeer-ticketaction-buttons-btn-select-no">',
							'</div>',
						'</tpl>',
						'<tpl if="btn_list">',
							'<div class="op5-spec-dbsezeer-ticketaction-buttons-btn op5-spec-dbsezeer-ticketaction-buttons-btn-new">',
							'</div>',
						'</tpl>',
					'</div>',
				],
				data: {
					btn_browse: true,
					btn_list: true,
				},
				listeners: {
					afterrender: function(cmp) {
						cmp.getEl().un('click',me.onButtonsClick,me) ;
						cmp.getEl().on('click',me.onButtonsClick,me) ;
					},
					scope: this,
				}
			},{
				flex:1,
				layout: {
					type: 'vbox',
					align: 'stretch'
				},
				items: [{
					hidden: true,
					border: false,
					xtype: 'form',
					itemId: 'fUpload',
					cls: 'ux-noframe-bg',
					bodyCls: 'ux-noframe-bg',
					bodyPadding: 2,
					defaults: {
							anchor: '100%',
							allowBlank: false,
							msgTarget: 'side',
							labelWidth: 50
					},
					//bodyPadding: '0 0 0 0',
					items: [{
						xtype: 'filefield',
						emptyText: 'Select file',
						name: 'uploadfile',
						buttonText: '',
						buttonConfig: {
							iconCls: 'upload-icon'
						},
						listeners: {
							change: {
								fn: function(field) {
									var form = field.up('form') ;
									this.doUploadManual(form) ;
								},
								scope:this
							}
						}
					}]
				},{
					flex: 1,
					xtype: 'grid',
					columns: [{
						header: 'Name',
						dataIndex: 'name',
						flex: 1
					}, {
						width:24,
						header: '',
						dataIndex: 'status',
						renderer: function(value, metaData, record) {
							switch( value ) {
								case "Ready" :
									metaData.tdCls += ' op5-spec-rsiveo-kpi-unknown' ;
									break ;
								case "Uploading" :
									metaData.tdCls += ' op5-spec-rsiveo-kpi-uploading' ;
									break ;
								case "Error" :
									metaData.tdCls += ' op5-spec-rsiveo-kpi-nok' ;
									break ;
								case "Uploaded" :
									metaData.tdCls += ' op5-spec-rsiveo-kpi-ok' ;
									break ;
							}
						}
					},{
						align: 'center',
						xtype:'actioncolumn',
						width:24,
						disabledCls: 'x-item-invisible',
						items: [{
							icon: 'images/op5img/ico_delete_16.gif',
							tooltip: 'Effacer',
							handler: function(grid, rowIndex, colIndex, item, e) {
								var rec = grid.getStore().getAt(rowIndex);
								this.handleDelete(grid.getStore(),rowIndex) ;
							},
							scope: this,
							disabledCls: 'x-item-invisible',
							isDisabled: function(grid,rowIndex,colIndex,item,record ) {
								var rec = grid.getStore().getAt(rowIndex);
								if( rec.get('status')=='Uploaded' && !Ext.isEmpty(rec.get('tmpMediaId')) ) {
									return false ;
								}
								return true ;
							}
						}]
					}],
					viewConfig: {
						emptyText: 'Drop Files Here',
						deferEmptyText: false
					},
					store: this.attachmentsStore,

					listeners: {
						itemdblclick: {
							fn: function(grid,record) {
								var store = grid.getStore() ;
								this.handleDownload(store,store.indexOf(record)) ;
							},
							scope: this
						},

						drop: {
							element: 'el',
							fn: 'drop'
						},

						dragstart: {
							element: 'el',
							fn: 'addDropZone'
						},

						dragenter: {
							element: 'el',
							fn: 'addDropZone'
						},

						dragover: {
							element: 'el',
							fn: 'addDropZone'
						},

						dragleave: {
							element: 'el',
							fn: 'removeDropZone'
						},

						dragexit: {
							element: 'el',
							fn: 'removeDropZone'
						},
					},

					noop: function(e) {
						e.stopEvent();
					},

					addDropZone: function(e) {
						if (!e.browserEvent.dataTransfer || Ext.Array.from(e.browserEvent.dataTransfer.types).indexOf('Files') === -1) {
							return;
						}

						e.stopEvent();

						this.addCls('drag-over');
					},

					removeDropZone: function(e) {
						var el = e.getTarget(),
							thisEl = this.getEl();

						e.stopEvent();


						if (el === thisEl.dom) {
							this.removeCls('drag-over');
							return;
						}

						while (el !== thisEl.dom && el && el.parentNode) {
							el = el.parentNode;
						}

						if (el !== thisEl.dom) {
							this.removeCls('drag-over');
						}

					},

					drop: function(e) {
						e.stopEvent();
						Ext.Array.forEach(Ext.Array.from(e.browserEvent.dataTransfer.files), function(file) {
							
							var newRecords = me.attachmentsStore.add({
									file: file,
									name: file.name,
									size: file.size,
									status: 'Ready'
							});
							var newRecord = newRecords[0] ;
							var newRecordIdx = me.attachmentsStore.indexOf(newRecord) ;
							Ext.defer(function() {
								newRecord.set('status',"Uploading") ;
								newRecord.commit() ;
								
								me.doUpload(me.attachmentsStore, newRecordIdx) ;
							},1000,me) ;
						});
						
					}
				}]
			}]
		}) ;
		this.callParent() ;
		this.mixins.field.constructor.call(this);
		this.on('destroy',this.onDestroyMyself,this) ;
	},
	
	onButtonsClick: function(e) {
		if( e.getTarget('.op5-spec-dbsezeer-ticketaction-buttons-btn-select-no') ) {
			this.onButtonBrowse() ;
		}
		if( e.getTarget('.op5-spec-dbsezeer-ticketaction-buttons-btn-new') ) {
			this.onButtonList() ;
		}
	},
	onButtonBrowse: function() {
		/*
		var cmp = this.down('#cmpButtons'),
			cmpData = cmp.getData() ;
		cmpData.btn_browse = false ;
		cmp.update(cmpData) ;
		*/
		
		//this.down('#fUpload').setVisible(true) ;
		this.down('#fUpload').down('filefield').fileInputEl.dom.click() ;
	},
	onButtonList: function() {
		this.fireEvent('list',this) ;
	},
	
	
	doUpload: function(store, i) {
		var tmpStoreRecord = store.getData().getAt(i) ;

		var fd = new FormData();
		Ext.Object.each( this.optimaModule.getConfiguredAjaxParams(), function(k,v) {
				fd.append(k,v) ;
		} ) ;

		fd.append("_moduleId",'spec_dbs_ezeer');
		fd.append("_action",'attach_uploadTmp');


		fd.append('file', tmpStoreRecord.data.file);

		var xhr = new XMLHttpRequest();
		
		xhr.open("POST", Optima5.Helper.getApplication().desktopGetBackendUrl(), true);
		
		

		xhr.setRequestHeader("serverTimeDiff", 0);

		xhr.onreadystatechange = function() {

			if (xhr.readyState == 4 && xhr.status == 200) {
				//handle the answer, in order to detect any server side error
				if (Ext.decode(xhr.responseText).success) {
					tmpStoreRecord.data.status = "Uploaded";
					tmpStoreRecord.data.tmpMediaId = Ext.decode(xhr.responseText).data.media_id;
					tmpStoreRecord.commit();
				} else {
					tmpStoreRecord.data.status = "Error";
					store.remove( tmpStoreRecord ) ;
				}
			} else if (xhr.readyState == 4 && xhr.status == 404) {
				tmpStoreRecord.data.status = "Error";
				tmpStoreRecord.commit();
			}
		};
		
		// Initiate a multipart/form-data upload
		xhr.send(fd);

	},
	doUploadManual: function(form) {
		var store = this.attachmentsStore ;
		if(form.isValid()){
			var ajaxParams = this.optimaModule.getConfiguredAjaxParams() ;
			Ext.apply( ajaxParams, {
				_moduleId: 'spec_dbs_ezeer',
				_action: 'attach_uploadTmp'
			}) ;
			var msgbox = Ext.Msg.wait('Uploading document...');
			form.submit({
				url: Optima5.Helper.getApplication().desktopGetBackendUrl(),
				params: ajaxParams,
				success : function(form,action){
					msgbox.close() ;
					Ext.menu.Manager.hideAll();
					var ajaxData = Ext.JSON.decode(action.response.responseText).data ;
					store.add({
							file: ajaxData.path,
							name: ajaxData.filename,
							size: ajaxData.size,
							status: 'Uploaded',
							tmpMediaId: ajaxData.media_id
					});
				},
				failure: function(form, action) {
					msgbox.close() ;
					var msg = 'Erreur' ;
					if( action.response.responseText ) {
							msg = Ext.JSON.decode(action.response.responseText).error ;
					}
					Ext.Msg.alert('Erreur',msg) ;
				},
				scope: this
			});
		}
	},
	handleDownload: function(store,i) {
		 var record = store.getAt(i),
			  tmpMediaId = record.get('tmpMediaId'),
			  fileName = record.get('name') ;
			  
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_ezeer',
				_action: 'attach_downloadB64',
				media_id: tmpMediaId
			},
			success: function(response) {
				var ajaxData = Ext.decode(response.responseText) ;
				if( ajaxData.success == false ) {
					Ext.Msg.alert('Failed', 'Unknown error');
				}
				Optima5.Modules.Spec.DbsEzeer.HelperCache.libBinaryDownload(ajaxData.bin_base64,fileName) ;
			},
			scope: this
		});
	},
	 handleDelete: function(store,i) {
		 var record = store.getAt(i),
			  tmpMediaId = record.get('tmpMediaId') ;
		 
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_ezeer',
				_action: 'attach_deleteTmp',
				arr_media_id: Ext.JSON.encode([tmpMediaId])
			},
			scope: this
		});
		 
		 store.remove(record) ;
	 },
	onDestroyMyself: function(myself) {
		var tmpMediaIds = [] ;
		this.attachmentsStore.each( function(rec) {
			if( !Ext.isEmpty(rec.get('tmpMediaId')) ) {
				tmpMediaIds.push( rec.get('tmpMediaId') ) ;
			}
		}) ;
		if( tmpMediaIds.length == 0 ) {
			return ;
		}
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_ezeer',
				_action: 'attach_deleteTmp',
				arr_media_id: Ext.JSON.encode(tmpMediaIds)
			},
			scope: this
		});
	},
	
	getStore: function() {
		return this.down('grid').getStore() ;
	},
	getRawValue: function() {
		return Ext.JSON.encode(this.getValue()) ;
	},
	getValue: function() {
		var values = [] ;
		this.getStore().each( function(rec) {
			values.push({
				media_id: rec.get('tmpMediaId'),
				media_filename: rec.get('name')
			}) ;
		}) ;
		return values ;
	},

}) ;
