Ext.define('Optima5.Modules.Spec.DbsEzeer.TicketCloseReasonField',{
	extend: 'Ext.form.FieldContainer',
	mixins: [
		'Ext.form.field.Field'
	],
	
	_value: null,
	
	initComponent: function() {
		Ext.apply(this,{
			layout: 'fit',
		});
		this.callParent();
	},
	
	setFormValues: function( values ) {
		this.removeAll() ;
		
		var propCategory = values.prop_category,
			propOrigin = values.prop_origin ;
		if( !Ext.isObject(propCategory) || !Ext.isObject(propCategory.lists) ) {
			return;
		}
		var propCategoryMain = propCategory.value,
			propCategoryLists = propCategory.lists;
		
		var cfgParam_id ;
		switch( propCategoryMain ) {
			case 'SAF' :
				switch( propOrigin ) {
					case 'CLI' :
						switch( propCategoryLists.SAF_BU ) {
							case 'SLS' :
								cfgParam_id = 'CLOSE'+':'+'G_SLS' ;
								break ;
							case 'SNA' :
								cfgParam_id = 'CLOSE'+':'+'G_SNA' ;
								break ;
							case 'AGI' :
								cfgParam_id = 'CLOSE'+':'+'G_AGI' ;
								break ;
							case 'SDLR' :
								cfgParam_id = 'CLOSE'+':'+'G_SDLR' ;
								break ;
						}
						break ;
					case 'ZMISC' :
						cfgParam_id = 'CLOSE'+':'+'9_1' ;
						break ;
					case 'INT' :
						cfgParam_id = 'CLOSE'+':'+'G_CI' ;
						break ;
					case 'T3' :
					case 'TRSPT' :
						cfgParam_id = 'CLOSE'+':'+'G_CT' ;
						break ;
					case 'OPS' :
						cfgParam_id = 'CLOSE'+':'+'G_CO' ;
						break ;
				}
				break ;
			case 'EMB' :
				switch( propCategoryLists.EMB_FLUX ) {
					case 'Réception' :
						cfgParam_id = 'CLOSE'+':'+'EMB_REC' ;
						break ;
					case 'Repair' :
						cfgParam_id = 'CLOSE'+':'+'EMB_RPR' ;
						break ;
					case 'Shipping' :
						cfgParam_id = 'CLOSE'+':'+'EMB_SHP' ;
						break ;
					case 'GDS' :
						cfgParam_id = 'CLOSE'+':'+'EMB_GDS' ;
						break ;
					case 'Claims' :
						cfgParam_id = 'CLOSE'+':'+'EMB_CLM' ;
						break ;
					case 'Picking' :
						cfgParam_id = 'CLOSE'+':'+'EMB_PKG' ;
						break ;
					case 'Douane' :
						cfgParam_id = 'CLOSE'+':'+'EMB_CST' ;
						break ;
				}
				break ;
		}
		if( !cfgParam_id ) {
			cfgParam_id = 'CLOSE'+':'+'X';
		}
		
		this.add( Ext.create('Optima5.Modules.Spec.DbsEzeer.CfgParamField',{
			flex: 1,
			
			allowBlankIfVisible: false,
			xtype: 'op5crmbasebibletreepicker',
			selectMode: 'single',
			cfgParam_id: cfgParam_id,
			cfgParam_emptyDisplayText: 'Close reason',
			cfgParam_leafOnly: true,
			
			itemId: 'fInnerClose',
			
			optimaModule: this.optimaModule
		}) );
	},
	
	getValue: function() {
		if( !this.down('#fInnerClose') ) {
			return null;
		}
		return this.down('#fInnerClose').getValue();
	},
	setValue: function(v) {
		if( !this.down('#fInnerClose') ) {
			return;
		}
		this.down('#fInnerClose').setValue(v);
	},
	
});
