Ext.define('Optima5.Modules.Spec.DbsEzeer.TicketEmailAdrField',{
	extend: 'Ext.form.FieldContainer',
	
	mixins: [
		'Ext.form.field.Field'
	],
	
	initComponent: function() {
		var me = this ;
		
		this._storeEmails = Ext.create('Ext.data.Store',{
			data: [],
			fields: [
				{name:'type', type:'string'},
				{name:'txt', type:'string'},
				{name:'email_adr', type: 'string'},
				{name:'list_id', type: 'string'},
			],
			proxy: {
				type: 'memory'
			}
		});
		
		Ext.apply(me,{
			layout: {
				type: 'hbox',
				align: 'stretch'
			},
			items: [{
				itemId: 'cmbAdd',
				xtype: 'combobox',
				width: 175,
				forceSelection: false,
				editable: true,
				queryMode: 'local',
				displayField: 'txt',
				valueField: 'email_adr',
				store: this._storeEmails,
				matchFieldWidth: false,
				anyMatch: true,
				listConfig: {
					width: 350,
					getInnerTpl: function(displayField) {
						return [
							'<div style="padding-bottom:6px">',
							'<tpl switch="type">',
								'<tpl case="email">',
									'<div style="text:10px">Email&#160;:&#160;<b>{[values.txt]}</b></div>',
								'<tpl case="list">',
									'<div style="text:10px">Liste&#160;:&#160;<b>{[values.txt]}</b></div>',
							'</tpl>',
							'</div>',
						].join('');
					}
				},
				listeners: {
					select: function(cmb,r) {
						if( r.get('type') == 'list' ) {
							this.handleAddList(r.get('list_id'),r.get('txt'));
							return;
						}
						this.handleAdd();
					},
					scope: this
				}
			},{
				itemId: 'btnAdd',
				xtype: 'button',
				iconCls: 'op5-spec-dbsezeer-headertags-btn',
				margin: {
					left: 4,
					right: 8
				},
				handler: function() {
					this.handleAdd() ;
				},
				scope: this
			},{
				flex: 1,
				itemId: 'dvTags',
				xtype: 'dataview',
				cls: 'op5-spec-dbsezeer-headertags-field',
				tpl: [
					'<tpl for=".">',
						'<div class="op5-spec-dbsezeer-headertags">',
							'<tpl if="_deletable">',
								'<div class="op5-spec-dbsezeer-headertags-ico op5-spec-dbsezeer-headertags-ico-delete">',
								'</div>',
							'</tpl>',
							'<tpl switch="type">',
								'<tpl case="email">',
									'<div class="op5-spec-dbsezeer-headertags-ico op5-spec-dbsezeer-headertags-ico-emailadr">',
									'</div>',
									'<div class="op5-spec-dbsezeer-headertags-text">',
									'{email_adr}',
									'</div>',
								'<tpl case="list">',
									'<div class="op5-spec-dbsezeer-headertags-ico op5-spec-dbsezeer-headertags-ico-group">',
									'</div>',
									'<div class="op5-spec-dbsezeer-headertags-text">',
									'{list_txt}',
									'</div>',
							'</tpl>',
						'</div>',
					'</tpl>',
					{
					}
				],
				itemSelector: 'div.op5-spec-dbsezeer-headertags',
				store: {
					data: [],
					fields: [
						{name:'_deletable', type:'boolean'},
						{name:'type', type:'string'},
						{name:'email_adr', type:'string'},
						{name:'list_id', type:'string'},
						{name:'list_txt', type:'string'},
					]
				},
				prepareData: function(data) {
					return data;
				},
				listeners: {
					itemmouseleave: function(dv, record, item, index, e, eOpts) {
						Ext.defer(function() {
							if( record.get('_deletable') ) {
								record.set('_deletable',false) ;
								return ;
							}
						},100) ;
					},
					itemclick: function(dv, record, item, index, e, eOpts) {
						if( !record.get('_deletable') ) {
							record.set('_deletable',true) ;
							return ;
						}
						if( e.getTarget('div.op5-spec-dbsezeer-headertags-ico-delete') ) {
							this.deleteTag(record) ;
						}
						e.stopEvent() ;
					},
					scope: this
					
				}
			}]
		}) ;
		me.mixins.field.constructor.call(me);
		me.callParent() ;
		me.populateEmails() ;
	},
	
	
	getStore: function() {
		return this.down('#dvTags').getStore() ;
	},
	getRawValue: function() {
		var values = this.getValue() ;
		return Ext.JSON.encode(values) ;
	},
	getValue: function() {
		var values = [] ;
		this.getStore().each( function(rec) {
			var v = rec.getData() ;
			switch( v.type ) {
				case 'list' :
					if( Ext.isEmpty(v.list_id) ) {
						break ;
					}
					values.push({
						type: 'list',
						list_id: v.list_id,
					});
					break ;
				case 'email' :
					if( Ext.isEmpty(v.email_adr) ) {
						break ;
					}
					values.push({
						type: 'email',
						email_adr: v.email_adr,
					});
					break ;
			}
		},this) ;
		return values ;
	},
	setRawValue: function(jsonValues) {
		var values = Ext.JSON.decode( jsonValues );
		this.setValue(values) ;
	},
	setValue: function(values) {
		if( Ext.isEmpty(values) || !Ext.isArray(values) ) {
			this.getStore().removeAll() ;
			return ;
		}
		var storeData = [] ;
		Ext.Array.each(values,function(v) {
			storeData.push({type:'email', email_adr:v}) ;
		});
		this.getStore().loadData(storeData) ;
	},
	handleAdd: function() {
		var cmbAdd = this.down('#cmbAdd'),
			dvTags = this.down('#dvTags') ;
		if( Ext.isEmpty(cmbAdd.getRawValue()) ) {
			return ;
		}
		var ereg = /^\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/;
		if( !ereg.test(cmbAdd.getRawValue()) ) {
			cmbAdd.markInvalid('Email invalide') ;
			return ;
		}

		var test = dvTags.getStore().findExact('tag',cmbAdd.getValue(),0);

		if (test == -1){
			dvTags.getStore().insert(0,{
				type: 'email',
				email_adr: cmbAdd.getValue()
			});
			cmbAdd.reset() ;
		}
	},
	handleAddList: function(listId,listTxt) {
		var cmbAdd = this.down('#cmbAdd'),
			dvTags = this.down('#dvTags') ;
		dvTags.getStore().insert(0,{
			type: 'list',
			list_id: listId,
			list_txt: listTxt,
		});
		cmbAdd.reset() ;
	},
	deleteTag: function(tagRecord) {
		this.down('#dvTags').getStore().remove(tagRecord) ;
	},
	
	
	
	
	
	populateEmails: function( arrEmails=[] ) {
		var emailData = Optima5.Modules.Spec.DbsEzeer.HelperCache.getAdrbookEmailAll() ;
		if( arrEmails ) {
			Ext.Array.each( arrEmails, function(e) {
				emailData.push({email_adr:e}) ;
			});
		}
		
		var storeData = [] ;
		Ext.Array.each( emailData, function(r) {
			storeData.push({
				type: 'email',
				email_adr: r.email_adr,
				txt: r.email_adr,
			});
		});
		Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getPeopleListAll(), function(r) {
			storeData.push({
				type: 'list',
				list_id: r.list_id,
				txt: r.list_txt,
			});
		});
		
		var store = this._storeEmails ;
		store.removeAll() ;
		store.loadData(storeData) ;
	}
});
