Ext.define('Optima5.Modules.Spec.DbsEzeer.TicketPropCategorySubTree',{
	extend:'Ext.tree.Panel',
	
	optimaModule: null,
	cfgParam_id: '',
	value: null,
	forceValue: false,
	
	initComponent: function() {
		var me = this ;
		if( (me.optimaModule) instanceof Optima5.Module ) {} else {
			Optima5.Helper.logError('DbsEzeer:CfgParamTree','No module reference ?') ;
		}
		
		Ext.apply(me,{
			store: {
				model: 'DbsEzeerCfgParamTreeModel',
				root: {
					// root not visible
					children:[]
				},
				proxy: {
					type: 'memory' ,
					reader: {
						type: 'json'
					}
				}
			},
			displayField: 'nodeText',
			rootVisible: false,
			useArrows: true
		});
		this.callParent() ;
		this.getView().on('checkchange',function(rec,check){
			// Cascade root node
			if( !rec.isLeaf() ) {
				return ;
			}
			var subrootNode = rec.parentNode ;
			subrootNode.cascadeBy(function(iternode) {
				if( !iternode.isLeaf() ) {
					return;
				}
				var doCheck = (check && rec==iternode) ;
				iternode.set('checked',doCheck) ;
			});
			this.fireEvent('change',this.getSelectedValues()) ;
		},this) ;
	},
	
	getSelectedValues: function() {
		var objValues = {} ;
		this.getRootNode().cascadeBy(function(node) {
			if( !node.isLeaf() ) {
				return ;
			}
			if( node.get('checked') ) {
				objValues[node.parentNode.get('nodeId')] = node.get('nodeText');
			}
		});
		return objValues ;
	},
	
	
	applyValues: function( objValues ) {
		if( !Ext.isObject(objValues) ) {
			objValues = {} ;
		}
		this.getRootNode().cascadeBy(function(node) {
			if( !node.isLeaf() ) {
				return;
			}
			var listId = node.parentNode.get('nodeId');
			var doCheck = (objValues[listId]==node.get('nodeText')) ;
			node.set('checked', doCheck);
		});
	},
	
	setCfgLists: function( cfgObj ) {
		var rootChildren = [];
		Ext.Array.each(cfgObj,function(l) {
			if( Ext.isEmpty(l.list_id) || !Ext.isArray(l.list_rows) ) {
				return ;
			}
			var listLeafs = [] ;
			Ext.Array.each(l.list_rows, function(r) {
				listLeafs.push({
					nodeText: r.row_txt,
					checked: false,
					leaf: true,
				});
			});
			rootChildren.push({
				nodeId: l.list_id,
				nodeText: l.list_txt,
				expanded: true,
				collapsible: false,
				children: listLeafs,
			});
		});
		this.setRootNode({
			root: true,
			expanded: true,
			children: rootChildren,
		});
	},
}) ;
Ext.define('Optima5.Modules.Spec.DbsEzeer.TicketPropCategorySubField',{
	extend:'Ext.form.field.Picker',

	requires: [
		'Ext.XTemplate',
		'Optima5.Modules.Spec.DbsEzeer.CfgParamTree'
	], 

	preSubTpl: [
		'<div id="{cmpId}-triggerWrap" data-ref="triggerWrap" class="{triggerWrapCls} {triggerWrapCls}-{ui}">',
			'<div id={cmpId}-inputWrap data-ref="inputWrap" class="{inputWrapCls} {inputWrapCls}-{ui}">'
	],
	
	childEls: ['divcontainer'],
	fieldSubTpl: [
		'<div id="{id}" type="{type}" ',
			'<tpl if="size">size="{size}" </tpl>',
			'<tpl if="tabIdx">tabIndex="{tabIdx}" </tpl>',
			'class="{fieldCls} {typeCls} {typeCls}-{ui} {editableCls} {inputCls}" autocomplete="off">',
			'<span id="{cmpId}-divcontainer" data-ref="divtext">&#160;</span>',
		'</div>',
		{
			compiled: true,
			disableFormats: true
		}
	],
			  
	

	isFormField: true,
	submitValue: true,
	//resizable: true,
	
	_cfgLists: null,
	
	initComponent: function() {
		var me = this ;
		if( (me.optimaModule) instanceof Optima5.Module ) {} else {
			Optima5.Helper.logError('CrmBase:BibleTreePicker','No module reference ?') ;
		}
		
		this.on('afterrender',this.displayValue,this) ;
		
		this.cfgParamTree = Ext.create('Optima5.Modules.Spec.DbsEzeer.TicketPropCategorySubTree',{
			renderTo: Ext.getBody(),
			floating: true,
			hidden: true,
			focusOnShow: true,
			ownerCt: me.ownerCt,
			pickerField: me,
			
			optimaModule: this.optimaModule,
			cfgParam_id: this.cfgParam_id,
			cfgParam_leafOnly: this.cfgParam_leafOnly,
			width:250,
			height:300,
			listeners: {
				change: {
					fn: function(){
						this.onChange() ;
					},
					scope: this
				},
			}
		});
		
		this.callParent() ;
	},
	setRootNode: function(rootNode) {
		var cfgParamTree = this.cfgParamTree ;
		cfgParamTree.setRootNode(rootNode) ;
	},
			  
	createPicker: function() {
		//console.log('created!!') ;
		var me = this ;
		return this.cfgParamTree ;
	},
	expand: function() {
		var cfgParamTree = this.cfgParamTree;
		cfgParamTree.applyValues(this.value);
		this.callParent();
	},
	
	onChange: function() {
		var cfgParamTree = this.cfgParamTree,
			value = cfgParamTree.getSelectedValues() ;
		
		this.value = value ;
		this.fireEvent('change',this,value,this.oldValue) ;
		this.oldValue = value ;
		
		this.displayValue() ;
	},
	displayValue: function() {
		if( !this.rendered ) {
			this.on('afterrender',function(){
				this.displayValue();
			},this,{
				single:true
			}) ;
			return ;
		}
		
		var value = this.value,
			backgroundColor = this._badgeColor ;
		
		var divStyles = [] ;
		divStyles.push('display:inline-block');
		divStyles.push('border-radius:6px');
		divStyles.push('color:white');
		divStyles.push('font-size:11px');
		divStyles.push('margin: 0px 2px');
		divStyles.push('padding: 0px 6px');
		divStyles.push('background-color:'+backgroundColor);
		var divStyle = '' ;
		Ext.Array.each(divStyles,function(s) {
			divStyle+= s+'; ';
		});
		
		var innerHtml = '' ;
		Ext.Object.each( value, function(k,v) {
			if( Ext.isEmpty(v) ) {
				return ;
			}
			innerHtml+= '<div style="'+divStyle+'">'+v+'</div>';
		});
		this.divcontainer.dom.innerHTML = innerHtml;
	},
	
	getValue: function() {
		return this.value ;
	},
	setValue: function(v) {
		this.value = v ;
		this.displayValue() ;
	},
	getRawValue: function() {
		return Ext.JSON.encode(this.getValue());
	},
	setRawValue: function(v) {
		this.setValue(Ext.JSON.decode(v));
	},
	
	getErrors: function( curvalue ) {
		var errors = [];
		
		if( !(this.allowBlank===false) ) {
			return errors ;
		}
		
		var v = this.getValue() ;
		while(true) {
			if( !Ext.isArray(this._cfgLists) || !Ext.isObject(v) ) {
				errors.push('Not configured');
				break ;
			}
			if( Ext.Object.getKeys(v).length != this._cfgLists.length ) {
				errors.push('Incomplete');
				break ;
			}
			break ;
		}
		
		return errors;
	},
	
	reset: function() {
		this.callParent() ;
		this.displayValue() ;
	},
	
	setColor: function( color ) {
		this._badgeColor = color ;
	},
	setCfgLists: function( cfgObj ) {
		this._cfgLists = cfgObj ;
		var cfgParamTree = this.cfgParamTree;
		cfgParamTree.setCfgLists(cfgObj) ;
		this.displayValue();
	},
}); 





Ext.define('Optima5.Modules.Spec.DbsEzeer.TicketPropCategoryField',{
	extend: 'Ext.form.FieldContainer',
	
	mixins: [
		'Ext.form.field.Field'
	],

	_layout: 'hbox',
	_comboboxData: null,
	
	initComponent: function() {
		var me = this ;
		
		// HACK TODO filter on bible field ?
		var dataCategory = [];
		Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getCategoryAll(), function(r) {
			dataCategory.push(r) ;
		});
		Ext.apply(me,{
			layout: {
				type: this._layout,
				align: 'stretch'
			},
			items: [{
				itemId: 'cmbProp',
				width:300,
				xtype: 'colorcombo',
				queryMode: 'local',
				forceSelection: true,
				editable: false,
				displayField: 'category_txt',
				valueField: 'category_code',
				iconColorField: 'category_color',
				store: {
					model: 'DbsEzeerCfgCategoryModel',
					data : dataCategory
				},
				listeners: {
					change: function(cmb,v) {
						this.onPropChange(v) ;
					},
					scope: this
				}
			},Ext.create('Optima5.Modules.Spec.DbsEzeer.TicketPropCategorySubField',{
				itemId: 'cmbPropSub',
				flex:1,
				optimaModule: this.optimaModule,
				listeners: {
					change: function(cmb,v) {
						this.onPropSubChange() ;
					},
					scope: this
				}
			})]
		}) ;
		me.mixins.field.constructor.call(me);
		
		me.callParent() ;
	},
	onPropChange: function(v) {
		var store = this.down('#cmbProp').getStore() ;
		var subRows = null ;
		if( !Ext.isEmpty(v) ) {
			subRows = store.getById(v).get('category_sub_lists') ;
		}
		
		var subCmb = this.down('#cmbPropSub') ;
		if( subRows != null ) {
			subCmb.setCfgLists(subRows) ;
			subCmb.setColor(store.getById(v).get('category_color'));
			subCmb.reset() ;
			subCmb.setVisible(true) ;
			subCmb._isVisible = true ;
		} else {
			subCmb.setVisible(false) ;
			subCmb._isVisible = false ;
			subCmb.setCfgLists(null) ;
		}
		
		if( this._silentChange ) {
			return ;
		}
		this.fireEvent('change',this,this.getValue()) ;
	},
	onPropSubChange: function() {
		if( !this.down('#cmbPropSub')._isVisible || this._silentChange ) {
			return ;
		}
		this.fireEvent('change',this,this.getValue()) ;
	},
	setValue: function(v) {
		this._silentChange = true ;
		if( !v || !Ext.isObject(v) || !v.hasOwnProperty('value') ) {
			this.down('#cmbProp').reset() ;
			this.down('#cmbPropSub').reset() ;
			this._silentChange = false ;
			this.fireEvent('change',this,this.getValue()) ;
			return ;
		}
		var tarr = v ;
		this.down('#cmbProp').setValue(tarr['value']) ;
		if( tarr['lists'] ) {
			this.down('#cmbPropSub').setValue(tarr['lists']) ;
		}
		this._silentChange = false ;
		this.fireEvent('change',this,this.getValue()) ;
	},
	getValue: function() {
		var tarr = {
			value: this.down('#cmbProp').getValue(),
		};
		if( this.down('#cmbPropSub')._isVisible && !Ext.isEmpty(this.down('#cmbPropSub').getValue()) ) {
			tarr['lists'] = this.down('#cmbPropSub').getValue() ;
		}
		return tarr ;
	},
	
	setReadOnly: function(torf,skipSub=false) {
		this.down('#cmbProp').setReadOnly(torf) ;
		this.down('#cmbPropSub').setReadOnly(torf&&!skipSub) ;
	},
});
