Ext.define('Optima5.Modules.Spec.DbsEzeer.TicketPropLinkField',{
	extend: 'Ext.form.FieldContainer',
	
	mixins: [
		'Ext.form.field.Field'
	],

	_comboboxData: null,
	
	setReadOnly: function(torf) {
		this.readOnly = true ;
		this.down('#cmbAddLink').setVisible( !torf );
		this.down('#cmbAddSearch').setVisible( !torf );
		this.down('#btnAdd').setVisible( !torf );
	},
	initComponent: function() {
		var me = this ;
		
		var thisFields = [
			{name:'link_class', type:'string'},
			{name:'link_class_isSearch', type:'boolean'},
			{name:'link_cfgcode', type:'string'},
			{name:'link_cfgtxt', type:'string'}
		] ;
		var comboboxData = [] ;
		Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getLinkAll(), function(row) {
			comboboxData.push(row) ;
		});
		
		Ext.apply(me,{
			layout: {
				type: 'hbox',
				align: 'stretch'
			},
			items: [{
				itemId: 'cmbAddLink',
				xtype: 'combobox',
				width: 130,
				forceSelection: false,
				editable: true,
				queryMode: 'local',
				valueField: 'link_cfgcode',
				displayField: 'link_cfgtxt',
				store: {
					data: comboboxData,
					fields: thisFields
				},
				listeners: {
					select: function(cmb,record) {
						this.down('#cmbAddSearch').reset() ;
						this.down('#btnAdd').setVisible(!record.get('link_class_isSearch')) ;
					},
					scope: this
				},
				matchFieldWidth: true,
				anyMatch: true
			},{
				itemId: 'cmbAddSearch',
				xtype: 'combobox',
				width: 200,
				forceSelection: false,
				editable: true,
				queryMode: 'remote',
				valueField: 'search_id',
				displayField: 'search_txt',
				queryParam: 'filter',
				minChars: 0,
				triggerAction: 'query',
				store: {
					//autoLoad: true,
					fields: ['search_id','search_txt'],
					proxy: this.optimaModule.getConfiguredAjaxProxy({
						extraParams : {
							_moduleId: 'spec_dbs_ezeer',
							_action: 'search_link'
						},
						reader: {
							type: 'json',
							rootProperty: 'data'
						}
					}),
					listeners: {
						beforeload: function(store,options) {
							var cmbAddLink = this.down('#cmbAddLink'),
								linkCfgCode = cmbAddLink.getValue(),
								linkCfgRecord = cmbAddLink.findRecordByValue(linkCfgCode) ;
							if( !linkCfgRecord || !linkCfgRecord.get('link_class_isSearch') ) {
								store.loadRawData([]) ;
								return false ;
							}
							
							var params = options.getParams() || {} ;
							if( linkCfgCode ) {
								Ext.apply(params,{
									link_cfgcode: linkCfgCode
								}) ;
							}
							options.setParams(params) ;
						},
						scope: this
					}
				},
				listeners: {
					select: function(cmb,rec) {
						this.handleSelectRecord(rec) ;
					},
					scope: this
				},
				matchFieldWidth: true,
				anyMatch: true
			},{
				itemId: 'btnAdd',
				hidden: true,
				xtype: 'button',
				iconCls: 'op5-spec-dbsezeer-headertags-btn',
				margin: {
					left: 4,
					right: 8
				},
				handler: function() {
					this.handleAdd() ;
				},
				scope: this
			},{
				_peopleGroupData: Optima5.Modules.Spec.DbsEzeer.HelperCache.getPeopleGroupAll(),
				_peopleUserData: Optima5.Modules.Spec.DbsEzeer.HelperCache.getPeopleUserAll(),
				itemId: 'dvTags',
				xtype: 'dataview',
				cls: 'op5-spec-dbsezeer-headertags-field',
				tpl: [
					'<tpl for=".">',
						'<div class="op5-spec-dbsezeer-headertags">',
							'<tpl if="_deletable">',
								'<div class="op5-spec-dbsezeer-headertags-ico op5-spec-dbsezeer-headertags-ico-delete">',
								'</div>',
							'</tpl>',
							'<div class="op5-spec-dbsezeer-headertags-ico {[this.getIconCls(values)]}">',
							'</div>',
							'<div class="op5-spec-dbsezeer-headertags-text">',
							'{[this.getLibelle(values)]}',
							'</div>',
						'</div>',
					'</tpl>',
					{
						getIconCls: function(v) {
							return 'op5-spec-dbsezeer-headertags-ico-dbs' ;
						},
						getLibelle: function(v) {
							var dv = this.owner ;
							var returnVal = v.link_txt ;
							return returnVal;
						}
					}
				],
				itemSelector: 'div.op5-spec-dbsezeer-headertags',
				store: {
					data: [],
					fields: thisFields,

				},
				prepareData: function(data) {
					return data;
				},
				listeners: {
					itemmouseleave: function(dv, record, item, index, e, eOpts) {
						Ext.defer(function() {
							if( record.get('_deletable') ) {
								record.set('_deletable',false) ;
								return ;
							}
						},100) ;
					},
					itemclick: function(dv, record, item, index, e, eOpts) {
						if( this.readOnly ) {
							return;
						}
						if( !record.get('_deletable') ) {
							record.set('_deletable',true) ;
							return ;
						}
						if( e.getTarget('div.op5-spec-dbsezeer-headertags-ico-delete') ) {
							this.deleteTag(record) ;
						}
						e.stopEvent() ;
					},
					scope: this
					
				}
			}]
		}) ;
		me.mixins.field.constructor.call(me);
		
		me.callParent() ;
	},
	getStore: function() {
		return this.down('#dvTags').getStore() ;
	},
	getRawValue: function() {
		var values = [] ;
		this.getStore().each( function(rec) {
			var v = rec.getData() ;
			values.push({
				link_cfgcode: v.link_cfgcode,
				link_id: v.link_id,
				link_txt: v.link_txt,
			}) ;
		},this) ;
		return Ext.JSON.encode(values) ;
	},
	getValue: function() {
		var values = [] ;
		this.getStore().each( function(rec) {
			var v = rec.getData() ;
			values.push({
				link_cfgcode: v.link_cfgcode,
				link_id: v.link_id,
				link_txt: v.link_txt,
			}) ;
		},this) ;
		return values ;
	},
	setRawValue: function(jsonValues) {
		if( Ext.isEmpty(jsonValues) ) {
			this.getStore().removeAll() ;
		}
		var values = Ext.JSON.decode( jsonValues ),
			data = [] ;
		this.getStore().loadData(values) ;
	},
	setValue: function(values) {
		if( Ext.isEmpty(values) ) {
			this.getStore().removeAll() ;
		}
		this.getStore().loadData(values) ;
	},
	handleAdd: function() {
		var cmbAddLink = this.down('#cmbAddLink'),
			cmbAddSearch = this.down('#cmbAddSearch'),
			dvTags = this.down('#dvTags') ; 
		var linkCfgCode = cmbAddLink.getValue(),
			linkCfgRecord = cmbAddLink.findRecordByValue(linkCfgCode) ;
		
		if( Ext.isEmpty(cmbAddSearch.getRawValue()) ) {
			return ;
		}

		/*
		var test = dvTags.getStore().findExact('tag',cmbAdd.getValue(),0);
		*/

		dvTags.getStore().insert(0,{
			link_cfgcode: linkCfgCode,
			link_id: cmbAddSearch.getRawValue(),
			link_txt: linkCfgRecord.get('link_cfgtxt')+' : '+cmbAddSearch.getRawValue()
		});
		cmbAddLink.reset() ;
		cmbAddSearch.reset() ;
	},
	handleSelectRecord: function(rec) {
		var cmbAddLink = this.down('#cmbAddLink'),
			cmbAddSearch = this.down('#cmbAddSearch'),
			dvTags = this.down('#dvTags') ; 
		var linkCfgCode = cmbAddLink.getValue(),
			linkCfgRecord = cmbAddLink.findRecordByValue(linkCfgCode) ;
			
		dvTags.getStore().insert(0,{
			link_cfgcode: linkCfgCode,
			link_id: rec.get('search_id'),
			link_txt: linkCfgRecord.get('link_cfgtxt')+' : '+rec.get('search_txt')
		});
		cmbAddLink.reset() ;
		cmbAddSearch.reset() ;
	},
	deleteTag: function(tagRecord) {
		this.down('#dvTags').getStore().remove(tagRecord) ;
	}
});
