Ext.define('Optima5.Modules.Spec.DbsEzeer.TicketPropPeopleField',{
	extend: 'Ext.form.FieldContainer',
	
	mixins: [
		'Ext.form.field.Field'
	],

	_comboboxData: null,
	
	setReadOnly: function(torf) {
		this.readOnly = true ;
		this.down('#cmbAdd').setVisible( !torf );
		this.down('#btnAdd').setVisible( !torf );
	},
	initComponent: function() {
		var me = this ;
		
		var thisFields = [
			{name:'_deletable', type:'boolean'},
			{name:'people_type', type:'string'},
			{name:'people_id', type:'string'},
			{name:'people_txt', type:'string'},
			{name:'owner_is_on', type:'boolean'},
			{name:'assign_is_on', type:'boolean'},
			{name:'assign_is_off', type:'boolean'},
		] ;
		var comboboxData = [] ;
		Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getPeopleGroupAll(), function(row) {
			comboboxData.push({
				people_type: 'group',
				people_type_txt: 'Group',
				people_id: row.group_id,
				people_txt: row.group_txt
			}) ;
		});
		Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getPeopleUserAll(), function(row) {
			comboboxData.push({
				people_type: 'user',
				people_type_txt: 'User',
				people_id: row.user_id,
				people_txt: row.user_name
			}) ;
		});
		
		Ext.apply(me,{
			_peopleGroupData: Optima5.Modules.Spec.DbsEzeer.HelperCache.getPeopleGroupAll(),
			_peopleUserData: Optima5.Modules.Spec.DbsEzeer.HelperCache.getPeopleUserAll(),
			
			layout: {
				type: 'hbox',
				align: 'stretch'
			},
			items: [{
				itemId: 'cmbAdd',
				xtype: 'combobox',
				width: 175,
				forceSelection: false,
				editable: true,
				queryMode: 'local',
				valueField: 'people_txt',
				displayField: 'people_txt',
				store: {
					data: comboboxData,
					fields: thisFields
				},
				matchFieldWidth: false,
				anyMatch: true,
				listConfig: {
					width: 250,
					getInnerTpl: function() {
						return '<div style="padding-bottom:6px">'
						+'<b>{people_type_txt}</b>'
						+'&nbsp;:&nbsp;'
						+'{people_txt}'
						+'</div>' ;
					}
				},
				listeners: {
					select: function(cmb,rec) {
						this.handleSelectRecord(rec) ;
					},
					scope: this
				}
			},{
				itemId: 'btnAdd',
				xtype: 'button',
				iconCls: 'op5-spec-dbsezeer-headertags-btn',
				margin: {
					left: 4,
					right: 8
				},
				handler: function() {
					this.handleAdd() ;
				},
				scope: this
			},{
				flex: 1,
				itemId: 'dvTags',
				xtype: 'dataview',
				cls: 'op5-spec-dbsezeer-headertags-field',
				tpl: [
					'<tpl for=".">',
						'<div class="op5-spec-dbsezeer-headertags {[this.getAssignBg(values)]}">',
							'<tpl if="_deletable">',
								'<div class="op5-spec-dbsezeer-headertags-ico op5-spec-dbsezeer-headertags-ico-delete">',
								'</div>',
							'</tpl>',
							'<div class="op5-spec-dbsezeer-headertags-ico {[this.getIconCls(values)]}">',
							'</div>',
							'<div class="op5-spec-dbsezeer-headertags-text">',
							'{[this.getLibelle(values)]}',
							'</div>',
						'</div>',
					'</tpl>',
					{
						getAssignBg: function(v) {
							var dv = this.owner,
								fp = dv.ownerCt ;
							if( v.assign_is_on && (fp._peopleMode!='owner') ) {
								return 'op5-spec-dbsezeer-headertags-assigned' ;
							}
							return '' ;
						},
						getIconCls: function(v) {
							switch( v.people_type ) {
								case 'group' :
									return 'op5-spec-dbsezeer-headertags-ico-group' ;
								case 'user' :
									return 'op5-spec-dbsezeer-headertags-ico-user' ;
								case 'email' :
									return 'op5-spec-dbsezeer-headertags-ico-email' ;
							}
							return '' ;
						},
						getLibelle: function(v) {
							var dv = this.owner,
								fp = dv.ownerCt ;
							return fp.getTagTxt(v) ;
						}
					}
				],
				itemSelector: 'div.op5-spec-dbsezeer-headertags',
				store: {
					data: [],
					fields: thisFields,

				},
				prepareData: function(data) {
					return data;
				},
				listeners: {
					itemmouseleave: function(dv, record, item, index, e, eOpts) {
						Ext.defer(function() {
							if( record.get('_deletable') ) {
								record.set('_deletable',false) ;
								return ;
							}
						},100) ;
					},
					itemclick: function(dv, record, item, index, e, eOpts) {
						if( this.readOnly ) {
							return;
						}
						if( !record.get('_deletable') ) {
							record.set('_deletable',true) ;
							return ;
						}
						if( e.getTarget('div.op5-spec-dbsezeer-headertags-ico-delete') ) {
							this.deleteTag(record) ;
						}
						e.stopEvent() ;
					},
					scope: this
					
				}
			}]
		}) ;
		me.mixins.field.constructor.call(me);
		
		me.callParent() ;
		
		switch( this._peopleMode ) {
			case 'owner' :
				this.down('#btnAdd').setVisible(false) ;
				break ;
			default :
				this.down('#btnAdd').setVisible(true) ;
				break ;
		}
	},
	
	getTagTxt: function(v) {
		var returnVal = v.people_id ;
		switch( v.people_type ) {
			case 'group' :
				Ext.Array.each(this._peopleGroupData,function(row) {
					if( row.group_id == v.people_id ) {
						returnVal = row.group_txt ;
					}
				});
				break ;
			case 'user' :
				Ext.Array.each(this._peopleUserData,function(row) {
					if( row.user_id == v.people_id ) {
						returnVal = row.user_name ;
					}
				});
				break ;
				
			default: 
				break ;
		}
		return returnVal;
	},
	
	getStore: function() {
		return this.down('#dvTags').getStore() ;
	},
	getRawValue: function() {
		var values = this.getValue() ;
		return Ext.JSON.encode(values) ;
	},
	getValue: function() {
		var values = [] ;
		this.getStore().each( function(rec) {
			var v = rec.getData() ;
			var pushObj = {
				people_type: v.people_type,
				people_id: v.people_id,
				people_txt: this.getTagTxt(v)
			};
			if( v.assign_is_off ) {
				pushObj['assign_is_off'] = true ;
			}
			values.push(pushObj) ;
		},this) ;
		if( this._peopleMode=='owner' ) {
			return values[0];
		}
		return values ;
	},
	setRawValue: function(jsonValues) {
		var values = Ext.JSON.decode( jsonValues );
		this.setValue(values) ;
	},
	setValue: function(values) {
		if( Ext.isEmpty(values) ) {
			this.getStore().removeAll() ;
			return ;
		}
		if( Ext.isObject(values) ) {
			values = [values] ;
		}
		if( this._peopleMode=='cc_only' ) {
			var newValues = [] ;
			Ext.Array.each( values, function(r) {
				if( r.owner_is_on ) {
					return ;
				}
				newValues.push(r) ;
			});
			values = newValues ;
		}
		this.getStore().loadData(values) ;
	},
	handleAdd: function() {
		var cmbAdd = this.down('#cmbAdd'),
			dvTags = this.down('#dvTags') ; 
		if( Ext.isEmpty(cmbAdd.getRawValue()) ) {
			return ;
		}
		var ereg = /^\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/;
		if( !ereg.test(cmbAdd.getRawValue()) ) {
			cmbAdd.markInvalid('Email invalide') ;
			return ;
		}

		var test = dvTags.getStore().findExact('tag',cmbAdd.getValue(),0);

		if (test == -1){
			dvTags.getStore().insert(0,{
			people_type: 'email',
			people_id: cmbAdd.getValue()
			});
			cmbAdd.reset() ;			
		}
		/*
		if( dvTags.getHeight() > this.getHeight() ) {
			this.setHeight(dvTags.getHeight()) ;
		}
		this.updateLayout() ;
		*/
	},
	handleSelectRecord: function(rec,assignOff=false) {
		var cmbAdd = this.down('#cmbAdd'),
			dvTags = this.down('#dvTags') ;
		cmbAdd.reset() ;
		
		var selectedKey = rec.get('people_type')+'|'+rec.get('people_id') ;
		if( Ext.isEmpty(selectedKey) ) {
			return ;
		}
		var isExisting = false ;
		dvTags.getStore().each( function(iterRec) {
			var iterKey = iterRec.get('people_type')+'|'+iterRec.get('people_id') ;
			if( iterKey == selectedKey ) {
				isExisting = true ;
				return false ;
			}
		}) ;
		if( isExisting ) {
			return ;
		}
		
		if( this._peopleMode == 'owner' ) {
			if( this.getStore().getCount()==1 ) {
				var prevrec = this.getStore().getAt(0) ;
				var prevPeople = {
					people_type: prevrec.get('people_type'),
					people_id: prevrec.get('people_id'),
				};
				this.fireEvent('peoplereplace',this,prevPeople);
			}
			dvTags.getStore().removeAll() ;
		}
		var insertValues = {
			people_type: rec.get('people_type'),
			people_id: rec.get('people_id'),
		};
		if( assignOff ) {
			insertValues['assign_is_off'] = true ;
		}
		dvTags.getStore().insert(0,insertValues);
		/*
		if( dvTags.getHeight() > this.getHeight() ) {
			this.setHeight(dvTags.getHeight()) ;
		}
		this.updateLayout() ;
		*/
	},
	deleteTag: function(tagRecord) {
		this.down('#dvTags').getStore().remove(tagRecord) ;
	},
	
	extAddPeople: function( peoepleType, peopleId ) {
		this.down('#cmbAdd').getStore().each( function(rec) {
			if( peoepleType==rec.get('people_type') && peopleId==rec.get('people_id') ) {
				this.handleSelectRecord(rec,true) ;
				return false ;
			}
		},this) ;
	},
});
