Ext.define('Optima5.Modules.Spec.DbsEzeer.TicketsExplorerPanel',{
	extend: 'Ext.panel.Panel',
	
	requires: [
		'Optima5.Modules.Spec.DbsEzeer.CfgParamButton'
	],
	
	autoRefreshDelay: (300*1000),
	
	initComponent: function() {
		
		var pushModelfields=[], stepColumns = [], colorSet = [] ;
		Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getPriorityAll(), function(prio) {
			pushModelfields.push('prio_'+prio.priority_code) ;
			colorSet.push(prio.priority_color) ;
		}) ;
		
		var pushModelfieldsC=[], stepColumns = [], colorSetC = [] ;
		Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getCategoryAll(), function(cat) {
			pushModelfieldsC.push('cat_'+cat.category_code) ;
			colorSetC.push(cat.category_color) ;
		}) ;
		
		var pushModelfieldsNew = ['J2','J1','JBefore','Jworking'];
		var colorSetNew = ['#333f50','#8497b0','#5b9bd5','#00b050'];
		
		
	    var priorityMap = {} ;
	    Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getPriorityAll(), function(prio) {
		    priorityMap[prio.priority_code] = prio ;
	    }) ;
	    var categoryMap = {} ;
	    Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getCategoryAll(), function(cat) {
		    categoryMap[cat.category_code] = cat ;
	    }) ;
		var peopleMap = {} ;
		Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getPeopleGroupAll(), function(row) {
			var mkey = 'group'+'|'+row.group_id ;
			peopleMap[mkey] = {
				people_type: 'group',
				people_type_txt: 'Group',
				people_id: row.group_id,
				people_txt: row.group_txt
			} ;
		});
		Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getPeopleUserAll(), function(row) {
			var mkey = 'user'+'|'+row.user_id ;
			peopleMap[mkey] = {
				people_type: 'user',
				people_type_txt: 'User',
				people_id: row.user_id,
				people_txt: row.user_name
			} ;
		});
		
		var closeMapTxt = {} ;
		Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getCloseAll(), function(row) {
			closeMapTxt[row.close_code] = row.close_txt ;
		});
		
		
		Ext.apply(this,{
			layout: 'border',
			tbar: [{
				padding: '0px 16px',
				xtype: 'box',
				html: '<b>Filters&nbsp;:</b>'
			},Ext.create('Optima5.Modules.Spec.DbsEzeer.CfgParamButton',{
				cfgParam_id: 'PEOPLE',
				icon: 'images/modules/admin-users-16.png',
				text: 'People',
				itemId: 'btnPeople',
				optimaModule: this.optimaModule,
				setValueSilent: function(value) {
					this.setValue(value,true) ;
				},
				listeners: {
					change: {
						fn: function(btn) {
							this.onViewSelect('status_scope') ;
						},
						scope: this
					},
					ready: {
						fn: function() {
							
						},
						scope: this
					}
				}
			}),'-',Ext.create('Optima5.Modules.Spec.DbsEzeer.CfgParamButton',{
				cfgParam_id: 'PRIORITY',
				icon: 'images/modules/crmbase-barschart-16.gif',
				text: 'Priorities',
				itemId: 'btnPriority',
				optimaModule: this.optimaModule,
				listeners: {
					change: {
						fn: function() {
							this.doLoad() ;
						},
						scope: this
					},
					ready: {
						fn: function() {
							
						},
						scope: this
					}
				}
			}),'-',Ext.create('Optima5.Modules.Spec.DbsEzeer.CfgParamButton',{
				cfgParam_id: 'CATEGORY',
				icon: 'images/op5img/ico_blocs_small.gif',
				text: 'Categories',
				itemId: 'btnCategory',
				optimaModule: this.optimaModule,
				listeners: {
					change: {
						fn: function() {
							this.doLoad() ;
						},
						scope: this
					},
					ready: {
						fn: function() {
							
						},
						scope: this
					}
				}
			}),'-',{
				itemId: 'tbViewmode',
				viewConfig: {forceFit: true},
				menu: {
					defaults: {
						handler:function(menuitem) {
							//console.log('ch view '+menuitem.itemId) ;
							this.onViewSelect( menuitem.itemId ) ;
						},
						scope:this
					},
					items: [{
						itemId: 'status_owned',
						text: 'Owned / Assigned',
						iconCls: 'op5-spec-dbsezeer-explorer-status-owned'
					},{
						itemId: 'status_scope',
						text: 'On scope',
						iconCls: 'op5-spec-dbsezeer-explorer-status-scope'
					},{
						itemId: 'search_dates',
						text: 'Opened at dates',
						iconCls: 'op5-spec-dbsezeer-explorer-status-dates'
					},{
						hidden: true,
						itemId: 'search_txt',
						text: 'Search :',
						iconCls: 'op5-spec-dbsezeer-explorer-status-search'
					}]
				}
			},{
				icon: 'images/op5img/ico_calendar_16.png',
				text: '&#160;',
				itemId: 'date-picker',
				menu: [{
					xtype: 'form',
					layout: 'anchor',
					bodyPadding: 5,
					bodyCls: 'ux-noframe-bg',
					defaults: {
						listeners: {
							change: function(field) {
								var form = field.up('form'),
									fieldDateStart = form.getForm().findField('date_start'),
									fieldDateEnd = form.getForm().findField('date_end') ;
								if( form._settingValues ) {
									return ;
								}
								if( fieldDateStart.isValid() && fieldDateEnd.isValid() ) {
									this.onDateSet(fieldDateStart.getValue(),fieldDateEnd.getValue()) ;
								}
							},
							scope: this
						}
					},
					items: [{
						margin: 5,
						xtype: 'datefield',
						name: 'date_start',
						format: 'Y-m-d',
						fieldLabel: 'Date start',
						labelWidth: 80,
					},{
						margin: 5,
						xtype: 'datefield',
						name: 'date_end',
						format: 'Y-m-d',
						fieldLabel: 'Date end',
						labelWidth: 80,
					}]
				}]
			},'-',{
				icon: 'images/op5img/ico_loupe_16.png',
				itemId: 'btnSearchIconBegin',
				handler: function() {
					this.onSearchBegin() ;
				},
				scope: this,
			},{
				icon: 'images/waitcircle.gif',
				itemId: 'btnSearchIconLoad'
			},{
				icon: 'images/op5img/ico_warning_16.gif',
				itemId: 'btnSearchIconDevelop',
				handler: function(btn) {
					this.openDeepSearchResults(btn._deepsearchData) ;
				},
				scope: this,
			},{
				hidden: true,
				xtype: 'textfield',
				itemId: 'btnSearch',
				width: 150,
				allowBlank:true,
				triggers: {
					clear: {
						cls: Ext.baseCSSPrefix + 'form-clear-trigger',
						handler: function(field) {
							if( Ext.isEmpty(field.getValue()) ) {
								this.setInitialView();
							} else {
								field.reset() ;
							}
						},
						scope: this,
					}
				},
				enableKeyEvents: true,
				listeners: {
					change: {
						fn: function(field) {
							this.onSearchChange() ;
						},
						scope: this,
						buffer: 500
					},
					afterrender: function( field ) {
						var triggers = field.getTriggers() ;
						if( triggers.picker ) {
							triggers.picker.hide() ;
						}
					},
					scope: this
				}
			},{
				xtype: 'box',
				width: 16
			},'->',{
				icon: 'images/op5img/ico_reload_small.gif',
				text: 'Reload',
				handler: function() {
					this.doReload() ;
				},
				scope: this
			},{
				hidden: true,
				itemId: 'tbNotifications',
				icon: 'images/op5img/ico_warning_16.gif',
				//cls: 'op5-spec-rsiveo-button-red',
				_text: 'Notifications',
				text: 'Notifications'+'&nbsp;'+'<font color="red"><b>(3)</b></font>',
				menu: [],
				handler: function(){
					this.openNotifications() ;
				},
				scope: this
			}],
			
			items: [{
				region: 'north',
				xtype: 'container',
				layout: {
					type: 'hbox',
					align: 'stretch'
				},
				height: 125,
				style: 'background-color:#f5f5f5',
				items: [{
					xtype: 'component',
					itemId: 'cmpHeadCounts',
					//width: 450,
					padding: 0,
					tpl: [
						'<div style="display: inline-grid ; padding:8px 24px">',
						'<b>Open tickets</b>',
						'<div style="padding:8px ; width:120px ; height: 90px">',
							'<div style="border-radius: 10%; background: {count_color}; height:100% ; width:100% ; display:table">',
								'<div style="display:table-cell ; vertical-align: middle; text-align:center">',
									'<div style="color:white ; font-size:48px ; line-height:54px">{count_int}</div>',
								'</div>',
							'</div>',
						'</div>',
						'</div>',
						
						'<tpl if="late_int">',
						'<div style="display: inline-grid ; padding:8px 24px">',
						'<b>Late / Urgent</b>',
						'<div style="padding:8px ; width:96px ; height: 84px">',
							'<div style="border-radius: 10%; background: {late_color}; height:100% ; width:100% ; display:table">',
								'<div style="display:table-cell ; vertical-align: middle; text-align:center">',
									'<div style="color:white ; font-size:42px ; line-height:48px">{late_int}</div>',
								'</div>',
							'</div>',
						'</div>',
						'</div>',
						'</tpl>',
						
						'<tpl if="urgent_int">',
						'<div style="display: inline-grid ; padding:8px 24px">',
							'<div>',
							
							'<div style="display: inline-block">',
								'<div style="text-align:center">','<b>High priority</b>','</div>',
								'<div style="padding:8px ; width:84px ; height: 72px">',
									'<div style="border-radius: 10%; background: {urgent_color}; height:100% ; width:100% ; display:table">',
										'<div style="display:table-cell ; vertical-align: middle; text-align:center">',
											'<div style="color:white ; font-size:42px ; line-height:48px">{urgent_int}</div>',
										'</div>',
									'</div>',
								'</div>',
							'</div>',
							
							'<tpl if="urgent_int_unassigned">',
							'<div style="display: inline-block">',
								'<div style="text-align:center">','<i>unassigned</i>','</div>',
								'<div style="padding:8px ; width:84px ; height: 72px">',
									'<div style="border-radius: 10%; background: {urgent_color}; height:100% ; width:100% ; display:table">',
										'<div style="display:table-cell ; vertical-align: middle; text-align:center">',
											'<div style="color:white ; font-size:42px ; line-height:48px">{urgent_int_unassigned}</div>',
										'</div>',
									'</div>',
								'</div>',
							'</div>',
							'</tpl>',
							
							'</div>',
						'</div>',
						'</tpl>',
						
						'<div style="display: inline-grid ; width:16px">&nbsp;</div>',
						
						'<tpl if="lines">',
						'<div style="display: inline-grid ; padding:0px">',
						'<div style="display:table">',
						'<tpl for="lines">',
							'<div style="display:table-row">',
							'<div style="display:table-cell">',
							'<tpl for="line">',
								'<div style="display: inline-grid">',
								'<div style="border-radius: 10%; background: {color}; display:table ; padding:4px; margin:4px; min-width:75px">',
									'<div style="display:table-row">',
									'<div style="display:table-cell ; text-align:left">',
										'<div style="color:white ; font-size:12px">{caption}</div>',
									'</div>',
									'</div>',
									'<div style="display:table-row">',
									'<div style="display:table-cell ; text-align:center">',
										'<div style="color:white ; font-size:26px">{value}</div>',
									'</div>',
									'</div>',
								'</div>',
								'</div>',
							'</tpl>',
							'</div>',
							'</div>',
						'</tpl>',
						'</div>',
						'</div>',
						'</tpl>',
				
						
					],
					data: {
						count_int: 0,
						count_color: '#26c4dc',
						late_int: null,
						late_color: '#ffa037',
						assign_int: 0 || null,
						assign_color: '#ffc34a',
						urgent_color: '#ca2d30',
						urgent_int: null,
						urgent_int_unassigned: null,
					}
				},{
					xtype: 'box',
					width: 16
				},{
					width: 350,
					hidden: true,
					xtype: 'container',
					layout: {
						type: 'vbox',
						align: 'stretch'
					},
					items: [{
						height: 32,
						padding: 8,
						xtype: 'box',
						html: '<b>Priorities</b>',
					},{
						flex: 1,
						xtype:'container',
						layout: 'fit',
						//padding: '0 0 0 0',
						items: [{
							flex: 1,
							//padding: '20 0 20 0',
							xtype:'chart',
							itemId: 'chrtPriority',
							animate: true,
							shadow: true,
							store: {
								proxy: {
									type: 'memory',
									reader: {
										type:'json'
									}
								},
								fields: Ext.Array.merge(['dummy'], pushModelfields),
								data: []
							},
							axes: [{
								type: 'Numeric',
								position: 'bottom',
								fields: pushModelfields,
								title: false,
								grid: false,
								majorTickSteps: 5
							}],
							series: [{
								colorSet: colorSet,
								type: 'bar',
								axis: 'bottom',
								gutter: 80,
								xField: 'dummy',
								yField: pushModelfields,
								stacked: true,
								tips: {
									trackMouse: true,
									width: 60,
									height: 36,
									renderer: function(storeItem, item) {
										this.setTitle("<span style='float:left'>"+ item.yField + ' :</span><span style="float:right">' + String(item.value[1]) + ' tickets</span>');
									}
								},
								renderer: function(sprite, record, attributes, index, store) {
									index = index % this.colorSet.length ;
									Ext.apply(attributes,{
										fill: this.colorSet[index],
										stroke: this.colorSet[index]
									}) ;
									return attributes ;
								}
							}]
						}]
					}]
				},{
					xtype: 'box',
					width: 16
				},{
					width: 350,
					hidden: true,
					xtype: 'container',
					layout: {
						type: 'vbox',
						align: 'stretch'
					},
					items: [{
						height: 32,
						padding: 8,
						xtype: 'box',
						html: '<b>Categories</b>',
					},{
						flex: 1,
						xtype:'container',
						layout: 'fit',
						//padding: '0 0 0 0',
						items: [{
							flex: 1,
							//padding: '20 0 20 0',
							xtype:'chart',
							itemId: 'chrtCategory',
							animate: true,
							shadow: true,
							store: {
								proxy: {
									type: 'memory',
									reader: {
										type:'json'
									}
								},
								fields: Ext.Array.merge(['dummy'], pushModelfieldsC),
								data: []
							},
							axes: [{
								type: 'Numeric',
								position: 'bottom',
								fields: pushModelfieldsC,
								title: false,
								grid: false,
								majorTickSteps: 5
							}],
							series: [{
								colorSet: colorSetC,
								type: 'bar',
								axis: 'bottom',
								gutter: 80,
								xField: 'dummy',
								yField: pushModelfieldsC,
								stacked: true,
								tips: {
									trackMouse: true,
									width: 60,
									height: 36,
									renderer: function(storeItem, item) {
										this.setTitle("<span style='float:left'>"+ item.yField + ' :</span><span style="float:right">' + String(item.value[1]) + ' tickets</span>');
									}
								},
								renderer: function(sprite, record, attributes, index, store) {
									index = index % this.colorSet.length ;
									Ext.apply(attributes,{
										fill: this.colorSet[index],
										stroke: this.colorSet[index]
									}) ;
									return attributes ;
								}
							}]
						}]
					}]
				},{
					width: 350,
					hidden: false,
					xtype: 'container',
					layout: {
						type: 'vbox',
						align: 'stretch'
					},
					items: [{
						height: 32,
						padding: 8,
						xtype: 'box',
						html: '<b>Tickets non pris en charge</b>',
					},{
						flex: 1,
						xtype:'container',
						layout: 'fit',
						//padding: '0 0 0 0',
						items: [{
							flex: 1,
							//padding: '20 0 20 0',
							xtype:'chart',
							itemId: 'chrtNew',
							animate: true,
							shadow: true,
							store: {
								proxy: {
									type: 'memory',
									reader: {
										type:'json'
									}
								},
								fields: Ext.Array.merge(['dummy'], pushModelfieldsNew),
								data: []
							},
							axes: [{
								type: 'Numeric',
								position: 'bottom',
								fields: pushModelfieldsNew,
								title: false,
								grid: false,
								majorTickSteps: 5
							}],
							series: [{
								colorSet: colorSetNew,
								type: 'bar',
								axis: 'bottom',
								gutter: 80,
								xField: 'dummy',
								yField: pushModelfieldsNew,
								stacked: true,
								tips: {
									trackMouse: true,
									width: 60,
									height: 36,
									renderer: function(storeItem, item) {
										var fieldLib = '' ;
										switch( item.yField ) {
											case 'J2': fieldLib = '> J-1'; break ;
											case 'J1': fieldLib = 'J-1'; break ;
											case 'JBefore': fieldLib = 'J avant 8h'; break ;
											case 'Jworking': fieldLib = 'J horaires bureau'; break ;
										}
										this.setTitle("<span style='float:left'>"+ fieldLib + ' :</span><span style="float:right">' + String(item.value[1]) + ' tickets</span>');
									}
								},
								renderer: function(sprite, record, attributes, index, store) {
									index = index % this.colorSet.length ;
									Ext.apply(attributes,{
										fill: this.colorSet[index],
										stroke: this.colorSet[index]
									}) ;
									return attributes ;
								}
							}]
						}]
					}]
				},{
					xtype: 'box',
					flex:1
				}]
			},{
				itemId: 'pEast',
				region: 'east',
				width: 500,
				xtype: 'panel',
				split: true,
				closable: true,
				closeAction: 'hide',
				hidden: true,
				layout: 'fit',
				bodyCls: 'op5-spec-dbsezeer-ticketline-dv',
				//scrollable: 'vertical',
			},{
				region: 'center',
				flex: 1,
				xtype: 'grid',
				itemId: 'pGrid',
				
				_priorityMap: priorityMap,
				_categoryMap: categoryMap,
				_peopleMap: peopleMap,
				_closeMapTxt: closeMapTxt,
				
				columns: [{
					width: 32,
					//dataIndex: 'is_active',
					renderer: function(v,m,r) {
						if( r.get('closed_is_on') ) {
							m.tdCls += ' op5-spec-dbsezeer-grid-closed' ;
						} else if( r.get('status_is_new') ) {
							m.tdCls += ' op5-spec-dbsezeer-grid-new' ;
						} else if( r.get('notification_is_on') ) {
							m.tdCls += ' op5-spec-dbsezeer-explorer-cell-notification' ;
						} else if( r.get('login_is_owner_ext') ) {
							m.tdCls += ' op5-spec-dbsezeer-explorer-cell-ownerext' ;
						} else if( r.get('login_is_assign') ) {
							m.tdCls += ' op5-spec-dbsezeer-explorer-cell-assign' ;
						}
						return '&#160;' ;
					}
				},{
					text: 'Next review',
					align: 'center',
					width: 100,
					tdCls: 'op5-spec-dbsezeer-grid-badgecell',
					filter: {
						type: 'date',
					},
					dataIndex: 'date_review',
					renderer: function(v,metaData,r) {
						if( r.get('date_review_is_late') ) {
							metaData.style += 'color: white ; background: #ff0000' ;
						}
						if( Ext.isDate(v) ) {
							v = Ext.util.Format.date(v,'d/m/Y') ;
						}
						return v ;
					}
				},{
					width: 100,
					itemId: 'colPrio',
					text: 'Priority',
					align: 'center',
					dataIndex: 'prop_priority',
					tdCls: 'op5-spec-dbsezeer-grid-badgecell',
					renderer: function(v,metaData,r) {
						if( !this._priorityMap.hasOwnProperty(v) ) {
							return v ;
						}
						var prio = this._priorityMap[v] ;
						metaData.style += 'color: white ; background: '+prio.priority_color ;
						v = prio.priority_txt ;
						return v ;
					}
				},{
					text: 'Date due',
					align: 'center',
					width: 100,
					tdCls: 'op5-spec-dbsezeer-grid-badgecell',
					dataIndex: 'date_due',
					filter: {
						type: 'date',
					},
					renderer: function(v,metaData,r) {
						if( !v ) {
							return '' ;
						}
						
						var evalColor = '' ;
						var nbDaysBetween = Optima5.Modules.Spec.DbsEzeer.HelperCache.dateDiffInDays( new Date(), v ) ;
						if( nbDaysBetween <= 0 ) {
							evalColor = '#ff0000' ;
						} else if( nbDaysBetween <= 2 ) {
							evalColor = '#ffa200' ;
						}
						
						
						
						if( evalColor ) {
							metaData.style += 'color: white ; background: '+evalColor ;
						}
						if( Ext.isDate(v) ) {
							var vLocal = Ext.clone(v);
							var vDisplay = Ext.util.Format.date(vLocal,'d/m/Y') ;
							var dueTimeLeftMs = vLocal.getTime() - Date.now();
							if( dueTimeLeftMs>0 && dueTimeLeftMs<(24*60*60*1000) ) {
								if( vLocal.getHours()==0 && vLocal.getMinutes()==0 ) {
									vLocal.setMinutes(59);
									vLocal.setHours(23);
								}
								vDisplay = Ext.util.Format.date(vLocal,'H:i');
							}
						}
						return vDisplay ;
					}
				},{
					width: 165,
					itemId: 'colCat',
					text: 'Category',
					align: 'center',
					dataIndex: 'prop_category',
					tdCls: 'op5-spec-dbsezeer-grid-badgecell',
					renderer: function(v,metaData,r) {
						v = r.get('prop_category_main') ;
						if( !this._categoryMap.hasOwnProperty(v) ) {
							return v ;
						}
						if( !Ext.isEmpty(r.get('prop_category_lists')) && Ext.isObject(r.get('prop_category_lists')) ) {
							var backgroundColor = this._categoryMap[v]['category_color'];
							var widthPx = '50' ;
							if( Ext.Object.getKeys(r.get('prop_category_lists')).length <= 2 ) {
								widthPx = '75';
							}
							var divStyles = [] ;
							divStyles.push('display:inline-block');
							divStyles.push('border-radius:6px');
							divStyles.push('color:white');
							divStyles.push('font-size:11px');
							divStyles.push('margin: 0px 1px');
							divStyles.push('padding: 3px 6px');
							divStyles.push('width: '+widthPx+'px');
							divStyles.push('background-color:'+backgroundColor);
							var divStyle = '' ;
							Ext.Array.each(divStyles,function(s) {
								divStyle+= s+'; ';
							});
							
							var innerHtml = '' ;
							Ext.Object.each( r.get('prop_category_lists'), function(k,v) {
								if( Ext.isEmpty(v) ) {
									return ;
								}
								innerHtml+= '<div style="'+divStyle+'">'+v+'</div>';
							});
							
							metaData.tdCls += ' '+'op5-spec-dbsezeer-grid-innerbadge' ;
							return innerHtml ;
						}
						var prio = this._categoryMap[v] ;
						metaData.style += 'color: white ; font-style:italic ; background: '+prio.category_color ;
						v = prio.category_txt ;
						return v ;
					}
				},{
					text: 'Links',
					align: 'left',
					width: 150,
					dataIndex: 'prop_links',
					filter: {
						type: 'string',
					},
					renderer: function(v,metaData,r) {
						if( !Ext.isEmpty(v) ) {
							metaData.tdCls += ' op5-spec-dbsezeer-grid-iconcell op5-spec-dbsezeer-grid-iconcell-dbs' ;
						}
						var txt = [] ;
						Ext.Array.each(v,function(vrow) {
							if( !Ext.isEmpty(vrow.link_txt) ) {
								txt.push(vrow.link_txt) ;
							}
						}) ;
						return txt.join(' + ') ;
					}
				},{
					text: 'Owner',
					align: 'left',
					width: 150,
					dataIndex: 'prop_people_owner',
					renderer: function(v,metaData,r) {
						if( Ext.isEmpty(v) ) {
							return '&#160;' ;
						}
						metaData.tdCls += ' op5-spec-dbsezeer-grid-iconcell' ;
						switch( v.people_type ) {
							case 'group' :
								metaData.tdCls += ' op5-spec-dbsezeer-headertags-ico-group' ;
								break ;
							case 'user' :
								metaData.tdCls += ' op5-spec-dbsezeer-headertags-ico-user' ;
								break ;
						}
						switch( v.people_type ) {
							case 'group' :
							case 'user' :
								var mkey = v.people_type+'|'+v.people_id ;
								if( this._peopleMap[mkey] ) {
									v = this._peopleMap[mkey].people_txt ;
								} else {
									v = v.people_id ;
								}
								return v ;
							default :
								v = v.people_id ;
								return v ;
						}
						return v ;
					}
				},{
					text: 'Assignee',
					align: 'left',
					width: 150,
					//dataIndex: 'assign',
					renderer: function(v,metaData,r) {
						if( !r.get('assign_is_ext') ) {
							return '&#160;' ;
						}
						metaData.tdCls += ' op5-spec-dbsezeer-grid-iconcell' ;
						switch( r.get('assign_people_type') ) {
							case 'group' :
								metaData.tdCls += ' op5-spec-dbsezeer-headertags-ico-group' ;
								break ;
							case 'user' :
								metaData.tdCls += ' op5-spec-dbsezeer-headertags-ico-user' ;
								break ;
							case 'email' :
								metaData.tdCls += ' op5-spec-dbsezeer-headertags-ico-email' ;
								break ;
						}
						switch( r.get('assign_people_type') ) {
							case 'group' :
							case 'user' :
								var mkey = r.get('assign_people_type')+'|'+r.get('assign_people_id') ;
								if( this._peopleMap[mkey] ) {
									v = this._peopleMap[mkey].people_txt ;
								} else {
									v = r.get('assign_people_id') ;
								}
								return v ;
							default :
								v = r.get('assign_people_id') ;
								return v ;
						}
						return v ;
					}
				},{
					text: 'Ticket #',
					align: 'center',
					width: 70,
					dataIndex: 'ticket_filerecord_id',
					tdCls: 'op5-spec-dbsezeer-grid-bold'
				},{
					text: 'Ticket title',
					width: 300,
					dataIndex: 'prop_title',
					filter: {
						type: 'string',
					},
				},{
					text: 'From (email)',
					width: 200,
					dataIndex: 'spec_email_from',
					filter: {
						type: 'string',
					},
				},{
					text: 'Last action',
					align: 'center',
					width: 115,
					dataIndex: 'date_update',
					filter: {
						type: 'date',
					},
					renderer: function(v,metaData,r) {
						if( Ext.isDate(v) ) {
							v = Ext.util.Format.date(v,'d/m/Y H:i') ;
						}
						return v ;
					}
				},{
					text: 'Last people',
					align: 'left',
					width: 150,
					//dataIndex: 'assign',
					renderer: function(v,metaData,r) {
						metaData.tdCls += ' op5-spec-dbsezeer-grid-iconcell' ;
						switch( r.get('lastaction_people_type') ) {
							case 'group' :
								metaData.tdCls += ' op5-spec-dbsezeer-headertags-ico-group' ;
								break ;
							case 'user' :
								metaData.tdCls += ' op5-spec-dbsezeer-headertags-ico-user' ;
								break ;
							case 'email' :
								metaData.tdCls += ' op5-spec-dbsezeer-headertags-ico-email' ;
								break ;
						}
						switch( r.get('lastaction_people_type') ) {
							case 'group' :
							case 'user' :
								var mkey = r.get('lastaction_people_type')+'|'+r.get('lastaction_people_id') ;
								if( this._peopleMap[mkey] ) {
									v = this._peopleMap[mkey].people_txt ;
								} else {
									v = r.get('lastaction_people_id') ;
								}
								return v ;
							default :
								v = r.get('lastaction_people_id') ;
								return v ;
						}
						return v ;
					}
				},{
					itemId: 'colClosed',
					text: 'Closed tickets',
					columns: [{
						width: 115,
						tdCls: 'op5-spec-dbsezeer-grid-badgecell',
						text: 'Close date',
						align: 'center',
						dataIndex: 'closed_date',
						filter: {
							type: 'date',
						},
						renderer: function(v,metaData,r) {
							if( r.get('closed_is_on') ) {
								metaData.style += 'color: white ; background: #777777' ;
							}
							if( Ext.isDate(v) ) {
								v = Ext.util.Format.date(v,'d/m/Y H:i') ;
							}
							return v ;
						}
					},{
						width: 150,
						tdCls: 'op5-spec-dbsezeer-grid-badgecell',
						text: 'Close reason',
						align: 'center',
						dataIndex: 'closed_code',
						renderer: function(v,metaData,r) {
							if( r.get('closed_is_on') && !Ext.isEmpty(v) ) {
								metaData.style += 'color: white ; background: #777777' ;
							}
							if( !this._closeMapTxt.hasOwnProperty(v) ) {
								return v ;
							}
							v = this._closeMapTxt[v] ;
							return v ;
						}
					}]
				}],
				plugins: [{
					ptype: 'uxgridfilters'
				}],
				store: {
					model: 'DbsEzeerTicketModel',
					autoLoad: false,
					proxy: this.optimaModule.getConfiguredAjaxProxy({
						extraParams : {
							_moduleId: 'spec_dbs_ezeer',
							_action: 'ticket_getList'
						},
						reader: {
							type: 'json',
							rootProperty: 'data'
						}
					}),
					sorters: [{
						property: 'date_review',
						direction: 'ASC'
					}],
					listeners: {
						beforeload: this.onGridBeforeLoad,
						load: this.onGridLoad,
						scope: this
					}
				},
				listeners: {
					itemcontextmenu: this.onItemContextMenu,
					itemdblclick: function(grid,record) {
						this.fireEvent('op5ezeerticketopen',this,record.get('ticket_filerecord_id')) ;
					},
					scope: this
				},
				selModel: {
					mode: 'MULTI',
					listeners: {
						selectionchange: function(s,records) {
							if( records && records.length==1 ) {
								if( records[0].get('status_is_new') ) {
									this.installPreview( records[0].get('ticket_filerecord_id') ) ;
								} else {
									var previewMode = true;
									this.installPreview( records[0].get('ticket_filerecord_id'), previewMode ) ;
								}
							} else {
								this.installPreview(null) ;
							}
						},
						scope: this,
					},
				},
				variableRowHeight: true,
				viewConfig: {
					enableTextSelection: true,
					getRowClass: function(r) {
						if( r.get('is_active') ) {
							//return 'op5-spec-rsiveo-pom' ;
						}
					}
				},
			}]
		});
		this.callParent() ;
		this.mon(this.optimaModule,'op5broadcast',this.onCrmeventBroadcast,this) ;
		
		// Create grid ?
		if( this.autoRefreshTask ) {
			this.autoRefreshTask.cancel() ;
		}
		this.autoRefreshTask = new Ext.util.DelayedTask( function(){
			if( this.isDestroyed ) { // private check
				return ;
			}
			this.doLoadOnTimer() ;
		},this);
		
		this._filterOwned = new Ext.util.Filter({
			filterFn: function(record) {
				if( record.get('login_is_owner') || record.get('login_is_assign') ) {
					return true ;
				}
				return false ;
			}
		});
		
		this.doConfigure() ;
	},
	
	doConfigure: function() {
		this.setInitialView();
	},
	setInitialView: function() {
		if( Optima5.Modules.Spec.DbsEzeer.HelperCache.authHelperGetUserId() ) {
			this.onViewSelect('status_owned') ;
		} else {
			this.onViewSelect('status_scope') ;
		}
	},
	onViewSelect: function(viewId,dontLoad=false) {
		if( viewId=='status_owned' ) {
			if( Optima5.Modules.Spec.DbsEzeer.HelperCache.authHelperGetUserId() ) {
				var userId = Optima5.Modules.Spec.DbsEzeer.HelperCache.authHelperGetUserId() ;
				this.down('#btnPeople').setValueSilent('user'+'|'+userId) ;
			} else {
				viewId = 'status_scope' ;
			}
		}
		
		var tbViewmode = this.down('#tbViewmode') ;
		if( viewId==null && tbViewmode.tbViewmodeItemId ) {
			viewId = tbViewmode.tbViewmodeItemId ;
		}
		var tbViewmode = this.down('#tbViewmode'),
			tbViewmodeItem = tbViewmode.menu.getComponent(viewId),
			iconCls, text ;
		if( !tbViewmodeItem ) {
			return ;
		}
		tbViewmode.tbViewmodeItemId = viewId ;
		// View mode
		var tbViewmodeItem = tbViewmode.menu.getComponent(viewId) ;
		if( tbViewmodeItem ) {
			var txt = '<b>' + tbViewmodeItem.text + '</b>' ;
			tbViewmode.setText( txt );
			tbViewmode.setIconCls( tbViewmodeItem.iconCls );
		}
		
		this.down('toolbar').down('#btnSearchIconBegin').setVisible(viewId!='search_txt') ;
		this.down('toolbar').down('#btnSearchIconLoad').setVisible(false) ;
		this.down('toolbar').down('#btnSearchIconDevelop').setVisible(false) ;
		this.down('toolbar').down('#btnSearch').setVisible(viewId=='search_txt') ;
		this.down('toolbar').down('#date-picker').setVisible( viewId=='search_dates' ) ;
		if( dontLoad ) {
			return ;
		}
		if( viewId=='search_dates' ) {
			var dateStart = new Date() ;
			var dateEnd = new Date() ;
			dateStart.setMonth( dateStart.getMonth() - 1 ) ;
			
			this.onDateSet(dateStart,dateEnd) ;
		} else {
			this.doLoad() ;
		}
	},
	onDateSet: function( dateStart, dateEnd ) {
		//this.doSearchResetSilent() ;
		
		var dateStartObj = new Date(dateStart.toDateString()),
			dateEndObj = new Date(dateEnd.toDateString());
		var datesForm = this.down('toolbar').down('#date-picker').menu.down('form') ;
		datesForm._settingValues = true ;
		datesForm.getForm().setValues({
			date_start: dateStartObj,
			date_end: dateEndObj,
		});
		datesForm._settingValues = false ;
		this.down('toolbar').down('#date-picker').setText('<b>'+Ext.Date.format(dateStartObj,'d/m/Y')+'</b>'+'&nbsp;<b>></b>&nbsp;'+'<b>'+Ext.Date.format(dateEndObj,'d/m/Y')+'</b>') ;
		
		this.doLoad() ;
	},
	
	onCrmeventBroadcast: function(crmEvent, eventParams) {
		switch( crmEvent ) {
			case 'maybenotificationschange' :
				this.doLoadNotifications() ;
				break ;
			case 'datachange' :
				this.onDataChange() ;
				break ;
			default: break ;
		}
	},
	onDataChange: function() {
		if( this.isVisible() ) {
			this.doReload() ;
		} else {
			this.on('activate',function(){this.onDataChange();}, this, {single:true}) ;
		}
	},
	
	onSearchBegin: function() {
		this.onViewSelect('search_txt',true) ;
		this.down('#btnSearch')._searchBegin = true ;
		this.down('#btnSearch').setVisible(true) ;
		this.down('#btnSearch').reset() ;
		this.down('#btnSearch').focus() ;
		this.down('#btnSearch')._searchBegin = false ;
	},
	onSearchChange: function() {
		this.down('toolbar').down('#btnSearchIconBegin').setVisible(false);
		this.down('toolbar').down('#btnSearchIconLoad').setVisible(false);
		this.down('toolbar').down('#btnSearchIconDevelop').setVisible(false);
		
		var btnSearch = this.down('#btnSearch') ;
		var btnSearchTxt = btnSearch.getValue().toLowerCase().trim() ;
		if( btnSearch._searchBegin ) {
			return ;
		}
		
		var gridPanel = this.getGridPanel() ;
		if( !gridPanel ) {
			return ;
		}
		var gridStore = gridPanel.getStore() ;
		
		if( Ext.isEmpty(btnSearchTxt) || !Ext.isString(btnSearchTxt) ) {
			gridStore.removeAll() ;
			return ;
		}
		if( btnSearchTxt[0]=='#' ) {
			
		} else if( btnSearchTxt.length<3 ) {
			gridStore.removeAll() ;
			return ;
		}
		
		
		this.doLoad() ;
		if( btnSearchTxt[0]=='#' ) {
			return ;
		}
		this.down('toolbar').down('#btnSearchIconLoad').setVisible(true);
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_ezeer',
				_action: 'ticket_searchDeep',
				search_txt: btnSearchTxt,
			},
			success: function(response) {
				var ajaxData = Ext.decode(response.responseText) ;
				if( ajaxData.success == false ) {
					return ;
				}
				this.onSearchDeepResult(ajaxData.data) ;
			},
			callback: function() {
				this.down('toolbar').down('#btnSearchIconLoad').setVisible(false);
			},
			scope: this
		});
	},
	onSearchDeepResult: function(deepsearchData) {
		this.down('toolbar').down('#btnSearchIconDevelop')._deepsearchData = deepsearchData ;
		this.down('toolbar').down('#btnSearchIconDevelop').setVisible(true);
	},
	onSearchChangeLocal: function() {
		var btnSearch = this.down('#btnSearch') ;
		var btnSearchTxt = btnSearch.getValue().toLowerCase() ;
		
		var gridPanel = this.getGridPanel() ;
		if( !gridPanel ) {
			return ;
		}
		if( gridPanel.filters ) {
			gridPanel.filters.clearFilters() ;
		}
		var gridStore = gridPanel.getStore() ;
		gridStore.clearFilter() ;
		
		
		if( Ext.isEmpty(btnSearchTxt) || !Ext.isString(btnSearchTxt) ) {
			return ;
		}
		
		// visible fields if the grid header
		var visibleDataIndexes = [] ;
		Ext.Array.each( gridPanel.getVisibleColumns(), function( gridCol ) {
			if( !Ext.isEmpty(gridCol.dataIndex) ) {
				visibleDataIndexes.push( gridCol.dataIndex ) ;
			}
		}) ;
		
		if( btnSearchTxt.charAt(0) == '#' ) {
			var ticketId = btnSearchTxt.substring(1) ;
			gridStore.filter([{
				property: 'ticket_filerecord_id',
				operator: '=',
				value: ticketId
			}]);
			return ;
		}
		
		// do filtering with a custom function
		gridStore.filterBy( function(record) {
			// For each record, iterate over the FIELDS, and for each field "string compare" to btnSearchTxt
			var isItAMatchIdx = [] ;
			Ext.Array.each( btnSearchTxt.split(' '), function(btnSearchWord,idx) {
				isItAMatchIdx[idx] = false ;
				Ext.Array.each( visibleDataIndexes, function( dataIndex ) {
					var recordFieldValue = record.get(dataIndex) ;
					if( !Ext.isString(recordFieldValue) ) {
						return ;
					}
					if( recordFieldValue.toLowerCase().indexOf(btnSearchWord) != -1 ) {
						isItAMatchIdx[idx] = true ;
					}
				}) ;
			}) ;
			var isItAMatch = true ;
			Ext.Array.each( isItAMatchIdx,function(torf) {
				if(!torf) {
					isItAMatch = false ;
				}
			}) ;
			return isItAMatch ;
		}) ;
	},
	
	onItemContextMenu: function(view, record, item, index, e) {
		var gridContextMenuItems = new Array() ;
		
		var selRecords = view.getSelectionModel().getSelection(),
			selRecord = null ;
		if( selRecords.length==1 ) {
			selRecord = selRecords[0] ;
		}
		//console.dir(selRecords) ;
		var arrNewTicketFilerecordIds = [], hasNewOnly=true, hasOpenOnly=true ;
		Ext.Array.each( selRecords, function(r) {
			if( !r.get('status_is_new') ) {
				hasNewOnly = false ;
			}
			if( r.get('status_is_new') ) {
				hasOpenOnly = false ;
			}
			arrNewTicketFilerecordIds.push(r.get('ticket_filerecord_id')) ;
		},this);
		if( selRecord ) {
			gridContextMenuItems.push({
				icon: 'images/op5img/ico_editsupp_small.gif',
				text: 'Open ticket # '+selRecord.get('ticket_filerecord_id'),
				handler : function() {
					this.fireEvent('op5ezeerticketopen',this,selRecord.get('ticket_filerecord_id')) ;
				},
				scope : this
			});
		}
		if( hasOpenOnly && !Ext.isEmpty(arrNewTicketFilerecordIds) ) {
			gridContextMenuItems.push({
				icon: 'images/op5img/ico_lock_small.gif',
				text: 'Close '+'<b>'+arrNewTicketFilerecordIds.length+'</b>'+' ticket(s)',
				handler : function() {
					this.openRelocatePopup(arrNewTicketFilerecordIds,'close') ;
				},
				scope : this
			});
		}
		if( hasNewOnly && !Ext.isEmpty(arrNewTicketFilerecordIds) ) {
			gridContextMenuItems.push({
				icon: 'images/op5img/ico_arrow-double_16.png',
				text: 'Pre-actions to new ('+'<b>'+arrNewTicketFilerecordIds.length+'</b>'+')',
				handler : function() {
					this.openRelocatePopup(arrNewTicketFilerecordIds,'preactions') ;
				},
				scope : this
			});
			gridContextMenuItems.push({
				icon: 'images/op5img/ico_lock_small.gif',
				text: 'Discard / close ('+'<b>'+arrNewTicketFilerecordIds.length+'</b>'+')',
				handler : function() {
					this.openRelocatePopup(arrNewTicketFilerecordIds,'close') ;
				},
				scope : this
			});
			gridContextMenuItems.push({
				icon: 'images/modules/dbsezeer-attachment-16.png',
				text: 'Link to ticket ('+'<b>'+arrNewTicketFilerecordIds.length+'</b>'+')',
				handler : function() {
					this.openRelocatePopup(arrNewTicketFilerecordIds,'link') ;
				},
				scope : this
			});
		}
		
		if( Ext.isEmpty(gridContextMenuItems) ) {
			return ;
		}
		
		var gridContextMenu = Ext.create('Ext.menu.Menu',{
			items : gridContextMenuItems,
			listeners: {
				hide: function(menu) {
					Ext.defer(function(){menu.destroy();},10) ;
				}
			}
		}) ;
		gridContextMenu.showAt(e.getXY());
	},
	
	
	getGridPanel: function() {
		return this.down('#pGrid') ;
	},
	doLoadOnTimer: function() {
		if( this.autoRefreshTask != null ) {
			this.autoRefreshTask.cancel() ;
		}
		if( this.isVisible() ) {
			this.doLoad() ;
		} else {
			this.on('activate',this.doLoadOnTimer, this, {single:true}) ;
		}
	},
	doLoad: function() {
		if( this.autoRefreshTask != null ) {
			this.autoRefreshTask.cancel() ;
		}
		
		var storeProxy = this.getGridPanel().getStore().getProxy() ;
		if( storeProxy && storeProxy.pendingOperations ) {
			Ext.Object.each( storeProxy.pendingOperations, function(k,op) {
				op.abort() ;
			});
		}
		this.getGridPanel().getStore().load() ;
		this.doLoadNotifications();
		this.doLoadHeaderData();
	},
	doReload: function() {
		this.doLoad() ;
	},
	
	onGridBeforeLoad: function(store,options) {
		if( this.deepsearchPanel ) {
			this.deepsearchPanel.destroy();
		}

		if( this.getGridPanel().getEl() ) {
			this.getGridPanel().getEl().unmask() ;
		}
			
		var viewMode = this.down('#tbViewmode').tbViewmodeItemId;
		
		var params = options.getParams() || {} ;
		var postfilter_data = {}, val ;
		if( val = this.down('#btnPeople').getValue() ) {
			postfilter_data['people'] = val ;
		}
		if( val = this.down('#btnPriority').getValue() ) {
			postfilter_data['priority'] = val ;
		}
		if( val = this.down('#btnCategory').getValue() ) {
			var ttmp = val.split('|');
			var categoryValue = ttmp[0] ;
			postfilter_data['category'] = categoryValue ;
			if( ttmp[1] ) {
				var ttmpSub = ttmp[1].split('=');
				postfilter_data['category_lists'] = {} ;
				postfilter_data['category_lists'][ttmpSub[0]] = ttmpSub[1] || '*' ;
			}
		}
		switch( viewMode ) {
			case 'search_dates' :
				var formPanel = this.down('toolbar').down('#date-picker').menu.down('form')
				var dateStart = formPanel.getForm().findField('date_start').getRawValue(),
					dateEnd = formPanel.getForm().findField('date_end').getRawValue() ;
				postfilter_data['search_dates'] = {
					date_start: dateStart,
					date_end: dateEnd,
				};
				break ;
			
			case 'search_txt' :
				var searchTxt = this.down('#btnSearch').getValue().toLowerCase().trim() ;
				// if( searchTxt[0]=='#' ) {
				// 	postfilter_data['filter_ticketFilerecordId'] = searchTxt.substring(1) ;
				// } else {
				// 	postfilter_data['search_txt'] = searchTxt ;
				// }
				postfilter_data['search_txt'] = searchTxt ;
				break ;
		}
		if( !Ext.isEmpty(postfilter_data) ) {
			params.postfilter_data = Ext.JSON.encode(postfilter_data) ;
		}
		options.setParams(params) ;
	},
	onGridLoad: function(store,records,success) {
		if( !success ) {
			if( this.getGridPanel().getEl() ) {
				this.getGridPanel().getEl().mask('Maximum reached ?') ;
			}
			store.removeAll() ;
			//Ext.Msg.alert('Loading failed', 'Maximum reached ?');
		}
		
		store.removeFilter(this._filterOwned) ;
		
		// date NOW
		var dNow = new Date();
		
		// calc stats
		var hasClosed = false ;
		var updateData = {
			'count_int': 0,
			'late_int': null,
			'assign_int': null
		};
		var chartPriority = {},
			chartCategory = {},
			chartOrigin = {},
			chartNew = {};
		Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getPriorityAll(), function(prio) {
			var prioKey = 'prio_'+prio.priority_code ;
			chartPriority[prioKey] = 0 ;
		}) ;
		Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getCategoryAll(), function(cat) {
			var catKey = 'cat_'+cat.category_code ;
			chartCategory[catKey] = 0 ;
		}) ;
		Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getOriginAll(), function(orig) {
			var origKey = 'orig_'+orig.origin_code ;
			chartOrigin[origKey] = 0 ;
		}) ;
		chartNew = {
			'J2': 0,
			'J1': 0,
			'JBefore': 0,
			'Jworking': 0,
		};
		Ext.Array.each( records, function(rec) {
			if( rec.get('closed_is_on') ) {
				hasClosed = true ;
				return ;
			}
			if( !rec.get('closed_is_on') ) {
				updateData['count_int']++ ;
			}
			if( rec.get('date_review_is_late') ) {
				if( !updateData['late_int'] ) {
					updateData['late_int'] = 0 ;
				}
				updateData['late_int']++ ;
			}
			
			if( rec.get('status_is_new') ) {
				var hours = Math.abs(dNow - rec.get('date_create')) / 36e5;
				var dTicket = rec.get('date_create');
				var utc1 = Date.UTC(dTicket.getFullYear(), dTicket.getMonth(), dTicket.getDate());
				var utc2 = Date.UTC(dNow.getFullYear(), dNow.getMonth(), dNow.getDate());
				var days = Math.floor((utc2 - utc1) / (1000*60*60*24));
				
				if( days > 1 ) {
					chartNew['J2']++;
				} else if ( days>=1 ) {
					chartNew['J1']++;
				} else if( dTicket.getHours() < 8 ) {
					chartNew['JBefore']++;
				} else {
					chartNew['Jworking']++;
				}
			}
			
			var prioKey = 'prio_'+rec.get('prop_priority') ;
			if( chartPriority.hasOwnProperty(prioKey) ) {
				chartPriority[prioKey]++ ;
			}
			
			var catKey = 'cat_'+rec.get('prop_category_main') ;
			if( chartCategory.hasOwnProperty(catKey) ) {
				chartCategory[catKey]++ ;
			}
			
			var origKey = 'orig_'+rec.get('prop_origin') ;
			if( chartOrigin.hasOwnProperty(origKey) ) {
				chartOrigin[origKey]++ ;
			}
		}) ;
		
		var linePriority = [] ;
		Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getPriorityAll(), function(prio) {
			var prioKey = 'prio_'+prio.priority_code ;
			linePriority.push({
				color: prio.priority_color,
				caption: prio.priority_txt,
				value: chartPriority[prioKey],
			});
		}) ;
		var lineOrigin = [] ;
		Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getOriginAll(), function(orig) {
			var origKey = 'orig_'+orig.origin_code ;
			lineOrigin.push({
				color: '#4472c4',
				caption: orig.origin_txt,
				value: chartOrigin[origKey],
			});
		}) ;
		updateData['lines'] = [
			{line: linePriority},
			{line: lineOrigin},
		];
		
		var cmpHeadCounts = this.down('#cmpHeadCounts'),
			data = cmpHeadCounts.getData() ;
		Ext.apply(data,updateData) ;
		cmpHeadCounts.update(data) ;
		
		//this.down('#chrtPriority').getStore().loadData([chartPriority]) ;
		//this.down('#chrtCategory').getStore().loadData([chartCategory]) ;
		this.down('#chrtNew').getStore().loadData([chartNew]) ;
		
		var gridpanel = this.getGridPanel() ;
		gridpanel.headerCt.down('#colClosed').setVisible(hasClosed) ;
		
		// apply view filter
		var viewId = this.down('#tbViewmode').tbViewmodeItemId ;
		if( viewId=='status_owned' ) {
			store.filter(this._filterOwned) ;
		}
		
		this.autoRefreshTask.delay( this.autoRefreshDelay ) ;
	},
	
	
	
	
	doLoadNotifications: function() {
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_ezeer',
				_action: 'ticket_getListNotifications',
				//ticket_filerecord_ids: this._ticketFilerecordId || 0,
			},
			success: function(response) {
				var ajaxData = Ext.decode(response.responseText) ;
				if( ajaxData.success == false ) {
					Ext.Msg.alert('Failed', 'Unknown error');
					return ;
				}
				this._notificationsData = ajaxData.data ;
				this.afterLoadNotifications() ;
			},
			callback: function() {
			},
			scope: this
		});
	},
	afterLoadNotifications: function() {
		var tbNotifications = this.down('#tbNotifications') ;
		if( !this._notificationsData || this._notificationsData.length==0 ) {
			tbNotifications.setVisible(false) ;
			if( this.notificationsPanel ) {
				this.notificationsPanel.destroy() ;
				this.notificationsPanel = null ;
			}
			return ;
		}
		var txt = tbNotifications._text + '&nbsp;'+'<font color="red"><b>('+this._notificationsData.length+')</b></font>' ;
		tbNotifications.setText(txt) ;
		tbNotifications.setVisible(true) ;
		
		if( this.notificationsPanel_isClosed ) {
			return ;
		}
		if( this.isVisible() ) {
			this.openNotifications() ;
		} else {
			this.on('activate',function(){this.openNotifications();}, this, {single:true}) ;
		}
	},
	openNotifications: function() {
		var notificationsData = this._notificationsData ;
		if( this.notificationsPanel ) {
			this.notificationsPanel.getStore().loadData( notificationsData ) ;
			this.notificationsPanel.doResize() ;
			return ;
		}
		
		var notificationsPanel = Ext.create('Ext.grid.Panel',{
			optimaModule: this.optimaModule,
			
			title: 'Notifications',
			
			store: {
				model: 'DbsEzeerNotificationModel',
				data: [],
				sorters: [{
					property: 'notification_date',
					direction: 'DESC'
				}],
				proxy: {
					type: 'memory'
				}
			},
			columns: {
				defaults: {
					menuDisabled: true,
					draggable: false,
					sortable: false,
					hideable: false,
					resizable: true,
					groupable: false,
					lockable: false
				},
				items: [{
					width: 36,
					renderer: function(v,m,r) {
						m.tdCls += ' op5-spec-dbsezeer-explorer-cell-assignfull' ;
					}
				},{
					width: 95,
					text: 'Date',
					dataIndex: 'notification_date',
					sortable: true,
					renderer: function(v,m,r) {
						var txt = '' ;
						txt += '<div style="font-size: 10px; padding-left:6px">'+Ext.util.Format.date(r.get('notification_date'),'d/m H:i')+'</div>' ;
						return txt ;
					}
				},{
					text: 'Ticket #',
					align: 'center',
					width: 70,
					dataIndex: 'ticket_filerecord_id',
					tdCls: 'op5-spec-dbsezeer-grid-bold'
				},{
					flex: 1,
					text: 'Title',
					dataIndex: 'ticket_title',
					sortable: true,
					menuDisabled: false,
					renderer: function(v,m,r) {
						var txt = '<div>'+r.get('ticket_title')+'</div>' ;
						return txt ;
					}
				}]
			},
			//hideHeaders: true,
			listeners: {
				itemdblclick: function( view, record, itemNode, index, e ) {
					this.fireEvent('op5ezeerticketopen',this,record.get('ticket_filerecord_id')) ;
				},
				scope: this
			},
			
			frame: false,
			border: 1,
			
			width:510,
			height:100,
			floating: true,
			draggable: false,
			resizable: false,
			renderTo: this.getEl(),
			tools: [{
				type: 'close',
				handler: function(e, t, p) {
					if( p.ownerCt._parentCmp ) {
						p.ownerCt._parentCmp.notificationsPanel_isClosed = true ;
					}
					p.ownerCt.destroy() ;
				},
				scope: this
			}],
			_parentCmp: this,
			doResize: function() {
				var parentCmp = this._parentCmp ;
				if( !parentCmp.getEl() ) {
					return ;
				}
				var targetHeight = (parentCmp.getEl().getHeight() * 1) ;
				this.setHeight( targetHeight ) ;
				this.getEl().alignTo(parentCmp.getEl(), 'tl-br?')
			}
		});
		
		notificationsPanel.on('destroy',function(p) {
			this.notificationsPanel = null ;
		},this,{single:true}) ;
		
		notificationsPanel.show();
		notificationsPanel.doResize() ;
		this.notificationsPanel = notificationsPanel ;
		this.notificationsPanel_isClosed = false ;
		this.notificationsPanel.mon(this,'resize', function(p){
			p.notificationsPanel.doResize() ;
		},this);
		
		notificationsPanel.getStore().loadData(notificationsData) ;
	},
	
	
	doLoadHeaderData: function() {
		var params = {
			_moduleId: 'spec_dbs_ezeer',
			_action: 'ticket_getExplorerCounters',
		}
		var postfilter_data = {};
		if( val = this.down('#btnPeople').getValue() ) {
			postfilter_data['people'] = val ;
		}
		params['postfilter_data'] = Ext.JSON.encode(postfilter_data);
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: params,
			success: function(response) {
				var ajaxData = Ext.decode(response.responseText) ;
				if( ajaxData.success == false ) {
					return ;
				}
				this.onLoadHeaderData(ajaxData.data) ;
			},
			callback: function() {
			},
			scope: this
		});
		
		
	},
	onLoadHeaderData: function(updateData) {
		var cmpHeadCounts = this.down('#cmpHeadCounts'),
		data = cmpHeadCounts.getData() ;
		Ext.apply(data,updateData) ;
		cmpHeadCounts.update(data) ;
	},
	
	
	
	openDeepSearchResults: function(deepsearchData) {
		if( !deepsearchData && this.deepsearchPanel ) {
			this.deepsearchPanel.destroy() ;
		}
		if( this.deepsearchPanel ) {
			this.deepsearchPanel.getStore().loadData( deepsearchData ) ;
			this.deepsearchPanel.doResize() ;
			return ;
		}
		
		console.dir(deepsearchData) ;
		var deepsearchPanel = Ext.create('Ext.grid.Panel',{
			optimaModule: this.optimaModule,
			
			title: 'Search results',
			
			store: {
				fields: [
					{name: 'ticket_filerecord_id', type:'int'},
					{name: 'action_type', type:'string'},
					{name: 'action_date', type:'date', dateFormat:'Y-m-d H:i:s'},
					{name: 'match_txt', type:'string'},
				],
				data: [],
				sorters: [{
					property: 'action_date',
					direction: 'DESC'
				}],
				proxy: {
					type: 'memory'
				}
			},
			columns: {
				defaults: {
					menuDisabled: true,
					draggable: false,
					sortable: false,
					hideable: false,
					resizable: true,
					groupable: false,
					lockable: false
				},
				items: [{
					dataIndex: 'action_type',
					width: 36,
					renderer: function(v,m,r) {
						switch( v ) {
							case 'email_from' :
								m.tdCls += ' op5-spec-dbsezeer-explorer-cell-email' ;
								break ;
							case 'title' :
								m.tdCls += ' op5-spec-dbsezeer-explorer-cell-title' ;
								break ;
						}
					}
				},{
					width: 95,
					text: 'Date',
					dataIndex: 'action_date',
					sortable: true,
					renderer: function(v,m,r) {
						var txt = '' ;
						txt += '<div style="font-size: 10px; padding-left:6px">'+Ext.util.Format.date(r.get('action_date'),'d/m/Y')+'</div>' ;
						return txt ;
					}
				},{
					text: 'Ticket #',
					align: 'center',
					width: 70,
					dataIndex: 'ticket_filerecord_id',
					tdCls: 'op5-spec-dbsezeer-grid-bold'
				},{
					flex: 1,
					text: 'Title',
					dataIndex: 'match_txt',
					sortable: true,
					menuDisabled: false,
					renderer: function(v,m,r) {
						var txt = '<div>'+v+'</div>' ;
						return txt ;
					}
				}]
			},
			//hideHeaders: true,
			listeners: {
				itemdblclick: function( view, record, itemNode, index, e ) {
					this.fireEvent('op5ezeerticketopen',this,record.get('ticket_filerecord_id')) ;
					
					// HACK reload ?
					Ext.defer(function() {
						this.doLoadNotifications() ;
					},500,this) ;
				},
				scope: this
			},
			
			frame: false,
			border: 1,
			
			width:510,
			height:200,
			floating: true,
			draggable: false,
			resizable: false,
			renderTo: this.getEl(),
			tools: [{
				type: 'close',
				handler: function(e, t, p) {
					if( p.ownerCt._parentCmp ) {
						p.ownerCt._parentCmp.notificationsPanel_isClosed = true ;
					}
					p.ownerCt.destroy() ;
				},
				scope: this
			}],
			_parentCmp: this,
			doResize: function() {
				var parentCmp = this._parentCmp ;
				if( !parentCmp.getEl() ) {
					return ;
				}
				this.getEl().alignTo(parentCmp.getEl(), 'tc-tc?')
			}
		});
		
		deepsearchPanel.on('destroy',function(p) {
			this.deepsearchPanel = null ;
		},this,{single:true}) ;
		
		deepsearchPanel.show();
		deepsearchPanel.doResize() ;
		this.deepsearchPanel = deepsearchPanel ;
		this.deepsearchPanel_isClosed = false ;
		this.deepsearchPanel.mon(this,'resize', function(p){
			p.deepsearchPanel.doResize() ;
		},this);
		
		deepsearchPanel.getStore().loadData(deepsearchData) ;
	},
	
	
	
	openRelocatePopup: function(arrTicketFilerecordIds=[], ticketnew_action) {
		if( this.relocatePopup ) {
			this.relocatePopup.destroy() ;
		}
		
		var thisFields = [
			{name:'people_type', type:'string'},
			{name:'people_id', type:'string'},
			{name:'people_txt', type:'string'}
		] ;
		var comboboxData = [] ;
		Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getPeopleUserAll(), function(row) {
			comboboxData.push({
				people_type: 'user',
				people_type_txt: 'User',
				people_id: row.user_id,
				people_txt: row.user_name
			}) ;
		});
		
		
		
		var me = this ;
		var popupPanel = Ext.create('Ext.form.Panel',{
			optimaModule: this.optimaModule,
			
			width:400,
			height:370,
			
			cls: 'ux-noframe-bg',
			
			arrTicketFilerecordIds: arrTicketFilerecordIds,
			ticketnew_action: ticketnew_action,
			
			floating: true,
			renderTo: me.getEl(),
			tools: [{
				type: 'close',
				handler: function(e, t, p) {
					p.ownerCt.destroy();
				}
			}],
			
			xtype: 'form',
			border: false,
			bodyCls: 'ux-noframe-bg',
			bodyPadding: 8,
			layout:'anchor',
			fieldDefaults: {
				labelWidth: 100,
				anchor: '100%'
			},
			items:[{
				height: 72,
				xtype: 'component',
				tpl: [
					'<div class="op5-spec-embralam-liveadr-relocatebanner">',
						'<span>{text}</span>',
					'</div>'
				],
				data: {text: '<b>Pre-actions on new ticket(s)</b><br>To submit, check & select properties'}
			},{
				xtype: 'displayfield',
				anchor: '',
				width: 180,
				fieldLabel: 'Count tickets',
				value: '<b>'+arrTicketFilerecordIds.length+'</b>'
			},{
				itemId: 'cntOwner',
				hidden: true,
				xtype: 'fieldcontainer',
				layout: 'anchor',
				items: [{
					xtype: 'fieldset',
					title: 'Assign owner',
					items: [{
						xtype: 'combobox',
						forceSelection: false,
						editable: true,
						queryMode: 'local',
						valueField: 'people_txt',
						displayField: 'people_txt',
						store: {
							data: comboboxData,
							fields: thisFields
						},
						name: 'prop_people_owner',
						fieldLabel: 'Owner',
						matchFieldWidth: false,
						anyMatch: true,
						listConfig: {
							width: 250,
							getInnerTpl: function() {
								return '<div style="padding-bottom:6px">'
								+'<b>{people_type_txt}</b>'
								+'&nbsp;:&nbsp;'
								+'{people_txt}'
								+'</div>' ;
							}
						},
						setValue: function(v) {
							if( Ext.isObject(v) ) {
								var match = null ;
								this.getStore().each( function(r) {
									if( r.get('people_type')==v.people_type && r.get('people_id')==v.people_id ) {
										match = r;
										return false;
									}
								});
								if( match ) {
									this.setSelection(match);
								}
							}
						},
						getValue: function() {
							if( this.getSelection() ) {
								return this.getSelection().getData() ;
							}
							var ereg = /^\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/;
							if( ereg.test(this.getRawValue()) ) {
								//console.log('email valide !!');
								return {
									people_type: 'email',
									people_id: this.getRawValue(),
									people_txt: this.getRawValue()
								};
							}
							return null ;
						},
						getErrors: function() {
							if( !this.getValue() && (this.allowBlank===false) ) {
								return ["Invalid assignee"] ;
							}
							return [] ;
						},
						enableKeyEvents: true,
						listeners: {
							keydown: function(f) {
								f.setSelection(null) ;
							}
						}
					}]
				},{
					xtype: 'fieldset',
					title: 'Assign category',
					items: [Ext.create('Optima5.Modules.Spec.DbsEzeer.TicketPropCategoryField',{
						optimaModule: this.optimaModule,
						_layout: 'vbox',
						fieldLabel: 'Category',
						name : 'prop_category_code',
					})]
				},{
					xtype: 'fieldset',
					title: 'Assign origin',
					items:[{
						xtype: 'colorcombo',
						
						queryMode: 'local',
						forceSelection: true,
						editable: false,
						displayField: 'origin_txt',
						valueField: 'origin_code',
						iconColorField: 'origin_color',
						store: {
							fields: 'DbsEzeerCfgOriginModel',
							data : Optima5.Modules.Spec.DbsEzeer.HelperCache.getOriginAll()
						},
						
						fieldLabel: 'Origin',
						name : 'prop_origin_code',
					}]
				}]
			},{
				itemId: 'cntClose',
				hidden: true,
				xtype: 'fieldcontainer',
				fieldLabel: 'Category',
				layout: {
					type: 'vbox',
					align: 'stretch'
				},
				items: [{
					xtype: 'checkboxfield',
					name: 'close_category_is_on',
					boxLabel: 'Discard category ?',
					listeners: {
						change: function(chk,val) {
							chk.up('form').getForm().findField('close_category_code').setVisible(val) ;
							chk.up('form').getForm().findField('close_origin_code').setVisible(val) ;
							chk.up('form').down('#cntCloseFinal').setVisible(val) ;
						}
					},
				},Ext.create('Optima5.Modules.Spec.DbsEzeer.TicketPropCategoryField',{
					optimaModule: this.optimaModule,
					_layout: 'vbox',

					hidden:true,
					//flex:1,
					//width: 300,
					
					name : 'close_category_code',
					listeners: {
						change: function(field) {
							field.up('form').onChangeCloseParams() ;
						},
						scope: this
					}
				}),{
					xtype: 'colorcombo',
					hidden:true,
					queryMode: 'local',
					forceSelection: true,
					editable: false,
					displayField: 'origin_txt',
					valueField: 'origin_code',
					iconColorField: 'origin_color',
					store: {
						fields: 'DbsEzeerCfgOriginModel',
						data : Optima5.Modules.Spec.DbsEzeer.HelperCache.getOriginAll()
					},
					labelWidth: 60,
					fieldLabel: 'Origin',
					name : 'close_origin_code',
					listeners: {
						change: function(field) {
							field.up('form').onChangeCloseParams() ;
						},
						scope: this
					}
				},Ext.create('Optima5.Modules.Spec.DbsEzeer.TicketCloseReasonField',{
					optimaModule: this.optimaModule,
					name: 'close_code_final',
					
					xtype: 'fieldcontainer',
					itemId: 'cntCloseFinal',
					
					hidden: true,
				})]
			},{
				itemId: 'cntLink',
				xtype: 'combobox',
				hidden: true,
				name: 'link_ticketFilerecordId',
				labelAlign: 'top',
				fieldLabel: 'Link to ticket',
				forceSelection: true,
				editable: true,
				queryMode: 'remote',
				valueField: 'ticket_filerecord_id',
				displayField: 'txt',
				queryParam: 'filter',
				minChars: 3,
				triggerAction: 'query',
				store: {
					//autoLoad: true,
					fields: [
						{name: 'ticket_filerecord_id', type: 'int'},
						{name: 'ticket_title', type: 'string'},
						{name: 'txt', type: 'string', calculate: function(data){return '#'+data.ticket_filerecord_id+' / '+data.ticket_title ;}}
					],
					proxy: this.optimaModule.getConfiguredAjaxProxy({
						extraParams : {
							_moduleId: 'spec_dbs_ezeer',
							_action: 'search_ticket'
						},
						reader: {
							type: 'json',
							rootProperty: 'data'
						}
					})
				},
				listConfig: {
					getInnerTpl: function() {
						return '<div style="padding-bottom:6px">'
						+'<b>#{ticket_filerecord_id}</b>'
						+'&nbsp;:&nbsp;'
						+'{ticket_title}'
						+'</div>' ;
					}
				},
				matchFieldWidth: true,
				anyMatch: true
			}],
			doSetupLayout: function() {
				switch( this.ticketnew_action ) {
					case 'preactions' :
						this.down('#cntOwner').setVisible(true) ;
						break ;
					case 'close' :
						this.down('#cntClose').setVisible(true) ;
						break ;
					case 'link' :
						this.down('#cntLink').setVisible(true) ;
						break ;
					default :
						Ext.Msg.alert('Batch error', 'Undefined action');
						this.destroy() ;
						break ;
				}
			},
			buttons: [{
				xtype: 'button',
				text: 'Submit',
				handler:function(btn){ 
					var formPanel = btn.up('form') ;
					formPanel.doSubmitRelocate() ;
				},
				scope: this
			}],
			forcePropParams: function( props ) {
				var formPanel = this,
					form = formPanel.getForm();
				form.setValues({
					prop_people_owner: props.prop_people_owner,
					prop_category_code: {
						value: props.prop_category,
						lists: props.prop_category_lists,
					},
					prop_origin_code: props.prop_origin,
				});
			},
			forceCloseParams: function( prop_category, prop_origin, propCategoryLists={} ) {
				var formPanel = this,
					form = formPanel.getForm();
				form.findField('close_category_is_on').setValue(true) ;
				form.findField('close_category_is_on').setReadOnly(true) ;
				form.findField('close_category_code').setValue({
					value: prop_category,
					lists: propCategoryLists,
				}) ;
				form.findField('close_category_code').setReadOnly(true,true) ;
				form.findField('close_origin_code').setValue(prop_origin) ;
				form.findField('close_origin_code').setReadOnly(true) ;
				this.onChangeCloseParams() ;
			},
			onChangeCloseParams: function() {
				var formPanel = this ;
					form = formPanel.getForm(),
					formValues = form.getFieldValues();
				var cntCloseFinal = formPanel.down('#cntCloseFinal') ;
				cntCloseFinal.setFormValues({
					prop_category: formValues.close_category_code,
					prop_origin: formValues.close_origin_code,
				});
			},
			doSubmitRelocate: function() {
				var formPanel = this,
					form = formPanel.getForm(),
					formValues = form.getFieldValues() ;
					
				var relocateObj = {
					ticketnew_action: this.ticketnew_action,
					arrTicketFilerecordIds: this.arrTicketFilerecordIds,
				} ;
				switch( this.ticketnew_action ) {
					case 'preactions' :
						form.findField('prop_people_owner').allowBlank = true;
						form.findField('prop_category_code').down('#cmbProp').allowBlank = true;
						form.findField('prop_category_code').down('#cmbPropSub').allowBlank = true;
						form.findField('prop_origin_code').allowBlank = true;
						if( !form.isValid() ) {
							var error = 'Incomplete description' ;
							Ext.Msg.alert('Ticket Action', error);
							return ;
						}
						Ext.apply(relocateObj,{
							prop_people_owner: formValues.prop_people_owner,
							prop_category_code: formValues.prop_category_code.value,
							prop_category_lists: !Ext.isEmpty(formValues.prop_category_code.lists) ? formValues.prop_category_code.lists : null,
							prop_origin_code: formValues.prop_origin_code,
						}) ;
						break ;
					case 'close' :
						//HACK
						form.findField('close_category_code').down('#cmbProp').allowBlank = false;
						form.findField('close_category_code').down('#cmbPropSub').allowBlank = false;
						form.findField('close_code_final').down('#fInnerClose').allowBlank = false;
						if( !form.isValid() ) {
							var error = 'Incomplete description' ;
							Ext.Msg.alert('Ticket Action', error);
							return ;
						}
						Ext.apply(relocateObj,{
							close_category_is_on: formValues.close_category_is_on,
							close_category_code: Ext.isObject(formValues.close_category_code) ? formValues.close_category_code.value : null,
							close_category_lists: Ext.isObject(formValues.close_category_code) ? formValues.close_category_code.lists : null,
							close_origin_code: formValues.close_origin_code,
							close_code_final: formValues.close_code_final,
						}) ;
						break ;
					case 'link' :
						Ext.apply(relocateObj,{
							link_ticketFilerecordId: formValues.link_ticketFilerecordId
						}) ;
						break ;
				}
				
				this.optimaModule.getConfiguredAjaxConnection().request({
					params: {
						_moduleId: 'spec_dbs_ezeer',
						_action: 'ticket_postUpdateNew',
						form_data: Ext.JSON.encode(relocateObj)
					},
					success: function(response) {
						var jsonResponse = Ext.JSON.decode(response.responseText) ;
						this.onSubmitRelocate(jsonResponse) ;
					},
					callback: function() {
						//this.hideLoadmask() ;
					},
					scope: this
				});
			},
			onSubmitRelocate: function(ajaxResponse) {
				var formPanel = this,
					form = formPanel.getForm(),
					formValues = form.getValues() ;
											 
				if( ajaxResponse.success ) {
					this.optimaModule.postCrmEvent('datachange') ;
					this.destroy() ;
				}
			}
		});
		
		popupPanel.on('destroy',function() {
			me.getEl().unmask() ;
			me.relocatePopup = null ;
		},me,{single:true}) ;
		me.getEl().mask() ;
		
		popupPanel.show();
		popupPanel.getEl().alignTo(me.getEl(), 'c-c?');
		popupPanel.doSetupLayout() ;
		
		this.relocatePopup = popupPanel ;
		
		// NOTE : preset category + origin
		var arrTicketData = [] ;
		if( arrTicketFilerecordIds.length>0 ) {
			var store = this.getGridPanel().getStore() ;
			Ext.Array.each( arrTicketFilerecordIds, function(ticketFilerecordId) {
				var rec ;
				if( store && (rec=store.getById(ticketFilerecordId)) ) {
					if( rec ) {
						arrTicketData.push(rec.getData());
					}
				}
			});
		}
		
		if( ticketnew_action == 'preactions' ) {
			var singleProps = {
				prop_people_owner: [],
				prop_category: [],
				prop_category_lists: [],
				prop_origin: [],
			} ;
			Ext.Array.each(arrTicketData, function(d) {
				Ext.Array.each(arrTicketData, function(d) {
					if( !d.status_is_new ) {
						return ;
					}
					
					var propPeopleOwner = null;
					if( Ext.isObject(d['prop_people_owner']) ) {
						propPeopleOwner = {
							people_type: d['prop_people_owner']['people_type'],
							people_id: d['prop_people_owner']['people_id'],
						};
					}
					if( !Ext.Array.contains(singleProps['prop_people_owner'],Ext.JSON.encode(propPeopleOwner)) ) {
						singleProps['prop_people_owner'].push(Ext.JSON.encode(propPeopleOwner)) ;
					}
					
					if( !Ext.Array.contains(singleProps['prop_category'],d['prop_category']) ) {
						singleProps['prop_category'].push(d['prop_category']) ;
					}
					if( !Ext.Array.contains(singleProps['prop_category_lists'],Ext.JSON.encode(d['prop_category_lists'])) ) {
						singleProps['prop_category_lists'].push(Ext.JSON.encode(d['prop_category_lists'])) ;
					}
					
					if( !Ext.Array.contains(singleProps['prop_origin'],d['prop_origin']) ) {
						singleProps['prop_origin'].push(d['prop_origin']) ;
					}
				});
			});
			
			var singleProp = {} ;
			Ext.Object.each( singleProps, function(k,v) {
				if( v.length==1 && !Ext.isEmpty(v[0]) ) {} else {
					return ;
				}
				var uniqueV = v[0] ;
				switch( k ) {
					case 'prop_people_owner' :
					case 'prop_category_lists' :
						singleProp[k] = Ext.JSON.decode(uniqueV);
						break ;
					default :
						singleProp[k] = uniqueV;
						break ;
				}
			});
			popupPanel.forcePropParams( singleProp ) ;
		}
		if( ticketnew_action == 'close' ) {
			var singlePropHash = [] ;
			if( arrTicketData.length == arrTicketFilerecordIds.length ) {
				Ext.Array.each(arrTicketData, function(d) {
					if( d.status_is_new ) {
						return ;
					}
					if( Ext.isEmpty(d['prop_category']) || Ext.isEmpty(d['prop_origin']) ) {
						return ;
					}
					var propHash = [d['prop_category'],Ext.JSON.encode(d['prop_category_lists']),d['prop_origin']].join('\n');
					if( !Ext.Array.contains(singlePropHash,propHash) ) {
						singlePropHash.push(propHash) ;
					}
				});
			}
			if( singlePropHash.length > 1 ) {
				Ext.Msg.alert('Failed', 'Category/Origin mutiples', function(){popupPanel.destroy();});
			} else if( singlePropHash.length==1 ) {
				singlePropHash = singlePropHash[0] ;
				var prop_category = singlePropHash.split('\n')[0],
				prop_category_lists = Ext.JSON.decode(singlePropHash.split('\n')[1],true),
				prop_origin = singlePropHash.split('\n')[2] ;
				popupPanel.forceCloseParams( prop_category, prop_origin, prop_category_lists ) ;
			} else {
				// mode NEW
			}
		}
	},
	
	installPreview: function(ticketFilerecordId, previewMode=false) {
		var pEast = this.down('#pEast') ;
		pEast.removeAll() ;
		
		if( !ticketFilerecordId ) {
			pEast.hide();
			return ;
		}
		
		pEast.add({
			flex:1,
			xtype: 'component',
			cls:'op5-waiting',
		});
		pEast.setTitle('#'+ticketFilerecordId);
		pEast.show();
		
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_ezeer',
				_action: 'ticket_getRecord',
				ticket_filerecord_id: ticketFilerecordId,
				preview_mode: (previewMode ? 1 : 0),
			},
			success: function(response) {
				var ajaxData = Ext.decode(response.responseText) ;
				if( ajaxData.success == false ) {
					return ;
				}
				var ticketRecord = Ext.ux.dams.ModelManager.create('DbsEzeerTicketModel',ajaxData.data) ;
				var emailMessagePanel = Ext.create('Optima5.Modules.Spec.DbsEzeer.TicketLineView',{
					flex:1,
					_ticketFilerecordId: ticketFilerecordId,
					_ticketRecord: ticketRecord,
					
					optimaModule: this.optimaModule,
				}) ;
				pEast.setTitle('#'+ticketFilerecordId+'&nbsp;//&nbsp;'+ticketRecord.get('prop_title'));
				pEast.removeAll();
				pEast.add(emailMessagePanel) ;
			},
			callback: function() {
			},
			scope: this
		});
	},
	
	onDestroy: function() {
		if( this.autoRefreshTask ) {
			this.autoRefreshTask.cancel() ;
		}
		if( this.notificationsPanel ) {
			this.notificationsPanel.destroy() ;
		}
		if( this.relocatePopup ) {
			this.relocatePopup.destroy() ;
		}
		if( this.deepsearchPanel ) {
			this.deepsearchPanel.destroy() ;
		}
		
	}
}) ;
