Ext.define('Optima5.Modules.Spec.DbsTracy.AogForm',{
	extend: 'Ext.form.Panel',
	
	initComponent: function() {
		Ext.apply(this,{
			cls: 'ux-noframe-bg',
			bodyCls: 'ux-noframe-bg',
			xtype: 'form',
			layout: {
				type: 'vbox',
				align: 'stretch'
			},
			bodyPadding: 10,
			fieldDefaults: {
				anchor: '100%',
				labelWidth: 100
			},
			items: [{
				xtype: 'hiddenfield',
				name: 'order_filerecord_id',
			},{
				itemId: 'fsHeader',
				xtype: 'fieldset',
				title: 'DN header',
				cls: 'op5-spec-dbstracy-field-narrowline',
				defaults: {
					labelStyle: 'font-weight: bold;'
				},
				items: [Ext.create('Optima5.Modules.Spec.DbsTracy.CfgParamField',{
					cfgParam_id: 'SOC',
					cfgParam_emptyDisplayText: 'Select...',
					optimaModule: this.optimaModule,
					fieldLabel: 'BU',
					name: 'id_soc',
					allowBlank: false,
					anchor: '',
					width: 325,
					readOnly: true,
				}),{
					xtype: 'displayfield',
					name: 'id_dn',
					fieldLabel: 'DN/BL#',
				},{
					xtype: 'displayfield',
					name: 'ref_invoice',
					fieldLabel: 'Invoice #',
				},{
					xtype: 'displayfield',
					name: 'atr_consignee',
					fieldLabel: 'Consignee',
				},{
					xtype: 'displayfield',
					name: 'atr_incoterm',
					fieldLabel: 'Incoterm',
				},{
					xtype: 'radiogroup',
					//name: 'atr_incoterm_txt',
					fieldLabel: 'FCA MiMo/CDG',
					columns: 2,
					anchor: '',
					width: 250,
					vertical: false,
					items: [
							{ boxLabel: 'Mi-Mo', name: 'atr_incoterm_txt', inputValue: 'MIMO' },
							{ boxLabel: 'CDG', name: 'atr_incoterm_txt', inputValue: 'CDG'},
					]
				},{
					xtype: 'datetimefield',
					name: 'create_AOG_date',
					fieldLabel: 'AOG T=0 date',
				},{
					xtype: 'datetimefield',
					readOnly: true,
					name: 'create_END_date',
					fieldLabel: 'AOG T=end date',
				}]
			},{
				hidden: true,
				itemId: 'fsIod',
				xtype: 'fieldset',
				title: 'IOD Acknowledge',
				checkboxToggle: true,
				checkboxName: 'IOD_is_on',
				items: [{
					itemId: 'fIodDate',
					xtype: 'datetimefield',
					fieldLabel: 'IOD Date',
					name: 'IOD_date',
				}]
			},{
				hidden: true,
				itemId: 'fsAwb',
				xtype: 'fieldset',
				title: 'AWB Acknowledge',
				checkboxToggle: true,
				checkboxName: 'AWB_is_on',
				items: [{
					hidden: true,
					itemId: 'fAwbDate',
					xtype: 'datetimefield',
					fieldLabel: 'AWB Date',
					name: 'AWB_date',
				},{
					xtype: 'textfield',
					fieldLabel: 'AWB Reference',
					name: 'AWB_txt',
				}]
			}],
			buttons: [{
				xtype: 'button',
				text: 'Submit',
				handler:function(btn){
					this.handleSave() ;
					//this.destroy();
				},
				scope: this
			}]
		});
		this.callParent() ;
		if( this._orderFilerecordId ) {
			this.doLoadOrder(this._orderFilerecordId) ;
		} else if( this._isNew ) {
			// TODO
			this.setForNew(this._isNew_idSoc) ;
		}
	},
	
	setForNew: function(idSoc) {
		var fsHeader = this.down('#fsHeader') ;
		fsHeader.removeAll() ;
		fsHeader.add(Ext.create('Optima5.Modules.Spec.DbsTracy.CfgParamField',{
			cfgParam_id: 'SOC',
			cfgParam_emptyDisplayText: 'Select...',
			optimaModule: this.optimaModule,
			fieldLabel: 'BU',
			name: 'id_soc',
			allowBlank: false,
			readOnly: true,
		}),{
			xtype: 'textfield',
			fieldLabel: 'DN/BL#',
			name: 'id_dn',
			allowBlank: false,
		},{
			xtype: 'op5specdbstracycfgparamtext',
			cfgParam_id: 'LIST_INCOTERM',
			fieldLabel: 'Incoterm',
			anchor: '',
			width: 200,
			name: 'atr_incoterm'
		},{
			xtype: 'op5specdbstracycfgparamtext',
			cfgParam_id: 'LIST_CONSIGNEE',
			fieldLabel: 'Consignee',
			name: 'atr_consignee',
			allowBlank: false,
			forceSelection: true,
		});
		
		this.down('#fsIod').setVisible(false);
		this.down('#fsAwb').setVisible(false);
		
		this.getForm().setValues({
			id_soc: idSoc,
			IOD_is_on: false,
			AWB_is_on: false,
		});
	},
	
	doLoadOrder: function(orderFilerecordId) {
		this.fireTitle( null ) ;
		this.getForm().reset() ;
		this.getForm().setValues({
			IOD_is_on: false,
			AWB_is_on: false,
			
			atr_incoterm_txt: 'MIMO',
		});
		this.showLoadmask() ;
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'aogpanel_getList',
				filter_orderFilerecordId_arr: Ext.JSON.encode([orderFilerecordId]),
			},
			success: function(response) {
				var ajaxData = Ext.decode(response.responseText) ;
				if( ajaxData.success && (ajaxData.data.length == 1) ) {
					var orderRow = ajaxData.data[0] ;
					this.onLoadOrder(orderRow) ;
					return ;
				}
				this.destroy() ;
			},
			callback: function() {
				this.hideLoadmask() ;
			},
			scope: this
		});
	},
	onLoadOrder: function(orderRow) {
		this._orderFilerecordId = orderRow.order_filerecord_id ;
		this._orderRow = orderRow;
		this.fireTitle( 'IOD/AWB data #'+orderRow['id_dn'] ) ;
		
		var form = this.getForm() ;
		form.setValues(orderRow) ;
		if( orderRow.create_AOG_date ) {
			form.findField('create_AOG_date').setReadOnly(true) ;
		}
		if( orderRow.create_AOG_date && !orderRow.create_END_date ) {
			form.findField('create_END_date').setReadOnly(false) ;
		}
		
		var nextSteps = ( orderRow.IOD_is_visible ) ;
		this.down('#fsIod').setVisible(nextSteps);
		var nextSteps = ( orderRow.AWB_is_visible ) ;
		this.down('#fsAwb').setVisible(nextSteps);
		
		// 11/04/2024 : IOD read-only
		this.down('#fsIod').setVisible(orderRow.IOD_is_on) ;
		this.down('#fIodDate').setReadOnly(true) ;
		form.findField('IOD_is_on').setReadOnly(true) ;
		
		if( orderRow.AWB_is_on ) {
			//this.down('#fAwbDate').setReadOnly(true) ;
			//form.findField('AWB_txt').setReadOnly(true) ;
			//form.findField('AWB_is_on').setReadOnly(true) ;
		}
	},
	
	showLoadmask: function() {
		if( this.rendered ) {
			this.doShowLoadmask() ;
		} else {
			this.on('afterrender',this.doShowLoadmask,this,{single:true}) ;
		}
	},
	doShowLoadmask: function() {
		if( this.loadMask ) {
			return ;
		}
		this.loadMask = Ext.create('Ext.LoadMask',{
			target: this,
			msg:"Please wait..."
		}).show();
	},
	hideLoadmask: function() {
		this.un('afterrender',this.doShowLoadmask,this) ;
		if( this.loadMask ) {
			this.loadMask.destroy() ;
			this.loadMask = null ;
		}
	},
	
	preSaveGetMsg: function() {
		var form = this.getForm(),
			formValues = form.getFieldValues() ;
		
		var txt = null ;
		if( !this._orderRow['aog_is_on'] ) {
			if( this._orderRow['aog_is_status'] ) {
				txt = 'Renseignement du T=0.<br>L\'information est-elle correcte ?';
			} else {
				txt = 'Upgrade AOG !<br>Veuillez confirmer.';
			}
			return txt ;
		}
		
		if( formValues['atr_incoterm_txt'] == 'CDG' ) {
			if( !this._orderRow['create_END_date'] && formValues['create_END_date'] ) {
				txt = 'CDG (Tend=IOD).<br>L\'information sera transmise au client. Veuillez confirmer.';
				return txt ;
			}
		}
		
		if( !this._orderRow['AWB_is_on'] && formValues['AWB_is_on'] ) {
			txt = 'Renseignement AWB.<br>L\'information sera transmise au client. Veuillez confirmer.';
			return txt ;
		}
		
		return null ;
	},
	handleSave: function(confirmed=false) {
		var form = this.getForm(),
			formValues = form.getFieldValues() ;
		if( !formValues['create_AOG_date'] && !this._orderRow['create_AOG_date'] ) {
			Ext.Msg.alert('Erreur','Action AOG T=0 non renseignée');
			return ;
		}
		
		var msgTxt ;
		if( !confirmed && (msgTxt=this.preSaveGetMsg()) ) {
			Ext.Msg.confirm('Confirm?',msgTxt,function(btn){
				if( btn=='yes' ) {
					this.handleSave(true) ;
				}
			},this);
			return ;
		}
		
		var form = this.getForm(),
			formValues = form.getFieldValues() ;
		this.showLoadmask() ;
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'aogpanel_saveOrder',
				order_filerecord_id: this._orderFilerecordId,
				data: Ext.JSON.encode(formValues),
			},
			success: function(response) {
				var ajaxResponse = Ext.decode(response.responseText) ;
				if( ajaxResponse.success == false ) {
					Ext.MessageBox.alert('Error',ajaxResponse.error||'Error') ;
				}
				this.fireEvent('saved',this) ;
				this.destroy() ;
			},
			callback: function() {
				this.hideLoadmask() ;
			},
			scope: this
		});
	},
	
	fireTitle: function(title) {
		this.fireEvent('titleset',this,title) ;
	},
});
