Ext.define('DbsTracyAogRowModel',{
	extend: 'Ext.data.Model',
	idProperty: 'order_filerecord_id',
	fields: [
		{name: 'order_filerecord_id', type:'int'},
		
		{name: 'AOG_is_on', type: 'boolean'},
		
		{name: 'flow_code', type:'string'},
		{name: 'id_soc', type:'string'},
		{name: 'id_dn', type:'string'},
		{name: 'ref_invoice', type:'string'},
		
		{name: 'create_AOG_date', type: 'date', dateFormat:'Y-m-d H:i:s', allowNull: true},
		{name: 'create_RLS_date', type: 'date', dateFormat:'Y-m-d H:i:s', allowNull: true},
		{name: 'create_END_date', type: 'date', dateFormat:'Y-m-d H:i:s', allowNull: true},
		
		{name: 'READY_adr', type: 'string'},
		{name: 'READY_date', type: 'date', dateFormat:'Y-m-d H:i:s', allowNull: true},
		
		{name: 'IOD_is_visible', type: 'boolean'},
		{name: 'IOD_is_on', type: 'boolean'},
		{name: 'IOD_date', type: 'date', dateFormat:'Y-m-d H:i:s', allowNull: true},
		
		{name: 'trspt_is_on', type: 'boolean', allowNull: true},
		
		{name: 'pickup_status', type: 'boolean'},
		
		{name: 'pod_status', type: 'boolean', allowNull: true},
		
		{name: 'AWB_is_visible', type: 'boolean'},
		{name: 'AWB_is_on', type: 'boolean'},
		{name: 'AWB_date', type: 'date', dateFormat:'Y-m-d H:i:s', allowNull: true},
		{name: 'AWB_txt', type: 'string'},
	],
});

Ext.define('Optima5.Modules.Spec.DbsTracy.AogPanel',{
	extend:'Ext.panel.Panel',
	
	requires: [
		'Optima5.Modules.Spec.DbsTracy.AogPopup',
	],
	
	_readonlyMode: false,
	
	_singlePage: false,
	
	defaultViewMode: 'order',
	viewMode: null,
	autoRefreshDelay: (10*60*1000),
	
	initComponent: function() {
		// HACK ?
		var prioMap = {} ;
		Ext.Array.each( Optima5.Modules.Spec.DbsTracy.HelperCache.getPriorityAll(), function(prio) {
			prioMap[prio.prio_id] = prio ;
		}) ;
		var consigneeMap = {} ;
		Ext.Array.each( Optima5.Modules.Spec.DbsTracy.HelperCache.getListData('LIST_CONSIGNEE'), function(r) {
			consigneeMap[r.id] = r.text ;
		}) ;
		
		var stepRenderer = function(vObj,metaData) {
			if( !vObj ) {
				//metaData.tdCls += ' '+'op5-spec-dbstracy-gridcell-gray' ;
				return '&#160;' ;
			}
			if( !vObj.pending && !vObj.ACTUAL_dateSql && !vObj.VOID_dateSql ) {
				return '&#160;' ;
			}
			var dateSql ;
			if( vObj.pending ) {
				dateSql = vObj.ETA_dateSql ;
			} else {
				dateSql = vObj.ACTUAL_dateSql ;
			}
			switch( vObj.color ) {
				case 'red' :
				case 'orange' :
				case 'green' :
				case 'paleblue' :
					metaData.tdCls += ' '+'op5-spec-dbstracy-gridcell-'+vObj.color ;
					break ;
			}
			if( !Ext.isEmpty(dateSql) || !Ext.isEmpty(vObj.VOID_dateSql) ) {
				metaData.tdCls += ' '+'op5-spec-dbstracy-gridcell-bold' ;
			} else {
				metaData.tdCls += ' '+'op5-spec-dbstracy-gridcell-nobold' ;
			}
			if( !Ext.isEmpty(vObj.VOID_dateSql) ) {
				return 'N/A<br>&#160;' ;
			}
			if( dateSql=='0000-00-00 00:00:00' && vObj.color=='red' ) {
				return '&#160;<br>&#160;' ;
			}
			if( Ext.isEmpty(dateSql) ) {
				return '&#160;' ;
			}
			dateSql = Ext.Date.format(Ext.Date.parse(dateSql,'Y-m-d H:i:s'),'d/m/Y H:i') ;
			return dateSql.replace(' ','<br>') ;
		};
		
		Ext.apply(this,{
			layout: {
				type: 'vbox',
				align: 'stretch'
			},
			tbar: [{
				hidden: this._singlePage,
				icon: 'images/op5img/ico_back_16.gif',
				text: '<u>Back</u>',
				handler: function(){
					this.doQuit() ;
				},
				scope: this
			},'-',{
				hidden:true,
				padding: '0px 16px',
				xtype: 'box',
				html: '<b>Filters&nbsp;:</b>'
			},Ext.create('Optima5.Modules.Spec.DbsTracy.CfgParamButton',{
				cfgParam_id: 'SOC',
				iconCls: 'op5-spec-dbsezeer-explorer-status-all',
				text: 'Business Unit',
				itemId: 'btnSoc',
				optimaModule: this.optimaModule,
				listeners: {
					change: {
						fn: function() {
							this.doToolbarLayout() ;
							this.doLoad() ;
						},
						scope: this
					},
					ready: {
						fn: function() {
							
						},
						scope: this
					}
				}
			}),{
				hidden:true,
				itemId: 'tbCreate',
				icon: 'images/modules/dbstracy-aognew-16.gif',
				text:'Create file...',
				handler: function() {
					this.openAogPopup(null,this.down('toolbar').down('#btnSoc').getValue()) ;
				},
				scope: this,
			},'-',{
				itemId: 'tbViewmode',
				viewConfig: {forceFit: true},
				menu: {
					defaults: {
						handler:function(menuitem) {
							//console.log('ch view '+menuitem.itemId) ;
							this.onViewSelect( menuitem.itemId ) ;
						},
						scope:this
					},
					items: [{
						itemId: 'status_current',
						text: 'Opened AOG / Waiting for IOD/POD',
						iconCls: 'op5-spec-dbsezeer-explorer-status-owned'
					},{
						itemId: 'search_dates',
						text: 'AOG opened at date',
						iconCls: 'op5-spec-dbsezeer-explorer-status-scope'
					}]
				}
			},{
				icon: 'images/op5img/ico_calendar_16.png',
				text: '&#160;',
				itemId: 'date-picker',
				menu: [{
					xtype: 'form',
					layout: 'anchor',
					bodyPadding: 5,
					bodyCls: 'ux-noframe-bg',
					defaults: {
						listeners: {
							select: function(field) {
								var form = field.up('form'),
									dateStart = form.getForm().findField('date_start').getValue(),
									dateEnd = form.getForm().findField('date_end').getValue() ;
								this.onDateSet(dateStart,dateEnd) ;
							},
							scope: this
						}
					},
					items: [{
						margin: 5,
						xtype: 'datefield',
						name: 'date_start',
						format: 'Y-m-d',
						fieldLabel: 'Date start',
						labelWidth: 80,
					},{
						margin: 5,
						xtype: 'datefield',
						name: 'date_end',
						format: 'Y-m-d',
						fieldLabel: 'Date end',
						labelWidth: 80,
					}]
				}]
			},'-',{
				icon: 'images/op5img/ico_loupe_16.png',
				itemId: 'btnSearchIcon',
			},{
				xtype: 'textfield',
				itemId: 'btnSearch',
				width: 150,
				allowBlank:true,
				triggers: {
					clear: {
						cls: Ext.baseCSSPrefix + 'form-clear-trigger',
						handler: function(field) {
							field.reset() ;
						}
					}
				},
				enableKeyEvents: true,
				listeners: {
					change: {
						fn: function(field) {
							this.onSearchChange() ;
						},
						scope: this,
						buffer: 500
					},
					afterrender: function( field ) {
						var triggers = field.getTriggers() ;
						if( triggers.picker ) {
							triggers.picker.hide() ;
						}
					},
					scope: this
				}
			},{
				xtype: 'box',
				width: 16
			},'->',{
				icon: 'images/op5img/ico_reload_small.gif',
				text: 'Reload',
				handler: function() {
					this.doLoad() ;
				},
				scope: this
			}],
			
			items: [{
				xtype: 'container',
				layout: {
					type: 'hbox',
					align: 'stretch'
				},
				height: 75,
				style: 'background-color:#f5f5f5',
				items: []
			},{
				flex: 1,
				xtype: 'grid',
				itemId: 'pGrid',
				store: {
					model: 'DbsTracyAogRowModel',
					autoLoad: false,
					proxy: this.optimaModule.getConfiguredAjaxProxy({
						extraParams : {
							_moduleId: 'spec_dbs_tracy',
							_action: 'aogpanel_getList'
						},
						reader: {
							type: 'json',
							rootProperty: 'data'
						}
					}),
					listeners: {
						beforeload: this.onGridBeforeLoad,
						load: this.onGridLoad,
						scope: this
					}
				},
				columns: [{
					text: '<b>BU</b>',
					dataIndex: 'id_soc',
					width:50,
					align: 'center',
					renderer: function(v) {
						switch(v) {
							case 'ACL' :
								return 'SNA' ;
							case 'MBD' :
								return 'SLS' ;
							default :
								return v ;
						}
					},
				},{
					text: '<b>DN#</b>',
					dataIndex: 'id_dn',
					width:150,
					tdCls: 'op5-spec-dbstracy-bigcolumn',
					resizable: true,
					align: 'left',
					filter: {
						type: 'string'
					},
					renderer: function(v) {
						return '<b>'+v+'</b>';
					}
				},{
					text: 'Priority',
					dataIndex: 'atr_priority',
					width:85,
					tdCls: 'op5-spec-dbstracy-bigcolumn',
					align: 'center',
					renderer: function(v,metaData) {
						var prioMap = this._prioMap ;
						if( prioMap.hasOwnProperty(v) ) {
							var prioData = prioMap[v] ;
							return '<font color="' + prioData.prio_color + '">' + prioData.prio_code + '</font>' ;
						}
						return '?' ;
					},
				},{
					text: 'Invoice#',
					dataIndex: 'ref_invoice',
					width:120,
					tdCls: 'op5-spec-dbstracy-bigcolumn',
					resizable: true,
					align: 'center',
					filter: {
						type: 'string'
					}
				},{
					text: 'Incoterm',
					dataIndex: 'atr_incoterm',
					width:60,
					resizable: true,
					align: 'center',
					renderer: function(v,m,r) {
						var str = '<span class="op5-spec-dbstracy-bigcolumn-inner">'+'<b>'+v+'</b>'+'</span>' ;
						if( !Ext.isEmpty(r.get('atr_incoterm_txt')) ) {
							str += '<br/>' ;
							str += r.get('atr_incoterm_txt') ;
						}
						return str ;
					},
					filter: {
						type: 'op5crmbasebible',
						optimaModule: this.optimaModule,
						bibleId: 'LIST_INCOTERM'
					}
				},{
					text: '<b>Consignee</b><br>Site location',
					dataIndex: 'atr_consignee',
					width:140,
					align: 'left',
					variableRowHeight: true,
					filter: {
						type: 'op5crmbasebible',
						optimaModule: this.optimaModule,
						bibleId: 'LIST_CONSIGNEE'
					},
					renderer: function(v,metaData,record) {
						var str = '' ;
						
						str+= '<b>' ;
						var consigneeMap = this._consigneeMap ;
						if( consigneeMap.hasOwnProperty(v) ) {
							str+= consigneeMap[v] ;
						} else {
							str+= v ;
						}
						str+= '</b>' ;
						
						if( !Ext.isEmpty( record.get('txt_location_city') ) ) {
							str+= '<br>' ;
							str+= Ext.util.Format.nl2br( Ext.String.htmlEncode( record.get('txt_location_city') ) ) ;
						}
						return str ;
					}
				},{
					text: 'AOG start / RLS',
					columns: [{
						align: 'center',
						dataIndex: 'create_AOG_date',
						text: 'AOG T=0',
						renderer: function(v,metaData,r) {
							if( !v ) {
								if( r.get('aog_is_on') ) {
									metaData.tdCls += ' '+'op5-spec-dbstracy-gridcell-bold' ;
									metaData.tdCls += ' '+'op5-spec-dbstracy-gridcell-red' ;
									return '&nbsp;<br>&nbsp;' ;
								} else {
									metaData.tdCls += ' '+'op5-spec-dbstracy-status-orange' ;
									return '' ;
								}
							}
							metaData.tdCls += ' '+'op5-spec-dbstracy-gridcell-bold' ;
							metaData.tdCls += ' '+'op5-spec-dbstracy-gridcell-paleorange' ;
							dateSql = Ext.Date.format(v,'d/m/Y H:i') ;
							return dateSql.replace(' ','<br>') ;
						}
					},{
						align: 'center',
						dataIndex: 'create_RLS_date',
						text: 'SAP release',
						renderer: function(v,metaData) {
							if( !v ) {
								metaData.tdCls += ' '+'op5-spec-dbstracy-status-orange' ;
								return '' ;
							}
							metaData.tdCls += ' '+'op5-spec-dbstracy-gridcell-bold' ;
							metaData.tdCls += ' '+'op5-spec-dbstracy-gridcell-paleorange' ;
							dateSql = Ext.Date.format(v,'d/m/Y H:i') ;
							return dateSql.replace(' ','<br>') ;
						}
					}]
				},{
					hidden: true,
					width: 70,
					align: 'center',
					text: 'Trspt?',
					dataIndex: 'trspt_is_on',
					renderer: function(v,metaData,r) {
						if( v && !!(r.get('IOD_date')) ) {
							return '&nbsp;' ;
						}
						metaData.tdCls += v ? 'op5-spec-dbstracy-status-green' : 'op5-spec-dbstracy-status-red' ;
						return '&nbsp;' ;
					}
				},{
					text: 'Mise à quai',
					columns: [{
						align: 'center',
						width: 90,
						dataIndex: 'READY_adr',
						text: 'Location',
						tdCls: 'op5-spec-dbstracy-bigcolumn',
						renderer: function(v,m,r) {
							if( r.get('pickup_status') ) {
								m.tdCls+= ' op5-spec-dbstracy-strikecolumn' ;
							}
							return v;
						}
					},{
						align: 'center',
						dataIndex: 'READY_date',
						text: 'Date',
						renderer: function(v,metaData,r) {
							if( !v ) {
								metaData.tdCls += ' '+'op5-spec-dbstracy-status-red' ;
								return '' ;
							}
							metaData.tdCls += ' '+'op5-spec-dbstracy-gridcell-bold' ;
							metaData.tdCls += ' '+'op5-spec-dbstracy-gridcell-paleblue' ;
							dateSql = Ext.Date.format(v,'d/m/Y H:i') ;
							return dateSql.replace(' ','<br>') ;
						}
					}]
				},{
					align: 'center',
					dataIndex: 'create_END_date',
					text: '<b>AOG T=end</b>',
					renderer: function(v,metaData) {
						if( !v ) {
							metaData.tdCls += ' '+'op5-spec-dbstracy-status-orange' ;
							return '' ;
						}
						metaData.tdCls += ' '+'op5-spec-dbstracy-gridcell-bold' ;
						metaData.tdCls += ' '+'op5-spec-dbstracy-gridcell-palegreen' ;
						dateSql = Ext.Date.format(v,'d/m/Y H:i') ;
						return dateSql.replace(' ','<br>') ;
					}
				},{
					text: '<b>IOD / POD</b>',
					columns: [{
						align: 'center',
						dataIndex: 'IOD_date',
						text: 'IOD date',
						renderer: function(v,metaData,r) {
							if( !r.get('IOD_is_visible') ) {
								return ;
							}
							if( !v ) {
								metaData.tdCls += ' '+'op5-spec-dbstracy-status-red' ;
								return '' ;
							}
							metaData.tdCls += ' '+'op5-spec-dbstracy-gridcell-bold' ;
							metaData.tdCls += ' '+'op5-spec-dbstracy-gridcell-paleblue' ;
							dateSql = Ext.Date.format(v,'d/m/Y H:i') ;
							return dateSql.replace(' ','<br>') ;
						}
					},{
						align: 'center',
						dataIndex: 'pod_status',
						text: '<b>POD attach.</b>',
						renderer: function(v,metaData,r) {
							if( v === null ) {
								return '&nbsp;' ;
							}
							metaData.tdCls += v ? 'op5-spec-dbstracy-status-green' : 'op5-spec-dbstracy-status-red' ;
							return '&nbsp;' ;
						}
					}]
				},{
					// TODO : cas du Mi-Mo : pas de LTA attendue >>>> pas de puce rouge
					text: '<b>AWB</b>',
					columns: [{
						align: 'center',
						dataIndex: 'AWB_date',
						text: 'AWB date',
						renderer: function(v,metaData,r) {
							if( !r.get('AWB_is_visible') ) {
								return ;
							}
							if( !v ) {
								metaData.tdCls += ' '+'op5-spec-dbstracy-status-red' ;
								return '' ;
							}
							metaData.tdCls += ' '+'op5-spec-dbstracy-gridcell-bold' ;
							metaData.tdCls += ' '+'op5-spec-dbstracy-gridcell-paleblue' ;
							dateSql = Ext.Date.format(v,'d/m/Y H:i') ;
							return dateSql.replace(' ','<br>') ;
						}
					},{
						align: 'center',
						width: 180,
						dataIndex: 'AWB_txt',
						text: 'AWB Reference',
						tdCls: 'op5-spec-dbstracy-boldcolumn',
					}]
				}],
				listeners: {
					itemdblclick: function(view, record, itemNode, index, e ) {
						var cellNode = e.getTarget( view.getCellSelector() ),
							cellColumn = view.getHeaderByCell( cellNode ) ;
						if( cellColumn.dataIndex=='pod_status' ) {
							this.openAogPopup(record.get('order_filerecord_id'),null,'pAttachments') ;
							return ;
						}
						this.openAogPopup(record.get('order_filerecord_id')) ;
					},
					scope: this
				},
				viewConfig: {
					enableTextSelection: true,
				},
				_consigneeMap: consigneeMap,
				_prioMap: prioMap,
			}]
		});
		this.callParent() ;
		this.mon(this.optimaModule,'op5broadcast',this.onCrmeventBroadcast,this) ;
		
		// Create grid ?
		if( this.autoRefreshTask ) {
			this.autoRefreshTask.cancel() ;
		}
		this.autoRefreshTask = new Ext.util.DelayedTask( function(){
			if( this.isDestroyed ) { // private check
				return ;
			}
			this.doLoad() ;
		},this);
		
		//this.doConfigure() ;
		this.doToolbarLayout() ;
		this.onViewSelect('status_current') ;
	},
	onCrmeventBroadcast: function(crmEvent, eventParams) {
		switch( crmEvent ) {
			case 'datachange' :
				this.onDataChange() ;
				break ;
			default: break ;
		}
	},
	onDataChange: function() {
		this.doLoad() ;
	},
	
	doToolbarLayout: function() {
		var btnSoc = this.down('toolbar').down('#btnSoc'),
			btnSocValue = btnSoc.getValue() ;
		
		this.down('toolbar').down('#tbCreate').setVisible( !Ext.isEmpty(btnSocValue) ) ;
	},
	
	onViewSelect: function(viewId) {
		this.doSearchResetSilent() ;
		
		var tbViewmode = this.down('#tbViewmode') ;
		if( viewId==null && tbViewmode.tbViewmodeItemId ) {
			viewId = tbViewmode.tbViewmodeItemId ;
		}
		var tbViewmode = this.down('#tbViewmode'),
			tbViewmodeItem = tbViewmode.menu.getComponent(viewId),
			iconCls, text ;
		if( !tbViewmodeItem ) {
			return ;
		}
		tbViewmode.tbViewmodeItemId = viewId ;
		// View mode
		var tbViewmodeItem = tbViewmode.menu.getComponent(viewId) ;
		if( tbViewmodeItem ) {
			var txt = '<b>' + tbViewmodeItem.text + '</b>' ;
			tbViewmode.setText( txt );
			tbViewmode.setIconCls( tbViewmodeItem.iconCls );
		}
		
		this.down('toolbar').down('#date-picker').setVisible( viewId=='search_dates' ) ;
		if( viewId=='search_dates' ) {
			var dateStart = new Date() ;
			var dateEnd = new Date() ;
			dateStart.setMonth( dateStart.getMonth() - 1 ) ;
			
			this.onDateSet(dateStart,dateEnd) ;
		} else {
			this.doLoad() ;
		}
	},
	onDateSet: function( dateStart, dateEnd ) {
		this.doSearchResetSilent() ;
		
		var dateStartObj = new Date(dateStart.toDateString()),
			dateEndObj = new Date(dateEnd.toDateString());
		this.down('toolbar').down('#date-picker').menu.down('form').getForm().setValues({
			date_start: dateStartObj,
			date_end: dateEndObj,
		});
		this.down('toolbar').down('#date-picker').setText('<b>'+Ext.Date.format(dateStartObj,'d/m/Y')+'</b>'+'&nbsp;<b>></b>&nbsp;'+'<b>'+Ext.Date.format(dateEndObj,'d/m/Y')+'</b>') ;
		
		this.doLoad() ;
	},
	
	
	doLoad: function(searchTxt=null) {
		if( !Ext.isEmpty(searchTxt) ) {
			this.down('grid').getStore()._searchTxt = searchTxt ;
		} else {
			this.doSearchResetSilent() ;
			this.down('grid').getStore()._searchTxt = null ;
		}
		this.down('grid').getStore().load() ;
	},
	
	onGridBeforeLoad: function(store,options) {
		var scopeViewId = this.down('#tbViewmode').tbViewmodeItemId ;
		//console.log(scopeViewId) ;
		
		var btnSoc = this.down('toolbar').down('#btnSoc'),
			btnSocValue = btnSoc.getValue() ;
		
		var formPanel = this.down('toolbar').down('#date-picker').menu.down('form')
		var dateStart = formPanel.getForm().findField('date_start').getRawValue(),
			dateEnd = formPanel.getForm().findField('date_end').getRawValue() ;
		if( scopeViewId=='search_dates' && dateStart && dateEnd ) {
			//console.log(dateStart+' >> '+dateEnd) ;
		}
		
		var params = options.getParams() || {} ;
		if( !Ext.isEmpty(btnSocValue) ) {
			Ext.apply(params,{
				filter_socCode: btnSocValue,
			}) ;
		}
		if( store._searchTxt ) {
			Ext.apply(params,{
				filter_searchTxt: store._searchTxt,
			}) ;
		} else if( scopeViewId=='search_dates' ) {
			Ext.apply(params,{
				filter_dates: Ext.JSON.encode({
					date_start: dateStart,
					date_end: dateEnd,
				}),
			}) ;
		}
		options.setParams(params) ;
	},
	onGridLoad: function() {
		
	},
	
	doSearchResetSilent: function() {
		btnSearch = this.down('#btnSearch') ;
		btnSearch.suspendEvents() ;
		btnSearch.reset() ;
		btnSearch.resumeEvents(true) ;
	},
	onSearchChange: function() {
		var btnSearch = this.down('#btnSearch') ;
		var btnSearchTxt = btnSearch.getValue().toLowerCase() ;
		
		this.doLoad(btnSearchTxt) ;
	},
	
	openAogPopup: function(orderFilerecordId,idSoc=null,activeTab=null) {
		if( this._aogPopup ) {
			this._aogPopup.destroy() ;
		}
		
		var me = this ;
		var popupPanel = Ext.create('Optima5.Modules.Spec.DbsTracy.AogPopup',{
			optimaModule: this.optimaModule,
			_orderFilerecordId: orderFilerecordId,
			_isNew: Ext.isEmpty(orderFilerecordId),
			_isNew_idSoc: idSoc,
			
			_activeTab: activeTab,
			
			width:500,
			height:500,
			
			floating: true,
			renderTo: me.getEl(),
			tools: [{
				type: 'close',
				handler: function(e, t, p) {
					p.ownerCt.destroy();
				}
			}],
		});
		
		popupPanel.on('saved',function() {
			me.doLoad(me.down('grid').getStore()._searchTxt) ; //HACK
		},me,{single:true}) ;
		popupPanel.on('destroy',function() {
			me.getEl().unmask() ;
			me._aogPopup = null ;
		},me,{single:true}) ;
		me.getEl().mask() ;
		
		popupPanel.show();
		popupPanel.getEl().alignTo(me.getEl(), 'c-c?');
		//popupPanel.doCalcLayout() ;
		
		this._aogPopup = popupPanel ;
	},
	
	doQuit: function() {
		if( this._singlePage ) {
			return ;
		}
		this.destroy() ;
	},
	onDestroy: function() {
		if( this._aogPopup ) {
			this._aogPopup.destroy() ;
		}
		if( this.autoRefreshTask ) {
			this.autoRefreshTask.cancel() ;
		}
		//Ext.ux.dams.ModelManager.unregister( this.tmpModelName ) ;
	}
});
