Ext.define('Optima5.Modules.Spec.DbsTracy.AogPopup',{
	extend: 'Ext.tab.Panel',
	requires: ['Optima5.Modules.Spec.DbsTracy.AogForm'],
	
	// optimaModule: null,
	// _orderFilerecordId: null,
	// _isNew: null,
	// _isNew_idSoc: null,
	
	initComponent: function() {
		Ext.apply(this,{
			items: [Ext.create('Optima5.Modules.Spec.DbsTracy.AogForm',{
				title: 'Details',
				
				optimaModule: this.optimaModule,
				_orderFilerecordId: this._orderFilerecordId,
				_isNew: this._isNew,
				_isNew_idSoc: this._isNew_idSoc,
				
				listeners: {
					saved: function(fp,title) {
						this.fireEvent('saved',this) ;
					},
					titleset: function(fp,title) {
						this.setTitle(title) ;
					},
					destroy: function(fp) {
						this.destroy();
					},
					scope: this,
				}
			}),Ext.create('Optima5.Modules.Spec.DbsTracy.OrderAttachmentsDataview',{
				optimaModule: this.optimaModule,
				_readonlyMode: this._readonlyMode,
				itemId: 'pAttachments',
				title: 'Attachments'
			})]
		});
		this.callParent();
		if( this._activeTab ) {
			var activeCmp = this.down('#'+this._activeTab) ;
			if( activeCmp ) {
				this.setActiveTab(activeCmp) ;
			}
		}
		if( !this._isNew && this._orderFilerecordId ) {
			this.loadOrder(this._orderFilerecordId) ;
		}
		this.mon(this.optimaModule,'op5broadcast',this.onCrmeventBroadcast,this) ;
	},
	onCrmeventBroadcast: function(crmEvent, eventParams) {
		switch( crmEvent ) {
			case 'attachmentschange' :
				if( this._orderFilerecordId && this._orderFilerecordId == eventParams.orderFilerecordId ) {
					this.loadOrder( this._orderFilerecordId ) ;
				}
				break ;
			default: break ;
		}
	},
	loadOrder: function( filerecordId ) {
		//this.showLoadmask() ;
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'order_getRecords',
				filter_orderFilerecordId_arr: Ext.JSON.encode([filerecordId])
			},
			success: function(response) {
				var ajaxResponse = Ext.decode(response.responseText) ;
				if( ajaxResponse.success == false || ajaxResponse.data.length != 1 ) {
					Ext.MessageBox.alert('Error','Error') ;
					return ;
				}
				this.onLoadOrder(Ext.ux.dams.ModelManager.create('DbsTracyFileOrderModel',ajaxResponse.data[0])) ;
			},
			callback: function() {
				//this.hideLoadmask() ;
			},
			scope: this
		}) ;
	},
	onLoadOrder: function( orderRecord ) {
		if( this.destroyed ) {
			return ;
		}
		//gAttachments
		//this.down('#pAttachments').getEl().unmask() ;
		this.down('#pAttachments').setOrderRecord(orderRecord) ;
	},
});
