Ext.define('Optima5.Modules.Spec.DbsTracy.AttachmentViewerWindow',{
	extend:'Ext.window.Window',
	
	_readonlyMode: false,
	_mediaId: null,
	
	initComponent: function() {
		if( (this.optimaModule) instanceof Optima5.Module ) {} else {
			Optima5.Helper.logError('Spec:DbsTracy:AttachmentViewerWindow','No module reference ?') ;
		}
		
		Ext.apply(this,{
			title:'Attachment Viewer',
			layout: 'border',
			//width:dispwidth,
			//height:dispheight,
			iconCls: 'op5-crmbase-dataformwindow-photo-icon',
			animCollapse:false,
			border: false,
			items: [{
				itemId: 'cntPage',
				region: 'center',
				flex: 1,
				xtype: 'panel',
				cls: 'ux-noframe-bg',
				layout: 'fit',
				items: []
			},{
				hidden: true,
				itemId: 'pWest',
				title: 'Pages',
				region: 'west',
				collapsible: true,
				collapsed: false,
				width: 222,
				layout: 'fit',
				xtype: 'panel',
				items: [{
					border: false,
					itemId: 'dvThumbnails',
					xtype: 'dataview',
					selectionModel: {
						mode: 'SINGLE'
					},
					store: {
						fields: [
							{name:'page_idx', type:'int'},
							{name:'thumb_base64', type:'string'},
						],
						data: [],
						proxy: {
							type: 'memory',
							reader: {
								type: 'json'
							}
						}
					},
					//frame: true,
					//autoScroll:true,
					//overflowX: 'auto',
					//style: {
						//whiteSpace: 'nowrap'
					//},
					scrollable: 'vertical',

					tpl:[
						'<tpl for=".">',
							'<div class="op5-spec-mrfoxy-attachments-item thumb-box">',
								//'<div>{thumb_date}</div>',
								'<a href="#">',
									'<img src="{thumb_url}"/>',
								'</a>',
								'<div>Page&#160;<b>{thumb_page}</b></div>',
							'</div>',
						'</tpl>'
					],
					trackOver: true,
					overItemCls: 'x-item-over',
					selectedItemCls: 'thumb-box-selected',
					itemSelector: 'div.thumb-box',
					prepareData: function(data) {
						Ext.apply(data, {
							thumb_page: data.page_idx,
							thumb_url: 'data:image/jpeg;base64,'+data.thumb_base64
						});
						return data;
					},
					listeners: {
						selectionchange: {
							fn: function(view, records) {
								if( records.length != 1 ) {
									return ;
								}
								this.setPageIdx( records[0].get('page_idx') ) ;
							},
							scope: this
						},
					}
				}]
			}],
			tbar: [{
				itemId: 'tbToggle',
				hidden: true,
				iconCls: 'op5-spec-dbstracy-attachments-icon',
				text: '',
				handler: function() {
					this.toggleFormVisibility() ;
				},
				scope: this
			},'->',{
				hidden: this._readonlyMode,
				icon: 'images/op5img/ico_new_16.gif',
				text:'Actions',
				menu: {
					defaults: {
						scope:this
					},
					items: [{
						iconCls: 'icon-save',
						text: 'Download file',
						handler: function() {
							this.handleDownload() ;
						}
					},{
						icon: 'images/op5img/ico_reload_small.gif',
						text: 'Move back to inbox',
						handler: function() {
							this.handleDetach() ;
						}
					},{
						iconCls: 'icon-bible-delete',
						text: 'Delete attachment',
						handler: function() {
							this.handleDelete() ;
						}
					}]
				}
			}]
		}) ;
		this.callParent() ;
		this.on('afterrender', function() {
			this.initCreateForm() ;
			this.setScrollable( true ) ;
		},this) ;
		this.on('beforeclose',this.onBeforeClose,this) ;
		this.on('beforedestroy',this.onBeforeDestroy,this) ;
	},
	initCreateForm: function() {
		var me = this ;
		this.floatForm = Ext.create('Ext.form.Panel',{
			optimaModule: this.optimaModule,
			width: 400,
			height: 200,
			floating: true,
			hidden: true,
			renderTo: this.getEl(),
			hideMode: 'visibility',
			tools: [{
				type: 'close',
				handler: function(e, t, p) {
					this.toggleFormVisibility() ;
				},
				scope: this
			}],
			
			title: 'Metadatas',
			bodyPadding: '10px 10px',
			bodyCls: 'ux-noframe-bg',
			cls: 'ux-noframe-bg',
			border: false,
			fieldDefaults: {
				labelAlign: 'left',
				labelWidth: 110,
				anchor: '100%',
				submitValue: false
			},
			layout: 'anchor',
			items: [{
				xtype:'hiddenfield',
				name:'filerecord_id'
			},{
				xtype:'hiddenfield',
				name:'media_id'
			},{
				xtype:'hiddenfield',
				name:'tmp_id'
			},{
				xtype: 'datefield',
				fieldLabel: 'Document Date',
				name: 'attachment_date',
				allowBlank: false,
				format: 'Y-m-d',
				startDay: 1,
				anchor: '',
				width: 230
			},{
				xtype: 'combobox',
				name: 'attachment_catg',
				fieldLabel: 'Type',
				queryMode: 'local',
				forceSelection: true,
				allowBlank: true,
				editable: false,
				store: {
					fields: ['id','text'],
					data: Optima5.Modules.Spec.DbsTracy.HelperCache.getListData('LIST_ATTACH'),
				},
				valueField: 'id',
				displayField: 'text',
			},{
				xtype: 'checkboxfield',
				fieldLabel: 'Discarded ?',
				name: 'attachment_discard'
			},{
				xtype: 'textarea',
				fieldLabel: '<b>Description</b>',
				name: 'attachment_txt'
			}],
			buttons: [
				{ hidden:this._readonlyMode, xtype: 'button', text: 'Submit' , handler:function(btn){ btn.up('form').handleSubmit();} }
			],
			
			handleSubmit: function() {
				var formPanel = this,
					baseForm = this.getForm() ;
				if(baseForm.isValid()){
					var ajaxParams = this.optimaModule.getConfiguredAjaxParams(),
						formValues = baseForm.getValues(false,false,false,true) ;
					Ext.apply( ajaxParams, {
						_moduleId: 'spec_dbs_tracy',
						_action: 'attachments_setAttachment',
						parent_file_code: me._parentFileCode,
						parent_filerecord_id: me._parentFilerecordId,
						data: Ext.JSON.encode(formValues)
					}) ;
					
					var msgbox = Ext.Msg.wait('Please wait...') ;
					baseForm.submit({
						url: Optima5.Helper.getApplication().desktopGetBackendUrl(),
						params: ajaxParams,
						success : function(form,action){
							if( !Ext.isEmpty(msgbox) ) {
								msgbox.close() ;
							}
							Ext.menu.Manager.hideAll();
							
							var ajaxData = Ext.JSON.decode(action.response.responseText).data ;
							form.findField('tmp_id').setValue(null) ;
							form.findField('filerecord_id').setValue(ajaxData.filerecord_id) ;
							form.findField('media_id').setValue(ajaxData.media_id) ;
							
							this.fireEvent('submitok') ;
						},
						failure: function(fp, o) {
							if( !Ext.isEmpty(msgbox) ) {
								msgbox.close() ;
							}
							Ext.Msg.alert('Error','Error during transaction') ;
						},
						scope: formPanel
					});
				}
			},
			
			listeners: {
				submitok: function(){
					this.fireEvent('submitok') ;
					this.destroy() ;
				},
				scope: this
			}
		});
	},
	
	loadTmpMedia: function( tmpId, countryCode ) {
		if( !this.rendered ) {
			this.on('afterrender', function() {
				this.loadTmpMedia(tmpId) ;
			},this,{single:true});
		}
		
		// Set window
		var mediaId = tmpId ;
		this.loadMedia(mediaId) ;
		
		// Set form
		this.floatForm.getForm().setValues({
			tmp_id: tmpId,
			attachment_date: (new Date()),
			country_code: countryCode
		}) ;
	},
	loadFilerecord: function( filerecordId ) {
		if( !this.rendered ) {
			this.on('afterrender', function() {
				this.loadFilerecord(filerecordId) ;
			},this,{single:true});
		}
		
		// Load form
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'attachments_load',
				parent_file_code: this._parentFileCode,
				parent_filerecord_id: this._parentFilerecordId,
				filerecord_id: filerecordId
			},
			success: function(response) {
				var ajaxObj = Ext.decode(response.responseText) ;
				if( ajaxObj.success ) {
					var values = ajaxObj.data,
						form = this.floatForm.getForm() ;
					form.setValues( values ) ;
					this.loadMedia( values.media_id ) ;
				}
			},
			scope: this
		});
		
	},
	loadMedia: function(mediaId) {
		this._mediaId = mediaId ;
		
		this.showLoadmask();
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'attachments_mediaGetPreview',
				media_id: this._mediaId,
			},
			success: function(response) {
				var ajaxObj = Ext.decode(response.responseText) ;
				if( ajaxObj.success ) {
					if( (ajaxObj.data.length==1) && (ajaxObj.data[0].page_idx==0) ) {
						this.down('#pWest').setVisible(false) ;
						this.setPageIdx(0) ;
					} else {
						this.down('#pWest').setVisible(true) ;
						this.down('#dvThumbnails').getStore().loadData(ajaxObj.data) ;
						this.down('#dvThumbnails').getSelectionModel().select(0) ;
					}
					
					Ext.defer(function() {
						this.toggleFormVisibility(true) ;
					},500,this) ;
				}
			},
			scope: this
		});
	},
	toggleFormVisibility: function(trueOrFalse) {
		var formPanel = this.floatForm ;
		if( trueOrFalse || !formPanel.isVisible() ) {
			formPanel.show() ;
			formPanel.getEl().alignTo(this.down('#cntPage').getEl(),'tl-tl?') ;
		} else {
			formPanel.hide() ;
		}
		this.down('#tbToggle').setVisible(true) ;
		this.down('#tbToggle').setText( formPanel.isVisible() ? 'Hide form' : '<b>Show form</b>' ) ;
	},
	
	setPageIdx: function( pageIdx ) {
		this.showLoadmask();
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'attachments_mediaGetPage',
				media_id: this._mediaId,
				page_idx: pageIdx,
			},
			success: function(response) {
				var ajaxObj = Ext.decode(response.responseText) ;
				if( ajaxObj.success ) {
					this.setPageOnJpeg(ajaxObj.data) ;
				}
			},
			scope: this
		});
	},
	setPageOnJpeg: function( jpegBase64 ) {
		var cntPage = this.down('#cntPage') ;
		cntPage.removeAll() ;
		cntPage.add({
			xtype: 'container',
			scrollable: true,
			items: [{
				xtype: 'image',
				style: 'width: 100%;',
				src: 'data:image/jpeg;base64,' + jpegBase64
			}]
		});
		this.hideLoadmask() ;
	},
	
	onBeforeClose: function() {
		if( !this.floatForm ) {
			return true ;
		}
		
		var formPanel = this.floatForm,
			form = formPanel.getForm(),
			formValues = form.getValues(false,false,false,true) ;
		if( !Ext.isEmpty(formValues.tmp_id) ) {
			Ext.Msg.confirm('Unsaved attachment','Uploaded attachment will be discarded',function(btn) {
				if( btn == 'yes' ) {
					this.doDiscardAttachment() ;
				}
			},this) ;
			return false ;
		}
		return true ;
	},
	onBeforeDestroy: function() {
		this.doDiscardAttachment() ;
		
		if( this.floatForm ) {
			this.floatForm.destroy() ;
			this.floatForm = null ;
		}
		
		return true ;
	},
	doDiscardAttachment: function() {
		if( !this.floatForm ) {
			return true ;
		}
		
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'attachments_delete',
				filerecord_id: this.floatForm.getForm().getValues(false,false,false,true).tmp_id
			},
			success: function(response) {
				var ajaxObj = Ext.decode(response.responseText) ;
				if( ajaxObj.success && this.floatForm ) {
					this.floatForm.getForm().reset() ;
					this.destroy() ;
				}
			},
			scope: this
		});
	},
	
	handleDownload: function() {
		var mediaId = this._mediaId ;
		if( !mediaId ) {
			return ;
		}
		
		var msgbox = Ext.Msg.wait('Downloading...');
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'attachments_mediaGetBinary',
				media_id: mediaId,
			},
			success: function(response) {
				var ajaxObj = Ext.decode(response.responseText) ;
				if( ajaxObj.success ) {
					Optima5.Modules.Spec.DbsTracy.HelperCache.libBinaryDownload(ajaxObj.bin_base64,ajaxObj.bin_filename);
				}
			},
			callback: function() {
				msgbox.close();
			},
			scope: this
		});
	},
	handleDetach: function() {
		if( !this.floatForm.getForm().getValues(false,false,false,true).filerecord_id ) {
			Ext.Msg.alert('Warning','Can\'t detach temporary upload') ;
			return ;
		}
		
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'attachments_detach',
				parent_file_code: this._parentFileCode,
				parent_filerecord_id: this._parentFilerecordId,
				filerecord_id: this.floatForm.getForm().getValues(false,false,false,true).filerecord_id
			},
			success: function(response) {
				var ajaxObj = Ext.decode(response.responseText) ;
				if( ajaxObj.success && this.floatForm ) {
					this.floatForm.getForm().reset() ;
					this.fireEvent('submitok') ;
					this.destroy() ;
				}
			},
			scope: this
		});
	},
	handleDelete: function() {
		if( !this.floatForm.getForm().getValues(false,false,false,true).filerecord_id ) {
			Ext.Msg.alert('Warning','Can\'t delete temporary upload. Close window to discard.') ;
			return ;
		}
		
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'attachments_delete',
				parent_file_code: this._parentFileCode,
				parent_filerecord_id: this._parentFilerecordId,
				filerecord_id: this.floatForm.getForm().getValues(false,false,false,true).filerecord_id
			},
			success: function(response) {
				var ajaxObj = Ext.decode(response.responseText) ;
				if( ajaxObj.success && this.floatForm ) {
					this.floatForm.getForm().reset() ;
					this.fireEvent('submitok') ;
					this.destroy() ;
				}
			},
			scope: this
		});
	},
	
	showLoadmask: function() {
		if( this.rendered ) {
			this.doShowLoadmask() ;
		} else {
			this.on('afterrender',this.doShowLoadmask,this,{single:true}) ;
		}
	},
	doShowLoadmask: function() {
		if( this.loadMask ) {
			return ;
		}
		this.loadMask = Ext.create('Ext.LoadMask',{
			target: this,
			msg:"Please wait..."
		}).show();
	},
	hideLoadmask: function() {
		this.un('afterrender',this.doShowLoadmask,this) ;
		if( this.loadMask ) {
			this.loadMask.destroy() ;
			this.loadMask = null ;
		}
	},
});
