Ext.define('Optima5.Modules.Spec.DbsTracy.GunFiltersForm',{
	extend: 'Ext.form.Panel',
	requires: [
		'Ext.form.field.ComboBox'
	],
	
	_filterValues: null ,
	
	initComponent: function() {
		Ext.apply(this,{
			cls: 'ux-noframe-bg',
			width: 250,
			bodyPadding: '5px 5px',
			bodyCls: 'ux-noframe-bg',
			flex: 1,
			layout: 'anchor',
			fieldDefaults: {
				labelAlign: 'top',
				labelWidth: 80,
				anchor: '100%'
			},
			title: 'Filters',
			items:[{
				xtype: 'combobox',
				width: 450,
				emptyText: 'All zones',
				fieldLabel: 'Zones / Adrs',
				name: 'filter_adrZone',
				queryMode: 'local',
				forceSelection: true,
				allowBlank: false,
				editable: false,
				store: {
					fields: ['adr_zone','adr_txt'],
					data: [
						{adr_zone:'M1', adr_txt:'M1 Embraer'},
						{adr_zone:'M2', adr_txt:'M2 Divers'},
						{adr_zone:'M5', adr_txt:'M5 Safran'},
					],
				},
				valueField: 'adr_zone',
				displayField: 'adr_txt'
			},{
				xtype: 'combobox',
				width: 450,
				emptyText: 'All companies',
				fieldLabel: 'Company',
				name: 'filter_soc',
				queryMode: 'local',
				forceSelection: true,
				allowBlank: false,
				editable: false,
				store: {
					fields: ['soc_code','soc_txt'],
					data: Optima5.Modules.Spec.DbsTracy.GunHelper.getSocAll()
				},
				valueField: 'soc_code',
				displayField: 'soc_txt'
			},{
				xtype: 'box',
				height: 60
			},{
				xtype: 'container',
				layout: {
					type: 'hbox',
					align: 'end',
					pack: 'end'
				},
				defaults: {minWidth: this.minButtonWidth, margin: '2px 8px'},
				items: [
					{ xtype: 'button', text: 'Apply', handler: function(){this.doApply()}, scope: this },
					{ xtype: 'button', text: 'Reset', handler: function(){this.doReset()}, scope: this },
				]
			}]
		}) ;
		this.callParent() ;
		
		this.getForm().reset() ;
		if( this._filterValues ) {
			this.getForm().setValues(this._filterValues) ;
		}
	},
	doReset: function() {
		this.getForm().reset() ;
		this.doApply() ;
	},
	doApply: function() {
		this.fireEvent('submit',this,this.getForm().getValues()) ;
	},
	
}) ;
