Ext.define('Optima5.Modules.Spec.DbsTracy.GunTracy60',{
	extend:'Ext.panel.Panel',
	
	requires: [
		'Optima5.Modules.Spec.DbsTracy.GunTracy60selectPrinter',
		'Optima5.Modules.Spec.DbsTracy.GunTracy60summary',
		'Optima5.Modules.Spec.DbsTracy.GunTracy60scanResult',
		'Optima5.Modules.Spec.DbsTracy.GunTracy60aogInvite',
	],
	
	_printerUri: null,
	_runTransferligSrcAdr: null,
	
	_run_tracy70transactionId: null,
	
	_mode_AOG: false,
	
	initComponent: function(){
		Ext.apply(this,{
			bodyCls: 'ux-noframe-bg',
			layout: 'fit',
			items: []
		});
		this.callParent() ;
		this.openBlank() ;
		Ext.defer(function() {
			if( this._mode_AOG ) {
				this.openAog() ;
				return ;
			}
			this.openSelectPrinter() ;
		},1000,this) ;
	},
	openBlank: function() {
		var blankPanel = {
			xtype: 'box',
			cls:'op5-waiting'
		}
		this.removeAll() ;
		this.add(blankPanel) ;
	},
	openSelectPrinter: function() {
		var listPanel = Ext.create('Optima5.Modules.Spec.DbsTracy.GunTracy60selectPrinter',{
			border: false,
			optimaModule: this.optimaModule,
			listeners: {
				quit: function() {
					this.destroy() ;
				},
				selectprinter: function(p,printerUri) {
					this._printerUri = printerUri ;
					this.openSummary() ;
				},
				scope: this
			}
		}) ;
		this.removeAll() ;
		this.add(listPanel) ;
	},
	openAog: function() {
		this.openSummary(false,true) ;
	},
	openSummary: function(forceReopen, modeAog=false) {
		this._run_tracy60transactionId = null ;
		this.openBlank() ;
		// resume session OR list ?
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'gun_t60_postAction',
				
				_subaction: forceReopen ? 'open_force' : 'open',
			},
			success: function(response) {
				var ajaxResponse = Ext.decode(response.responseText) ;
				if( ajaxResponse.success == false ) {
					var error = ajaxResponse.success || 'Error' ;
					Ext.MessageBox.alert('Error',error, function(){this.handleInit();},this) ;
					return ;
				}
				if( ajaxResponse.transaction_id ) {
					this._run_tracy60transactionId = ajaxResponse.transaction_id ;
					var clsName = 'Optima5.Modules.Spec.DbsTracy.GunTracy60summary' ;
					if( modeAog ) {
						var clsName = 'Optima5.Modules.Spec.DbsTracy.GunTracy60aogInvite' ;
					}
					var listPanel = Ext.create(clsName,{
						border: false,
						optimaModule: this.optimaModule,
						_transactionId: this._run_tracy60transactionId,
						_printerUri: this._printerUri,
						listeners: {
							scan: function(p,scanval) {
								this.handleScan(scanval,modeAog) ;
							},
							reload: function(p) {
								this.openSummary(true) ;
							},
							quit: function() {
								this._run_tracy60transactionId = null ;
								if( this._mode_AOG ) {
									this.destroy() ;
								}
								this.openSelectPrinter() ;
							},
							scope: this
						}
					}) ;
					this.removeAll() ;
					this.add(listPanel) ;
				} else {
					this.openSelectPrinter() ;
				}
			},
			callback: function() {},
			scope: this
		}) ;
	},
	openScanResult: function(formData) {
		var listPanel = Ext.create('Optima5.Modules.Spec.DbsTracy.GunTracy60scanResult',{
			border: false,
			optimaModule: this.optimaModule,
			_transactionId: this._run_tracy60transactionId,
			_printerUri: this._printerUri,
			_data: formData,
			listeners: {
				afteraction: function(p,afterAction) {
					this.handleTransactionScanAfter(p._data,afterAction) ;
				},
				quit: function() {
					if( this._mode_AOG ) {
						this.openSummary(false,true) ;
						return ;
					}
					this.openSummary() ;
				},
				scope: this
			}
		}) ;
		this.removeAll() ;
		this.add(listPanel) ;
	},
	
	handleScan: function(scanval,modeAog=false) {
		this.openBlank() ;
		// resume session OR list ?
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'gun_t60_postAction',
				
				_transaction_id: this._run_tracy60transactionId,
				_subaction: modeAog ? 'scan_aog': 'scan',
				scanval: scanval
			},
			success: function(response) {
				var ajaxResponse = Ext.decode(response.responseText) ;
				if( ajaxResponse.success == false ) {
					var error = ajaxResponse.success || 'Error' ;
					Ext.MessageBox.alert('Error',error, function(){this.openSummary();},this) ;
					return ;
				}
				this.openScanResult( ajaxResponse.data ) ;
			},
			callback: function() {},
			scope: this
		}) ;
	},
}) ;
