Ext.define('Optima5.Modules.Spec.DbsTracy.GunTracy60aogInvite',{
	extend:'Ext.form.Panel',
	scrollable: 'vertical',
	requires: ['Optima5.Modules.Spec.DbsTracy.GunFormHeader'],
	
	mixins: {
		loadmaskable: 'Optima5.Modules.Spec.DbsTracy.GunLoadmaskableMixin'
	},
	
	initComponent: function(){
		Ext.apply(this,{
			tbar: [{
				icon: 'images/op5img/ico_back_16.gif',
				text: '<u>Back</u>',
				handler: function(){
					this.doQuit() ;
				},
				scope: this
			}],
			bodyPadding: 4,
			layout: 'anchor',
			fieldDefaults: {
				labelWidth: 90,
				anchor: '100%'
			},
			items: []
		});
		
		this.callParent() ;
		this.mon(this.optimaModule,'op5broadcast',this.onCrmeventBroadcast,this) ;
		
		this.buildInvite() ;
	},
	onCrmeventBroadcast: function(crmEvent,eventParams) {
		switch( crmEvent ) {
			case 'scan' :
				this.handleScan(eventParams.scanResult) ;
				break ;
		}
	},
	
	buildInvite: function(data) {
		var formItems = [] ;
		
		
		formItems.push( Ext.create('Optima5.Modules.Spec.DbsTracy.GunFormHeader',{
			padding: '0px 0px 16px 0px',
			width:'100%',
			data:{
				iconCls:'op5-spec-dbstracy-warning-icon',
				title: 'Mise à quai / Relocation',
				caption: 'Action : scan colis AOG'
			}
		}) );
		
		
		
		if( true ) {
			formItems.push({
				itemId: 'adrPosition',
				xtype: 'fieldset',
				cls: 'op5-spec-dbstracy-field-narrowline',
				//title: 'Scan AOG parcel',
				layout: {
					type: 'hbox',
					align: 'top',
				},
				padding: 4,
				items: [{
					flex: 1,
					xtype: 'container',
					layout: 'anchor',
					items: [{
						xtype: 'textfield',
						itemId: 'scanInput',
						fieldLabel: '<i>Scan AOG parcel</i>',
						labelAlign: 'top',
						listeners : {
							specialkey: function(field, e){
								if (e.getKey() == e.ENTER) {
									this.handleScan(field.getValue()) ;
								}
							},
							scope: this
						}
					}]
				}]
			});
		}
		this.addBodyCls('ux-noframe-bg') ;
		
		this.removeAll() ;
		this.add(formItems) ;
		
		this.add({
			xtype: 'container',
			padding: 6,
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			items: [{
				xtype: 'button',
				scale: 'large',
				style: 'min-width: 100px',
				text: 'Next',
				listeners: {
					click: function() {
						this.handleScan(this.down('#scanInput').getValue()) ;
					},
					afterrender: function(btn) {
						btn.focus() ;
					},
					scope: this
				}
			}]
		});
	},
	
	handleScan: function(scanval) {
		if( Ext.isEmpty(scanval) ) {
			return ;
		}
		scanval = scanval.trim().toUpperCase() ;
		if( Ext.isEmpty(scanval) ) {
			return ;
		}
		
		this.fireEvent('scan',this,scanval) ;
	},
	
	doAfterAction: function(afterAction) {
		this.fireEvent('afteraction',this, afterAction) ;
	},
	doQuit: function() {
		this.fireEvent('quit',this) ;
	}
});
