Ext.define('Optima5.Modules.Spec.DbsTracy.GunTracy60scanResult',{
	extend:'Ext.form.Panel',
	scrollable: 'vertical',
	requires: [
		'Optima5.Modules.Spec.DbsTracy.GunFormHeader',
		'Ext.form.FieldSet',
		'Ext.form.field.Hidden',
	],
	
	mixins: {
		loadmaskable: 'Optima5.Modules.Spec.DbsTracy.GunLoadmaskableMixin'
	},
	
	initComponent: function(){
		Ext.apply(this,{
			bodyPadding: 4,
			layout: 'anchor',
			fieldDefaults: {
				labelWidth: 90,
				anchor: '100%'
			},
			items: []
		});
		
		this.callParent() ;
		this.mon(this.optimaModule,'op5broadcast',this.onCrmeventBroadcast,this) ;
		
		this.buildForm( this._data ) ;
	},
	onCrmeventBroadcast: function(crmEvent,eventParams) {
		switch( crmEvent ) {
			case 'scan' :
				if( this.down('#tmsTextInput') && this.down('#tmsTextInput').isVisible() ) {
					this.handleTmsScan(eventParams.scanResult) ;
				}
				if( this.down('#adrTextInput') && this.down('#adrTextInput').isVisible() ) {
					this.handleAdrScan(eventParams.scanResult) ;
				}
				break ;
		}
	},
	
	buildForm: function(data) {
		var formItems = [] ;
		
		var deferQuit = false ;
		
		var bodyCls ;
		var iconCls, title, caption ;
		switch( data.header.result_type ) {
			case 'success' :
			case 'adr' :
				bodyCls = 'ux-noframe-bg' ;
				iconCls = 'op5-spec-dbstracy-gun-result-ok' ;
				title = 'Scan success' ;
				caption = 'Scanned item has been recorded' ;
				if( data.header.result_type=='success' ) {
					deferQuit = true ;
				}
				break ;
				
			case 'aog_enroll' :
				bodyCls = 'ux-noframe-bg' ;
				iconCls = 'op5-spec-dbstracy-gun-result-tms' ;
				title = data.header.aog_txt_title ;
				caption = data.header.aog_txt_caption ;
				break ;
				
			case 'tms' :
				bodyCls = 'ux-noframe-bg' ;
				iconCls = 'op5-spec-dbstracy-gun-result-tms' ;
				title = 'TMS Labels' ;
				caption = 'Need label confirmation' ;
				break ;
				
			case 'fail' :
			default :
				bodyCls = 'ux-noframe-bg-alert' ;
				iconCls = 'op5-spec-dbstracy-gun-result-fail' ;
				title = 'Scan rejected' ;
				caption = 'Error on scan, see below reason' ;
				break ;
		}
		formItems.push( Ext.create('Optima5.Modules.Spec.DbsTracy.GunFormHeader',{
			padding: '0px 0px 16px 0px',
			width:'100%',
			data:{
				iconCls:iconCls,
				title: title,
				caption: caption
			}
		}) );
		
		if( !Ext.isEmpty(data.primary_key) ) {
			formItems.push( {
				xtype: 'hiddenfield',
				name: data.primary_key.name,
				value: data.primary_key.value
			} );
		}
		
		if( !Ext.isEmpty(data.fields) ) {
			var fieldsetItems = [] ;
			Ext.Array.each( data.fields, function(field) {
				fieldsetItems.push({
					hidden: Ext.isEmpty(field.label),
					xtype: 'displayfield',
					fieldLabel: field.label,
					value: field.text
				});
			}) ;
			formItems.push( {
				xtype: 'fieldset',
				title: 'Informations',
				cls: 'op5-spec-dbstracy-field-narrowline',
				defaults: {
					labelStyle: 'font-weight: bold;'
				},
				items: fieldsetItems
			} );
		}
		
		if( data.tms ) {
			formItems.push({
				itemId: 'tmsWait',
				hidden: true,
				xtype: 'box',
				height: 32,
				cls: 'op5-waiting'
			});
			formItems.push({
				itemId: 'tmsResult',
				hidden: true,
				xtype: 'fieldset',
				cls: 'op5-spec-dbstracy-field-narrowline',
				title: 'Label management',
				layout: {
					type: 'hbox',
					align: 'top',
				},
				padding: 4,
				items: [{
					hidden: true,
					itemId: 'tmsPrint',
					margin: '0px 9px',
					xtype: 'button',
					width: 40,
					icon: 'images/op5img/ico_print_16.png',
					iconAlign: 'top',
					//scale: 'large',
					text: 'Print',
					handler: function() {
						this.doTmsInit() ;
					},
					scope: this
				},{
					flex: 1,
					xtype: 'container',
					layout: 'anchor',
					items: [{
						hidden: true,
						itemId: 'tmsScanError',
						xtype: 'displayfield',
						value: '<font color="red"><b>Error : Scan mismatch</b></font>'
					},{
						xtype: 'textfield',
						itemId: 'tmsTextInput',
						fieldLabel: '<i>Confirm barcode</i>',
						labelAlign: 'top',
						listeners : {
							specialkey: function(field, e){
								if (e.getKey() == e.ENTER) {
									this.handleTmsScan() ;
								}
							},
							scope: this
						}
					}]
				}]
			});
		}
		
		if( data.adr ) {
			formItems.push({
				itemId: 'adrPosition',
				hidden: true,
				xtype: 'fieldset',
				cls: 'op5-spec-dbstracy-field-narrowline',
				title: 'Address / Location',
				layout: {
					type: 'hbox',
					align: 'top',
				},
				padding: 4,
				items: [{
					margin: '0px 9px',
					xtype: 'box',
					width: 40,
					height: 40,
					cls: 'op5-spec-dbstracy-warning-icon'
				},{
					flex: 1,
					xtype: 'container',
					layout: 'anchor',
					items: [{
						hidden: true,
						itemId: 'adrScanError',
						xtype: 'displayfield',
						value: '<font color="red"><b>Error : Location not accepted</b></font>'
					},{
						xtype: 'textfield',
						itemId: 'adrTextInput',
						fieldLabel: '<i>Scan location</i>',
						labelAlign: 'top',
						listeners : {
							specialkey: function(field, e){
								if (e.getKey() == e.ENTER) {
									this.handleAdrScan() ;
								}
							},
							scope: this
						}
					}]
				}]
			});
		}
		
		if( data.reason ) {
			formItems.push({
				xtype: 'fieldset',
				title: 'Reason',
				items: [{
					xtype: 'box',
					padding: 6,
					html: Ext.util.Format.nl2br( data.reason )
				}]
			});
		}
		
		if( bodyCls ) {
			this.addBodyCls(bodyCls) ;
		}
		this.removeAll() ;
		this.add(formItems) ;
		
		// Bottom btn
		switch( data.header.result_type ) {
			case 'aog_enroll' :
				this.add({
					xtype: 'container',
					padding: 4,
					layout: {
						type: 'hbox',
						pack: 'center'
					},
					items: [{
						margin: 4,
						xtype: 'button',
						scale: 'medium',
						style: 'min-width: 100px',
						icon: 'images/op5img/ico_ok_16.gif',
						text: 'Confirm',
						listeners: {
							click: function() {
								this.handleAogEnroll() ;
							},
							afterrender: function(btn) {
								//btn.focus() ;
							},
							scope: this
						}
					},{
						margin: 4,
						xtype: 'button',
						scale: 'medium',
						style: 'min-width: 100px',
						icon: 'images/op5img/ico_cancel_small.gif',
						text: 'Cancel',
						listeners: {
							click: function() {
								this.doQuit() ;
							},
							afterrender: function(btn) {
								//btn.focus() ;
							},
							scope: this
						}
					}]
				});
				break ;
			case 'tms' :
			case 'adr' :
				this.add({
					xtype: 'container',
					padding: 6,
					layout: {
						type: 'hbox',
						pack: 'center'
					},
					items: [{
						xtype: 'button',
						scale: 'medium',
						style: 'min-width: 100px',
						icon: 'images/op5img/ico_cancel_small.gif',
						text: 'Cancel',
						listeners: {
							click: function() {
								this.doQuit() ;
							},
							afterrender: function(btn) {
								//btn.focus() ;
							},
							scope: this
						}
					}]
				});
				break ;
			default :
				this.add({
					xtype: 'container',
					padding: 6,
					layout: {
						type: 'hbox',
						pack: 'center'
					},
					items: [{
						xtype: 'button',
						scale: 'large',
						style: 'min-width: 100px',
						text: 'Next',
						listeners: {
							click: function() {
								this.doQuit() ;
							},
							afterrender: function(btn) {
								btn.focus() ;
							},
							scope: this
						}
					}]
				});
				break ;
		}
		
		if( deferQuit ) {
			Ext.defer( function(){
				this.doQuit() ;
			},2000,this) ;
		}
		
		if( data.header.result_type=='tms' ) {
			this.doTmsInit() ;
		}
		if( data.header.result_type=='adr' ) {
			this.doAdrInit() ;
		}
	},
	
	doTmsInit: function() {
		if( this._data.primary_key.name != 'trspt_filerecord_id' ) {
			this.doQuit() ;
		}
		
		
		this.down('#tmsWait').setVisible(true) ;
		this.down('#tmsResult').setVisible(false) ;
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'gun_t60_postAction',
				
				_transaction_id: this._transactionId,
				_subaction: 'tms_init',
				printer_uri: this._printerUri,
				trspt_filerecord_id: this._data.primary_key.name == 'trspt_filerecord_id' ? this._data.primary_key.value : 0
			},
			success: function(response) {
				var ajaxResponse = Ext.decode(response.responseText) ;
				if( ajaxResponse.success == false ) {
					var error = ajaxResponse.success || 'Error' ;
					Ext.MessageBox.alert('Error',error, function(){this.openSummary();},this) ;
					return ;
				}
				this.onTmsResponse( ajaxResponse ) ;
			},
			callback: function() {},
			scope: this
		}) ;
	},
	onTmsResponse: function(ajaxData) {
		if( ajaxData.tms_error ) {
			this._data.header.result_type = 'fail' ;
			this._data.tms = false ;
			this._data.reason = 'TMS : ' + (ajaxData.tms_error_str || 'Error') ;
			return this.buildForm( this._data ) ;
		}
		this.down('#tmsWait').setVisible(false) ;
		this.down('#tmsResult').setVisible(true) ;
		this.down('#tmsResult').down('#tmsPrint').setVisible(ajaxData.tms_print) ;
	},
	handleTmsScan: function(tmsScanval=null) {
		if( !this._data.tms || !this.down('#tmsTextInput').isVisible() ) {
			return ;
		}
		if( tmsScanval==null ) {
			tmsScanval = this.down('#tmsTextInput').getValue() ;
		}
		
		this.showLoadmask() ;
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'gun_t60_postAction',
				
				_transaction_id: this._transactionId,
				_subaction: 'tms_scan',
				trspt_filerecord_id: this._data.primary_key.name == 'trspt_filerecord_id' ? this._data.primary_key.value : 0,
				tms_scanval: tmsScanval
			},
			success: function(response) {
				var ajaxResponse = Ext.decode(response.responseText) ;
				if( ajaxResponse.success == false ) {
					var error = ajaxResponse.success || 'Error' ;
					Ext.MessageBox.alert('Error',error, function(){this.openSummary();},this) ;
					return ;
				}
				this.onTmsValidate( ajaxResponse.tms_result, ajaxResponse.need_adr ) ;
			},
			callback: function() {
				this.hideLoadmask() ;
			},
			scope: this
		}) ;
	},
	onTmsValidate: function(torf,needAdr) {
		if( torf ) {
			return this.onTmsEnd(needAdr) ;
		}
		this.down('#tmsScanError').setVisible(true) ;
		this.down('#tmsTextInput').reset() ;
	},
	onTmsEnd: function(needAdr) {
		this._data.header.result_type = needAdr ? 'adr' : 'success' ;
		this._data.tms = false ;
		return this.buildForm( this._data ) ;
	},
	
	doAdrInit: function() {
		// NOTE :
		console.dir(this._data) ;
		this.down('#adrPosition').setVisible(true) ;
	},
	handleAdrScan: function( adrScanval=null ) {
		if( !this._data.adr || !this.down('#adrTextInput').isVisible() ) {
			return ;
		}
		if( adrScanval==null ) {
			adrScanval = this.down('#adrTextInput').getValue() ;
		}
		
		this.showLoadmask() ;
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'gun_t60_postAction',
				
				_transaction_id: this._transactionId,
				_subaction: 'adr_set',
				trspt_filerecord_id: this._data.primary_key.name == 'trspt_filerecord_id' ? this._data.primary_key.value : 0,
				adr_scanval: adrScanval
			},
			success: function(response) {
				var ajaxResponse = Ext.decode(response.responseText) ;
				if( ajaxResponse.success == false ) {
					var error = ajaxResponse.success || 'Error' ;
					Ext.MessageBox.alert('Error',error, function(){this.openSummary();},this) ;
					return ;
				}
				this.onAdrValidate( ajaxResponse.adr_result, ajaxResponse.adr_id ) ;
			},
			callback: function() {
				this.hideLoadmask() ;
			},
			scope: this
		}) ;
	},
	onAdrValidate: function(torf,adrId) {
		if( torf ) {
			return this.onAdrEnd(adrId) ;
		}
		this.down('#adrScanError').setVisible(true) ;
		this.down('#adrTextInput').reset() ;
	},
	onAdrEnd: function(adrId) {
		this._data.header.result_type = 'success' ;
		this._data.adr = false ;
		Ext.Array.each( this._data.fields, function(r) {
			if( r.label_id == 'adr_id' ) {
				r.text = '<b>'+adrId+'</b>' ;
			}
		});
		
		return this.buildForm( this._data ) ;
	},
	
	handleAogEnroll: function( adrScanval=null ) {
		if( !this._data.aog_enroll ) {
			return ;
		}
		
		this.showLoadmask() ;
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'gun_t60_postAction',
				
				_transaction_id: this._transactionId,
				_subaction: 'aog_enroll',
				order_filerecord_id: this._data.primary_key.name == 'order_filerecord_id' ? this._data.primary_key.value : 0,
			},
			success: function(response) {
				var ajaxResponse = Ext.decode(response.responseText) ;
				if( ajaxResponse.success == false ) {
					var error = ajaxResponse.success || 'Error' ;
					Ext.MessageBox.alert('Error',error, function(){this.openSummary();},this) ;
					return ;
				}
				this.onAogEnroll( ajaxResponse.data ) ;
			},
			callback: function() {
				this.hideLoadmask() ;
			},
			scope: this
		}) ;
	},
	onAogEnroll: function(data) {
		this._data = data ;
		return this.buildForm( this._data ) ;
	},
	
	doAfterAction: function(afterAction) {
		this.fireEvent('afteraction',this, afterAction) ;
	},
	doQuit: function() {
		this.fireEvent('quit',this) ;
	}
});
