Ext.define('Optima5.Modules.Spec.DbsTracy.GunTracy70',{
	extend:'Ext.panel.Panel',
	
	requires: [
		'Optima5.Modules.Spec.DbsTracy.GunTracy70selectPrinter',
		'Optima5.Modules.Spec.DbsTracy.GunTracy70selectTrspt',
		'Optima5.Modules.Spec.DbsTracy.GunTracy70transactionBuild',
		'Optima5.Modules.Spec.DbsTracy.GunTracy70transactionScanResult',
		'Optima5.Modules.Spec.DbsTracy.GunTracy70transactionFinalForm',
		'Optima5.Modules.Spec.DbsTracy.GunTracy70transactionBuildAog',
	],
	mixins: {
		loadmaskable: 'Optima5.Modules.Spec.DbsTracy.GunLoadmaskableMixin'
	},
	
	_printerUri: null,
	_runTransferligSrcAdr: null,
	
	_run_tracy70transactionId: null,
	
	_mode_AOG: false,
	
	initComponent: function(){
		Ext.apply(this,{
			bodyCls: 'ux-noframe-bg',
			layout: 'fit',
			items: []
		});
		this.callParent() ;
		this.mixins.loadmaskable.constructor.call(this);
		this.handleInit() ;
	},
	openBlank: function() {
		var blankPanel = {
			xtype: 'box',
			cls:'op5-waiting'
		}
		this.removeAll() ;
		this.add(blankPanel) ;
	},
	openSelectPrinter: function() {
		var listPanel = Ext.create('Optima5.Modules.Spec.DbsTracy.GunTracy70selectPrinter',{
			border: false,
			optimaModule: this.optimaModule,
			listeners: {
				quit: function() {
					this.destroy() ;
				},
				selectprinter: function(p,printerUri) {
					console.log( printerUri ) ;
					this._printerUri = printerUri ;
					if( this._mode_AOG ) {
						this.handleInitAog() ;
						return ;
					}
					this.openSelectTrspt() ;
				},
				scope: this
			}
		}) ;
		this.removeAll() ;
		this.add(listPanel) ;
	},
	openSelectTrspt: function() {
		this._run_tracy70transactionId = null ;
		var listPanel = Ext.create('Optima5.Modules.Spec.DbsTracy.GunTracy70selectTrspt',{
			border: false,
			optimaModule: this.optimaModule,
			_printerUri: this._printerUri,
			listeners: {
				quit: function() {
					this.destroy() ;
				},
				selecttrspt: function(p,data) {
					this.handleSelectTrspt(data) ;
				},
				scope: this
			}
		}) ;
		this.removeAll() ;
		this.add(listPanel) ;
	},
	openTransactionBuild: function(tracy70transactionId, modeAog=false) {
		this._run_tracy70transactionId = tracy70transactionId ;
		var listPanel = Ext.create('Optima5.Modules.Spec.DbsTracy.GunTracy70transactionBuild',{
			border: false,
			optimaModule: this.optimaModule,
			_printerUri: this._printerUri,
			_transactionId: tracy70transactionId,
			listeners: {
				validate: function() {
					this.handleTransactionValidate() ;
				},
				scan: function(p,scanval) {
					this.handleTransactionScan(scanval) ;
				},
				quit: function() {
					this.handleInit() ;
				},
				scope: this
			}
		}) ;
		this.removeAll() ;
		this.add(listPanel) ;
	},
	openTransactionAog: function(tracy70transactionId) {
		var authObj = Optima5.Modules.Spec.DbsTracy.GunHelper.getAuthObj();
		if( authObj && authObj.hasOwnProperty('aogZone') ) {
			Optima5.Modules.Spec.DbsTracy.GunHelper.setFilters({filter_adrZone:authObj.aogZone});
		}
		
		this._run_tracy70transactionId = tracy70transactionId ;
		var listPanel = Ext.create('Optima5.Modules.Spec.DbsTracy.GunTracy70transactionBuildAog',{
			border: false,
			optimaModule: this.optimaModule,
			_printerUri: this._printerUri,
			_transactionId: tracy70transactionId,
			listeners: {
				validate: function() {
					this.handleTransactionValidate() ;
				},
				scan: function(p,scanval) {
					this.handleTransactionScan(scanval) ;
				},
				quit: function() {
					//Optima5.Modules.Spec.DbsTracy.GunHelper.setFilters({});
					this.destroy() ;
				},
				scope: this
			}
		}) ;
		this.removeAll() ;
		this.add(listPanel) ;
	},
	openTransactionScanResult: function(formData) {
		var listPanel = Ext.create('Optima5.Modules.Spec.DbsTracy.GunTracy70transactionScanResult',{
			border: false,
			optimaModule: this.optimaModule,
			_printerUri: this._printerUri,
			_data: formData,
			listeners: {
				afteraction: function(p,afterAction) {
					this.handleTransactionScanAfter(p._data,afterAction) ;
				},
				quit: function() {
					if( this._mode_AOG ) {
						this.handleTransactionValidate() ;
						return ;
					}
					this.openTransactionBuild(this._run_tracy70transactionId) ;
				},
				scope: this
			}
		}) ;
		this.removeAll() ;
		this.add(listPanel) ;
	},
	openTransactionScanFinal: function(formData) {
		var listPanel = Ext.create('Optima5.Modules.Spec.DbsTracy.GunTracy70transactionFinalForm',{
			border: false,
			optimaModule: this.optimaModule,
			_printerUri: this._printerUri,
			_data: formData,
			listeners: {
				submit: function(p,values) {
					this.handleTransactionSubmit(values) ;
				},
				back: function() {
					if( this._mode_AOG ) {
						this.handleInit() ;
						return ;
					}
					this.openTransactionBuild(this._run_tracy70transactionId) ;
				},
				scope: this
			}
		}) ;
		this.removeAll() ;
		this.add(listPanel) ;
	},
	openTransactionScanEnd: function(formData) {
		var listPanel = Ext.create('Optima5.Modules.Spec.DbsTracy.GunTracy70transactionScanResult',{
			border: false,
			optimaModule: this.optimaModule,
			_printerUri: this._printerUri,
			_data: formData,
			listeners: {
				print: function(p) {
					this.handleTransactionPrint(p._data) ;
				},
				quit: function() {
					this.handleInit() ;
				},
				scope: this
			}
		}) ;
		this.removeAll() ;
		this.add(listPanel) ;
	},
	
	handleInitAog: function() {
		this.openBlank() ;
		
		// Get printer IP ??
		if( !this._printerUri ) {
			var authObj = Optima5.Modules.Spec.DbsTracy.GunHelper.getAuthObj() ;
			if( authObj && authObj.hasOwnProperty('printerIp') ) {
				this._printerUri = 'spool'+':'+authObj.printerIp ;
			}
		}
		if( !this._printerUri ) {
			this.openSelectPrinter() ;
			return ;
		}
		
		// resume session OR list ?
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'gun_t70_transactionPostAction',
				
				_subaction: 'create_aog', // HACK ?
				data: Ext.JSON.encode({}),
			},
			success: function(response) {
				var ajaxResponse = Ext.decode(response.responseText) ;
				if( ajaxResponse.success == false ) {
					var error = ajaxResponse.success || 'Error' ;
					Ext.MessageBox.alert('Error',error, function(){this.handleInit();},this) ;
					return ;
				}
				if( ajaxResponse.transaction_id ) {
					this.openTransactionAog(ajaxResponse.transaction_id) ;
				} else {
					this.destroy() ;
				}
			},
			callback: function() {},
			scope: this
		}) ;
	},
	
	handleInit: function() {
		this.openBlank() ;
		
		if( this._mode_AOG ) {
			return this.handleInitAog() ;
		}
		
		// resume session OR list ?
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'gun_t70_transactionGetActiveId'
			},
			success: function(response) {
				var ajaxResponse = Ext.decode(response.responseText) ;
				if( ajaxResponse.success == false ) {
					var error = ajaxResponse.success || 'Error' ;
					Ext.MessageBox.alert('Error',error) ;
					return ;
				}
				if( ajaxResponse.transaction_id ) {
					this.openTransactionBuild(ajaxResponse.transaction_id) ;
				} else if( this._printerUri ) {
					this.openSelectTrspt() ;
				} else {
					this.openSelectPrinter() ;
				}
			},
			callback: function() {},
			scope: this
		}) ;
	},
	handleSelectTrspt: function(data) {
		this.openBlank() ;
		// resume session OR list ?
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'gun_t70_transactionPostAction',
				
				_subaction: 'create',
				data: Ext.JSON.encode(data)
			},
			success: function(response) {
				var ajaxResponse = Ext.decode(response.responseText) ;
				if( ajaxResponse.success == false ) {
					var error = ajaxResponse.success || 'Error' ;
					Ext.MessageBox.alert('Error',error, function(){this.handleInit();},this) ;
					return ;
				}
				if( ajaxResponse.transaction_id ) {
					this.openTransactionBuild(ajaxResponse.transaction_id) ;
				} else {
					this.openSelectTrspt() ;
				}
			},
			callback: function() {},
			scope: this
		}) ;
	},
	handleTransactionScan: function(scanval) {
		this.openBlank() ;
		// resume session OR list ?
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'gun_t70_transactionPostAction',
				
				_transaction_id: this._run_tracy70transactionId,
				_subaction: 'scan',
				scanval: scanval
			},
			success: function(response) {
				var ajaxResponse = Ext.decode(response.responseText) ;
				if( ajaxResponse.success == false ) {
					var error = ajaxResponse.success || 'Error' ;
					Ext.MessageBox.alert('Error',error, function(){this.openTransactionBuild(this._run_tracy70transactionId);},this) ;
					return ;
				}
				if( ajaxResponse.skip == true ) {
					if( this._mode_AOG ) {
						this.handleTransactionValidate() ;
						return ;
					}
					this.openTransactionBuild(this._run_tracy70transactionId) ;
					return ;
				}
				this.openTransactionScanResult( ajaxResponse.data ) ;
			},
			callback: function() {},
			scope: this
		}) ;
	},
	handleTransactionScanAfter: function(formData, afterAction) {
		this.openBlank() ;
		var ajaxParams = {
			_moduleId: 'spec_dbs_tracy',
			_action: 'gun_t70_transactionPostAction',
			
			_transaction_id: this._run_tracy70transactionId,
			_subaction: afterAction
		};
		if( formData.primary_key ) {
			ajaxParams[formData.primary_key.name] = formData.primary_key.value ;
		}
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams,
			success: function(response) {
				var ajaxResponse = Ext.decode(response.responseText) ;
				if( ajaxResponse.success == false ) {
					var error = ajaxResponse.success || 'Error' ;
					Ext.MessageBox.alert('Error',error, function(){this.openTransactionBuild(this._run_tracy70transactionId);},this) ;
					return ;
				}
				this.openTransactionBuild(this._run_tracy70transactionId) ;
			},
			callback: function() {},
			scope: this
		}) ;
	},
	handleTransactionValidate: function() {
		this.openBlank() ;
		// resume session OR list ?
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'gun_t70_transactionPostAction',
				
				_transaction_id: this._run_tracy70transactionId,
				_subaction: 'validate'
			},
			success: function(response) {
				var ajaxResponse = Ext.decode(response.responseText) ;
				if( ajaxResponse.success == false ) {
					var error = ajaxResponse.error || 'Manifest build incomplete' ;
					Ext.MessageBox.alert('Error',error, function(){
						if( this._mode_AOG ) {
							this.handleInit() ;
							return ;
						}
						this.openTransactionBuild(this._run_tracy70transactionId);
					},this) ;
					return ;
				}
				this.openTransactionScanFinal( ajaxResponse.data ) ;
			},
			callback: function() {},
			scope: this
		}) ;
	},
	handleTransactionSubmit: function(values) {
		this.openBlank() ;
		// resume session OR list ?
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'gun_t70_transactionPostAction',
				
				_transaction_id: this._run_tracy70transactionId,
				_subaction: 'submit',
				data: Ext.JSON.encode(values)
			},
			success: function(response) {
				var ajaxResponse = Ext.decode(response.responseText) ;
				if( ajaxResponse.success == false ) {
					var error = ajaxResponse.success || 'Manifest build error' ;
					Ext.MessageBox.alert('Error',error, function(){this.openTransactionBuild(this._run_tracy70transactionId);},this) ;
					return ;
				}
				this.openTransactionScanEnd( ajaxResponse.data ) ;
			},
			callback: function() {},
			scope: this
		}) ;
	},
	handleTransactionPrint: function(formData) {
		this.showLoadmask() ;
		var ajaxParams = {
			_moduleId: 'spec_dbs_tracy',
			_action: 'gun_t70_transactionPostAction',
			
			_transaction_id: this._run_tracy70transactionId,
			_subaction: 'print',
			printerUri: this._printerUri
		};
		if( formData.primary_key ) {
			ajaxParams[formData.primary_key.name] = formData.primary_key.value ;
		}
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: ajaxParams,
			success: function(response) {
				var ajaxResponse = Ext.decode(response.responseText) ;
				if( ajaxResponse.success == false ) {
					return ;
				}
				return ;
			},
			callback: function() {
				this.hideLoadmask() ;
			},
			scope: this
		}) ;
	},
}) ;
