Ext.define('Optima5.Modules.Spec.DbsTracy.GunTracy70transactionBuildAog',{
	extend:'Ext.panel.Panel',
	requires: [
		'Ext.grid.column.Action',
		'Optima5.Modules.Spec.DbsTracy.GunTracy70transactionBuildWarning'
	],
	mixins: {
		gunfilter: 'Optima5.Modules.Spec.DbsTracy.GunFiltersMixin',
		focusable: 'Optima5.Modules.Spec.DbsTracy.GunFocusableMixin',
		loadmaskable: 'Optima5.Modules.Spec.DbsTracy.GunLoadmaskableMixin'
	},
	
	_transactionId: null,
	
	initComponent: function(){
		Ext.apply(this,{
			tbar: [{
				icon: 'images/op5img/ico_back_16.gif',
				text: '<u>Back</u>',
				handler: function(){
					this.doQuit() ;
				},
				scope: this
			},'->',{
				itemId: 'btnFilters',
				iconCls: 'op5-spec-dbstracy-gun-filters',
				textBase: 'Filters',
				text: '',
				handler: function() {
					this.openFilters() ;
				},
				scope: this
			}],
			bbar : [{
				xtype:'textfield',
				itemId: 'txtScan',
				flex:1,
				listeners : {
					specialkey: function(field, e){
						if (e.getKey() == e.ENTER) {
							this.handleScan() ;
						}
					},
					change: {
						fn: function(field) {
							//this.handleScan(true) ;
						},
						buffer: 500,
						scope: this
					},
					scope: this
				}
			},{
				xtype:'button',
				text: 'Send',
				handler : function(button,event) {
					this.handleScan() ;
				},
				scope : this
			}],
			layout: {
				type: 'vbox',
				align: 'stretch'
			},
			items: [{
				flex: 1,
				xtype: 'grid',
				store: {
					model: 'DbsTracyGun70transactionSummary',
					sorters: [{
						property: 'id_hat',
						direction: 'ASC'
					}],
					groupField: 'aog_adrZone',
					proxy: {
						type: 'memory',
						reader: {
							type: 'json'
						}
					}
				},
				columns: [{
					xtype: 'actioncolumn',
					align: 'center',
					width: 36,
					items: [{
						getClass: function(v,metadata,r) {
							return 'op5-spec-dbstracy-gun-warning-off' ;
						},
					}]
				},{
					dataIndex: 'aog_adrZone',
					width: 60,
					text: 'Zone',
				},{
					dataIndex: 'aog_adrId',
					width: 70,
					text: 'Adr',
				},{
					dataIndex: 'id_dn',
					width: 80,
					text: 'DN/Inv.',
				},{
					dataIndex: 'ref_invoice',
					text: 'Facture',
				},{
					dataIndex: 'atr_consignee_txt',
					width: 150,
					text: 'Consignee'
				},{
					//dataIndex: 'count_parcel',
					align: 'center',
					width: 75,
					text: 'Packs',
					renderer: function(v,metadata,r) {
						var v = r.get('count_parcel_scan') + '/' + r.get('count_parcel_total') ;
						if( r.get('count_parcel_trsptpartial') ) {
							metadata.style += 'color: orange;' ;
							metadata.style += 'font-weight: bold;' ;
						} else if( r.get('count_parcel_scan') == 0 ) {
							metadata.style += 'color: #999999;' ;
						} else if( r.get('count_parcel_scan') < r.get('count_parcel_total') ) {
							metadata.style += 'color: red;' ;
							metadata.style += 'font-weight: bold;' ;
						} else {
							metadata.style += 'color: green;' ;
							metadata.style += 'font-weight: bold;' ;
						}
						return v ;
					}
				},{
					align: 'center',
					dataIndex: 'vol_kg',
					text: 'Weight(kg)',
					renderer: function(v) {
						if( v<=0 ) {
							return 'N/A' ;
						}
						return v ;
					}
				},{
					dataIndex: 'mvt_carrier',
					width: 100,
					text: 'Carrier',
					renderer: function(v,m,r) {
						return r.get('mvt_carrier_txt') ;
					}
				}],
				viewConfig: {},
				features: [{
					ftype: 'grouping',
					hideGroupedHeader: true,
					enableGroupingMenu: false,
					enableNoGroups: false,
					groupHeaderTpl:Ext.create('Ext.XTemplate',
						'<div>{[this.renderer(values)]}</div>',
						{
							renderer: function(values) {
								if( values.rows.length == 0 ) {
									return '' ;
								}
								if( Ext.isEmpty(values.rows[0].data[values.groupField]) ) {
									return 'Non défini' ;
								}
								return values.rows[0].data[values.groupField] ;
							}
						}
					)
				}]
			}]
		});
		this.callParent() ;
		this.mixins.loadmaskable.constructor.call(this);
		this.mixins.focusable.constructor.call(this);
		this.mixins.gunfilter.constructor.call(this);
		
		this.registerFocusableComponent( this.down('#txtScan') ) ;
		this.mon(this.optimaModule,'op5broadcast',this.onCrmeventBroadcast,this) ;
		
		this.onFilterChanged() ; //will call doLoad
	},
	onCrmeventBroadcast: function(crmEvent,eventParams) {
		switch( crmEvent ) {
			case 'scan' :
				this.fireEvent('scan',this,eventParams.scanResult) ;
				break ;
		}
	},
	handleScan: function(dontSend) {
		var scanval = this.down('#txtScan').getValue() ;
		scanval = scanval.trim().toUpperCase() ;
		if( Ext.isEmpty(scanval) ) {
			return ;
		}
		
		this.fireEvent('scan',this,scanval) ;
		if(!dontSend) {
			//this.fireEvent('brtbegin',this,transferligFilerecordId) ;
		}
	},
	
	openFilters: function() {
		this.openModalFilters() ;
	},
	onFilterChanged: function() {
		// update Button
		var filterArr = [] ;
		Ext.Object.each( this.getFilterValues(), function(k,v) {
			filterArr.push(v) ;
		});
		this.down('#btnFilters').setText( Ext.isEmpty(filterArr) ? this.down('#btnFilters').textBase : '<b>'+filterArr.join(',')+'</b>' ) ;
		
		this.doLoad() ;
	},
	
	doLoad: function() {
		this.showLoadmask() ;
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'gun_t70_transactionGetSummary',
				_transaction_id: this._transactionId
			},
			success: function(response) {
				var ajaxResponse = Ext.decode(response.responseText) ;
				if( ajaxResponse.success == false ) {
					var error = ajaxResponse.success || 'File not saved !' ;
					Ext.MessageBox.alert('Error',error, function(){this.doQuit;},this) ;
					return ;
				}
				this.onLoad( ajaxResponse.data ) ;
			},
			callback: function() {
				this.hideLoadmask() ;
			},
			scope: this
		}) ;
	},
	onLoad: function( ajaxData ) {
		var storeFilters = [] ;
		Ext.Object.each( this.getFilterValues(), function(k,v) {
			switch( k ) {
				case 'filter_soc' :
					storeFilters.push({
						property: 'id_soc',
						value: v
					});
					break ;
				case 'filter_adrZone' :
					storeFilters.push({
						property: 'aog_adrZone',
						value: v
					});
					break ;
				default :
					return ;
			}
		});
		
		var store = this.down('grid').getStore() ;
		store.loadData(ajaxData.grid) ;
		store.clearFilter() ;
		if( !Ext.isEmpty(storeFilters) ) {
			store.filter(storeFilters) ;
		}
	},
	
	handleAbort: function(dosave=false) {
		this.showLoadmask() ;
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'gun_t70_transactionPostAction',
				
				_transaction_id: this._transactionId,
				_subaction: dosave ? 'abort_save' : 'abort',
			},
			success: function(response) {
				var ajaxResponse = Ext.decode(response.responseText) ;
				if( ajaxResponse.success == false ) {
					var error = ajaxResponse.success || 'File not saved !' ;
					return ;
				}
				
				this.doQuit() ;
			},
			callback: function() {
				this.hideLoadmask() ;
			},
			scope: this
		}) ;
	},
	handleValidate: function() {
		this.fireEvent('validate',this) ;
	},
	
	doQuit: function() {
		this.fireEvent('quit',this) ;
	},
	onDestroy: function() {
		if( this.floatingPanel ) {
			this.floatingPanel.destroy() ;
		}
	}
}) ;
