Ext.define('Optima5.Modules.Spec.DbsTracy.GunTracy80Romain', {
    extend: 'Ext.panel.Panel',
    xtype: 'guntracy80romain',

    // Scope CSS pour ne PAS impacter le desktop
    id: 'guntracy80-root',
    cls: 'zebra-scope zebra-mode',

    zebraMode: true,

    bodyStyle: { backgroundColor: '#167D86' },
    layout: { type: 'vbox', align: 'stretch' },
    scrollable: 'y',
    bodyPadding: 16,
    title: 'Catalogue d’apps',

    buildNativeData: function () {
        return [
            { id: 1, name: 'Tracy', team: 'IT', platform: 'Android', iconUrl: 'images/modules/dbstracy-mainmenu-logo-tracy.png', updatedAt: '2025-09-20', usage: 90 },
            { id: 2, name: 'EzeeR', team: 'BI', platform: 'iOS',     iconUrl: 'images/icons/ico_ezeer_48.png',                   updatedAt: '2025-09-28', usage: 70 },
        ];
    },
    buildWebData: function () {
        return [
            { id: 101, name: 'Tracy Live Tracking', team: 'PMO', type: 'Web', iconUrl: 'images/modules/dbstracy-mainmenu-logo-tracy.png', updatedAt: '2025-09-18', usage: 60 },
            { id: 102, name: 'EASA vs BL',          team: 'BI',  type: 'Web', iconUrl: 'images/modules/dbstracy-mainmenu-logo-tracy.png', updatedAt: '2025-09-22', usage: 80 },
        ];
    },

    initComponent: function () {
        var me = this;

        // UA Zebra si tu veux t’en servir plus tard
        var ua = (navigator.userAgent || '').toLowerCase();
        var isZebraUA = /zebra|enterprisebrowser|eb/.test(ua);
        var zebra = (me.zebraMode === null) ? isZebraUA : !!me.zebraMode;

        // Stores
        me.nativeStore = Ext.create('Ext.data.Store', {
            fields: ['id','name','team','platform','iconUrl','updatedAt','usage'],
            data: me.buildNativeData(),
            sorters: [{ sorterFn: function(a,b){ return a.get('name').localeCompare(b.get('name')); } }]
        });

        me.webStore = Ext.create('Ext.data.Store', {
            fields: ['id','name','team','type','iconUrl','updatedAt','usage'],
            data: me.buildWebData(),
            sorters: [{ sorterFn: function(a,b){ return a.get('name').localeCompare(b.get('name')); } }]
        });

        // UI (pas de dockedItems sur gun, on garde simple et lisible)
        Ext.apply(me, {
            items: [{
                xtype: 'container',
                itemId: 'mainContent',
                padding: 16,
                layout: { type: 'vbox', align: 'stretch' },
                items: [
                    // ---------- Apps natives ----------
                    {
                        xtype: 'container',
                        cls: 'romain-section-hdr',
                        layout: { type: 'hbox', align: 'middle' },
                        items: [{ xtype: 'component', html: '<h2>Apps natives</h2>', flex: 1 }]
                    },
                    {
                        xtype: 'dataview',
                        itemId: 'nativeView',
                        cls: 'romain-grid',
                        store: me.nativeStore,
                        itemSelector: 'div.romain-card',
                        tpl: new Ext.XTemplate(
                            '<div class="cards-flex">',
                              '<tpl for=".">',
                                '<div class="romain-card romain-card--tile" role="button" tabindex="0" aria-label="Ouvrir {name}">',
                                  '<div class="romain-card__tile">',
                                    '<div class="romain-card__icon romain-card__icon--img">',
                                      '<img src="{iconUrl}" alt="{name}" loading="lazy"',
                                      ' onerror="this.onerror=null;this.src=\'images/modules/dbstracy-mainmenu-logo-tracy.png\'">',
                                    '</div>',
                                    '<div class="romain-card__title romain-card__title--center">{name}</div>',
                                    '<div class="romain-card__meta romain-card__meta--muted">{[values.platform ? (values.platform + " · " + values.team) : ("Web · " + values.team)]}</div>',
                                  '</div>',
                                '</div>',
                              '</tpl>',
                            '</div>',
                            '<tpl if="values.length === 0"><div class="romain-empty">Aucune app trouvée</div></tpl>'
                        )
                    },

                    { xtype: 'component', html: '<div class="romain-sep"></div>' },

                    // ---------- Web apps ----------
                    {
                        xtype: 'container',
                        cls: 'romain-section-hdr',
                        layout: { type: 'hbox', align: 'middle' },
                        items: [{ xtype: 'component', html: '<h2>Web apps</h2>', flex: 1 }]
                    },
                    {
                        xtype: 'dataview',
                        itemId: 'webView',
                        cls: 'romain-grid',
                        store: me.webStore,
                        itemSelector: 'div.romain-card',
                        tpl: new Ext.XTemplate(
                            '<div class="cards-flex">',
                              '<tpl for=".">',
                                '<div class="romain-card romain-card--tile" role="button" tabindex="0" aria-label="Ouvrir {name}">',
                                  '<div class="romain-card__tile">',
                                    '<div class="romain-card__icon romain-card__icon--img">',
                                      '<img src="{iconUrl}" alt="{name}" loading="lazy"',
                                      ' onerror="this.onerror=null;this.src=\'images/modules/dbstracy-mainmenu-logo-tracy.png\'">',
                                    '</div>',
                                    '<div class="romain-card__title romain-card__title--center">{name}</div>',
                                    '<div class="romain-card__meta romain-card__meta--muted">Web · {team}</div>',
                                  '</div>',
                                '</div>',
                              '</tpl>',
                            '</div>',
                            '<tpl if="values.length === 0"><div class="romain-empty">Aucune app trouvée</div></tpl>'
                        )
                    }
                ]
            }]
        });

        me.callParent();
    },

    // (Tri/filtre gardés si tu veux les réactiver plus tard)
    getQuery: function () {
        var f = this.down('#searchField');
        return (f && f.getValue ? (f.getValue() || '').toLowerCase() : '');
    },
    applyFilters: function () {
        var q = this.getQuery();
        this.nativeStore.clearFilter(true);
        this.nativeStore.filterBy(function (rec) {
            var hay = (rec.get('name') + ' ' + rec.get('team') + ' ' + (rec.get('platform') || '')).toLowerCase();
            return (!q || hay.indexOf(q) !== -1);
        });
        this.webStore.clearFilter(true);
        this.webStore.filterBy(function (rec) {
            var hay = (rec.get('name') + ' ' + rec.get('team')).toLowerCase();
            return (!q || hay.indexOf(q) !== -1);
        });
    },
    sortNative: function (combo, val) {
        var st = this.nativeStore; st.getSorters().clear();
        if (val === 'recent') st.sort([{ property: 'updatedAt', direction: 'DESC' }]);
        else if (val === 'usage') st.sort([{ property: 'usage', direction: 'DESC' }]);
        else st.sort([{ sorterFn: function(a,b){ return a.get('name').localeCompare(b.get('name')); } }]);
    },
    sortWeb: function (combo, val) {
        var st = this.webStore; st.getSorters().clear();
        if (val === 'recent') st.sort([{ property: 'updatedAt', direction: 'DESC' }]);
        else if (val === 'usage') st.sort([{ property: 'usage', direction: 'DESC' }]);
        else st.sort([{ sorterFn: function(a,b){ return a.get('name').localeCompare(b.get('name')); } }]);
    }
});