Ext.define('Optima5.Modules.Spec.DbsTracy.MainPanel',{
	extend:'Ext.tab.Panel',
	requires:[
		'Optima5.Modules.Spec.DbsTracy.HelperCache',
		'Optima5.Modules.Spec.DbsTracy.MainMenu',
		'Optima5.Modules.Spec.DbsTracy.FilesGrid',
		'Optima5.Modules.Spec.DbsTracy.TrsptFilePanel',
		'Optima5.Modules.Spec.DbsTracy.OrderFilePanel',
		'Optima5.Modules.Spec.DbsTracy.HatFilePanel',
		'Optima5.Modules.Spec.DbsTracy.AttachmentsPanel',
		'Optima5.Modules.Spec.DbsTracy.AttachmentViewerWindow',
		'Optima5.Modules.Spec.DbsTracy.UploadForm',
		'Optima5.Modules.Spec.DbsTracy.ReportForm',
		'Optima5.Modules.Spec.DbsTracy.LivePanel',
		'Optima5.Modules.Spec.DbsTracy.GunPanel',
		'Optima5.Modules.Spec.DbsTracy.AogPanel',
		'Optima5.Modules.Spec.DbsTracy.WarningsListPanel',
		'Optima5.Modules.Spec.DbsTracy.TestRomainPanel',
	],
	
	_readonlyMode: false,
	
	initComponent: function() {
		var me = this ;
			
		Ext.apply(me,{
			layout:'fit',
			items:[{
				xtype:'box',
				cls:'op5-spec-dbstracy-mainmenu',
				flex:1,
				html: '<div class="op5-spec-dbstracy-logo"></span>' 
			}]
		});
		
		this.on('afterrender', function(){
			Ext.defer(this.onEndAnimation, 500, this) ;
		}, me) ;
		
		this.callParent() ;
		this.mon(this.optimaModule,'op5broadcast',this.onCrmeventBroadcast,this) ;
	},
	startAnimation: function() {
		var logoEl = Ext.get( Ext.DomQuery.selectNode('div.op5-spec-dbstracy-logo') );
		logoEl.animate({
			duration: 1000,
			to: {
				opacity: 1
			}
		});
		Ext.defer( this.onEndAnimation, 2000, this) ;
	},
	onEndAnimation: function() {
		var me = this ;
		
		var helperCache = Optima5.Modules.Spec.DbsTracy.HelperCache ;
		helperCache.init(me.optimaModule) ;
		if( helperCache.isReady ) {
			this.switchToMainMenu() ;
		} else {
			this.mon(helperCache,'ready',function() {
				this.switchToMainMenu() ;
			},me,{single:true}) ;
		}
	},
	switchToMainMenu: function() {
		if( Optima5.Modules.Spec.DbsTracy.HelperCache.authHelperQueryPageOnly('AOG') ) {
			this.switchToAogMode() ;
			return ;
		}
			
		this._readonlyMode = Optima5.Modules.Spec.DbsTracy.HelperCache.authHelperIsReadOnly() ;
		this._readonlySoc = this._readonlyMode ? Optima5.Modules.Spec.DbsTracy.HelperCache.authHelperGetSoc() : null ;
		
		if( this._readonlyMode ) {
			//return this.openAppPanel('Optima5.Modules.Spec.DbsTracy.FilesGrid',{}) ;
		}
		
		var me = this ;
		var mainMenuView = Ext.create('Optima5.Modules.Spec.DbsTracy.MainMenu',{
			listeners: {
				actionclick: function( view, actionCode ) {
					me.onActionClick(actionCode) ;
				},
				scope: me
			}
		}) ;
		
		this.removeAll() ;
		this.add( {
			_mainTab: true,
			xtype: 'panel',
			title: 'Menu',
			layout: 'fit',
			cls:'op5-spec-dbslam-mainmenu',
			items: [mainMenuView],
			border: false,
			listeners: {
				beforeclose: this.onBeforeCloseMain,
				destroy: this.onCloseMain,
				scope: this
			}
		}) ;
		this.setActiveTab(0) ;
	},
	onActionClick: function( actionCode ) {
		var me = this ;
		//console.log("Action: "+actionCode) ;
		
		switch( actionCode ) {
			case 'attachments' :
				return me.openAppPanel('Optima5.Modules.Spec.DbsTracy.AttachmentsPanel','Attachments') ;
			case 'files_order' :
				return me.openFiles('order') ;
			case 'files_trspt' :
				return me.openFiles('trspt') ;
			case 'trspt_create' :
				return me.optimaModule.postCrmEvent('opentrspt',{trsptNew:true}) ;
			case 'order_create' :
				return me.optimaModule.postCrmEvent('openorder',{orderNew:true}) ;
			case 'form_upload' :
				return me.openUploadPopup() ;
			case 'form_report' :
				return me.openReportPopup() ;
			case 'panel_live' :
				return me.openLivePanel() ;
			case 'form_copydemo' :
				return me.askCopyDemo() ;
			case 'aog_panel' :
				return me.openAppPanel('Optima5.Modules.Spec.DbsTracy.AogPanel','AOG Panel') ;
			case 'warnings' :
				return me.openTicketsList(null);
			case 'test_romain' :
				return me.openAppPanel('Optima5.Modules.Spec.DbsTracy.TestRomainPanel','Attachments') ;
			default :
				return ;
		}
	},
	
	switchToAogMode: function() {
		var me = this ;
		
		options = {} ;
		Ext.apply(options,{
			optimaModule: me.optimaModule,
			_readonlyMode: this._readonlyMode,
			_readonlySoc: this._readonlySoc,
			_singlePage: true,
		}) ;
		
		var panel = Ext.create('Optima5.Modules.Spec.DbsTracy.AogPanel',options) ;
		
		this.removeAll() ;
		this.add( panel ) ;
	},
	
	openAppPanel: function( className, tabTitle, params={}, allowDup=false ) {
		// recherche d'une fenetre deja ouverte
		var existingPanel = null ;
		this.eachPanel(function(pnl){
			if( !(Ext.getClassName(pnl) == className) ) {
				return true ;
			}
			switch( className ) {
				case 'Optima5.Modules.Spec.DbsTracy.FilesGrid' :
					if( params.defaultViewMode == pnl.defaultViewMode ) {
						break ;
					}
					return true ;
				case 'Optima5.Modules.Spec.DbsTracy.OrderFilePanel' :
					if( params._orderFilerecordId == pnl._orderFilerecordId ) {
						break ;
					}
					return true ;
				case 'Optima5.Modules.Spec.DbsTracy.HatFilePanel' :
					if( params._hatFilerecordId == pnl._hatFilerecordId ) {
						break ;
					}
					return true ;
				case 'Optima5.Modules.Spec.DbsTracy.TrsptFilePanel' :
					if( params._trsptFilerecordId == pnl._trsptFilerecordId ) {
						break ;
					}
					return true ;
			}
			existingPanel = pnl ;
			return false ;
		},this) ;
		if( !allowDup && (existingPanel != null) ) {
			this.focusPanel(existingPanel) ;
			return existingPanel ;
		}
		
		//create
		var pnl = Ext.create(className,Ext.apply(params,{
			optimaModule: this.optimaModule,
			_readonlyMode: this._readonlyMode,
			_readonlySoc: this._readonlySoc,
			
			title: tabTitle || '...',
			closable: true,
			
			border: false,
			
			listeners: {
				candestroy: function(p) {
					p.destroy() ;
				}
			}
		})) ;
		//open
		this.addPanel(pnl) ;
		this.focusPanel(pnl) ;
		return pnl;
	},
	
	
	onCrmeventBroadcast: function(crmEvent, eventParams) {
		switch( crmEvent ) {
			case 'datachange' :
				break ;
			case 'opentrspt' :
				return this.openTrsptFile( eventParams.trsptNew ? 0 : eventParams.trsptFilerecordId, eventParams.trsptNew_orderRecords ) ;
			case 'openorder' :
				return this.openOrderFile( eventParams.orderNew ? 0 : eventParams.orderFilerecordId ) ;
			case 'openhat' :
				return this.openHatFile( eventParams.hatNew ? 0 : eventParams.hatFilerecordId, eventParams.hatNew_orderRecords ) ;
				
			case 'opengun' :
				this.openGunWindow(eventParams) ;
				break ;
				
			case 'opentickets' :
				return this.openTicketsList(eventParams.filterCfg) ;
				break ;
			
			default: break ;
		}
	},
	openFiles: function( viewMode ) {
		var title='', allowDup=true ;
		switch( viewMode ) {
			case 'order' :
				title = 'Orders';
				break ;
			case 'trspt' :
				title = 'Transports';
				break ;
		}
		this.openAppPanel( 'Optima5.Modules.Spec.DbsTracy.FilesGrid', title, {defaultViewMode: viewMode},allowDup);
	},
	openTicketsList: function(filterCfg) {
		var pnl = this.openAppPanel('Optima5.Modules.Spec.DbsTracy.WarningsListPanel','Warnings') ;
		if( filterCfg ) {
			pnl.setFilters(filterCfg) ;
		}
	},
	openTrsptFile: function(trsptFilerecordId, trsptNew_orderRecords) {
		if( trsptFilerecordId === null ) {
			return ;
		}
		this.openAppPanel( 'Optima5.Modules.Spec.DbsTracy.TrsptFilePanel','', {
			_trsptNew: (trsptFilerecordId==0),
			_trsptFilerecordId: trsptFilerecordId,
			_trsptNew_orderRecords: trsptNew_orderRecords,
		});
	},
	openOrderFile: function(orderFilerecordId) {
		if( orderFilerecordId === null ) {
			return ;
		}
		this.openAppPanel( 'Optima5.Modules.Spec.DbsTracy.OrderFilePanel','', {
			_orderNew: (orderFilerecordId==0),
			_orderFilerecordId: orderFilerecordId,
		});
	},
	openHatFile: function(hatFilerecordId, hatNew_orderRecords) {
		if( hatFilerecordId === null ) {
			return ;
		}
		this.openAppPanel( 'Optima5.Modules.Spec.DbsTracy.HatFilePanel','', {
			_hatNew: (hatFilerecordId==0),
			_hatFilerecordId: hatFilerecordId,
			_hatNew_orderRecords: hatNew_orderRecords,
		});
	},
	openUploadPopup: function() {
		this.getEl().mask() ;
		// Open panel
		var createPanel = Ext.create('Optima5.Modules.Spec.DbsTracy.UploadForm',{
			optimaModule: this.optimaModule,
			width:400, // dummy initial size, for border layout to work
			height:null, // ...
			floating: true,
			draggable: true,
			resizable: true,
			renderTo: this.getEl(),
			tools: [{
				type: 'close',
				handler: function(e, t, p) {
					p.ownerCt.destroy();
				},
				scope: this
			}]
		});
		createPanel.on('saved', function(p) {
			this.doTreeLoad() ;
		},this,{single:true}) ;
		createPanel.on('destroy',function(p) {
			this.getEl().unmask() ;
			this.floatingPanel = null ;
		},this,{single:true}) ;
		
		createPanel.show();
		createPanel.getEl().alignTo(this.getEl(), 'c-c?');
	},
	openReportPopup: function() {
		this.getEl().mask() ;
		// Open panel
		var createPanel = Ext.create('Optima5.Modules.Spec.DbsTracy.ReportForm',{
			optimaModule: this.optimaModule,
			width:400, // dummy initial size, for border layout to work
			height:null, // ...
			floating: true,
			draggable: true,
			resizable: true,
			renderTo: this.getEl(),
			tools: [{
				type: 'close',
				handler: function(e, t, p) {
					p.ownerCt.destroy();
				},
				scope: this
			}]
		});
		createPanel.on('saved', function(p) {
			this.doTreeLoad() ;
		},this,{single:true}) ;
		createPanel.on('destroy',function(p) {
			this.getEl().unmask() ;
			this.floatingPanel = null ;
		},this,{single:true}) ;
		
		createPanel.show();
		createPanel.getEl().alignTo(this.getEl(), 'c-c?');
	},
	openLivePanel: function() {
		// recherche d'une fenetre deja ouverte
		var doOpen = true ;
		this.optimaModule.eachWindow(function(win){
			if( win instanceof Optima5.Modules.Spec.DbsTracy.LivePanel ) {
				win.show() ;
				win.focus() ;
				doOpen = false ;
				return false ;
			}
		},this) ;
		if( !doOpen ) {
			return ;
		}
		
		// new window
		this.optimaModule.createWindow({
			title: 'Live Trspt Validation',
			width:450,
			height:500,
			iconCls: 'op5-crmbase-dataformwindow-icon',
			animCollapse:false,
			
				optimaModule: this.optimaModule,
				listeners: {
					candestroy: function(w) {
						w.close() ;
					}
				}
		},Optima5.Modules.Spec.DbsTracy.LivePanel) ;
	},
	
	
	openGunWindow: function() {
		// recherche d'une fenetre deja ouverte
		var doOpen = true ;
		this.optimaModule.eachWindow(function(win){
			if( win.itemId == 'windowGun' ) {
				win.show() ;
				win.focus() ;
				doOpen = false ;
				return false ;
			}
		},this) ;
		if( !doOpen ) {
			return ;
		}
		
		// new window
		this.optimaModule.createWindow({
			title: 'Gun Interface',
			itemId: 'windowGun',
			width:375,
			height:500,
			iconCls: 'op5-crmbase-authandroidwindow-icon',
			animCollapse:false,
			layout: 'fit',
			items:[Ext.create('Optima5.Modules.Spec.DbsTracy.GunPanel',{
				border: false,
				optimaModule: this.optimaModule,
				listeners: {
					candestroy: function(w) {
						w.close() ;
					}
				}
			})]
		}) ;
	},
	
	askCopyDemo: function() {
		Ext.MessageBox.confirm('Confirmation','Réinitialisation base démo ?',function(btn) {
			if( btn=='yes' ) {
				this.doCopyDemo() ;
			}
		},this) ;
	},
	doCopyDemo: function() {
		var msgbox = Ext.Msg.wait('Please wait...');
		this.optimaModule.getConfiguredAjaxConnection().request({
			timeout: (10 * 60 * 1000),
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'upload_tmpCloneActiveFetch'
			},
			success: function(response) {
				msgbox.close() ;
				var ajaxResponse = Ext.decode(response.responseText) ;
				if( ajaxResponse.success == false ) {
					Ext.MessageBox.alert('Error','Error') ;
					return ;
				}
				Ext.MessageBox.alert('Success','Success') ;
			},
			callback: function() {
			},
			scope: this
		}) ;
	},
	
	
	eachPanel: function(fn,scope) {
		this.items.each(fn,scope) ;
	},
	focusPanel: function(pnl) {
		this.setActiveItem(pnl) ;
	},
	addPanel: function(panel) {
		this.add(panel) ;
	},
	closeActive: function() {
		if( this.getActiveTab().closable ) {
			this.getActiveTab().close() ;	
		}
	},
	onBeforeCloseMain: function(tab) {
		if( this.allowClose ) {
			return true ;
		}
		var nbOpen = this.items.getCount() ;
		if( nbOpen > 1 ) {
			return false ;
		}
		Ext.Msg.confirm('Fermeture', 'Quitter l\'application ?', function(btn){
			if( btn == 'yes' ){
				this.allowClose = true ;
				tab.close() ;
			}
		},this) ;
		return false ;
	},
	onCloseMain: function() {
		this.destroy() ;
	}
}) ;
