Ext.define('Optima5.Modules.Spec.DbsTracy.OrderAttachmentsDataview',{
	extend:'Ext.panel.Panel',
	
	_readonlyMode: false,
	
	initComponent: function() {
		var me = this ;
		
		if( (me.optimaModule) instanceof Optima5.Module ) {} else {
			Optima5.Helper.logError('Spec:DbsTracy:OrderAttachmentsDataview','No module reference ?') ;
		}
		
		var map_attachCatg_color = {};
		var filterMenu = [] ;
		Ext.Array.each( Optima5.Modules.Spec.DbsTracy.HelperCache.getListData('LIST_ATTACH'), function(r) {
			map_attachCatg_color[r.id] = r.color ;
			filterMenu.push({
				_attachCatg: r.id,
				text: r.text,
				icon: Optima5.Modules.Spec.DbsTracy.HelperCache.getDotImgSrc(r.color),
			});
		}) ;
		
		Ext.apply(me,{
			title: 'Attachments',
			layout: 'fit',
			tbar: [{
				itemId: 'tbFilter',
				_attachCatg: null,
				//icon: 'op5-spec-mrfoxy-promorow-action-icon-attachments',
				//text: 'Filter',
				_emptyText: 'Filter',
				_emptyIcon: 'images/op5img/ico_loupe_16.png',
				menu: {
					defaults: {
						handler:function(menuitem) {
							this.down('#tbFilter')._attachCatg = menuitem._attachCatg;
							this.applyFilters();
						},
						scope:this
					},
					items: Ext.Array.merge([{
						_attachCatg: null,
						text: '<i>All categories</i>',
					}],filterMenu,[{
						xtype: 'menuseparator',
						handler: null,
					},{
						xtype: 'menucheckitem',
						text: 'Show hidden/obsolete',
						handler: null,
						checkHandler: function(chk,checked) {
							this.applyFilters();
						},
						scope: this
					}])
				}
			},'-',{
				itemId: 'tbUpload',
				iconCls: 'op5-spec-mrfoxy-promorow-action-icon-attachments',
				text: 'Upload',
				menu: [{
					xtype: 'form',
					frame: true,
					defaults: {
							anchor: '100%',
							allowBlank: false,
							msgTarget: 'side',
							labelWidth: 50
					},
					//bodyPadding: '0 0 0 0',
					items: [{
						xtype: 'filefield',
						width: 450,
						emptyText: 'Select an image',
						fieldLabel: 'Photo',
						name: 'photo-filename',
						buttonText: '',
						buttonConfig: {
							iconCls: 'upload-icon'
						},
						listeners: {
							change: {
								fn: this.doUpload,
								scope:this
							}
						}
					}]
				}]
			},'->',{
				iconCls: 'op5-crmbase-datatoolbar-file-export-gallery',
				text: 'Get ZIP',
				handler: function(){
					this.handleDownloadZipArchive() ;
				},
				scope: this
			}],
			items:[{
				_map_attachCatg_color: map_attachCatg_color,
				
				xtype: 'dataview',
				store: {
					model: 'DbsTracyAttachmentModel',
					data: [],
					proxy: {
						type: 'memory',
						reader: {
							type: 'json'
						}
					},
					sorters: [{
						property: 'attachment_filerecord_id',
						direction: 'DESC',
					}],
				},
				//frame: true,
				//autoScroll:true,
				//overflowX: 'auto',
				//style: {
					//whiteSpace: 'nowrap'
				//},
				scrollable: 'vertical',

				tpl:[
					'<tpl for=".">',
						'<div class="op5-spec-mrfoxy-attachments-item thumb-box op5-spec-dbstracy-thumbox">',
							'<tpl if="thumb_dotimgsrc">',
								'<div class="op5-spec-dbstracy-thumbox-dot"><img src="{thumb_dotimgsrc}"/></div>',
							'</tpl>',
							'<div class="{thumb_date_cls}">{thumb_date}</div>',
							'<a href="#">',
								'<img src="{thumb_url}"/>',
							'</a>',
							'<div>{thumb_caption}</div>',
						'</div>',
					'</tpl>'
				],
				trackOver: true,
				overItemCls: 'x-item-over',
				itemSelector: 'div.thumb-box',
				prepareData: function(data) {
					var getParams = me.optimaModule.getConfiguredAjaxParams() ;
					Ext.apply( getParams, {
						media_id: data.attachment_media_id,
						thumb: true
					});
					
					Ext.apply(data, {
						thumb_date: Ext.util.Format.date(data.attachment_date,'d/m/Y'),
						thumb_url: 'server/backend_media.php?' + Ext.Object.toQueryString(getParams),
						thumb_caption: Ext.util.Format.nl2br( Ext.String.htmlEncode( data.attachment_txt ) ),
						thumb_date_cls: data.attachment_discard ? 'op5-spec-dbstracy-thumbox-stroke' : '',
					});
					if( data.attachment_catg ) {
						var attachCatg = data.attachment_catg,
							attachColor = this._map_attachCatg_color[attachCatg];
						if( attachColor ) {
							var imgDotSrc = Optima5.Modules.Spec.DbsTracy.HelperCache.getDotImgSrc(attachColor);
							Ext.apply(data, {
								thumb_dotimgsrc: imgDotSrc
							}) ;
						}
					}
					return data;
				},
				listeners: {
					itemcontextmenu: {
						fn:function(view, record, item, index, event) {
							//console.log('okokokok') ;
							
							var contextMenuItems = new Array() ;
							contextMenuItems.push({
								iconCls: 'icon-fullscreen',
								text: 'Details',
								handler : function() {
									// console.log( 'Create child node of '+record.get('treenode_key') ) ;
									me.handleEditAttachment(record.get('attachment_filerecord_id')) ;
								},
								scope : me
							});
							contextMenuItems.push('-') ;
							contextMenuItems.push({
								iconCls: 'icon-save',
								text: 'Download file',
								handler : function() {
									me.handleDownload(record.get('attachment_media_id')) ;
								},
								scope : me
							});
							
							var contextMenu = Ext.create('Ext.menu.Menu',{
								items : contextMenuItems,
								listeners: {
									hide: function(menu) {
										Ext.defer(function(){menu.destroy();},10) ;
									}
								}
							}) ;
							
							contextMenu.showAt(event.getXY());
							
						},
						scope:me
					},
					itemdblclick: {
						fn:function(view, record, item, index, event) {
							me.handleEditAttachment(record.get('attachment_filerecord_id')) ;
						},
						scope:me
					},
					render: { 
						fn: this.onDataviewRender,
						scope: me
					}
				}
			}]
		});
		
		this.callParent() ;
		this.applyFilters();
		if( this._readonlyMode ) {
			//this.down('toolbar').setVisible(false) ;
			this.down('toolbar').down('#tbUpload').setVisible(false) ;
		}
	},
	onDataviewRender: function(view) {
		var me = this ;
		
		var viewDropTargetEl =  view.getEl();

		var viewDropTarget = Ext.create('Ext.dd.DropTarget', viewDropTargetEl, {
			ddGroup: 'AttachmentDD'+me.optimaModule.sdomainId,
			notifyEnter: function(ddSource, e, data) {
				var selectedRecord = ddSource.dragData.records[0];
				if( !selectedRecord ) {
					return ;
				}
				//Add some flare to invite drop.
				view.getEl().stopAnimation();
				view.getEl().highlight();
				this.dropStatus = this.dropAllowed ;
				return  ;
			},
			notifyOver: function(ddSource, e, data) {
				return this.dropStatus ;
			},
			notifyDrop: function(ddSource, e, data){
					// Reference the record (single selection) for readability
					var selectedRecord = ddSource.dragData.records[0];
					me.handleAssociate(selectedRecord);
					return true;
			}
		});
	},
	
	setOrderRecord: function( orderRecord ) {
		var dvDataview = this.down('dataview') ;
		if( !orderRecord ) {
			this.orderRecord = null ;
			dvDataview.getStore().removeAll() ;
			return ;
		}
		if( orderRecord instanceof DbsTracyFileOrderModel ) {} else {
			Optima5.Helper.logError('Spec:DbsTracy:OrderAttachmentsDataview','No DbsTracyFileOrderModel instance ?') ;
			return ;
		}
		
		this.orderRecord = orderRecord ;
		dvDataview.getStore().loadRawData( Ext.pluck(orderRecord.attachments().getRange(),'data') ) ;
	},
	
	
	doUpload: function( dummyfield ) {
		var me = this ;
		var msg = function(title, msg) {
			Ext.Msg.show({
					title: title,
					msg: msg,
					minWidth: 200,
					modal: true,
					icon: Ext.Msg.INFO,
					buttons: Ext.Msg.OK
			});
		};
		var uploadform = this.down('toolbar').down('form') ;
		var fileuploadfield = uploadform.query('> filefield')[0] ;
		var baseForm = uploadform.getForm() ;
		if(baseForm.isValid()){
			var ajaxParams = me.optimaModule.getConfiguredAjaxParams() ;
			Ext.apply( ajaxParams, {
				_moduleId: 'spec_dbs_tracy',
				_action: 'attachments_uploadfile'
			}) ;
			
			var msgbox = Ext.Msg.wait('Uploading document...');
			baseForm.submit({
				url: Optima5.Helper.getApplication().desktopGetBackendUrl(),
				params: ajaxParams,
				success : function(form,action){
					msgbox.close() ;
					Ext.menu.Manager.hideAll();
					var ajaxData = Ext.JSON.decode(action.response.responseText).data ;
					if( !ajaxData.tmp_id ) {
						return ;
					}
					this.handleNewAttachment( ajaxData.tmp_id ) ;
				},
				failure: function(fp, o) {
					msgbox.close() ;
					msg('Pouet','Error during upload') ;	
				},
				scope: me
			});
		}
	},
	
	
	handleNewAttachment: function( tmpId ) {
		var attachmentViewerWindow = this.createAttachmentWindow() ;
		attachmentViewerWindow.loadTmpMedia( tmpId ) ;
	},
	handleEditAttachment: function( filerecordId ) {
		var attachmentViewerWindow = this.createAttachmentWindow() ;
		attachmentViewerWindow.loadFilerecord( filerecordId ) ;
	},
	createAttachmentWindow: function() {
		attachmentViewerWindow = this.optimaModule.createWindow({
			_parentFileCode:'order',
			_parentFilerecordId: this.orderRecord.get('order_filerecord_id'),
			_readonlyMode: this._readonlyMode
		},Optima5.Modules.Spec.DbsTracy.AttachmentViewerWindow) ;
		attachmentViewerWindow.on('load',function() {
			attachmentViewerWindow.show() ;
		},this) ;
		attachmentViewerWindow.on('submitok',function() {
			this.optimaModule.postCrmEvent('attachmentschange',{orderFilerecordId:this.orderRecord.get('order_filerecord_id')}) ;
		},this) ;
		return attachmentViewerWindow ;
	},
	
	handleAssociate: function(attachmentRecord) {
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'attachments_attach',
				parent_file_code: 'order',
				parent_filerecord_id: this.orderRecord.get('order_filerecord_id'),
				filerecord_id: attachmentRecord.get('attachment_filerecord_id')
			},
			success: function(response) {
				var ajaxObj = Ext.decode(response.responseText) ;
				if( ajaxObj.success ) {
					this.optimaModule.postCrmEvent('attachmentschange',{orderFilerecordId:this.orderRecord.get('order_filerecord_id')}) ;
				}
			},
			scope: this
		});
	},
	handleDownload: function(mediaId) {
		if( !mediaId ) {
			return ;
		}
		
		var msgbox = Ext.Msg.wait('Downloading...');
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'attachments_mediaGetBinary',
				media_id: mediaId,
			},
			success: function(response) {
				var ajaxObj = Ext.decode(response.responseText) ;
				if( ajaxObj.success ) {
					Optima5.Modules.Spec.DbsTracy.HelperCache.libBinaryDownload(ajaxObj.bin_base64,ajaxObj.bin_filename);
				}
			},
			callback: function() {
				msgbox.close();
			},
			scope: this
		});
	},
	handleDownloadZipArchive: function() {
		var dvDataview = this.down('dataview'),
			dvStore = dvDataview.getStore();
		if( !dvStore ) {
			return ;
		}
		
		var mediaIds = [] ;
		dvStore.each(function(r) {
			mediaIds.push(r.get('attachment_media_id'));
		});
		
		var msgbox = Ext.Msg.wait('Downloading...');
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'attachments_buildZipArchive',
				order_filerecord_id: this.orderRecord.get('order_filerecord_id'),
				media_ids: Ext.JSON.encode(mediaIds),
			},
			success: function(response) {
				var ajaxObj = Ext.decode(response.responseText) ;
				if( ajaxObj.success ) {
					Optima5.Modules.Spec.DbsTracy.HelperCache.libBinaryDownload(ajaxObj.bin_base64,ajaxObj.bin_filename);
				}
			},
			callback: function() {
				msgbox.close();
			},
			scope: this
		});
	},
	
	
	applyFilters: function() {
		var dvDataview = this.down('dataview') ;
		
		var tbFilter = this.down('#tbFilter'),
			tbFilterMenu = tbFilter.menu ;
		
		dvDataview.getStore().clearFilter();
		
		var filterAttachCatg = tbFilter._attachCatg,
			filterAttachHidden = !tbFilterMenu.down('menucheckitem').checked;
		
		var filters = [] ;
		if( filterAttachCatg==null ) {
			tbFilter.setText(tbFilter._emptyText) ;
			tbFilter.setIcon(tbFilter._emptyIcon) ;
		} else {
			var tbFilterMenuItem = tbFilterMenu.down('[_attachCatg="'+filterAttachCatg+'"]') ;
			tbFilter.setText(tbFilterMenuItem.text) ;
			tbFilter.setIcon(tbFilterMenuItem.icon) ;
			filters.push({
				property: 'attachment_catg',
				value: filterAttachCatg,
			});
		}
		if( filterAttachHidden ) {
			filters.push({
				property: 'attachment_discard',
				value: false,
			});
		}
		if( !Ext.isEmpty(filters) ) {
			dvDataview.getStore().setFilters(filters);
		}
	},
	
	
});
