Ext.define('Optima5.Modules.Spec.DbsTracy.TestRomainPanel', {
    extend: 'Ext.panel.Panel',
    xtype: 'testromainpanel',

    cls: 'desktop-scope',

    bodyStyle: {
        backgroundColor: '#f2f2f2'
    },
    layout: { type: 'vbox', align: 'stretch' },
    title: 'Catalogue d’apps',

    // ------- Données démo --------------
    buildNativeData: function () {
        return [
            { id: 1, name: 'Tracy', team: 'IT', platform: 'Android', iconUrl: 'images/modules/dbstracy-mainmenu-logo-tracy.png', badges: ['Prod', 'Critique'], updatedAt: '2025-09-20', usage: 90 },
            { id: 2, name: 'EzeeR', team: 'BI', platform: 'iOS',     iconUrl: 'images/icons/ico_ezeer_240.png',                   badges: ['Prod'],             updatedAt: '2025-09-28', usage: 70 },
        ];
    },
    buildWebData: function () {
        return [
            { id: 101, name: 'Tracy Live Tracking', team: 'PMO',   type: 'Web', iconUrl: 'images/modules/dbstracy-mainmenu-logo-tracy.png', badges: ['iOS', 'Android', 'Beta'], updatedAt: '2025-09-18', usage: 60 },
            { id: 102, name: 'EASA vs BL',          team: 'BI',    type: 'Web', iconUrl: 'images/modules/dbstracy-mainmenu-logo-tracy.png', badges: ['Beta'],                   updatedAt: '2025-09-22', usage: 80 },
        ];
    },

    // --------------------------- Init --------------------------------------
    initComponent: function () {
        var me = this;

        Ext.util.CSS.createStyleSheet(`
            .desktop-scope .romain-header{
            background: #167D86;
            color:#fff; padding:12px 16px;
            }
            .desktop-scope .romain-brand{ display:flex; align-items:center; gap:8px; font-weight:600; }
            .desktop-scope .romain-brand .title{ font-size:16px; }

            .desktop-scope .romain-section-hdr{ display:flex; align-items:center; gap:8px; margin:8px 0; }
            .desktop-scope .romain-section-hdr h2{ margin:0; font-weight:700; }

            .desktop-scope .romain-sep{
            height:4px; width:100%; border-radius:999px;
            background: linear-gradient(90deg,#22c1c3,#8a4fff,#22c1c3); opacity:.95; margin:24px 0;
            }

            .desktop-scope .romain-grid .x-view-item{ padding:0 !important; margin:8px; }

            .desktop-scope .romain-card{
            border: 1px solid rgba(0,0,0,.06);
            border-radius: 16px;
            padding: 12px; background: #fff;
            display: flex; flex-direction: column; gap: 8px;
            }
            .desktop-scope .x-nlg .romain-card{ background:#fff; }

            .desktop-scope .romain-card__top{
            display:flex; gap:12px; align-items:flex-start; justify-content: space-around;
            }

            .desktop-scope .romain-card__icon{
            width:120px; height:120px; flex:0 0 120px;
            display:flex; align-items:center; justify-content:center;
            font-size:24px; border-radius:10px; background:black;
            }

            .desktop-scope .romain-card__info{ flex:0 0 auto; min-width:0; }
            .desktop-scope .romain-card__title{
            font-weight:600; white-space:nowrap; overflow:hidden; text-overflow:ellipsis;
            }
            .desktop-scope .romain-card__meta{ opacity:.7; font-size:12px; margin-top:2px; }

            .desktop-scope .romain-badges{
            display:flex; gap:6px; flex-wrap:nowrap; overflow:hidden; white-space:nowrap;
            text-overflow:ellipsis; margin-top:6px;
            }
            .desktop-scope .romain-badge{
            display:inline-block; padding:2px 8px; border-radius:999px;
            border:1px solid rgba(0,0,0,.08); font-size:11px; background:#f8fafc;
            }

            .desktop-scope .romain-open{
            margin-top:10px; margin-left:auto; margin-right:auto; align-self:flex-start;
            padding:8px 16px; background-color:#0479df; border:1px solid #0479df;
            border-radius:20px; color:#fff; cursor:pointer;
            }

            .desktop-scope .romain-empty{ opacity:.6; padding:24px; }
            `, 'romain-desktop-css'
        );

        me.nativeStore = Ext.create('Ext.data.Store', {
            fields: ['id','name','team','platform','icon','badges','updatedAt','usage'],
            data: me.buildNativeData(),
            sorters: [{ sorterFn: function(a,b){ return a.get('name').localeCompare(b.get('name')); } }]
        });

        me.webStore = Ext.create('Ext.data.Store', {
            fields: ['id','name','team','type','icon','badges','updatedAt','usage'],
            data: me.buildWebData(),
            sorters: [{ sorterFn: function(a,b){ return a.get('name').localeCompare(b.get('name')); } }]
        });

        // Éléments UI
        Ext.apply(me, {
            dockedItems: [{
                xtype: 'container',
                dock: 'top',
                itemId: 'topBar',
                cls: 'romain-header',
                layout: { type: 'hbox', align: 'middle' },
                items: [
                    {
                    xtype: 'component',
                    html: '<div class="romain-brand"><span class="title">Catalogue d’apps</span></div>',
                    flex: 1
                    },

                    {
                    xtype: 'component',
                    itemId: 'companyLogo',
                    html: '<img src="images/modules/dbstracy-mainmenu-logo.png" class="romain-logo" alt="Logo DB Schenker">',
                    width: 300,
                    height: 44,
                    cls: 'romain-logo-wrap'
                    },

                    {
                    xtype: 'container',
                    layout: { type: 'hbox', align: 'middle', pack: 'end' },
                    flex: 1,
                    items: [{
                        xtype: 'textfield',
                        itemId: 'searchField',
                        width: 360,
                        maxWidth: 420,
                        emptyText: 'Rechercher',
                        triggers: { search: { cls: Ext.baseCSSPrefix + 'form-search-trigger' } },
                        enableKeyEvents: true,
                        listeners: { change: me.applyFilters, scope: me }
                    },{
                        xtype: 'tbspacer', width: 8
                    },{
                        xtype: 'button',
                        iconCls: 'x-fa fa-user-circle',
                        ui: 'default-toolbar'
                    }]
                    }
                ]
            }],

            items: [{
                xtype: 'container',
                itemId: 'mainContent',
                padding: 16,
                layout: { type: 'vbox', align: 'stretch' },
                items: [

                    // ---------- Apps natives ----------
                    {
                        xtype: 'container',
                        cls: 'romain-section-hdr',
                        layout: { type: 'hbox', align: 'middle' },
                        items: [{
                            xtype: 'component', html: '<h2>Apps natives</h2>', flex: 1
                        },{
                            xtype: 'tagfield',
                            itemId: 'nativeTags',
                            width: 260,
                            filterPickList: true,
                            emptyText: 'Tags',
                            valueField: 'text',
                            displayField: 'text',
                            queryMode: 'local',
                            store: { fields: ['text'], data: [{text:'Prod'},{text:'Beta'},{text:'Critique'},{text:'iOS'},{text:'Android'}] },
                            listeners: { change: me.applyFilters, scope: me }
                        },{
                            xtype: 'combobox',
                            itemId: 'nativeSort',
                            width: 160,
                            margin: '0 0 0 8',
                            editable: false,
                            displayField: 'label',
                            valueField: 'value',
                            value: 'az',
                            store: {
                                fields: ['label','value'],
                                data: [
                                    {label:'Tri A–Z', value:'az'},
                                    {label:'Plus récentes', value:'recent'},
                                    {label:'Plus utilisées', value:'usage'}
                                ]
                            },
                            listeners: { change: me.sortNative, scope: me }
                        }]
                    },{
                        xtype: 'dataview',
                        itemId: 'nativeView',
                        cls: 'romain-grid',
                        store: me.nativeStore,
                        itemSelector: 'div.romain-card',
                        tpl: new Ext.XTemplate(
                            '<div class="cards-flex">',
                                '<tpl for=".">',
                                '<div class="romain-card romain-card--tile">',
                                    '<div class="romain-card__tile">',
                                    '<div class="romain-card__icon romain-card__icon--img">',
                                        '<img src="{iconUrl}" alt="{name}" loading="lazy"/>',
                                    '</div>',
                                    '<div class="romain-card__title romain-card__title--center">{name}</div>',
                                    '<div class="romain-card__meta romain-card__meta--muted">{[values.platform ? (values.platform + " · " + values.team) : ("Web · " + values.team)]}</div>',
                                    '<div class="romain-badges romain-badges--center">',
                                        '<tpl for="badges"><span class="romain-badge">{.}</span></tpl>',
                                    '</div>',
                                    '</div>',
                                '</div>',
                                '</tpl>',
                            '</div>',
                            '<tpl if="values.length === 0"><div class="romain-empty">Aucune app trouvée</div></tpl>',
                        ),
                        autoScroll: true
                    },

                    // ---------- Séparateur ----------
                    { xtype: 'component', html: '<div class="romain-sep"></div>' },

                    // ---------- Web apps ----------
                    {
                        xtype: 'container',
                        cls: 'romain-section-hdr',
                        layout: { type: 'hbox', align: 'middle' },
                        items: [{
                            xtype: 'component', html: '<h2>Web apps</h2>', flex: 1
                        },{
                            xtype: 'tagfield',
                            itemId: 'webTags',
                            width: 260,
                            filterPickList: true,
                            emptyText: 'Tags',
                            valueField: 'text',
                            displayField: 'text',
                            queryMode: 'local',
                            store: { fields: ['text'], data: [{text:'Prod'},{text:'Beta'},{text:'PWA'},{text:'SaaS'}] },
                            listeners: { change: me.applyFilters, scope: me }
                        },{
                            xtype: 'combobox',
                            itemId: 'webSort',
                            width: 160,
                            margin: '0 0 0 8',
                            editable: false,
                            displayField: 'label',
                            valueField: 'value',
                            value: 'az',
                            store: {
                                fields: ['label','value'],
                                data: [
                                    {label:'Tri A–Z', value:'az'},
                                    {label:'Plus récentes', value:'recent'},
                                    {label:'Plus utilisées', value:'usage'}
                                ]
                            },
                            listeners: { change: me.sortWeb, scope: me }
                        }]
                    },{
                        xtype: 'dataview',
                        itemId: 'webView',
                        cls: 'romain-grid',
                        store: me.webStore,
                        itemSelector: 'div.romain-card',
                        tpl: new Ext.XTemplate(
                            '<div class="cards-flex">',
                                '<tpl for=".">',
                                '<div class="romain-card romain-card--tile">',
                                    '<div class="romain-card__tile">',
                                    '<div class="romain-card__icon romain-card__icon--img">',
                                        '<img src="{iconUrl}" alt="{name}" loading="lazy"/>',
                                    '</div>',
                                    '<div class="romain-card__title romain-card__title--center">{name}</div>',
                                    '<div class="romain-card__meta romain-card__meta--muted">{[values.platform ? (values.platform + " · " + values.team) : ("Web · " + values.team)]}</div>',
                                    '<div class="romain-badges romain-badges--center">',
                                        '<tpl for="badges"><span class="romain-badge">{.}</span></tpl>',
                                    '</div>',
                                    '</div>',
                                '</div>',
                                '</tpl>',
                            '</div>',
                            '<tpl if="values.length === 0"><div class="romain-empty">Aucune app trouvée</div></tpl>',
                        ),
                        autoScroll: true
                    }
                ]
            }]
        });

        me.callParent();

        me.keyMap = new Ext.util.KeyMap({
            target: Ext.getBody(),
            binding: [{
                key: 'k', ctrl: true, defaultEventAction: 'stopEvent',
                fn: function () { me.down('#searchField').focus(); }
            }, {
                key: 'k', meta: true, defaultEventAction: 'stopEvent',
                fn: function () { me.down('#searchField').focus(); }
            }]
        });
    },

    // ----------------------- Filtres & tris --------------------------------
    getQuery: function () { 
        return (this.down('#searchField').getValue() || '').toLowerCase(); 
    },

    getTags: function (which) {
        var fld = this.down(which === 'native' ? '#nativeTags' : '#webTags');
        return fld ? (fld.getValue() || []) : [];
    },

    applyFilters: function () {
        var me = this,
            q = me.getQuery(),
            nativeTags = me.getTags('native'),
            webTags = me.getTags('web');

        me.nativeStore.clearFilter(true);
        me.nativeStore.filterBy(function (rec) {
            var hay = (rec.get('name') + ' ' + rec.get('team') + ' ' + (rec.get('platform') || '')).toLowerCase();
            var badges = rec.get('badges') || [];
            var tagOk = nativeTags.length ? Ext.Array.every(nativeTags, function (t) {
                return Ext.Array.contains(badges, t) || hay.indexOf(String(t).toLowerCase()) !== -1;
            }) : true;
            return (!q || hay.indexOf(q) !== -1) && tagOk;
        });

        me.webStore.clearFilter(true);
        me.webStore.filterBy(function (rec) {
            var hay = (rec.get('name') + ' ' + rec.get('team')).toLowerCase();
            var badges = rec.get('badges') || [];
            var tagOk = webTags.length ? Ext.Array.every(webTags, function (t) {
                return Ext.Array.contains(badges, t) || hay.indexOf(String(t).toLowerCase()) !== -1;
            }) : true;
            return (!q || hay.indexOf(q) !== -1) && tagOk;
        });
    },

    sortNative: function (combo, val) {
        var st = this.nativeStore;
        st.getSorters().clear();
        if (val === 'recent') {
            st.sort([{ property: 'updatedAt', direction: 'DESC' }]);
        } else if (val === 'usage') {
            st.sort([{ property: 'usage', direction: 'DESC' }]);
        } else {
            st.sort([{ sorterFn: function(a,b){ return a.get('name').localeCompare(b.get('name')); } }]);
        }
    },

    sortWeb: function (combo, val) {
        var st = this.webStore;
        st.getSorters().clear();
        if (val === 'recent') {
            st.sort([{ property: 'updatedAt', direction: 'DESC' }]);
        } else if (val === 'usage') {
            st.sort([{ property: 'usage', direction: 'DESC' }]);
        } else {
            st.sort([{ sorterFn: function(a,b){ return a.get('name').localeCompare(b.get('name')); } }]);
        }
    }
});