Ext.define('Optima5.Modules.Spec.DbsTracy.WarningFormPanel',{
	extend:'Ext.panel.Panel',
	
	editDisabled: null,

	initComponent: function() {
		var me = this ;
		Ext.apply( me, {
			layout:{
				type:'vbox',
				align:'stretch'
			},
			cls: 'ux-noframe-bg',
			items:[ {
				xtype: 'container',
				layout: 'fit',
				itemId: 'pHeader',
			},{
				itemId: 'pForm',
				border: false,
				xtype:'form',
				cls: 'ux-noframe-bg',
				flex: 1,
				bodyCls: 'ux-noframe-bg',
				bodyPadding: 15,
				layout:'anchor',
				fieldDefaults: {
					labelWidth: 100,
					anchor: '100%'
				},
				items: [{
					xtype: 'fieldset',
					title: 'Incident description',
					items: [Ext.create('Optima5.Modules.Spec.DbsTracy.CfgParamField',{
						hidden: true,
						cfgParam_id: 'INCIDENTCODE',
						cfgParam_emptyDisplayText: 'Select...',
						optimaModule: this.optimaModule,
						fieldLabel: '<b>Incident code</b>',
						name: 'incident_code_new',
						allowBlankIfVisible: false,
						listeners: {
							change: function(f,value) {
								var incidentRow = Optima5.Modules.Spec.DbsTracy.HelperCache.getIncidentByCode(value) ;
								this.down('form').getForm().findField('incident_txt').setValue( incidentRow.incident_desc_full ) ;
								this.buildAdditionalForm(incidentRow.flow_formcfg_obj) ;
							},
							scope: this,
						},
					}),{
						hidden: true,
						xtype: 'displayfield',
						name: 'incident_code_display',
						fieldLabel: 'Incident code',
						cls: 'op5-spec-dbstracy-field-bold',
					},{
						hidden: true,
						xtype: 'displayfield',
						name: 'incident_desc_short',
						fieldLabel: 'Description',
						cls: 'op5-spec-dbstracy-field-bold',
					},{
						xtype: 'fieldset',
						itemId: 'fsIncidentUpdate',
						hidden: true,
						title: 'Change incident code',
						checkboxToggle: true,
						checkboxName: 'incident_code_update_is_on',
						items: [Ext.create('Optima5.Modules.Spec.DbsTracy.CfgParamField',{
							cfgParam_id: 'INCIDENTCODE',
							cfgParam_emptyDisplayText: 'Select...',
							optimaModule: this.optimaModule,
							fieldLabel: '<b>Incident code</b>',
							name: 'incident_code_update',
							allowBlankIfVisible: false,
							listeners: {
								change: function(f,value) {
									var incidentRow = Optima5.Modules.Spec.DbsTracy.HelperCache.getIncidentByCode(value) ;
									this.down('form').getForm().findField('incident_txt').setValue( incidentRow.incident_desc_full ) ;
									this.buildAdditionalForm(incidentRow.flow_formcfg_obj) ;
								},
								scope: this,
							},
						})]
					},{
						xtype: 'textarea',
						fieldLabel: 'Explanation',
						name: 'incident_txt'
					}]
				},{
					itemId: 'fsAddData',
					hidden: true,
					xtype: 'fieldset',
					title: 'Additional data',
					items: [],
				},{
					itemId: 'fsNewAttach',
					hidden: true,
					xtype: 'fieldset',
					title: 'Attachments',
					items: [{
						xtype: 'fieldcontainer',
						layout: {
							type: 'hbox',
							align: 'middle',
						},
						items:[{
							xtype: 'button',
							scale: 'small',
							icon: 'images/modules/dbsembramach-attachment-16.png',
							text: 'Select attachments',
							handler: function(btn) {
								btn.up('form').getForm().findField('attach_ids').openAttachmentsPopup() ;
							},
						}]
					},Ext.create('Optima5.Modules.Spec.DbsTracy.WarningImportAttachmentsField',{
						optimaModule: this.optimaModule,
						_ticketRecord: null,
						_ownerPanel: this,
						
						fieldLabel: 'Attachments',
						name:'attach_ids',
						
						hidden:true,
					})]
				}],
				buttons:[{
					itemId: 'btnSubmit',
					text: 'Validation',
					handler: function() {
						this.handleSubmit() ;
					},
					scope: this
				}],
			}],
		});
		
		this.callParent() ;
		
		if( this._ticketRecord ) {
			this.onLoadTicket(this._ticketRecord) ;
			this.down('form').getForm().findField('attach_ids')._ticketRecord = this._ticketRecord ; // HACK ?
		}
	},
	onLoadTicket: function(ticketRecord) {
		this._ticketRecord = ticketRecord ;
		
		var form = this.down('form').getForm() ;
		if( ticketRecord.get('ticket_is_new') ) {
			this.setTitle('New incident...');
			form.findField('incident_code_new').setVisible(true);
			this.down('#fsNewAttach').setVisible(true);
		} else {
			this.setTitle(ticketRecord.get('incident_code'));
			this.down('#fsIncidentUpdate').setVisible(true);
			form.findField('incident_code_display').setVisible(true);
			form.findField('incident_desc_short').setVisible(true);
			var setValues = {
				incident_code_update_is_on: false,
			};
			setValues['incident_code_display'] = ticketRecord.get('incident_code') ;
			setValues['incident_desc_short'] = ticketRecord.get('incident_cfg_obj').incident_desc_short ;
			setValues['incident_txt'] = ticketRecord.get('incident_txt') ;
			
			var formCfg = this.buildAdditionalForm( ticketRecord.get('incident_cfg_obj').flow_formcfg_obj ) ;
			if( formCfg ) {
				Ext.Array.each( formCfg, function(r) {
					var mkey = 'data_'+r.name ;
					setValues[mkey] = ticketRecord.get('inputdata_obj')[r.name];
				});
			}
			
			form.setValues(setValues);
			
			if( ticketRecord.get('closed_is_on') ) {
				form.getFields().each(function(f) {
					if( f.setReadOnly ) {
						f.setReadOnly(true) ;
					}
				});
				this.down('#btnSubmit').setVisible(false);
			}
		}
		if( ticketRecord.links().getCount() > 0 ) {
			this.fetchLinks( ticketRecord.links().getRange() ) ;
		}
	},
	
	buildAdditionalForm: function(formCfgObj) {
		var optimaModule = this.optimaModule ;
		
		var formCfg ;
		if( !Ext.isObject(formCfgObj) && Ext.isArray(formCfgObj) ) {
			formCfg=formCfgObj;
		}
		if( Ext.isObject(formCfgObj) && this._ticketRecord.get('id_soc') ) {
			var idSoc = this._ticketRecord.get('id_soc');
			formCfg=formCfgObj[idSoc];
		}
		
		formCfg = formCfg || [];
		//build form ?
		var formItems = [] ;
		Ext.Array.each( formCfg, function(r) {
			var mkey = 'data_'+r.name ;
			if( r.hintquery ) {
				formItems.push({
					anchor: '100%',
					xtype: 'combobox',
					name: mkey,
					fieldLabel: r.label,
					forceSelection:false,
					allowBlank:r.allowBlank,
					editable:true,
					typeAhead:false,
					queryMode: 'remote',
					displayField: 'value',
					valueField: 'value',
					queryParam: 'hintquery_txt',
					minChars: 0,
					checkValueOnChange: function() {}, //HACK
					store: {
						fields: ['value'],
						proxy: optimaModule.getConfiguredAjaxProxy({
							extraParams : {
								_moduleId: 'spec_dbs_tracy',
								_action: 'ticket_hintquery',
								hintquery_name: r.name,
								limit: 20
							},
							reader: {
								type: 'json',
								rootProperty: 'data'
							}
						}),
						listeners: {
							beforeload: function(store,options) {
								var pHeaderTpl = this.down('#pHeaderTpl') ;
								if( !pHeaderTpl ) {
									return ;
								}
								var params = options.getParams() || {} ;
								Ext.apply(params,{
									hintquery_links: Ext.JSON.encode(pHeaderTpl.getData()),
								});
								options.setParams(params) ;
							},
							scope: this,
						}
					},
				});
			} else {
				formItems.push({
					anchor: '100%',
					xtype: 'textfield',
					name: mkey,
					fieldLabel: r.label,
					allowBlank:r.allowBlank,
				});
			}
		},this);
		var fsAddData = this.down('#fsAddData') ;
		fsAddData.removeAll() ;
		fsAddData.setVisible(formItems.length>0);
		fsAddData.add(formItems);
		
		return formCfg;
	},
	
	fetchLinks: function( arr_ticketLinkRecord ) {
		if( Ext.isEmpty(arr_ticketLinkRecord) ) {
			return ;
		}
		var linkType = arr_ticketLinkRecord[0].get('link_type'),
				linkIds = [] ;
		Ext.Array.each( arr_ticketLinkRecord, function(ticketLinkRecord) {
			linkIds.push( ticketLinkRecord.get('link_filerecord_id') );
		});
		switch( linkType ) {
			case 'order' :
				this.optimaModule.getConfiguredAjaxConnection().request({
					params: {
						_moduleId: 'spec_dbs_tracy',
						_action: 'order_getRecords',
						filter_orderFilerecordId_arr: Ext.JSON.encode(linkIds)
					},
					success: function(response) {
						var ajaxData = Ext.decode(response.responseText) ;
						if( ajaxData.success == false ) {
							//Ext.Msg.alert('Failed', 'Unknown error');
						}
						this.onFetchLinks(arr_ticketLinkRecord,ajaxData.data) ;
					},
					callback: function() {
						//this.hideLoadmask() ;
					},
					scope: this
				});
				break; 
			
		}
	},
	onFetchLinks: function( arr_ticketLinkRecord, rows ) {
		if( Ext.isEmpty(rows) ) {
			return ;
		}
		var linkType = arr_ticketLinkRecord[0].get('link_type') ;
		var arrIds=[], txtIds='' ;
		Ext.Array.each(rows, function(row) {
			arrIds.push(row.id_dn) ;
		});
		txtIds = arrIds.join('+');
		
		var fRow = rows[0] ;
		Ext.Array.each( this.query('[cfgParam_id="INCIDENTCODE"]'), function(cfgParamField) {
			cfgParamField.filterSoc( fRow.id_soc ) ;
		});
		if( fRow.id_soc && this._ticketRecord.get('ticket_is_new') ) {
			this._ticketRecord.set('id_soc',fRow.id_soc);
		}
		
		var pHeader = this.down('#pHeader'),
			fRow = rows[0] ;
		switch( linkType ) {
			case 'order' :
				this.fireEvent('linktitle',this,fRow.id_soc+'/'+txtIds) ;
				
				pHeader.removeAll() ;
				pHeader.add({
					itemId: 'pHeaderTpl',
					xtype:'component',
					cls: 'ux-noframe-bg',
					padding: 16,
					tpl: [
						'<div class="op5-spec-dbspeople-realvalidhdr">',
							'<div class="op5-spec-dbspeople-realvalidhdr-inline-tbl">',
								'<div class="op5-spec-dbspeople-realvalidhdr-inline-elem op5-spec-dbstracy-warning-icon">',
								'</div>',
								'<div class="op5-spec-dbspeople-realvalidhdr-inline-elem">',
									'<table class="op5-spec-dbspeople-realvalidhdr-tbl">',
									'<tr>',
										'<td class="op5-spec-dbspeople-realvalidhdr-tdlabel">DN / BL :</td>',
										'<td class="op5-spec-dbspeople-realvalidhdr-tdvalue">{id_dn}</td>',
									'</tr>',
									'<tr>',
										'<td class="op5-spec-dbspeople-realvalidhdr-tdlabel">Consignee :</td>',
										'<td class="op5-spec-dbspeople-realvalidhdr-tdvalue">{atr_consignee}</td>',
									'</tr>',
									'<tr>',
										'<td class="op5-spec-dbspeople-realvalidhdr-tdlabel">Date RLS :</td>',
										'<td class="op5-spec-dbspeople-realvalidhdr-tdvalue">{date_rls}</td>',
									'</tr>',
									'</table>',
								'</div>',
							'</div>',
						'</div>',
						{
							disableFormats: true
						}
					]
				});
				pHeader.down('#pHeaderTpl').update({
					id_soc: fRow.id_soc,
					id_dn_arr: arrIds,
					id_dn: txtIds,
					atr_consignee: fRow.atr_consignee,
					date_rls: Ext.util.Format.date(new Date(fRow.date_create),'d/m/Y H:i'),
				});
				break ;
				
			default:
				pHeader.removeAll() ;
				break ;
		}
	},
	
	
	handleSubmit: function() {
		var formPanel = this.down('#pForm'),
			form = formPanel.getForm(),
			values = form.getValues(false,false,false,true) ;
			
		form.getFields().each(function(f){
			if( f.allowBlankIfVisible === false ) {
				f.allowBlank = !f.isVisible(true) ;
			}
		}) ;
		if( !form.isValid() ) {
			return ;
		}
			
		var formData = {} ;
		if( this._ticketRecord.get('ticket_is_new') ) {
			formData['incident_code'] = values['incident_code_new'];
			formData['incident_cfg_obj'] = Optima5.Modules.Spec.DbsTracy.HelperCache.getIncidentByCode(values['incident_code_new']) ;
		} else if( values.incident_code_update_is_on ) {
			formData['incident_code'] = values['incident_code_update'];
			formData['incident_cfg_obj'] = Optima5.Modules.Spec.DbsTracy.HelperCache.getIncidentByCode(values['incident_code_update']) ;
		} else {
			formData['incident_code'] = this._ticketRecord.get('incident_code') ;
		}
		if( Ext.isEmpty(formData['incident_code']) ) {
			return ; // ???
		}
		formData['incident_txt'] = values['incident_txt'];
		
		var prefix = 'data_', inputDataObj={} ;
		Ext.Object.each( values, function(k,v) {
			if( k.indexOf(prefix)===0 ) {
				inputDataObj[k.substr(prefix.length)] = v;
			}
		});
		formData['inputdata_obj'] = inputDataObj ;
		
		if( this._ticketRecord.get('ticket_is_new') ) {
			formData['links'] = [] ;
			this._ticketRecord.links().each( function(l) {
				formData['links'].push(l.getData());
			});
			
			formData['attach_ids'] = values['attach_ids'];
		}
		
		
		this.loadMask = Ext.create('Ext.LoadMask',{
			target: this,
			msg:"Please wait..."
		}).show();
		
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'ticket_saveHeader',
				ticket_filerecord_id: this._ticketRecord.get('ticket_filerecord_id'),
				ticket_is_new: this._ticketRecord.get('ticket_is_new') ? 1 : 0,
				data: Ext.JSON.encode(formData)
			},
			success: function(response) {
				var ajaxResponse = Ext.decode(response.responseText) ;
				if( ajaxResponse.success == false ) {
					var error = ajaxResponse.error || 'File not saved !' ;
					Ext.MessageBox.alert('Error',error) ;
					return ;
				}
				this.optimaModule.postCrmEvent('datachange',{}) ;
				this.fireEvent('saved',this,ajaxResponse.ticket_filerecord_id) ;
			},
			callback: function() {
				this.loadMask.destroy() ;
			},
			scope: this
		}) ;
	},
}) ;
