Ext.define('Optima5.Modules.Spec.DbsTracy.WarningImportAttachmentsField',{
	extend: 'Ext.form.FieldContainer',
	
	mixins: [
		'Ext.form.field.Base'
	],
	
	optimaModule: null,
	_ownerPanel: null,
	_ticketRecord: null,
	
	initComponent: function() {
		var me = this ;
		
		Ext.apply(me,{
			layout: {
				type: 'hbox',
				align: 'center'
			},
			items: [{
				itemId: 'dvTags',
				xtype: 'dataview',
				cls: 'op5-crmbase-definestoretags-field',
				tpl: [
					'<tpl for=".">',
						'<div class="op5-crmbase-definestoretags">',
							'<div class="op5-crmbase-definestoretags-icoattach">',
							'</div>',
							'<div class="op5-crmbase-definestoretags-text">',
							'{attachment_txt}',
							'</div>',
						'</div>',
					'</tpl>'
				],
				itemSelector: 'div.op5-crmbase-definestoretags',
				store: {
					data: [],
					fields: [
						{name:'attachment_media_id', type:'string'},
						{name:'attachment_txt', type:'string'},
					],
					proxy: {
						type: 'memory',
						reader: {
							type: 'json'
						}
					}
				},
			}]
		}) ;
		me.mixins.field.constructor.call(me);
		
		me.callParent() ;
	},
	getStore: function() {
		return this.down('#dvTags').getStore() ;
	},
	getRawValue: function() {
		var values = [] ;
		this.getStore().each( function(rec) {
			values.push(rec.get('attachment_media_id')) ;
		}) ;
		return Ext.JSON.encode(values) ;
	},
	getValue: function() {
		var values = [] ;
		this.getStore().each( function(rec) {
			values.push(rec.get('attachment_media_id')) ;
		}) ;
		return values ;
	},
	setAttachments: function(attachmentsData) {
		this.setVisible( !Ext.isEmpty(attachmentsData) ) ;
		
		if( Ext.isEmpty(attachmentsData) ) {
			this.getStore().removeAll();
			return ;
		}
		this.getStore().loadData(attachmentsData) ;
	},
	setValue: function(values) {
		//
	},
	
	
	openAttachmentsPopup: function() {
		if( this._attachmentsPopup ) {
			this._attachmentsPopup.destroy() ;
		}
		
		var map_attachCatg_color = {};
		var filterMenu = [] ;
		Ext.Array.each( Optima5.Modules.Spec.DbsTracy.HelperCache.getListData('LIST_ATTACH'), function(r) {
			map_attachCatg_color[r.id] = r.color ;
			filterMenu.push({
				_attachCatg: r.id,
				text: r.text,
				icon: Optima5.Modules.Spec.DbsTracy.HelperCache.getDotImgSrc(r.color),
			});
		}) ;
		
		var me = this ;
		var popupPanel = Ext.create('Ext.panel.Panel',{
			width:500,
			height:500,
			
			cls: 'ux-noframe-bg',
			
			layout: 'fit',
			items: [{
				itemId: 'dvWait',
				xtype: 'box',
				cls:'op5-waiting',
			},{
				itemId: 'dvStore',
				hidden:true,
				_map_attachCatg_color: map_attachCatg_color,
				
				xtype: 'dataview',
				store: {
					model: 'DbsTracyAttachmentModel',
					data: [],
					proxy: {
						type: 'memory',
						reader: {
							type: 'json'
						}
					},
					sorters: [{
						property: 'attachment_filerecord_id',
						direction: 'DESC',
					}],
				},
				//frame: true,
				//autoScroll:true,
				//overflowX: 'auto',
				//style: {
					//whiteSpace: 'nowrap'
				//},
				scrollable: 'vertical',

				tpl:[
					'<tpl for=".">',
						'<div class="op5-spec-mrfoxy-attachments-item thumb-box op5-spec-dbstracy-thumbox">',
							'<tpl if="thumb_dotimgsrc">',
								'<div class="op5-spec-dbstracy-thumbox-dot"><img src="{thumb_dotimgsrc}"/></div>',
							'</tpl>',
							'<div class="{thumb_date_cls}">{thumb_date}</div>',
							'<a href="#">',
								'<img src="{thumb_url}"/>',
							'</a>',
							'<div>',
								'{thumb_caption}',
							'</div>',
							'<div style="text-align:center">',
								'<input type="checkbox" data-attachmentmediaid="{attachment_media_id}" data-filerecordid="{thumb_date}"/>',
							'</div>',
						'</div>',
					'</tpl>'
				],
				trackOver: true,
				overItemCls: 'x-item-over',
				itemSelector: 'div.thumb-box',
				prepareData: function(data) {
					var getParams = me.optimaModule.getConfiguredAjaxParams() ;
					Ext.apply( getParams, {
						media_id: data.attachment_media_id,
						thumb: true
					});
					
					Ext.apply(data, {
						thumb_date: Ext.util.Format.date(data.attachment_date,'d/m/Y'),
						thumb_url: 'server/backend_media.php?' + Ext.Object.toQueryString(getParams),
						thumb_caption: Ext.util.Format.nl2br( Ext.String.htmlEncode( data.attachment_txt ) ),
						thumb_date_cls: data.attachment_discard ? 'op5-spec-dbstracy-thumbox-stroke' : '',
					});
					if( data.attachment_catg ) {
						var attachCatg = data.attachment_catg,
							attachColor = this._map_attachCatg_color[attachCatg];
						if( attachColor ) {
							var imgDotSrc = Optima5.Modules.Spec.DbsTracy.HelperCache.getDotImgSrc(attachColor);
							Ext.apply(data, {
								thumb_dotimgsrc: imgDotSrc
							}) ;
						}
					}
					return data;
				},
				
				getSelectedRows: function() {
					var selectedIds = [] ;
					Ext.Array.each( this.getEl().query('input:checked'), function(inputEl) {
						var mediaId = inputEl.dataset['attachmentmediaid'] ;
						if( !Ext.Array.contains(selectedIds,mediaId) ) {
							selectedIds.push(mediaId) ;
						}
					});
					
					var attachmentsData = [] ;
					this.getStore().each( function(rec) {
						var row = rec.getData();
						if( Ext.Array.contains(selectedIds,row.attachment_media_id) ) {
							attachmentsData.push(row) ;
						}
					});
					return attachmentsData ;
				}
			}],
			
			buttons: [{
				xtype: 'button',
				text: 'Submit',
				handler:function(btn){ 
					var attachmentsPopup = btn.up('panel'),
						attachmentsData = attachmentsPopup.down('#dvStore').getSelectedRows() ;
					attachmentsPopup.fireEvent('saved',attachmentsPopup,attachmentsData) ;
				},
				scope: this
			}],
			
			floating: true,
			renderTo: this._ownerPanel.getEl(),
			tools: [{
				type: 'close',
				handler: function(e, t, p) {
					p.ownerCt.destroy();
				}
			}],
		});
		
		popupPanel.on('saved',function(p,attachmentsData) {
			this.setAttachments(attachmentsData) ;
			p.destroy() ;
		},this,{single:true}) ;
		popupPanel.on('destroy',function() {
			this._ownerPanel.getEl().unmask() ;
			this._attachmentsPopup = null ;
		},this,{single:true}) ;
		this._ownerPanel.getEl().mask() ;
		
		popupPanel.show();
		popupPanel.getEl().alignTo(this._ownerPanel.getEl(), 'c-c?');
		//popupPanel.doCalcLayout() ;
		
		
		
		
		var arr_ticketLinkRecord = this._ticketRecord.links().getRange() ;
		if( Ext.isEmpty(arr_ticketLinkRecord) ) {
			popupPanel.destroy() ;
			return ;
		}
		var linkType = arr_ticketLinkRecord[0].get('link_type'),
				linkIds = [] ;
		Ext.Array.each( arr_ticketLinkRecord, function(ticketLinkRecord) {
			linkIds.push( ticketLinkRecord.get('link_filerecord_id') );
		});
		switch( linkType ) {
			case 'order' :
				this.optimaModule.getConfiguredAjaxConnection().request({
					params: {
						_moduleId: 'spec_dbs_tracy',
						_action: 'order_getRecords',
						filter_orderFilerecordId_arr: Ext.JSON.encode(linkIds)
					},
					success: function(response) {
						var ajaxData = Ext.decode(response.responseText) ;
						if( ajaxData.success == false ) {
							//Ext.Msg.alert('Failed', 'Unknown error');
						}
						
						var attachmentsData = [],
							attachmentsTxts = [];
						Ext.Array.each( ajaxData.data, function(orderRow) {
							Ext.Array.each( orderRow.attachments, function(attachmentRow) {
								var attachmentsTxt = attachmentRow.attachment_txt ;
								if( !Ext.Array.contains(attachmentsTxts,attachmentsTxt) ) {
									attachmentsTxts.push(attachmentsTxt) ;
									attachmentsData.push(attachmentRow) ;
								}
							});
						});
						popupPanel.down('#dvWait').setVisible(false);
						popupPanel.down('#dvStore').getStore().loadData(attachmentsData) ;
						popupPanel.down('#dvStore').setVisible(true);
					},
					callback: function() {
						//this.hideLoadmask() ;
					},
					scope: this
				});
				break; 
			default :
				break;
		}
		
		
		
		this._attachmentsPopup = popupPanel ;
	},
	onDestroy: function() {
		if( this._attachmentsPopup ) {
			this._attachmentsPopup.destroy() ;
		}
	},
});
