Ext.define('Optima5.Modules.Spec.DbsTracy.WarningLinePanel',{
	extend: 'Ext.panel.Panel',
	requires: [
		'Optima5.Modules.Spec.DbsTracy.WarningLineView',
		'Optima5.Modules.Spec.DbsTracy.WarningImportAttachmentsField',
	],
	
	scollable: 'vertical',
	
	initComponent: function() {
		Ext.apply(this,{
			layout: {
				type: 'vbox',
				//pack: 'middle',
				align: 'stretch',
			},
			defaults: {
				anchor: '100%',
			},
			bodyStyle: {
				'background-color' : '#dddddd',
			},
			items: [{
				xtype: 'box',
				flex: 1,
				cls:'op5-waiting'
			}]
		});
		this.callParent();
		//this.setScrollable('vertical');
		if( this._ticketRecord ) {
			this.onLoadTicket(this._ticketRecord) ;
		}
	},
	onLoadTicket: function( ticketRecord ) {
		this._ticketFilerecordId = ticketRecord.get('ticket_filerecord_id');
		
		this.removeAll() ;
		this.add( {
			xtype: 'container',
			layout: 'fit',
			//height: 200,
			padding: '16 32 16 32',
			style: {
				'background-color' : '#dddddd',
			},
			items: [{
				hidden: ticketRecord.get('closed_is_on'),
				collapsible: true,
				frame: true,
				title: 'New action',
				xtype: 'form',
				layout: 'anchor',
				//height: 100,
				bodyPadding: 6,
				bodyCls: 'ux-noframe-bg',
				fieldDefaults: {
					labelWidth: 80,
					anchor: '100%',
				},
				items: [{
					xtype: 'combobox',
					allowBlank: false,
					queryMode: 'local',
					forceSelection: true,
					editable: false,
					displayField: 'eventType_txt',
					valueField: 'eventType_code',
					store: {
						fields: ['eventType_code','eventType_txt','eventType_iconCls'],
						data : [
							{eventType_code:'action',eventType_txt:'New comment',eventType_iconCls:'op5-spec-dbspeople-icon-role'},
							{eventType_code:'close',eventType_txt:'Close warning',eventType_iconCls:'op5-spec-dbspeople-icon-absence'},
						]
					},
					fieldLabel: 'Action',
					name: 'next_?',
					value: 'action',
					anchor: '',
					width: 250,
					listeners: {
						change: function(cmb,v) {
							var formPanel = cmb.up('form'),
								form = formPanel.getForm(),
								isClose = (v=='close');
							form.findField('body_txt').setVisible(!isClose);
							form.findField('body_txt').allowBlank = isClose;
							form.findField('attach_file').setVisible(!isClose) ;
							formPanel.down('#btnAttach').setVisible(!isClose) ;
							form.findField('close_is_confirm').setVisible(isClose) ;
						}
					}
				},{
					name: 'body_txt',
					allowBlank: false,
					fieldLabel: 'Message',
					xtype: 'textarea',
				},Ext.create('Optima5.Modules.Spec.DbsTracy.WarningImportAttachmentsField',{
					optimaModule: this.optimaModule,
					_ticketRecord: ticketRecord,
					_ownerPanel: this,
					
					fieldLabel: 'Attachments',
					name:'attach_ids',
					
					hidden:true,
				}),{
					xtype: 'container',
					layout: {
						type: 'hbox',
						align: 'middle',
					},
					items:[{
						name: 'attach_file',
						xtype: 'filefield',
						fieldLabel: 'Upload file',
						buttonText: '...',
						anchor: '',
						width: 300,
					},{
						itemId: 'btnAttach',
						xtype: 'button',
						scale: 'small',
						icon: 'images/modules/dbsembramach-attachment-16.png',
						//text: '&#160;',
						handler: function(btn) {
							btn.up('form').getForm().findField('attach_ids').openAttachmentsPopup() ;
						},
					},{
						hidden: true,
						name: 'close_is_confirm',
						xtype: 'checkboxfield',
						boxLabel: 'Confirm close ?',
					},{
						xtype: 'component',
						flex:1
					},{
						width: 75,
						xtype: 'button',
						text: 'Submit',
						handler: function() {
							this.handleSubmitAction() ;
						},
						scope: this,
					}]
				}]
			}]
		},Ext.create('Optima5.Modules.Spec.DbsTracy.WarningLineView',{
			scrollable: 'vertical',
			flex:1,
			optimaModule: this.optimaModule,
			_ticketFilerecordId: 1,
			_ticketRecord: ticketRecord,
		}) );
		this.setScrollable('vertical');
		
		if( this._presetAction ) {
			this.down('form').getForm().findField('next_?').setValue( this._presetAction ) ;
		}
	},
	
	showLoadmask: function() {
		if( this.rendered ) {
			this.doShowLoadmask() ;
		} else {
			this.on('afterrender',this.doShowLoadmask,this,{single:true}) ;
		}
	},
	doShowLoadmask: function() {
		if( this.loadMask ) {
			return ;
		}
		this.loadMask = Ext.create('Ext.LoadMask',{
			target: this,
			msg:"Please wait..."
		}).show();
	},
	hideLoadmask: function() {
		this.un('afterrender',this.doShowLoadmask,this) ;
		if( this.loadMask ) {
			this.loadMask.destroy() ;
			this.loadMask = null ;
		}
	},
	
	handleSubmitAction: function(){
		var me = this ;
		var msg = function(title, msg) {
			Ext.Msg.show({
					title: title,
					msg: msg,
					minWidth: 200,
					modal: true,
					icon: Ext.Msg.INFO,
					buttons: Ext.Msg.OK
			});
		};
		var uploadform = this.down('form') ;
		var baseForm = uploadform.getForm() ;
		
		var values = baseForm.getFieldValues() ;
		if( values['next_?']=='close' && !values['close_is_confirm'] ) {
			Ext.Msg.alert('Confirm', 'Please confirm to close ticket');
			return ;
		}
		
		if(baseForm.isValid()){
			var ajaxParams = me.optimaModule.getConfiguredAjaxParams() ;
			Ext.apply( ajaxParams, {
				_moduleId: 'spec_dbs_tracy',
				_action: 'ticket_pushAction',
				ticket_filerecord_id: this._ticketRecord.get('ticket_filerecord_id'),
			}) ;
			
			var msgbox = Ext.Msg.wait('Please wait...');
			baseForm.submit({
				url: Optima5.Helper.getApplication().desktopGetBackendUrl(),
				params: ajaxParams,
				success : function(form,action){
					msgbox.close() ;
					Ext.menu.Manager.hideAll();
					var ajaxData = Ext.JSON.decode(action.response.responseText) ;
					if( !ajaxData.success ) {
						return ;
					}
					this.optimaModule.postCrmEvent('datachange',{}) ;
					this.fireEvent('saved',me, this._ticketRecord.get('ticket_filerecord_id')) ;
				},
				failure: function(form,action) {
					if( msgbox ) {
						msgbox.close() ;
					}
					if( action.response && action.response.responseText ) {
						var ajaxData = Ext.JSON.decode(action.response.responseText) ;
						msg('Error',ajaxData.error||'Error') ;
					}
				},
				scope: me
			});
		}
	},
});
