Ext.define('Optima5.Modules.Spec.DbsTracy.WarningLineView',{
	extend: 'Ext.view.View',
	
	_modeSelect: false,
	_modeSelect_ids: {},
	
	focusable: false,
	focusNode: Ext.emptyFn,
	
	initComponent: function() {
		var priorityMapTxt = {} ;
		// Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getPriorityAll(), function(prio) {
		// 	priorityMapTxt[prio.priority_code] = prio.priority_txt ;
		// }) ;
		var categoryMapTxt = {} ;
		// Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getCategoryAll(), function(cat) {
		// 	categoryMapTxt[cat.category_code] = cat.category_txt ;
		// }) ;
		var userMapTxt = {} ;
		// Ext.Array.each( Optima5.Modules.Spec.DbsEzeer.HelperCache.getPeopleUserAll(), function(row) {
		// 	userMapTxt[row.user_id] = row.user_name ;
		// });
		
		
		var ticketAction = new Ext.XTemplate(
			'<tpl for=".">',
				'<div class="op5-spec-dbsezeer-ticketaction-box {select_style}" data-ticketactionfilerecordid="{ticketaction_filerecord_id}">',
					'<tpl if="ticket_base_filerecord_id">',
						'<div style="text-align:left"><i>From Ticket # :</i>&nbsp;<b>{ticket_base_filerecord_id}</b></div>',
					'</tpl>',
					
					'<div class="op5-spec-dbsezeer-ticketaction-group op5-spec-dbsezeer-ticketaction-group-{ticket_type}">',
						'<div class="op5-spec-dbsezeer-ticketaction-rows-container">',
							'<div class="op5-spec-dbsezeer-ticketaction-rows">',
							'<tpl for="header">',
								'<div class="op5-spec-dbsezeer-ticketaction-row">',
									'<div class="op5-spec-dbsezeer-ticketaction-row-title">{title}</div>',
									'<div>&nbsp;<b>:</b>&nbsp;</div>',
									'<div class="op5-spec-dbsezeer-ticketaction-row-value">{value}</div>',
								'</div>',
							'</tpl>',
							'</div>',
						'</div>',
					
						'<div class="op5-spec-dbsezeer-ticketaction-buttons">',
							'<tpl if="_spec_closed_is_on">',
								'<div class="op5-spec-dbsezeer-ticketaction-buttons-btn op5-spec-dbsezeer-ticketaction-buttons-btn-reopen" data-id="{ticket_filerecord_id}">',
								'</div>',
							'</tpl>',
							'<tpl if="!select_is_on">',
							'<tpl if="ticket_base_filerecord_id">',
								'<div class="op5-spec-dbsezeer-ticketaction-buttons-btn op5-spec-dbsezeer-ticketaction-buttons-btn-eject" data-id="{ticket_base_filerecord_id}">',
								'</div>',
							'</tpl>',
							'<tpl if="ticket_status_is_new_reset">',
								'<div class="op5-spec-dbsezeer-ticketaction-buttons-btn op5-spec-dbsezeer-ticketaction-buttons-btn-new">',
								'</div>',
							'</tpl>',
							'</tpl>',
							'<tpl if="select_is_on">',
								'<div class="op5-spec-dbsezeer-ticketaction-buttons-btn op5-spec-dbsezeer-ticketaction-buttons-btn-select {select_btn_style}" data-id="{ticketaction_filerecord_id}">',
								'</div>',
							'</tpl>',
						'</div>',
					
					'</div>',
					
					'<tpl if="ticketaction_filerecord_id">',
					'<div class="op5-spec-dbsezeer-ticketaction-content">',
						'<iframe frameborder="0" width="100%" height="10" style="overflow-x:scroll"></iframe>',
						
						'<div class="op5-spec-dbsezeer-ticketaction-content-btn">',
							'<tpl if="[true]">',
								'<div class="op5-spec-dbsezeer-ticketaction-buttons-btn op5-spec-dbsezeer-ticketaction-buttons-btn-next" data-id="{ticketaction_filerecord_id}">',
								'</div>',
							'</tpl>',
						'</div>',
					'</div>',
					'</tpl>',
					
					'<tpl if="attachments">',
					'<hr></hr>',
					'<div style="text-align:left">',
					'<tpl for="attachments">',
						'<div class="op5-spec-dbsezeer-headertags op5-spec-dbsezeer-headertags-select" data-id="{ticketattach_filerecord_id}">',
							'<div class="op5-spec-dbsezeer-headertags-icopdf">',
							'</div>',
							'<div class="op5-spec-dbsezeer-headertags-text">',
							'{attach_filename}',
							'</div>',
						'</div>',
					'</tpl>',
					'</div>',
					'</tpl>',
					
					'<tpl if="images">',
					'<hr></hr>',
					'<div style="text-align:center">',
					'<tpl for="images">',
						'<img src="{img_src}" style="padding-bottom:16px"/>',
					'</tpl>',
					'</div>',
					'</tpl>',
					
					'<tpl if="false">',
					'<hr></hr>',
					'<div style="text-align:left">',
					'<input type="text" style="width:150px" data-id="{ticket_filerecord_id}" />',
					'</div>',
					'</tpl>',
					
					'<tpl if="props">',
					'<hr></hr>',
					'<div class="op5-spec-dbsezeer-ticketaction-group-noicon">',
					'<div class="op5-spec-dbsezeer-ticketaction-rows-container">',
					'<div class="op5-spec-dbsezeer-ticketaction-rows">',
					'<tpl for="props">',
						'<div class="op5-spec-dbsezeer-ticketaction-row">',
							'<div class="op5-spec-dbsezeer-ticketaction-row-icon {iconCls}"></div>',
							'<div class="op5-spec-dbsezeer-ticketaction-row-value">{title}</div>',
							'<div>&nbsp;<b>:</b>&nbsp;</div>',
							'<div class="op5-spec-dbsezeer-ticketaction-row-value">{value}</div>',
						'</div>',
					'</tpl>',
					'</div>',
					'</div>',
					'</div>',
					'</tpl>',
					
					'<div>{thumb_date}</div>',
					'<a href="#">',
						'<img src="{thumb_url}"/>',
					'</a>',
					'<div>{thumb_caption}</div>',
				'</div>',
			'</tpl>'
		);
		Ext.apply(this,{
			_userMapTxt: userMapTxt,
			_categoryMapTxt: categoryMapTxt,
			_priorityMapTxt: priorityMapTxt,
			
			tpl: ticketAction,
			cls: 'op5-spec-dbsezeer-ticketline-dv op5-spec-dbsezeer-ticketline-dv-nowide',
			itemSelector: 'div.op5-spec-dbsezeer-ticketaction-box',
			//overItemCls: '',
			//disableSelection: true,
			focusable: false,
			emptyText: 'No images available',
			store: {
				model: 'DbsTracyTicketActionModel',
				data: [],
				proxy: { type: 'memory' },
				sorters: [{
					property: '_spec_closed_is_on',
					direction: 'DESC'
				},{
					property: 'ticketaction_filerecord_id',
					direction: 'DESC'
				}]
			},
			prepareDataSplitEmailHeaderLine: function(specEmailHeaderLine) {
				var arrEntry = specEmailHeaderLine.split(',') ;
				return arrEntry.join('&nbsp;<b>,</b>&nbsp;') ;
			},
			prepareData: function(data,index,record) {
				var recordData = record.getData(true) ;
				
				if( recordData._spec_closed_is_on ) {
					var tplData = {
						_spec_closed_is_on: true,
						ticket_type: 'closed',
						ticket_filerecord_id: this._ticketRecord.data['ticket_filerecord_id'],
						header: [{
							title: 'Close date',
							value: Ext.util.Format.date(recordData._spec_closed_date,'d/m/Y H:i')
						},{
							title: 'Close reason',
							value: 'Tracy action',
						}],
						
						select_is_on: false,
					} ;
					return tplData;
				}
				
				var tplData = {
					ticket_type: 'standard',
					ticketaction_filerecord_id: recordData.ticketaction_filerecord_id,
					ticket_base_filerecord_id: (recordData.ticket_base_filerecord_id != recordData.ticket_filerecord_id ? recordData.ticket_base_filerecord_id : false),
					ticket_status_is_new_reset: (this._ticketRecord && this._ticketRecord.data['status_is_new_reset'])
				} ;
				Ext.apply(tplData, {
					header: [{
						title: 'Date',
						value: Ext.util.Format.date(recordData.action_date,'d/m/Y H:i')
					},{
						title: 'User',
						value: this._userMapTxt[recordData.action_user] || recordData.action_user
					}]
				});
				if( record.get('spec_email_is_on') ) {
					var headerData = [] ;
					headerData.push({
						title: 'Date',
						value: Ext.util.Format.date(record.get('spec_email_date'),'d/m/Y H:i')
					});
					if( !Ext.isEmpty(record.get('spec_email_from')) ) {
						headerData.push({
							title: 'From',
							value: record.get('spec_email_from')
						});
					}
					if( !Ext.isEmpty(record.get('spec_email_to')) ) {
						headerData.push({
							title: 'To',
							value: this.prepareDataSplitEmailHeaderLine(record.get('spec_email_to'))
						});
					}
					if( !Ext.isEmpty(record.get('spec_email_cc')) ) {
						headerData.push({
							title: 'Cc',
							value: this.prepareDataSplitEmailHeaderLine(record.get('spec_email_cc'))
						});
					}
					headerData.push({
						title: 'Subject',
						value: record.get('spec_email_subject')
					});
					var ticketType = 'email' ;
					if( record.get('spec_email_is_outbox') ) {
						ticketType = 'emailout' ;
					}
					Ext.apply(tplData, {
						ticket_type: ticketType,
						header: headerData
					}) ;
				}
				
				if( !Ext.isEmpty(recordData['attachments']) ) {
					tplData.attachments = Ext.clone(recordData['attachments']) ;
				}
				
				if( !Ext.isEmpty(recordData['changeprops']) ) {
					var props = [] ;
					var propsArr=[], propsObj={} ;
					Ext.Array.each(recordData['changeprops']||[], function(chrow) {
						var chType = chrow.propchange_type ;
						switch( chrow.propchange_type ) {
							case 'title' :
							case 'priority' :
							case 'category' :
								if( !propsObj.hasOwnProperty(chType) ) {
									propsObj[chType] = {} ;
								}
								var vals = [] ;
								Ext.Array.each(['propchange_id','propchange_txt'],function(k) {
									if( !Ext.isEmpty(chrow[k]) ) {
										vals.push(chrow[k]) ;
									}
								});
								propsObj[chType][chrow.propchange_sign] = vals ;
								break ;
							default :
								propsArr.push(chrow) ;
								break ;
						}
					}) ;
					var titles = {
						'title': 'Title',
						'category': 'Category',
						'priority': 'Priority'
					};
					Ext.Object.each( propsObj, function(k,v) {
						var iconCls = '', title ;
						switch( k ) {
							case 'title' :
							case 'priority' :
							case 'category' :
								iconCls = 'op5-spec-dbsezeer-ticketaction-row-icon-' + k ;
								title = titles[k] ;
								break ;
								
							default :
								iconCls = 'op5-spec-dbsezeer-ticketaction-row-icon-title' ;
								title = k ;
								break ;
						}
						
						var value = '' ;
						value += '<strike>'+v[-1].join(' - ')+'</strike>' ;
						value += '&nbsp;&nbsp;' ;
						value += '<b>'+v[1].join(' - ')+'</b>' ;
						
						props.push({
							iconCls: iconCls,
							title: title,
							value: value
						});
					});
					Ext.Array.each( propsArr, function(v) {
						var iconCls = '',
							title=v.propchange_type,
							value=v.propchange_txt ;
						if( v.propchange_sign == -1 ) {
							iconCls = 'op5-spec-dbsezeer-ticketaction-row-icon-remove' ;
							value = '<strike>'+value+'</strike>' ;
						}
						if( v.propchange_sign == 1 ) {
							iconCls = 'op5-spec-dbsezeer-ticketaction-row-icon-add' ;
							value = '<b>'+value+'</b>' ;
						}
						switch( title ) {
							case 'people' :
								if( v.propchange_id.split('|')[0] == 'group' ) {
									title = 'Group' ;
								}
								if( v.propchange_id.split('|')[0] == 'user' ) {
									title = 'User' ;
								}
								if( v.propchange_id.split('|')[0] == 'email' ) {
									title = 'Email' ;
								}
								break ;
						}
						props.push({
							iconCls: iconCls,
							title: title,
							value: value
						});
					});
					tplData.props = props ;
				}
				
				//console.dir(tplData) ;
				if( this._modeSelect ) {
					tplData.select_is_on = true ;
					var ticketaction_filerecord_id = recordData.ticketaction_filerecord_id ;
					if( this._modeSelect_ids[ticketaction_filerecord_id] ) {
						tplData.select_enabled = true ;
						tplData.select_style = 'op5-spec-dbsezeer-ticketaction-box-enabled' ;
						tplData.select_btn_style = 'op5-spec-dbsezeer-ticketaction-buttons-btn-select-yes' ;
					} else {
						tplData.select_disabled = true ;
						tplData.select_style = 'op5-spec-dbsezeer-ticketaction-box-disabled' ;
						tplData.select_btn_style = 'op5-spec-dbsezeer-ticketaction-buttons-btn-select-no' ;
					}
				} else {
					tplData.select_is_on = false ;
				}
				
				if( recordData.form_is_discard ) {
					tplData.select_style = 'op5-spec-dbsezeer-ticketaction-box-disabled' ;
				}
				
				return tplData;
			}
		});
		this.callParent() ;
		this.on('itemclick',this.onItemOneClick,this) ;
		this.on('beforerefresh',this.onViewBeforeRefresh,this) ;
		this.on('refresh',this.onViewRefresh,this) ;
		if( this._ticketFilerecordId && this._ticketRecord ) {
			this.onLoadTicket( this._ticketRecord ) ;
		}
	},
	
	onLoadTicket: function( ticketRecord ) {
		var data = [] ;
		if( ticketRecord.get('closed_is_on') ) {
			data.push({
				'_spec_closed_is_on': true,
				 '_spec_closed_date': ticketRecord.get('closed_date'),
				 '_spec_closed_code': ticketRecord.get('closed_code'),
			});
		}
		ticketRecord.actions().each( function(rec) {
			data.push( rec.getData(true) ) ;
		}) ;
		this.getStore().loadRawData(data) ;
	},
	
	onViewBeforeRefresh: function(view) {
		this._refreshScrollY = this.getScrollY() ;
		//console.log('scroll is at '+this.getScrollY()) ;
	},
	onViewRefresh: function(view) {
		view.getStore().each( function(rec) {
			if( rec.get('_spec_closed_is_on') ) {
				return ;
			}
			var contentHtml = rec.get('body_html') ;
			if( Ext.isEmpty(contentHtml) && !Ext.isEmpty(rec.get('body_txt')) ) {
				contentHtml = '<pre>' + rec.get('body_txt') + '</pre>' ;
			}
			if( rec.get('phonecall_is_on') ) {
				var phonecallObj = rec.get('phonecall_obj') ;
				if( !Ext.isEmpty(phonecallObj['call_txt']) ) {
					contentHtml = '<pre>' + phonecallObj['call_txt'] + '</pre>' ;
				}
			}
			this.doWriteIframe(rec,contentHtml,rec.get('body_html_hasNext')) ;
		},this) ;
		Ext.defer( function() {
			this.setScrollY( this._refreshScrollY ) ;
		},100,this) ;
	},
	loadActionHtml: function(ticketactionFilerecordId) {
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_ezeer',
				_action: 'ticket_getActionHtml',
				ticket_filerecord_id: this._ticketFilerecordId,
				ticketaction_filerecord_id: ticketactionFilerecordId
			},
			success: function(response) {
				var ajaxData = Ext.decode(response.responseText) ;
				if( ajaxData.success ) {
					this.onLoadActionHtml(ticketactionFilerecordId,ajaxData.html) ;
				}
			},
			scope: this
		});
	},
	onLoadActionHtml: function( ticketactionFilerecordId, bodyHtml ) {
		var view = this,
			store = view.getStore() ;
		if( !store ) {
			return ;
		}
		var rec = store.findRecord('ticketaction_filerecord_id',ticketactionFilerecordId) ;
		this.doWriteIframe(rec,bodyHtml,false) ;
	},
	
	doWriteIframe: function( storeRecord, bodyHtml, showNextIcon=false ) {
		var view = this ;
		
		var dom = view.getNode(storeRecord) ;
		var iframe = dom.querySelector('iframe') ;
		var doc = iframe.contentWindow.document ;
		
		if( Ext.isEmpty(bodyHtml) ) {
			iframe.style.display = 'none' ;
			Ext.get(dom.querySelector('.op5-spec-dbsezeer-ticketaction-content-btn')).setVisible(false) ;
			return ;
		}
		
		iframe.addEventListener( "load", function() {
			var targetHeight = doc.documentElement.scrollHeight + 20 ;
			iframe.style.height = targetHeight + 'px';
		} );
		
		var iframeSrc = '' ;
		iframeSrc+= '<html>';
		iframeSrc+= '<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8"/></head>' ;
		iframeSrc+= '<body>'+bodyHtml+'</body>' ;
		iframeSrc+= '</html>' ;
		
		
		doc.open() ;
		doc.write(iframeSrc) ;
		doc.close() ;
		
		// Toggle content-btn force hidden
		Ext.get(dom.querySelector('.op5-spec-dbsezeer-ticketaction-content-btn')).setVisible(showNextIcon) ;
	},
	
	onItemOneClick: function(view,record,item,index,event) {
		var el ;
		if( (el = event.getTarget('.op5-spec-dbsezeer-headertags-select')) && el.dataset.id ) {
			return this.onItemAttachOneClick( record, el.dataset.id, event ) ;
		}
		if( (el = event.getTarget('.op5-spec-dbsezeer-ticketaction-buttons-btn-next')) && el.dataset.id ) {
// 			var ticketaction_filerecord_id = el.dataset.id ;
// 			
// 			var domEl = Ext.get(el) ;
// 			domEl.removeCls('op5-spec-dbsezeer-ticketaction-buttons-btn-next') ;
// 			domEl.addCls('op5-spec-dbsezeer-ticketaction-buttons-btn-nextloading') ;
// 			
// 			this.loadActionHtml(ticketaction_filerecord_id) ;
		}
		if( (el = event.getTarget('.op5-spec-dbsezeer-ticketaction-buttons-btn-reopen')) && el.dataset.id ) {
// 			var ticket_filerecord_id = el.dataset.id ;
// 			
// 			this.handleReopenTicket(ticket_filerecord_id) ;
		}
	},
	
	onItemAttachOneClick: function(ticketActionRecord, attachFilerecordId, event) {
		//console.log('onItemOneClick') ;
		if( !ticketActionRecord ) {
			return ;
		}
		if( Ext.isEmpty(attachFilerecordId) ) {
			return ;
		}
		var attachmentRecord = ticketActionRecord.attachments().getById(attachFilerecordId) ;
		if( Ext.isEmpty(attachmentRecord) ) {
			return ;
		}
		
		var filename = attachmentRecord.get('attach_filename') ;
		
		var gridContextMenuItems = [{
			text: '<b>'+filename+'</b>',
			handler: null,
			disabled: true,
		},'-',{
			icon: 'images/op5img/ico_camera_16.png',
			text: 'Preview',
			handler : function() {
				this.handleDownloadAttach(attachmentRecord,true) ;
			},
			scope : this
		},{
			icon: 'images/op5img/ico_download_16.png',
			text: 'Download',
			handler : function() {
				this.handleDownloadAttach(attachmentRecord) ;
			},
			scope : this
		}] ;
		
		if( Ext.isEmpty(gridContextMenuItems) ) {
			return ;
		}
		
		var gridContextMenu = Ext.create('Ext.menu.Menu',{
			items : gridContextMenuItems,
			listeners: {
				hide: function(menu) {
					Ext.defer(function(){menu.destroy();},10) ;
				}
			}
		}) ;
		
		gridContextMenu.showAt(event.getXY());
		
		return ;
	},
	
	
	
	setWideMode: function(torf) {
		var cClass = 'op5-spec-dbsezeer-ticketline-dv-nowide' ;
		if(torf) {
			if( this.hasCls(cClass) ) {
				this.removeCls(cClass);
			}
		} else {
			if( !this.hasCls(cClass) ) {
				this.addCls(cClass);
			}
		}
	},
	
	setModeSelect: function(torf) {
		if( this._modeSelect == !!torf ) {
			return ;
		}
		this._modeSelect = !!torf ;
		
		this._modeSelect_ids = {} ;
		var selected = false ;
		this.getStore().each( function(rec) {
			var ticketaction_filerecord_id = rec.get('ticketaction_filerecord_id'),
				ticketactionData = rec.getData() ;
				
			var preselect = false ;
			if( ticketactionData.spec_email_is_on && ticketactionData.spec_email_is_inbox && !selected ) {
				preselect = true ;
				selected = true ;
			}
			this._modeSelect_ids[ticketaction_filerecord_id] = preselect ;
		},this) ;
		
		this.refresh() ;
	},
	getModeSelectIds: function() {
		if( !this._modeSelect ) {
			return null ;
		}
		var selectedIds = [] ;
		Ext.Object.each(this._modeSelect_ids,function(k,v) {
			if(v) {
				selectedIds.push(k) ;
			}
		}) ;
		return selectedIds ;
	},
	
	handleDownloadAttach: function(ticketattachRecord,isPreview=false) {
		var filename = ticketattachRecord.get('attach_filename') ;
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'ticket_attachDownloadB64',
				ticketattach_filerecord_id: ticketattachRecord.get('ticketattach_filerecord_id')
			},
			success: function(response) {
				var ajaxData = Ext.decode(response.responseText) ;
				if( ajaxData.success == false ) {
					Ext.Msg.alert('Failed', 'Unknown error');
				}
				if( isPreview ) {
					if( !ajaxData.bin_mimetype || !Optima5.Modules.Spec.DbsTracy.HelperCache.libBinaryPreview(ajaxData.bin_base64,ajaxData.bin_mimetype) ) {
						Ext.Msg.alert('Warning', 'Preview unavailable');
					}
					return ;
				}
				Optima5.Modules.Spec.DbsTracy.HelperCache.libBinaryDownload(ajaxData.bin_base64,filename) ;
			},
			scope: this
		});
	},

}) ;
