Ext.define('Optima5.Modules.Spec.DbsTracy.WarningPanel',{
	extend: 'Ext.tab.Panel',
	requires: [
		'Optima5.Modules.Spec.DbsTracy.WarningLinePanel',
		'Optima5.Modules.Spec.DbsTracy.WarningFormPanel',
		'Optima5.Modules.Spec.DbsTracy.WarningPreviewPanel',
	],
	
	//scollable: 'vertical',
	
	initComponent: function() {
		Ext.apply(this,{
			layout: {
				type: 'anchor',
				pack: 'middle',
				align: 'stretch',
			},
			defaults: {
				anchor: '100%',
			},
			items: []
		});
		this.callParent();
		if( this._ticketRecord ) {
			this.onLoadTicket(this._ticketRecord) ;
		} else if( this._ticketFilerecordId ) {
			this.loadTicket(this._ticketFilerecordId) ;
		}
	},
	loadTicket: function(ticketFilerecordId) {
		this._ticketFilerecordId = ticketFilerecordId ;
		
		this.removeAll();
		this.add({
			title: 'Loading...',
			xtype: 'box',
			flex: 1,
			cls:'op5-waiting'
		});
		
		//this.showLoadmask() ;
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'ticket_getRecord',
				ticket_filerecord_id: ticketFilerecordId,
				//status_reset: 1,
			},
			success: function(response) {
				var ajaxData = Ext.decode(response.responseText) ;
				if( ajaxData.success == false ) {
					Ext.Msg.alert('Failed', 'Unknown error');
				}
				var ticketRecord = Ext.ux.dams.ModelManager.create('DbsTracyTicketModel',ajaxData.data) ;
				this.onLoadTicket(ticketRecord) ;
			},
			callback: function() {
				//this.hideLoadmask() ;
			},
			scope: this
		});
	},
	onLoadTicket: function( ticketRecord ) {
		this.removeAll() ;
		
		if( !Ext.isEmpty(ticketRecord.get('incident_cfg_obj')) ) {
			var printTpl = null ;
			if( !Ext.isEmpty(ticketRecord.get('incident_cfg_obj')['flow_print_tpl']) ) {
				printTpl = ticketRecord.get('incident_cfg_obj')['flow_print_tpl'];
			}
			if( Ext.isObject(ticketRecord.get('incident_cfg_obj')['flow_print_obj'])
				&& ticketRecord.get('incident_cfg_obj')['flow_print_obj'].hasOwnProperty( ticketRecord.get('id_soc') ) 
			) {
				printTpl = ticketRecord.get('incident_cfg_obj')['flow_print_obj'][ticketRecord.get('id_soc')];
			}
			var titleTxt = 'Warning' ;
			if( printTpl ) {
				titleTxt = 'Litige' ;
			}
			this.setTitle(titleTxt + ' : ' + ticketRecord.get('incident_no'));
		} else {
			this.setTitle('New incident...');
		}
		
		var linePresetAction, modePresetAction ;
		switch( this._presetAction ) {
			case 'modify' :
				modePresetAction = this._presetAction ;
				break ;
			case 'close' :
				linePresetAction = this._presetAction ;
				break ;
		}
		
		this.add( Ext.create('Optima5.Modules.Spec.DbsTracy.WarningFormPanel',{
			title: 'Properties',
			border: false,
			
			optimaModule: this.optimaModule,
			_ticketRecord: ticketRecord,
			
			listeners: {
				linktitle: function(p,title) {
					//this.setTitle('Incident : ' + title) ;
				},
				saved: function(p,ticketFilerecordId) {
					this.loadTicket(ticketFilerecordId);
				},
				scope: this,
			},
		}) );
		if( ticketRecord.get('ticket_is_new') ) {
			this.setActiveTab(0);
			return ;
		}
		
		this.add(Ext.create('Optima5.Modules.Spec.DbsTracy.WarningLinePanel',{
			title: 'Events',
			border: false,
			
			optimaModule: this.optimaModule,
			_ticketRecord: ticketRecord,
			_presetAction: linePresetAction,
			
			listeners: {
				saved: function(p,ticketFilerecordId) {
					this.loadTicket(ticketFilerecordId);
				},
				scope: this,
			},
		}));
		this.setActiveTab( modePresetAction=='modify' ? 0 : 1 );
		
		ticketRecord.actions().each( function(ticketactionRecord) {
			ticketactionRecord.attachments().each( function(ticketattachRecord) {
				if( ticketattachRecord.get('ticket_is_header') ) {
					this.add( Ext.create('Optima5.Modules.Spec.DbsTracy.WarningPreviewPanel',{
						title: ticketattachRecord.get('attach_filename'),
						border: false,
						
						optimaModule: this.optimaModule,
						_ticketattachFilerecordId: ticketattachRecord.get('ticketattach_filerecord_id'),
						_ticketattachFilename: ticketattachRecord.get('attach_filename'),
					}));
				}
			},this);
		},this);
	},
	
	showLoadmask: function() {
		if( this.rendered ) {
			this.doShowLoadmask() ;
		} else {
			this.on('afterrender',this.doShowLoadmask,this,{single:true}) ;
		}
	},
	doShowLoadmask: function() {
		if( this.loadMask ) {
			return ;
		}
		this.loadMask = Ext.create('Ext.LoadMask',{
			target: this,
			msg:"Please wait..."
		}).show();
	},
	hideLoadmask: function() {
		this.un('afterrender',this.doShowLoadmask,this) ;
		if( this.loadMask ) {
			this.loadMask.destroy() ;
			this.loadMask = null ;
		}
	},
});
