Ext.define('Optima5.Modules.Spec.DbsTracy.WarningPreviewPanel',{
	extend: 'Ext.panel.Panel',
	
	scollable: 'vertical',
	
	initComponent: function() {
		Ext.apply(this,{
			layout: 'fit',
			tbar: [{
				icon: 'images/op5img/ico_camera_16.png',
				text: 'Preview',
				handler : function() {
					this.handleDownloadAttach(true) ;
				},
				scope : this
			},{
				icon: 'images/op5img/ico_download_16.png',
				text: 'Download',
				handler : function() {
					this.handleDownloadAttach() ;
				},
				scope : this
			}],
			items: [{
				xtype: 'box',
				flex: 1,
				cls:'op5-waiting'
			}]
		});
		this.callParent();
		this.setScrollable('vertical');
		if( this._ticketattachFilerecordId ) {
			this.doLoadAttachment(this._ticketattachFilerecordId) ;
		}
	},
	doLoadAttachment: function(ticketattachFilerecordId) {
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'ticket_attachDownloadB64',
				ticketattach_filerecord_id: ticketattachFilerecordId,
				page_idx: 1,
			},
			success: function(response) {
				var ajaxData = Ext.decode(response.responseText) ;
				if( ajaxData.success == false ) {
					Ext.Msg.alert('Failed', 'Unknown error');
				}
				this.removeAll() ;
				this.add({
					xtype: 'container',
					scrollable: true,
					items: [{
						xtype: 'image',
						style: 'width: 100%;',
						src: 'data:image/jpeg;base64,' + ajaxData.bin_base64,
						listeners: {
							afterrender: function(c) {
								var me = this ;
								c.getEl().on('dblclick', function() {
									me.handleDownloadAttach(true);
								});
							},
							scope: this ,
						}
					}]
				});
			},
			scope: this
		});
	},
	
	
	handleDownloadAttach: function(isPreview=false) {
		var filename = this._ticketattachFilename ;
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'ticket_attachDownloadB64',
				ticketattach_filerecord_id: this._ticketattachFilerecordId,
			},
			success: function(response) {
				var ajaxData = Ext.decode(response.responseText) ;
				if( ajaxData.success == false ) {
					Ext.Msg.alert('Failed', 'Unknown error');
				}
				if( isPreview ) {
					if( !ajaxData.bin_mimetype || !Optima5.Modules.Spec.DbsTracy.HelperCache.libBinaryPreview(ajaxData.bin_base64,ajaxData.bin_mimetype) ) {
						Ext.Msg.alert('Warning', 'Preview unavailable');
					}
					return ;
				}
				Optima5.Modules.Spec.DbsTracy.HelperCache.libBinaryDownload(ajaxData.bin_base64,filename) ;
			},
			scope: this
		});
	},
	
});
