Ext.define('Optima5.Modules.Spec.DbsTracy.WarningsListPanel',{
	extend:'Ext.panel.Panel',
	
	requires: [
		'Optima5.Modules.Spec.DbsTracy.WarningPanel',
	],
	
	_readonlyMode: false,
	
	_singlePage: false,
	
	defaultViewMode: 'order',
	viewMode: null,
	autoRefreshDelay: (10*60*1000),
	
	initComponent: function() {
		// HACK ?
		var prioMap = {} ;
		Ext.Array.each( Optima5.Modules.Spec.DbsTracy.HelperCache.getPriorityAll(), function(prio) {
			prioMap[prio.prio_id] = prio ;
		}) ;
		var consigneeMap = {} ;
		Ext.Array.each( Optima5.Modules.Spec.DbsTracy.HelperCache.getListData('LIST_CONSIGNEE'), function(r) {
			consigneeMap[r.id] = r.text ;
		}) ;
		
		Ext.apply(this,{
			layout: {
				type: 'vbox',
				align: 'stretch'
			},
			tbar: [{
				hidden: this._singlePage,
				icon: 'images/op5img/ico_back_16.gif',
				text: '<u>Back</u>',
				handler: function(){
					this.doQuit() ;
				},
				scope: this
			},'-',{
				hidden:true,
				padding: '0px 16px',
				xtype: 'box',
				html: '<b>Filters&nbsp;:</b>'
			},Ext.create('Optima5.Modules.Spec.DbsTracy.CfgParamButton',{
				cfgParam_id: 'SOC',
				iconCls: 'op5-spec-dbsezeer-explorer-status-all',
				text: 'Business Unit',
				itemId: 'btnSoc',
				optimaModule: this.optimaModule,
				listeners: {
					change: {
						fn: function() {
							this.doToolbarLayout() ;
							this.doLoad() ;
						},
						scope: this
					},
					ready: {
						fn: function() {
							
						},
						scope: this
					}
				}
			}),'-',{
				itemId: 'tbViewmode',
				viewConfig: {forceFit: true},
				menu: {
					defaults: {
						handler:function(menuitem) {
							//console.log('ch view '+menuitem.itemId) ;
							this.onViewSelect( menuitem.itemId ) ;
						},
						scope:this
					},
					items: [{
						itemId: 'status_highlight',
						text: 'Action required / notifications',
						iconCls: 'op5-spec-dbsezeer-explorer-status-owned'
					},{
						itemId: 'status_open',
						text: 'Open tickets / incidents',
						iconCls: 'op5-spec-dbsezeer-explorer-status-scope'
					},{
						itemId: 'search_dates',
						text: 'Incidents at date',
						iconCls: 'op5-spec-dbsezeer-explorer-status-dates'
					},{
						xtype: 'menuseparator'
					},{
						xtype: 'menucheckitem',
						text: 'Vue restreinte (hors DBS)',
						handler: null,
						checkHandler: function(chk,checked) {
							var gridpanel = this.down('#pGrid') ;
							if( !gridpanel ) {
								return ;
							}
							gridpanel.headerCt.down('#colgroupDbs').setVisible(!checked) ;
						},
						scope: this
					},{
						itemId: 'chkSpecRAQ',
						xtype: 'menucheckitem',
						text: '<i>Reste à quai</i>',
						handler: function() {
							this.doLoad();
						},
						scope: this,
						//checkHandler: function(chk,checked) {
						// checkHandler: function(chk,checked) {
						// 	var gridpanel = this.down('#pGrid') ;
						// 	if( !gridpanel ) {
						// 		return ;
						// 	}
						// 	gridpanel.headerCt.down('#colgroupFrom').setVisible(checked) ;
						// },
						// scope: this
					}]
				}
			},{
				icon: 'images/op5img/ico_calendar_16.png',
				text: '&#160;',
				itemId: 'date-picker',
				menu: [{
					xtype: 'form',
					layout: 'anchor',
					bodyPadding: 5,
					bodyCls: 'ux-noframe-bg',
					defaults: {
						listeners: {
							select: function(field) {
								var form = field.up('form'),
									dateStart = form.getForm().findField('date_start').getValue(),
									dateEnd = form.getForm().findField('date_end').getValue() ;
								this.onDateSet(dateStart,dateEnd) ;
							},
							scope: this
						}
					},
					items: [{
						margin: 5,
						xtype: 'datefield',
						name: 'date_start',
						format: 'Y-m-d',
						fieldLabel: 'Date start',
						labelWidth: 80,
					},{
						margin: 5,
						xtype: 'datefield',
						name: 'date_end',
						format: 'Y-m-d',
						fieldLabel: 'Date end',
						labelWidth: 80,
					}]
				}]
			},'-',{
				icon: 'images/op5img/ico_loupe_16.png',
				itemId: 'btnSearchIcon',
			},{
				xtype: 'textfield',
				itemId: 'btnSearch',
				width: 150,
				allowBlank:true,
				triggers: {
					clear: {
						cls: Ext.baseCSSPrefix + 'form-clear-trigger',
						handler: function(field) {
							field.reset() ;
						}
					}
				},
				enableKeyEvents: true,
				listeners: {
					change: {
						fn: function(field) {
							this.onSearchChange() ;
						},
						scope: this,
						buffer: 500
					},
					afterrender: function( field ) {
						var triggers = field.getTriggers() ;
						if( triggers.picker ) {
							triggers.picker.hide() ;
						}
					},
					scope: this
				}
			},{
				xtype: 'box',
				width: 16
			},'->',{
				icon: 'images/op5img/ico_reload_small.gif',
				text: 'Reload',
				handler: function() {
					this.doLoad() ;
				},
				scope: this
			},'-',{
				iconCls: 'op5-crmbase-datatoolbar-file-export-excel',
				text: 'Export',
				handler: function() {
					this.handleDownload() ;
				},
				scope: this
			}],
			
			items: [{
				xtype: 'container',
				layout: {
					type: 'hbox',
					align: 'stretch'
				},
				height: 35,
				style: 'background-color:#f5f5f5',
				items: []
			},{
				flex: 1,
				xtype: 'grid',
				itemId: 'pGrid',
				store: {
					model: 'DbsTracyTicketRowModel',
					autoLoad: false,
					proxy: this.optimaModule.getConfiguredAjaxProxy({
						extraParams : {
							_moduleId: 'spec_dbs_tracy',
							_action: 'ticket_getList'
						},
						reader: {
							type: 'json',
							rootProperty: 'data'
						}
					}),
					listeners: {
						beforeload: this.onGridBeforeLoad,
						load: this.onGridLoad,
						scope: this
					},
					sorters: [{
						property: 'date_update',
						direction: 'DESC',
					}],
				},
				columns: [{
					width: 32,
					//dataIndex: 'is_active',
					renderer: function(v,m,r) {
						if( r.get('closed_is_on') ) {
							m.tdCls += ' op5-spec-dbsezeer-grid-closed' ;
						} else if( r.get('status_is_highlight') ) {
							m.tdCls += ' op5-spec-dbsezeer-explorer-cell-notification' ;
						} else {
							
						}
						return '&#160;' ;
					}
				},{
					text: '<b>INC#</b>',
					width: 150,
					dataIndex: 'incident_no',
					tdCls: 'op5-spec-dbstracy-bigcolumn',
					renderer: function(v) {
						return '<b>'+v+'</b>';
					}
				},{
					itemId: 'colgroupDbs',
					text: 'Attrs.',
					columns: [{
						text: 'User',
						dataIndex: 'action1_user',
						width:90,
						align: 'left',
						filter: {
							type: 'stringlist',
						}
					},{
						text: 'Empl.',
						dataIndex: 'inputobj_empl',
						width:80,
						align: 'left',
						filter: {
							type: 'stringlist',
						}
					}],
				},{
					text: 'Incident',
					columns: [{
						width: 70,
						text: 'Node',
						dataIndex: 'incident_node',
						renderer: function(v){
							return v;
						},
						filter: {
							type: 'stringlist',
						}
					},{
						width: 150,
						text: 'Code',
						dataIndex: 'incident_code',
						renderer: function(v,m,r) {
							m.tdCls += ' op5-spec-dbstracy-ticketlist-rowdot';
							var hasTpl = false ;
							if( Ext.isObject(r.get('incident_cfg_obj')['flow_print_obj'])
								&& r.get('incident_cfg_obj')['flow_print_obj'].hasOwnProperty( r.get('id_soc') )
							) {
								hasTpl = true ;
							}
							if( !Ext.isEmpty(r.get('incident_cfg_obj')['flow_print_tpl']) ) {
								hasTpl = true ;
							}
							if( hasTpl ) {
								m.tdCls += ' op5-spec-dbstracy-ticketlist-rowdot-orange';
							} else {
								m.tdCls += ' op5-spec-dbstracy-ticketlist-rowdot-gray'
							}
							return v ;
						},
						filter: {
							type: 'op5specdbstracycfgfilter',
							cfgParam_id: 'INCIDENTCODE',
							cfgParam_emptyDisplayText: 'Select...',
							optimaModule: this.optimaModule,
						},
					},{
						width: 200,
						text: 'Desc',
						dataIndex: 'incident_desc_short',
						renderer: function(v){
							return v;
						},
					}]
				},{
					text: 'Link',
					columns: [{
						text: '<b>BU</b>',
						dataIndex: 'link_id_soc',
						width:50,
						align: 'center',
						renderer: function(v) {
							switch(v) {
								case 'ACL' :
									return 'SNA' ;
								case 'MBD' :
									return 'SLS' ;
								default :
									return v ;
							}
						},
						filter: {
							type: 'stringlist',
						}
					},{
						text: '<b>DN#</b>',
						dataIndex: 'link_id_dn',
						width:150,
						resizable: true,
						align: 'left',
						filter: {
							type: 'string'
						},
						renderer: function(v,m,r) {
							var txt = '<span class="op5-spec-dbstracy-bigcolumn-inner">'+v+'</span>' ;
							if( r.get('link_order_filerecord_ids').length > 1 ) {
								txt += '&nbsp;&nbsp;' ;
								txt += '<b>('+r.get('link_order_filerecord_ids').length+')</b>' ;
							}
							return txt ;
						},
						filter: {
							type: 'string',
						}
					},{
						text: 'Priority',
						dataIndex: 'link_atr_priority',
						width:85,
						align: 'center',
						renderer: function(v,metaData) {
							var prioMap = this._prioMap ;
							if( prioMap.hasOwnProperty(v) ) {
								var prioData = prioMap[v] ;
								return '<font color="' + prioData.prio_color + '">' + prioData.prio_code + '</font>' ;
							}
							return '?' ;
						},
						filter: {
							type: 'op5crmbasebible',
							bibleId: 'LIST_SERVICE',
							optimaModule: this.optimaModule,
						}
					},{
						text: 'Consignee',
						dataIndex: 'link_atr_consignee',
						width:150,
						renderer: function(v,metaData,record) {
							var str = '' ;
							str+= '' ;
							var consigneeMap = this._consigneeMap ;
							if( consigneeMap.hasOwnProperty(v) ) {
								str+= consigneeMap[v] ;
							} else {
								str+= v ;
							}
							str+= '' ;
							return str ;
						},
						filter: {
							type: 'string',
						}
					}]
				},{
					text: 'Dates',
					columns: [{
						align: 'center',
						width: 115,
						text: 'Opened',
						dataIndex: 'date_create',
						renderer: function(v,metaData,r) {
							if( Ext.isDate(v) ) {
								v = Ext.util.Format.date(v,'d/m/Y H:i') ;
							}
							return v ;
						},
						filter: {
							type: 'date',
						}
					},{
						align: 'center',
						width: 115,
						text: 'Last update',
						dataIndex: 'date_update',
						renderer: function(v,metaData,r) {
							if( Ext.isDate(v) ) {
								v = Ext.util.Format.date(v,'d/m/Y H:i') ;
							}
							return v ;
						},
						filter: {
							type: 'date',
						}
					}]
				},{
					text: 'Explanation',
					width: 200,
					dataIndex: 'incident_txt'
				},{
					text: '<i><b>Editors</b></i>',
					columns: [{
						width: 200,
						dataIndex: 'editobj_safran',
						text: '<i>Service Safran</i>',
						tdCls: 'op5-spec-dbstracy-ticketlist-editable',
						editor: {xtype: 'textfield'},
					},{
						width: 200,
						dataIndex: 'editobj_comment',
						text: '<i>Commentaire GOM</i>',
						tdCls: 'op5-spec-dbstracy-ticketlist-editable',
						editor: {xtype: 'textarea', growMin:1, growMax:3},
					}]
				}],
				plugins: [{
					ptype: 'uxgridfilters'
				},{
					ptype: 'cellediting',
					clicksToEdit: 1,
					listeners: {
						edit: function(editor,context) {
							var prefix = 'editobj_' ;
							if( context.field.indexOf(prefix)===0 ) {
								var mkey = context.field.substr(prefix.length) ;
								var editobj = context.record.get('editdata_obj') || {} ;
								editobj[mkey] = context.value ;
								context.record.set('editdata_obj',editobj) ;
								context.record.set(context.field,context.value) ;
								context.record.commit();
								
								this.doSaveEditObj( context.record.getId() ) ;
							}
						},
						scope: this,
					},
				}],
				listeners: {
					itemdblclick: function(view, record, item, index, event) {
						this.openTicketPanel( record.get('ticket_filerecord_id') ) ;
					},
					itemcontextmenu: function(view, record, item, index, event) {
						var gridContextMenuItems = new Array() ;
						
						var selRecords = view.getSelectionModel().getSelection() ;
						if( selRecords.length != 1 ) {
							return ;
						}
						var selRecord = selRecords[0] ;
						gridContextMenuItems.push({
							iconCls: 'icon-bible-edit',
							text: 'Modify',
							handler : function() {
								this.openTicketPanel( selRecord.get('ticket_filerecord_id'), 'modify' ) ;
							},
							scope : this
						});
						gridContextMenuItems.push({
							iconCls: 'op5-spec-dbsezeer-explorer-status-owned',
							text: 'New action',
							handler : function() {
								this.openTicketPanel( selRecord.get('ticket_filerecord_id') ) ;
							},
							scope : this
						});
						gridContextMenuItems.push({
							iconCls: 'icon-bible-lock',
							text: 'Close',
							handler : function() {
								this.openTicketPanel( selRecord.get('ticket_filerecord_id'), 'close' ) ;
							},
							scope : this
						});
						
						var gridContextMenu = Ext.create('Ext.menu.Menu',{
							items : gridContextMenuItems,
							listeners: {
								hide: function(menu) {
									Ext.defer(function(){menu.destroy();},10) ;
								}
							}
						}) ;
						
						gridContextMenu.showAt(event.getXY());
					},
					scope: this
				},
				viewConfig: {
					enableTextSelection: true,
				},
				_consigneeMap: consigneeMap,
				_prioMap: prioMap,
			}]
		});
		this.callParent() ;
		this.mon(this.optimaModule,'op5broadcast',this.onCrmeventBroadcast,this) ;
		
		// Create grid ?
		if( this.autoRefreshTask ) {
			this.autoRefreshTask.cancel() ;
		}
		this.autoRefreshTask = new Ext.util.DelayedTask( function(){
			if( this.isDestroyed ) { // private check
				return ;
			}
			this.doLoad() ;
		},this);
		
		this.onViewSelect('status_open') ;
		//this.doLoad() ;
	},
	onCrmeventBroadcast: function(crmEvent, eventParams) {
		switch( crmEvent ) {
			case 'datachange' :
				this.onDataChange() ;
				break ;
			default: break ;
		}
	},
	onDataChange: function() {
		this.doLoad() ;
	},
	
	doToolbarLayout: function() {
		var btnSoc = this.down('toolbar').down('#btnSoc'),
			btnSocValue = btnSoc.getValue() ;
		
		//this.down('toolbar').down('#tbCreate').setVisible( !Ext.isEmpty(btnSocValue) ) ;
	},
	
	
	onViewSelect: function(viewId) {
		this.doSearchResetSilent() ;
		
		var tbViewmode = this.down('#tbViewmode') ;
		if( viewId==null && tbViewmode.tbViewmodeItemId ) {
			viewId = tbViewmode.tbViewmodeItemId ;
		}
		var tbViewmode = this.down('#tbViewmode'),
			tbViewmodeItem = tbViewmode.menu.getComponent(viewId),
			iconCls, text ;
		if( !tbViewmodeItem ) {
			return ;
		}
		tbViewmode.tbViewmodeItemId = viewId ;
		// View mode
		var tbViewmodeItem = tbViewmode.menu.getComponent(viewId) ;
		if( tbViewmodeItem ) {
			var txt = '<b>' + tbViewmodeItem.text + '</b>' ;
			tbViewmode.setText( txt );
			tbViewmode.setIconCls( tbViewmodeItem.iconCls );
		}
		
		this.down('toolbar').down('#date-picker').setVisible( viewId=='search_dates' ) ;
		if( viewId=='search_dates' ) {
			var dateStart = new Date() ;
			var dateEnd = new Date() ;
			dateStart.setMonth( dateStart.getMonth() - 1 ) ;
			
			this.onDateSet(dateStart,dateEnd) ;
		} else {
			this.doLoad() ;
		}
	},
	onDateSet: function( dateStart, dateEnd ) {
		this.doSearchResetSilent() ;
		
		var dateStartObj = new Date(dateStart.toDateString()),
			dateEndObj = new Date(dateEnd.toDateString());
		this.down('toolbar').down('#date-picker').menu.down('form').getForm().setValues({
			date_start: dateStartObj,
			date_end: dateEndObj,
		});
		this.down('toolbar').down('#date-picker').setText('<b>'+Ext.Date.format(dateStartObj,'d/m/Y')+'</b>'+'&nbsp;<b>></b>&nbsp;'+'<b>'+Ext.Date.format(dateEndObj,'d/m/Y')+'</b>') ;
		
		this.doLoad() ;
	},
	
	
	setFilters: function(filterCfg) {
		this._suspendLoad = true ;
		if( filterCfg.hasOwnProperty('filterSoc') ) {
			this.down('#btnSoc').setValue(filterCfg.filterSoc);
		}
		if( filterCfg.hasOwnProperty('viewMode') ) {
			this.onViewSelect(filterCfg.viewMode);
		}
		this._suspendLoad = false;
		this.doLoad();
	},
	doLoad: function(searchTxt=null) {
		if( this._suspendLoad ) {
			return ;
		}
		if( !Ext.isEmpty(searchTxt) ) {
			this.down('grid').getStore()._searchTxt = searchTxt ;
		} else {
			this.doSearchResetSilent() ;
			this.down('grid').getStore()._searchTxt = null ;
		}
		this.down('grid').getStore().load() ;
	},
	
	onGridBeforeLoad: function(store,options) {
		var scopeViewId = this.down('#tbViewmode').tbViewmodeItemId ;
		//console.log(scopeViewId) ;
		
		var btnSoc = this.down('toolbar').down('#btnSoc'),
			btnSocValue = btnSoc.getValue() ;
			
		var btnClosed = this.down('toolbar').down('#chkClosed');
		
		var formPanel = this.down('toolbar').down('#date-picker').menu.down('form')
		var dateStart = formPanel.getForm().findField('date_start').getRawValue(),
			dateEnd = formPanel.getForm().findField('date_end').getRawValue() ;
		if( scopeViewId=='search_dates' && dateStart && dateEnd ) {
			//console.log(dateStart+' >> '+dateEnd) ;
		}
		
		var params = options.getParams() || {} ;
		Ext.apply(params,{
			filter_hightlight: 0,
			filter_closed: 1,
			filter_spec_RAQ: 0,
		});
		switch( scopeViewId ) {
			case 'status_highlight' :
				params['filter_highlight'] = 1;
				break ;
			case 'search_dates' :
				params['filter_closed'] = 0;
				break ;
			default:
				break ;
		}
		if( !Ext.isEmpty(btnSocValue) ) {
			Ext.apply(params,{
				filter_socCode: btnSocValue,
			}) ;
		}
		if( scopeViewId=='search_dates' ) {
			Ext.apply(params,{
				filter_dates: Ext.JSON.encode({
					date_start: dateStart,
					date_end: dateEnd,
				}),
			}) ;
		}
		if( this.down('#chkSpecRAQ') ) {
			params['filter_spec_RAQ'] = this.down('#chkSpecRAQ').checked ? 1 : 0;
		}
		options.setParams(params) ;
	},
	onGridLoad: function() {
		
	},
	
	doSearchResetSilent: function() {
		btnSearch = this.down('#btnSearch') ;
		//btnSearch.suspendEvents() ; // NOTE: local search
		btnSearch.reset() ;
		//btnSearch.resumeEvents(true) ; // NOTE: local search
	},
	onSearchChange: function() {
		var btnSearch = this.down('#btnSearch') ;
		var btnSearchTxt = btnSearch.getValue().toLowerCase() ;
		
		var gridPanel = this.down('#pGrid') ;
		//gridPanel.filters.clearFilters() ;
		var gridStore = this.down('#pGrid').getStore() ;
		gridStore.clearFilter() ;
		
		//this.onViewSelect(null) ;
		
		if( Ext.isEmpty(btnSearchTxt) ) {
			return ;
		}
		
		// visible fields if the grid header
		var visibleDataIndexes = [] ;
		Ext.Array.each( gridPanel.getVisibleColumns(), function( gridCol ) {
			if( !Ext.isEmpty(gridCol.dataIndex) ) {
				visibleDataIndexes.push( gridCol.dataIndex ) ;
			}
		}) ;
		
		// do filtering with a custom function
		gridStore.filterBy( function(record) {
			// For each record, iterate over the FIELDS, and for each field "string compare" to btnSearchTxt
			var isItAMatchIdx = [] ;
			Ext.Array.each( btnSearchTxt.split(' '), function(btnSearchWord,idx) {
				isItAMatchIdx[idx] = false ;
				Ext.Array.each( visibleDataIndexes, function( dataIndex ) {
					var recordFieldValue = record.get(dataIndex) ;
					if( !Ext.isString(recordFieldValue) ) {
						return ;
					}
					if( recordFieldValue.toLowerCase().indexOf(btnSearchWord) != -1 ) {
						isItAMatchIdx[idx] = true ;
					}
				}) ;
			}) ;
			var isItAMatch = true ;
			Ext.Array.each( isItAMatchIdx,function(torf) {
				if(!torf) {
					isItAMatch = false ;
				}
			}) ;
			return isItAMatch ;
		}) ;
	},
	
	
	openTicketPanel: function(ticketFilerecordId, presetAction=null) {
		var warningPanel = Ext.create('Optima5.Modules.Spec.DbsTracy.WarningPanel',{
			optimaModule: this.optimaModule,
			
			_ticketFilerecordId: ticketFilerecordId,
			_presetAction: presetAction,
			
			frame: false,
			border: false,
			
			width:510,
			height:100,
			floating: true,
			draggable: false,
			resizable: false,
			renderTo: this.getEl(),
			tools: [{
				type: 'close',
				handler: function(e, t, p) {
					p.ownerCt.destroy() ;
				},
				scope: this
			}],
			_parentCmp: this,
			doResize: function() {
				var parentCmp = this._parentCmp ;
				if( !parentCmp.getEl() ) {
					return ;
				}
				var targetHeight = (parentCmp.getEl().getHeight() * 0.95) ;
				var targetWidth = 700 ;
				this.setHeight( targetHeight ) ;
				this.setWidth( targetWidth ) ;
				this.getEl().alignTo(parentCmp.getEl(), 'c-c?')
			}
		});
		
		warningPanel.on('destroy',function(p) {
			this._warningPanel = null ;
			this.getEl().unmask() ;
		},this,{single:true}) ;
		
		warningPanel.show();
		warningPanel.doResize() ;
		this._warningPanel = warningPanel ;
		this._warningPanel.mon(this,'resize', function(p){
			p._warningPanel.doResize() ;
		},this);
		this.getEl().mask() ;
		
		//notificationsPanel.getStore().loadData(notificationsData) ;
		return warningPanel ;
	},
	
	doSaveEditObj: function( ticketFilerecordId ) {
		var record = this.down('#pGrid').getStore().getById(ticketFilerecordId) ;
		this.optimaModule.getConfiguredAjaxConnection().request({
			params: {
				_moduleId: 'spec_dbs_tracy',
				_action: 'ticket_saveHeader',
				ticket_filerecord_id: record.get('ticket_filerecord_id'),
				ticket_is_new: 0,
				data: Ext.JSON.encode({
					editdata_obj: record.get('editdata_obj'),
				}),
			},
			success: function(response) {},
			callback: function() {},
			scope: this
		}) ;
	},
	
	doQuit: function() {
		if( this._singlePage ) {
			return ;
		}
		this.destroy() ;
	},
	onDestroy: function() {
		if( this._warningPanel ) {
			this._warningPanel.destroy() ;
		}
		if( this.autoRefreshTask ) {
			this.autoRefreshTask.cancel() ;
		}
		//Ext.ux.dams.ModelManager.unregister( this.tmpModelName ) ;
	},
	
	handleDownload: function( everything ) {
		var columns = [] ;
		Ext.Array.each( this.down('#pGrid').headerCt.getGridColumns(), function(column) {
			if( Ext.isEmpty(column.dataIndex) ) {
				return ;
			}
			if( !column.isVisible(true) ) {
				return ;
			}
			columns.push({
				dataIndex: column.dataIndex,
				text: column.text
			});
		});
		
		var data = [],
			grid = this.down('#pGrid'),
			gridStore = grid.getStore() ;
		gridStore.each( function(record) {
			var row = record.getData() ;
			
			switch(row['link_id_soc']) {
				case 'ACL' :
					row['link_id_soc']= 'SNA' ;
					break ;
				case 'MBD' :
					row['link_id_soc']= 'SLS' ;
					break ;
				default :
					break ;
			}
			
			var prioMap = grid._prioMap ;
			var v = row['link_atr_priority'] ;
			if( prioMap.hasOwnProperty(v) ) {
				var prioData = prioMap[v] ;
				row['link_atr_priority'] = prioData.prio_code ;
			}
			
			var consigneeMap = grid._consigneeMap ;
			var v = row['link_atr_consignee'] ;
			if( consigneeMap.hasOwnProperty(v) ) {
				row['link_atr_consignee'] = consigneeMap[v] ;
			}
			
			data.push( row ) ;
		}) ;
		
		var exportParams = this.optimaModule.getConfiguredAjaxParams() ;
		Ext.apply(exportParams,{
			_moduleId: 'spec_dbs_tracy',
			_action: 'xls_create',
			columns: Ext.JSON.encode(columns),
			data: Ext.JSON.encode(data),
			exportXls: true
		}) ;
		if( !Ext.isEmpty(this.down('#btnSoc').getValue()) ) {
			Ext.apply(exportParams,{
				filter_socCode: this.down('#btnSoc').getValue()
			}) ;
		}
		Ext.create('Ext.ux.dams.FileDownloader',{
			renderTo: Ext.getBody(),
			requestParams: exportParams,
			requestAction: Optima5.Helper.getApplication().desktopGetBackendUrl(),
			requestMethod: 'POST'
		}) ;
	},
	
});
