/**
* Barebones iframe implementation. From ExtJS 5.1
*/
Ext.define('Ext.ux.dams.AceEditor', {
	extend: 'Ext.Component',

	loadMask: 'Loading...',

	src: 'about:blank',
	
	

	/*
	renderTpl: [
		'<iframe src="{src}" id="{id}-iframeEl" data-ref="iframeEl" name="{frameName}" width="100%" height="100%" frameborder="0"></iframe>'
	],
	childEls: ['iframeEl'],
	*/

	initComponent: function () {
		this.callParent();
		
		//console.dir(this.getId()) ;
		
		if( typeof ace === 'undefined' ) {
			//console.log('Need to load ACE') ;
			this.doLoadLibrary() ;
			return ;
		}
		this.onLoadLibrary();
	},
	
	doLoadLibrary: function() {
		let scriptEle = document.createElement("script");
		scriptEle.setAttribute("src", 'js/include/ace/ace.js');
		scriptEle.setAttribute("type", "text/javascript");
		scriptEle.setAttribute("async", true);
		document.body.appendChild(scriptEle);

		// success event 
		scriptEle.addEventListener("load", () => {
			//ace.config.set("basePath", "js/include/ace") ;
			this.onLoadLibrary();
		});
	},
	onLoadLibrary: function() {
		if( this.rendered ) {
			this.doCreateEditor();
		} else {
			this.on('afterrender',function(){this.doCreateEditor();},this) ;
		}
	},
	
	doCreateEditor: function() {
		//console.log('onAfterRender');
		//console.dir(this) ;
		var mode = null;
		if( this.mode ) {
			mode = "ace/mode/"+this.mode ;
		}
		
		this._aceInstance = ace.edit(this.getId(), {
			theme: "ace/theme/textmate",
			mode: mode,
			value: this.value
		});
		this.fireEvent('editorready',this) ;
		//console.dir(ace) ;
		//console.dir(this._aceInstance) ;
	},
	getValue: function() {
		if( this._aceInstance ) {
			return this._aceInstance.getValue() ;
		}
	},
	getAceEditor: function() {
		return this._aceInstance ;
	},
	onDestroy: function() {
		//console.log('destroy') ;
		if( this._aceInstance ) {
			this._aceInstance.destroy() ;
		}
	},
	highlight: function() {
		if( this.getEl() ) {
			this.getEl().highlight() ;
		}
	},
	insertTextAtCursor: function(txt) {
		this.getAceEditor().insert(txt) ;
	},
}) ;
