Ext.Loader.setConfig({
	enabled: true,
	disableCaching: true,
	paths: {
		'Ext': './extjs/src', 
		'Optima5' : './js/app'
		}
});

Ext.require('Optima5.AppMobile');
Ext.require('Optima5.Modules.Spec.DbsTracy.DbsTracyModuleMobile');

var op5app ;
Ext.onReady(function () {
	
	/*
	 * From Ext 5.1.1, Floating inside other ELs seem to mess with Ext.dom.GarbageCollector
	 * Guess: Ext.util.Floating tries to reuse shadows cleared/invalidated by garbageCollector before ???
	 */
	Ext.util.Floating.override({
		//shadow: false
	}) ;
	Ext.dom.Underlay.override({
		hide: function() {
			this.callOverridden(arguments) ;
			this.getPool().reset() ;
		}
	}) ;
	
	/*
	 * Ext 5.1.1 : onUpdate if filtered => non-existant group => metaGroup isCollapsed not defined
	 * fixed in 5.1.2 ?
	 */
	Ext.grid.feature.GroupStore.override({
		onUpdate: function(store, record, operation, modifiedFieldNames) {
			var me = this,
				groupingFeature = me.groupingFeature ;
			
			if (store.isGrouped() && !groupingFeature.getGroup(record)) {
				me.fireEvent('update', me, record, operation, modifiedFieldNames);
				return ;
			}
			
			this.callOverridden(arguments) ;
		}
	});
	/*
	 * https://www.sencha.com/forum/showthread.php?301099-Grouping-is-not-working-when-value-is-null/page2
	 * http://forums.ext.net/showthread.php?60224&p=275467&viewfull=1#post275467
	 */
	Ext.grid.feature.Grouping.override({
		// Overridden because of #919
		getMetaGroup: function (group) {
			var metaGroupCache = this.metaGroupCache || this.createCache(),
					key,
					metaGroup;

			if (group.isModel) {
					group = this.getGroup(group);
			}

			if (group != null) { // #919. Do not replace with "!==", beucase it should filter for null and undefined.
					key = (typeof group === 'string') ? group : group.getGroupKey();
					metaGroup = metaGroupCache[key];

					if (!metaGroup) {
						metaGroup = metaGroupCache[key] = {
							isCollapsed: false,
							lastGroup: null,
							lastGroupGeneration: null,
							lastFilterGeneration: null,
							aggregateRecord: new Ext.data.Model()
						};

						if (!metaGroupCache.map) {
							metaGroupCache.map = {};
						}

						metaGroupCache.map[key] = true;
					}
			}

			return metaGroup;
		}
	});
	
	/*
	Ext.scroll.TouchScroller.override({
		privates: {
			onAxisDrag: function(axis, delta) {
				this.setOutOfBoundRestrictFactor(0) ;
				this.callOverridden(arguments) ;
			},
			getAnimationEasing: function(axis, e) {
				return null ;
			}
		}
	});
	*/
	Ext.grid.Panel.prototype.bufferedRenderer = false ;
	
	/*
	Désactiver le click droit
	*/
	Ext.getDoc().on('contextmenu', function(e){
		e.preventDefault() ;
	}) ;
	Ext.getDoc().on('keydown', function(e){
		if( e.getKey() == e.BACKSPACE && !Ext.Array.contains(['text','password','textarea'], e.getTarget().type) ) {
			e.preventDefault();
		}
	}) ;
	
	// onReady : bootstrap Optima app.
	op5app = Ext.create('Optima5.AppMobile',{}) ;
});
