<?php
$app_root = dirname($_SERVER['SCRIPT_NAME']).'/../../..' ;
$server_root=$app_root.'/server' ;
$resources_root=$app_root.'/resources' ;
$templates_dir=$resources_root.'/server/templates' ;

include("$server_root/include/config.inc.php");
include("$server_root/include/toolfunctions.inc.php");
include("$server_root/modules/media/include/media.inc.php");

include( "$server_root/include/database/mysql_DB.inc.php" ) ;
$_opDB = new mysql_DB( );
$_opDB->connect_mysql( $mysql_host, $mysql_db, $mysql_user, $mysql_pass );
$_opDB->query("SET NAMES UTF8") ;

//include("$server_root/modules/paracrm/backend_paracrm.inc.php");
include("$server_root/modules/spec_dbs_embramach/backend_spec_dbs_embramach.inc.php");

$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
$_SESSION['login_data']['mysql_db'] = 'op5_'.$_domain_id.'_prod' ;
$_SESSION['login_data']['login_domain'] = $_domain_id.'_prod' ;
$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;

function normalizePath($path) {
	return array_reduce(explode('/', $path), function($a, $b) {
		if ($a === null) {
				$a = "/";
		}
		if ($b === "" || $b === ".") {
				return $a;
		}
		if ($b === "..") {
				return dirname($a);
		}

		return (preg_replace("/\/+/", "/", "$a/$b"));
	});
}

function doResizeJpeg( $path_src, $path_thumb ) {
	$img_src = imagecreatefromjpeg($path_src);
	
	$orig_h = imagesy($img_src);
	$orig_w = imagesx($img_src);
	
	$ttmp = media_img_getResize( $orig_w, $orig_h, $is_thumb=TRUE ) ;
	$dest_w = $ttmp[0];
	$dest_h = $ttmp[1] ;

	$img_new = imagecreatetruecolor($dest_w, $dest_h);
	imagecopyresampled($img_new, $img_src, 0, 0, 0, 0, $dest_w, $dest_h, $orig_w, $orig_h);
	imagejpeg($img_new, $path_thumb,90);
}


media_contextOpen( $_sdomain_id ) ;

$query = "SELECT * FROM view_file_FLOW_INBOUND_STEP WHERE field_Z_ATTACHSRC_JSON<>'' AND field_Z_ATTACHSRC_STATUS='0'" ;
$result = $_opDB->query($query);
while( ($arr = $_opDB->fetch_assoc($result)) != FALSE ) {
	
	//print_r($arr) ; continue ;
	$flowinboundstep_filerecord_id = $arr['filerecord_id'] ;
	$flowinbound_filerecord_id = $arr['filerecord_parent_id'] ;
	
	$attachsrc_obj = json_decode($arr['field_Z_ATTACHSRC_JSON'],true) ;
	
	$filepath_pdf_domain = '/../'.$attachsrc_obj['_sdomainId'].'/'.$attachsrc_obj['table_code'].'_'.$attachsrc_obj['primaryHash'].'.bin' ;
	$filepath_pdf = normalizePath(media_contextGetDirPath().$filepath_pdf_domain) ;
	
	if( !is_file($filepath_pdf) ) {
		continue ;
	}
	
	$finfo = finfo_open(FILEINFO_MIME_TYPE);
	$mimetype = finfo_file($finfo, $filepath_pdf) ;
	if( $mimetype != 'application/pdf' ) {
		echo "???\n" ;
		continue ;
	}
	
	$dirpath = dirname($filepath_pdf) ;
	$filename_base = basename($filepath_pdf,'.bin') ;
	echo $filename_base."\n" ;
	echo $dirpath."\n" ;
	
	$filepath_pages = $dirpath.'/'.$filename_base.'.pages' ;
	echo $filepath_pages."\n" ;
	
	if( is_file($filepath_pages) ) {
		$nb_pages = (int)file_get_contents($filepath_pages) ;
		echo "JPEGS (cached): ".$nb_pages."\n" ;
	} else {
		$binary_pdf = file_get_contents($filepath_pdf) ;
		//echo strlen($binary_pdf)."\n" ;
		$jpegs = media_pdf_pdf2jpgs( $binary_pdf ) ;
		echo "JPEGS : ".count($jpegs)."\n" ;
		$page = 0 ;
		foreach( $jpegs as $binary_jpg ) {
			$page++ ;
			
			$filepath_jpg = $dirpath.'/'.$filename_base.'.'.str_pad($page, 2, "0", STR_PAD_LEFT).'.jpg' ;
			echo $filepath_jpg."\n" ;
			file_put_contents($filepath_jpg,$binary_jpg) ;
			
			$filepath_thumb = $dirpath.'/'.$filename_base.'.'.str_pad($page, 2, "0", STR_PAD_LEFT).'.thumb.jpg' ;
			doResizeJpeg($filepath_jpg,$filepath_thumb) ;
		}
		$nb_pages = $page ;
		file_put_contents($filepath_pages,(string)$nb_pages) ;
	}
	
	
	$mach_basepath = media_contextGetDirPath() ;
	for( $page=1 ; $page<=$nb_pages ; $page++ ) {
		$filepath_jpg = $dirpath.'/'.$filename_base.'.'.str_pad($page, 2, "0", STR_PAD_LEFT).'.jpg' ;
		$filepath_thumb = $dirpath.'/'.$filename_base.'.'.str_pad($page, 2, "0", STR_PAD_LEFT).'.thumb.jpg' ;
		if( !is_file($filepath_jpg) ) {
			echo "????!!!!!!\n" ;
			continue ;
		}
		echo "Reading : ".$filepath_jpg."\n" ;
		$attach_title = $arr['field_STEP'].' / #'.$page ;
		$attach_date = $arr['field_DATE'] ;
		echo " attach title : ".$attach_title."\n" ;
		
		$arr_ins = array() ;
		$arr_ins['field_ATTACHMENT_DATE'] = $attach_date ;
		$arr_ins['field_ATTACHMENT_TXT'] = $attach_title ;
		
		$file_code = 'FLOW_INBOUND_ATTACH' ;
		$flowinboundattach_filerecord_id = paracrm_lib_data_insertRecord_file( $file_code, $flowinbound_filerecord_id, $arr_ins ) ;
		
		$linkpath_jpg = $mach_basepath.'/'.media_img_toolFile_getId($file_code,$flowinboundattach_filerecord_id).'.jpg' ;
		echo $linkpath_jpg."\n" ;
		symlink($filepath_jpg, $linkpath_jpg) ;
		$linkpath_thumb = $mach_basepath.'/'.media_img_toolFile_getId($file_code,$flowinboundattach_filerecord_id).'.thumb.jpg' ;
		echo $linkpath_thumb."\n" ;
		symlink($filepath_thumb, $linkpath_thumb) ;
	}
	
	paracrm_lib_data_updateRecord_file( "FLOW_INBOUND_STEP", array('field_Z_ATTACHSRC_STATUS'=>1), $flowinboundstep_filerecord_id ) ;
	continue ;
}

media_contextClose() ;

?>
