<?php

function media_auto_processUploaded( $tmpfilepath, $src_filename=NULL ) {
	if( !$GLOBALS['_media_context'] )
		return FALSE ;
	$media_path = media_contextGetDirPath() ;
	if( !$media_path ) {
		return FALSE ;
	}

	if( function_exists('finfo_open') ) {
		$finfo = finfo_open(FILEINFO_MIME_TYPE);
		$mimetype = finfo_file($finfo, $tmpfilepath) ;
	} elseif( $src_filename ) {
		$ttmp = explode('.',$src_filename) ;
		$mimetype = end($ttmp) ;
	} else {
		return FALSE ;
	}

	$pdf_binary = NULL ;
	switch($mimetype) {
		case 'application/pdf':
		case 'pdf':
			return media_pdf_processUploaded($tmpfilepath,$src_filename);
			
		case 'image/jpeg':
		case 'image/jpg':
		case 'jpeg':
		case 'jpg':
		case 'image/png':
		case 'png':
		case 'image/gif':
		case 'gif':
		case 'application/xhtml+xml' :
		case 'text/html' :
		case 'html' :
		case 'htm' :
			return media_img_processUploaded($tmpfilepath,$src_filename,false);
			
		default :
			return media_bin_processUploaded($tmpfilepath);
	}
}


function media_auto_getType($src_id,$media_path=NULL) { // img pdf bin
	if( !$GLOBALS['_media_context'] )
		return FALSE ;
	if( !$media_path ) {
		$media_path = media_contextProbeDirPath($src_id) ;
	}
	if( !$media_path ) {
		return FALSE ;
	}

	if( strpos($src_id,'tmp_') === 0 ) {
		$ttmp = substr($src_id,4,strlen($src_id)-4) ;
		$src_path = $media_path.'/tmp/'.$ttmp ;
	} else {
		$src_path = $media_path.'/'.$src_id ;
	}
	
	if( is_file($src_path.'.bin') ) {
		return 'bin' ;
	}
	if( is_file($src_path.'.jpg') ) {
		return 'img' ;
	}
	if( is_file($src_path.'.pdf') ) {
		return 'pdf' ;
	}
	return null ;
}

function media_auto_move($src_id,$dst_id) {
	switch( media_auto_getType($src_id) ) {
		case 'bin' : media_bin_move( $src_id , $dst_id ); break ;
		case 'img' : media_img_move( $src_id , $dst_id ); break ;
		case 'pdf' : media_pdf_move( $src_id , $dst_id ); break ;
		default : break ;
	}
}
function media_auto_copy($src_id,$dst_id) {
	switch( media_auto_getType($src_id) ) {
		case 'bin' : media_bin_copy( $src_id , $dst_id ); break ;
		case 'img' : media_img_copy( $src_id , $dst_id ); break ;
		case 'pdf' : media_pdf_copy( $src_id , $dst_id ); break ;
		default : break ;
	}
}
function media_auto_delete($src_id) {
	switch( media_auto_getType($src_id) ) {
		case 'bin' : media_bin_delete( $src_id ); break ;
		case 'img' : media_img_delete( $src_id ); break ;
		case 'pdf' : media_pdf_delete( $src_id ); break ;
		default : break ;
	}
}


function media_auto_getBinary($src_id) {} // 






?>
